/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.history;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricVariableInstanceEntity;
import kd.bos.workflow.engine.impl.variable.VariableType;
import org.apache.commons.lang.StringUtils;

public class HistoricVariableInstanceEntityImpl
extends AbstractEntity
implements HistoricVariableInstanceEntity,
Serializable {
    private static final long serialVersionUID = 1L;
    protected VariableType variableType;
    protected Object cachedValue;

    public HistoricVariableInstanceEntityImpl() {
    }

    public HistoricVariableInstanceEntityImpl(DynamicObject dynamicObject) {
        super(dynamicObject);
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        persistentState.put("longValue", this.getLongValue());
        persistentState.put("doubleValue", this.getDoubleValue());
        persistentState.put("textValue", this.getTextValue());
        return persistentState;
    }

    @Override
    public String getDynObjTypeName() {
        return "wf_hivarinst";
    }

    @Override
    public Object getValue() {
        if (!(this.getVariableType() == null || this.getVariableType().isCachable() && this.cachedValue != null)) {
            this.cachedValue = this.getVariableType().getValue(this);
        }
        return this.cachedValue;
    }

    @Override
    public String getVariableTypeName() {
        return this.variableType != null ? this.variableType.getTypeName() : null;
    }

    @Override
    public VariableType getVariableType() {
        if (this.variableType == null && WfUtils.isNotEmpty(this.getTypeName()) && Context.getCommandContext() != null && Context.getCommandContext().getProcessEngineConfiguration() != null) {
            this.variableType = Context.getCommandContext().getProcessEngineConfiguration().getVariableTypes().getVariableType(this.getTypeName());
        }
        return this.variableType;
    }

    @Override
    public void setVariableType(VariableType variableType) {
        this.variableType = variableType;
        this.setTypeName(variableType.getTypeName());
    }

    @Override
    @SimplePropertyAttribute(name="typeName")
    public String getTypeName() {
        return this.dynamicObject.getString("typeName");
    }

    @Override
    public void setTypeName(String variableType) {
        this.dynamicObject.set("typeName", (Object)variableType);
        if (Context.getCommandContext() != null && Context.getCommandContext().getProcessEngineConfiguration() != null) {
            VariableType type;
            this.variableType = type = Context.getCommandContext().getProcessEngineConfiguration().getVariableTypes().getVariableType(variableType);
        }
    }

    @Override
    public String getVariableName() {
        return this.getName();
    }

    @Override
    @SimplePropertyAttribute(name="name")
    public String getName() {
        return this.dynamicObject.getString("name");
    }

    @Override
    public void setName(String name) {
        this.dynamicObject.set("name", (Object)name);
    }

    @Override
    @SimplePropertyAttribute(name="longValue")
    public Long getLongValue() {
        long val = this.dynamicObject.getLong("longValue");
        if (WfUtils.isEmpty(val)) {
            try {
                String text = this.getTextValue();
                if (WfUtils.isNotEmpty(text)) {
                    val = Long.parseLong(text);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return val;
    }

    @Override
    public void setLongValue(Long longValue) {
        this.dynamicObject.set("longValue", (Object)longValue);
    }

    @Override
    @SimplePropertyAttribute(name="doubleValue")
    public Double getDoubleValue() {
        BigDecimal ret = this.dynamicObject.getBigDecimal("doubleValue");
        if (ret != null) {
            return ret.doubleValue();
        }
        return null;
    }

    @Override
    public void setDoubleValue(Double doubleValue) {
        this.dynamicObject.set("doubleValue", (Object)doubleValue);
    }

    @Override
    @SimplePropertyAttribute(name="textValue")
    public String getTextValue() {
        return this.dynamicObject.getString("textValue");
    }

    @Override
    public void setTextValue(String textValue) {
        this.dynamicObject.set("textValue", (Object)textValue);
    }

    @Override
    @SimplePropertyAttribute(name="textValue2")
    public String getTextValue2() {
        return this.dynamicObject.getString("textValue2");
    }

    @Override
    public void setTextValue2(String textValue2) {
        this.dynamicObject.set("textValue2", (Object)textValue2);
    }

    @Override
    @SimplePropertyAttribute(name="processInstanceId")
    public Long getProcessInstanceId() {
        return this.normalizeId(this.dynamicObject.getLong("processInstanceId"));
    }

    @Override
    public void setProcessInstanceId(Long processInstanceId) {
        this.dynamicObject.set("processInstanceId", (Object)processInstanceId);
    }

    @Override
    @SimplePropertyAttribute(name="taskId")
    public Long getTaskId() {
        return this.normalizeId(this.dynamicObject.getLong("taskId"));
    }

    @Override
    public void setTaskId(Long taskId) {
        this.dynamicObject.set("taskId", (Object)taskId);
    }

    @Override
    @SimplePropertyAttribute(name="actInstId")
    public Long getActInstId() {
        return this.normalizeId(this.dynamicObject.getLong("actInstId"));
    }

    @Override
    public void setActInstId(Long actInstId) {
        this.dynamicObject.set("actInstId", (Object)actInstId);
    }

    @SimplePropertyAttribute(name="time")
    public Date getTime() {
        return this.dynamicObject.getDate("time");
    }

    @Override
    public void setTime(Date time) {
        this.dynamicObject.set("time", (Object)time);
    }

    @Override
    @SimplePropertyAttribute(name="executionId")
    public Long getExecutionId() {
        return this.normalizeId(this.dynamicObject.getLong("executionId"));
    }

    @Override
    public void setExecutionId(Long executionId) {
        this.dynamicObject.set("executionId", (Object)executionId);
    }

    @Override
    public Object getCachedValue() {
        return this.cachedValue;
    }

    @Override
    public void setCachedValue(Object cachedValue) {
        this.cachedValue = cachedValue;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HistoricVariableInstanceEntity[");
        sb.append("id=").append(this.getId());
        sb.append(", name=").append(this.getName());
        sb.append(", type=").append(this.variableType != null ? this.variableType.getTypeName() : "null");
        if (this.getLongValue() != null) {
            sb.append(", longValue=").append(this.getLongValue());
        }
        if (this.getDoubleValue() != null) {
            sb.append(", doubleValue=").append(this.getDoubleValue());
        }
        if (WfUtils.isNotEmpty(this.getTextValue())) {
            sb.append(", textValue=").append(StringUtils.abbreviate((String)this.getTextValue(), (int)40));
        }
        sb.append(']');
        return sb.toString();
    }
}

