/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.history;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.history.HistoryLevel;
import kd.bos.workflow.engine.impl.persistence.CachedEntityMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.HistoricVariableInstanceByProcInstMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.HistoricVariableInstanceByTaskIdMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricVariableInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricVariableInstanceEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricVariableInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.VariableInstanceEntity;
import kd.bos.workflow.engine.impl.variable.ValueFields;

public class HistoricVariableInstanceEntityManagerImpl
extends AbstractEntityManager<HistoricVariableInstanceEntity>
implements HistoricVariableInstanceEntityManager {
    protected CachedEntityMatcher<HistoricVariableInstanceEntity> historicVariableInstanceByTaskIdMatcher = new HistoricVariableInstanceByTaskIdMatcher();
    protected CachedEntityMatcher<HistoricVariableInstanceEntity> historicVariableInstanceByProcInstMatcher = new HistoricVariableInstanceByProcInstMatcher();

    public HistoricVariableInstanceEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public Class<? extends HistoricVariableInstanceEntity> getManagedEntityClass() {
        return HistoricVariableInstanceEntityImpl.class;
    }

    @Override
    public String getSelectFields() {
        return "id,taskid,actInstId,time,processinstanceid,executionid,name,typename,doublevalue,longvalue,textvalue,textvalue2,createdate,modifydate";
    }

    @Override
    public HistoricVariableInstanceEntity copyAndInsert(VariableInstanceEntity variableInstance) {
        HistoricVariableInstanceEntity historicVariableInstance = (HistoricVariableInstanceEntity)this.create();
        historicVariableInstance.setId(variableInstance.getId());
        historicVariableInstance.setProcessInstanceId(variableInstance.getProcessInstanceId());
        historicVariableInstance.setExecutionId(variableInstance.getExecutionId());
        historicVariableInstance.setTaskId(variableInstance.getTaskId());
        historicVariableInstance.setActInstId(variableInstance.getActInstId());
        historicVariableInstance.setName(variableInstance.getName());
        historicVariableInstance.setVariableType(variableInstance.getType());
        this.copyVariableValue(historicVariableInstance, variableInstance);
        Date time = this.getClock().getCurrentTime();
        historicVariableInstance.setCreateDate(time);
        historicVariableInstance.setModifyDate(time);
        this.insert(historicVariableInstance);
        return historicVariableInstance;
    }

    @Override
    public void copyVariableValue(HistoricVariableInstanceEntity historicVariableInstance, VariableInstanceEntity variableInstance) {
        historicVariableInstance.setTextValue(variableInstance.getTextValue());
        historicVariableInstance.setDoubleValue(variableInstance.getDoubleValue());
        historicVariableInstance.setLongValue(variableInstance.getLongValue());
        historicVariableInstance.setVariableType(variableInstance.getType());
        if (WfUtils.isEmpty(historicVariableInstance.getTaskId()) && WfUtils.isNotEmpty(variableInstance.getTaskId())) {
            historicVariableInstance.setTaskId(variableInstance.getTaskId());
        }
        historicVariableInstance.setModifyDate(this.getClock().getCurrentTime());
    }

    @Override
    public void delete(HistoricVariableInstanceEntity entity, boolean fireDeleteEvent) {
        super.delete(entity, fireDeleteEvent);
    }

    @Override
    public void deleteHistoricVariableInstanceByProcessInstanceId(Long historicProcessInstanceId) {
        if (this.getHistoryManager().isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            EntityQueryBuilder eb = this.createQueryBuilder().addFilter("processInstanceId", historicProcessInstanceId);
            List historicProcessVariables = this.findByQueryBuilder(eb);
            for (HistoricVariableInstanceEntity historicProcessVariable : historicProcessVariables) {
                this.delete(historicProcessVariable);
            }
        }
    }

    @Override
    public void deleteHistoricVariableInstancesByTaskId(Long taskId) {
        if (this.getHistoryManager().isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            List<HistoricVariableInstanceEntity> historicProcessVariables = this.findHistoricVariableInstancesByTaskId(taskId);
            for (HistoricVariableInstanceEntity historicProcessVariable : historicProcessVariables) {
                this.delete(historicProcessVariable);
            }
        }
    }

    @Override
    public Map<String, Object> findVariablesByExecution(Long execution) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("executionId", execution);
        List list = this.findByQueryBuilder(eb);
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (list != null) {
            for (HistoricVariableInstanceEntity var : list) {
                ret.put(var.getName(), var.getValue());
            }
        }
        return ret;
    }

    @Override
    public Map<String, Object> findVariablesByTaskId(Long taskId) {
        List<HistoricVariableInstanceEntity> col = this.findHistoricVariableInstancesByTaskId(taskId);
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (col != null) {
            for (HistoricVariableInstanceEntity var : col) {
                ret.put(var.getName(), var.getValue());
            }
        }
        return ret;
    }

    @Override
    public List<HistoricVariableInstanceEntity> findHistoricVariableInstancesByExecutionId(Long executionId) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("executionId", executionId);
        return this.findByQueryBuilder(eb);
    }

    @Override
    public List<HistoricVariableInstanceEntity> findHistoricVariableInstancesByTaskId(Long taskId) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("taskId", taskId);
        return this.findByQueryBuilder(eb, this.historicVariableInstanceByTaskIdMatcher, taskId, true);
    }

    @Override
    public HistoricVariableInstanceEntity findHistoricVariableInstancesByTaskIdAndVarName(Long taskId, String variableName) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("taskId", taskId).addFilter("name", variableName);
        List<HistoricVariableInstanceEntity> ret = this.findByQueryBuilder(eb, this.historicVariableInstanceByTaskIdMatcher, taskId, true);
        if (WfUtils.isNotEmptyForCollection(ret) && WfUtils.isNotEmpty(variableName)) {
            for (HistoricVariableInstanceEntity entity : ret) {
                if (!variableName.equals(entity.getName())) continue;
                return entity;
            }
        }
        return null;
    }

    @Override
    public Map<String, HistoricVariableInstanceEntity> findHistoricVariableInstancesByTaskIdAndVarNames(Long taskId, String ... varnames) {
        HashMap<String, HistoricVariableInstanceEntity> varMap = new HashMap<String, HistoricVariableInstanceEntity>();
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("taskId", taskId).addFilter("name", "in", varnames);
        List<HistoricVariableInstanceEntity> ret = this.findByQueryBuilder(eb, this.historicVariableInstanceByTaskIdMatcher, taskId, true);
        if (ret != null && !ret.isEmpty()) {
            for (HistoricVariableInstanceEntity variable : ret) {
                varMap.put(variable.getName(), variable);
            }
        }
        return varMap;
    }

    @Override
    public HistoricVariableInstanceEntity findHistoricVariableInstanceByVariableInstanceId(Long variableInstanceId) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("id", variableInstanceId);
        List list = this.findByQueryBuilder(eb);
        return list != null && list.size() > 0 ? (HistoricVariableInstanceEntity)list.get(0) : null;
    }

    @Override
    public List<HistoricVariableInstanceEntity> findHistoricVariableInstancesByProcessInstanceId(Long processInstanceId) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("processInstanceId", processInstanceId);
        return this.findByQueryBuilder(eb);
    }

    @Override
    public Map<String, String> findBizApplierInfoByProcessInstanceId(Long processInstanceId) {
        List<HistoricVariableInstanceEntity> entities = this.findHistoricVariableInstancesByProcessInstanceId(processInstanceId);
        HashMap<String, String> bizApplierInfo = new HashMap<String, String>();
        for (HistoricVariableInstanceEntity variableInstanceEntity : entities) {
            String variableName = variableInstanceEntity.getName();
            if (variableName.equals("bizApplier")) {
                bizApplierInfo.put("bizApplier", variableInstanceEntity.getTextValue());
            }
            if (!variableName.equals("bizApplierName")) continue;
            bizApplierInfo.put("bizApplierName", variableInstanceEntity.getTextValue());
        }
        return bizApplierInfo;
    }

    @Override
    protected void fixSpecialProp(HistoricVariableInstanceEntity t) {
        super.fixSpecialProp(t);
        String typeName = t.getTypeName();
        if (WfUtils.isNotEmpty(typeName)) {
            t.setVariableType(this.processEngineConfiguration.getVariableTypes().getVariableType(typeName));
        }
    }

    @Override
    public String getEntityName() {
        return "wf_hivarinst";
    }

    @Override
    public String getTableName() {
        return "t_wf_hivarinst";
    }

    @Override
    public String getMultiLangTableName() {
        return "t_wf_hivarinst_l";
    }

    @Override
    public Map<String, Object> findHistoricVariableInstancesByExecutionId(Long executionId, String[] name) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("executionId", executionId).addFilter("name", "in", name).setSelectFields(String.format("%s,%s,%s,%s,%s", "name", "typeName", "longValue", "doubleValue", "textValue"));
        List o = this.findByQueryBuilder(eb);
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (o != null && o.size() > 0) {
            for (HistoricVariableInstanceEntity t : o) {
                ret.put(t.getName(), t.getValue());
            }
        }
        return ret;
    }

    @Override
    public List<ValueFields> findHistoricVariableInstancesByProcessInstanceId(Long procInstanceId, String[] name) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("processInstanceId", procInstanceId).addFilter("name", "in", name);
        List o = this.findByQueryBuilder(eb);
        ArrayList<ValueFields> tmp = new ArrayList<ValueFields>(o == null ? 0 : o.size());
        if (o != null && o.size() > 0) {
            for (HistoricVariableInstanceEntity t : o) {
                tmp.add(t);
            }
        }
        return tmp;
    }
}

