/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.history.separatestorage.collector;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.EntityNumberConstant;
import kd.bos.workflow.engine.TableNameConstant;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.params.EntityQueryParams;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.history.separatestorage.common.AbstractCollector;
import kd.bos.workflow.engine.impl.persistence.entity.history.separatestorage.common.DefaultSqlSelector;
import kd.bos.workflow.engine.impl.persistence.entity.history.separatestorage.common.EntitySelector;
import kd.bos.workflow.engine.impl.persistence.entity.history.separatestorage.common.ISelector;
import kd.bos.workflow.service.impl.ThreadLocalVariables;

public class HistoricProcessInstanceCollector
extends AbstractCollector {
    private static final String ENTRABILLNAME = "entrabillname";

    public DataSet getHiProinstanceByStartuserid(String uid, String billType, String entityNumber, int start, int limit, String filterSql, List<Object> paramsList, String orderBy) {
        List<String> separateStorageKeys = this.getSeparateStorageKeys();
        ArrayList<ISelector> iSelectors = new ArrayList<ISelector>(separateStorageKeys.size());
        separateStorageKeys.forEach(key -> iSelectors.add(this.getHiProinstanceByStartuserid((String)key, uid, billType, entityNumber, start, limit, filterSql, paramsList, orderBy)));
        DataSet result = this.serialCollect(iSelectors);
        if (result != null) {
            StringBuilder orderBySb = new StringBuilder();
            if (WfUtils.isNotEmpty(orderBy)) {
                orderBySb.append(this.getAliasOrderByStr(orderBy, "applyed")).append(",");
            }
            orderBySb.append("endtime desc");
            result = result.orderBy(orderBySb.toString().split(",")).limit(start, limit);
        }
        return result;
    }

    public DataSet getHistoricProcessList(EntityQueryParams entityQueryParams) {
        List<String> separateStorageKeys = this.getSeparateStorageKeys(entityQueryParams.getSource());
        ArrayList<ISelector> iSelectors = new ArrayList<ISelector>(separateStorageKeys.size());
        separateStorageKeys.forEach(key -> iSelectors.add(this.getHistoricProcess((String)key, entityQueryParams)));
        DataSet result = this.serialCollect(iSelectors);
        if (result != null) {
            StringBuilder orderBySb = new StringBuilder();
            if (WfUtils.isNotEmpty(entityQueryParams.getMainEntityQueryParams().getOriginalOrderBySql())) {
                orderBySb.append(entityQueryParams.getMainEntityQueryParams().getOriginalOrderBySql());
            }
            if (orderBySb.length() > 0) {
                result = result.orderBy(orderBySb.toString().split(","));
            }
            result = result.limit(0, entityQueryParams.getLimit());
        }
        return result;
    }

    private EntitySelector getHistoricProcess(String separateStorageKey, EntityQueryParams entityQueryParams) {
        String hiProcTableName = EntityNumberConstant.getHiProcInstEntityNumber(separateStorageKey);
        String queryFields = entityQueryParams.getMainEntityQueryParams().getQueryALLFields();
        QFilter[] qFilters = this.buildHistoricProcessQfilter(entityQueryParams);
        String orderby = entityQueryParams.getMainEntityQueryParams().getOrderBySql();
        return this.createEntitySelector("WfTaskCenter.getHistoricProcess", hiProcTableName, queryFields, qFilters, orderby, entityQueryParams.getStart(), entityQueryParams.getLimit(), separateStorageKey);
    }

    private QFilter[] buildHistoricProcessQfilter(EntityQueryParams entityQueryParams) {
        List<QFilter> params;
        QFilter qFilter;
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        if (entityQueryParams.getUserId() == null) {
            qFilter = new QFilter("endtime", "is not null", null).and(new QFilter("endtype", "<>", (Object)"20"));
            qFilterList.add(qFilter);
        } else {
            qFilter = new QFilter("creatorid", "=", (Object)entityQueryParams.getUserId()).and(new QFilter("endtime", "is not null", null)).and(new QFilter("endtype", "<>", (Object)"20"));
            qFilterList.add(qFilter);
        }
        String noCodeFlow = ThreadLocalVariables.get();
        if (WfUtils.isNotEmpty(noCodeFlow)) {
            qFilterList.add(new QFilter("processtype", "=", (Object)noCodeFlow));
        }
        if ((params = entityQueryParams.getMainEntityQueryParams().getQFilter()) != null && params.size() > 0) {
            qFilterList.addAll(params);
        }
        return (QFilter[])qFilterList.stream().toArray(QFilter[]::new);
    }

    public int getHistoricProcessCount(EntityQueryParams entityQueryParams) {
        List<String> separateStorageKeys = this.getSeparateStorageKeys(entityQueryParams.getSource());
        ArrayList<ISelector> iSelectors = new ArrayList<ISelector>(separateStorageKeys.size());
        separateStorageKeys.forEach(key -> iSelectors.add(this.getHistoricProcessCount((String)key, entityQueryParams)));
        return this.serialCollectDataCount(iSelectors);
    }

    private EntitySelector getHistoricProcessCount(String separateStorageKey, EntityQueryParams entityQueryParams) {
        String hiProcTableName = EntityNumberConstant.getHiProcInstEntityNumber(separateStorageKey);
        QFilter[] qFilters = this.buildHistoricProcessQfilter(entityQueryParams);
        return this.createEntitySelector("WfTaskCenter.getHistoricProcessCount", hiProcTableName, qFilters, separateStorageKey);
    }

    public DataSet innerGetUnionCount(String billType, String entityNumber, String filterSql, List<Object> paramsList, String uid, boolean isAuditFlow) {
        List<String> separateStorageKeys = this.getSeparateStorageKeys();
        ArrayList<ISelector> iSelectors = new ArrayList<ISelector>(separateStorageKeys.size());
        separateStorageKeys.forEach(key -> iSelectors.add(this.innerGetUnionCount((String)key, billType, entityNumber, filterSql, paramsList, uid, isAuditFlow)));
        DataSet result = this.serialCollect(iSelectors);
        return result;
    }

    private DefaultSqlSelector innerGetUnionCount(String separateStorageKey, String billType, String entityNumber, String filterSql, List<Object> paramsList, String uid, boolean isAuditFlow) {
        String hiProcTableName = TableNameConstant.getHiProcInstTableName(separateStorageKey);
        String hiProcMultiLTableName = String.format("%s_l", hiProcTableName);
        String sql = null;
        String entityFilter = "";
        String billFilter = "";
        ArrayList<Object> params = new ArrayList<Object>();
        if (WfUtils.isNotEmpty(billType)) {
            billFilter = " and a.fbilltype=?";
            params.add(billType);
        }
        if (WfUtils.isNotEmpty(entityNumber)) {
            entityFilter = " and a.fentitynumber=?";
            params.add(entityNumber);
        }
        String userFilter = "";
        if (WfUtils.isNotEmpty(uid)) {
            userFilter = " and a.fcreatorid=" + Long.valueOf(uid);
        }
        if (WfUtils.isEmpty(filterSql)) {
            StringBuilder sqlTpl = new StringBuilder("select count(1) count from ");
            sqlTpl.append(hiProcTableName).append(" a WHERE a.fendtype<>'20' ");
            sqlTpl.append(" %s %s %s");
            if (isAuditFlow) {
                sqlTpl.append(String.format(" AND a.fprocesstype = '%s'", ModelType.AuditFlow.name()));
            }
            sqlTpl.append(" AND a.fendtime is not null ");
            sql = String.format(sqlTpl.toString(), userFilter, entityFilter, billFilter);
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("select count(1) count from ").append(hiProcTableName).append(" a ").append("left join ").append(hiProcMultiLTableName).append(" b ").append("on a.fid = b.fid and b.flocaleid = ? ").append(" WHERE a.fendtype<>'20' ").append(" %s %s %s %s");
            if (isAuditFlow) {
                sb.append(String.format(" AND a.fprocesstype = '%s'", ModelType.AuditFlow.name()));
            }
            sb.append(" AND a.fendtime is not null ");
            sql = String.format(sb.toString(), userFilter, entityFilter, billFilter, filterSql);
            params.add(0, RequestContext.get().getLang().toString());
        }
        params.addAll(paramsList);
        return this.createDefaultSelector("WFTASK.hiproinstCount", sql, params, separateStorageKey);
    }

    private DefaultSqlSelector getHiProinstanceByStartuserid(String separateStorageKey, String uid, String billType, String entityNumber, int start, int limit, String filterSql, List<Object> paramsList, String orderBy) {
        String hiProcTableName = TableNameConstant.getHiProcInstTableName(separateStorageKey);
        String hiProcMultiLTableName = String.format("%s_l", hiProcTableName);
        String lang = RequestContext.get().getLang().toString();
        String masterTableAlias = "a";
        String multiLangTableAlias = "b";
        String entraBillNameSQL = WfMultiLangUtils.getGeneralLangSQL(EntityNumberConstant.getHiProcInstEntityNumber(separateStorageKey), masterTableAlias, multiLangTableAlias, "fentrabillname", "entrabillnameshow", ENTRABILLNAME);
        String subjectSQL = WfMultiLangUtils.getGeneralLangSQL(EntityNumberConstant.getHiProcInstEntityNumber(separateStorageKey), masterTableAlias, multiLangTableAlias, "fsubject", "subjectshow", "subject");
        String nameSQL = WfMultiLangUtils.getGeneralLangSQL(EntityNumberConstant.getHiProcInstEntityNumber(separateStorageKey), masterTableAlias, multiLangTableAlias, "FNAME", "proandversion", "name");
        StringBuilder sqlSb = new StringBuilder();
        sqlSb.append(String.format("SELECT top %s", start + limit));
        sqlSb.append(" a.fid id,");
        sqlSb.append(entraBillNameSQL).append(",");
        sqlSb.append(subjectSQL).append(",");
        sqlSb.append("a.fbillno billno,");
        sqlSb.append("a.fcreateDate createdate,");
        sqlSb.append("a.fendtime endtime,");
        sqlSb.append("a.fprocesstype processtype,");
        sqlSb.append("a.fduration duration,");
        sqlSb.append("a.frealduration realduration,");
        String hour = ResManager.loadKDString((String)"\u5c0f\u65f6", (String)"HistoricProcessInstanceEntityManagerImpl_1", (String)"bos-wf-engine", (Object[])new Object[0]);
        boolean isOpenWorkCalendar = WfConfigurationUtil.getIsOpenWorkCalendar();
        if (isOpenWorkCalendar && WfConfigurationUtil.enableWorkCalendar()) {
            sqlSb.append(String.format(" concat(round(a.frealduration/3600/1000.0,2), '%s') handletime,", hour));
        } else {
            sqlSb.append(String.format(" concat(round(a.fduration/3600/1000.0,2), '%s') handletime,", hour));
        }
        sqlSb.append(String.format(" concat(round(a.fduration/3600/1000.0,2), '%s') totalhandleduration,", hour));
        sqlSb.append("a.fpriorityshow priorityshow,");
        sqlSb.append(nameSQL);
        sqlSb.append(" FROM ").append(hiProcTableName).append(" a LEFT JOIN ").append(hiProcMultiLTableName).append(" b ON a.fid = b.fid  AND b.flocaleid = ?");
        sqlSb.append(" WHERE a.fcreatorid = ? AND a.fendtime Is NOT NULL ");
        sqlSb.append(WfUtils.isEmpty(billType) ? "" : "AND a.fbilltype = ? ");
        sqlSb.append(" AND a.fendtype <>'20' ");
        sqlSb.append(WfUtils.isEmpty(entityNumber) ? "" : "AND a.FENTITYNUMBER = ? ");
        sqlSb.append(WfUtils.isNotEmpty(filterSql) ? filterSql : " ");
        sqlSb.append(String.format(" ORDER BY %s a.FENDTIME DESC", WfUtils.isEmpty(orderBy) ? "" : orderBy + ","));
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(lang);
        params.add(Long.valueOf(uid));
        if (WfUtils.isNotEmpty(entityNumber)) {
            params.add(entityNumber);
        }
        if (WfUtils.isNotEmpty(billType)) {
            params.add(billType);
        }
        params.addAll(paramsList);
        return this.createDefaultSelector("WfTaskCenter.t_wf_hiprocinst.queryGridData", sqlSb.toString(), params, separateStorageKey);
    }

    @Override
    protected String getOriginalEntityNumber() {
        return "wf_hiprocinst";
    }
}

