/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.history.separatestorage.collector;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.EntityNumberConstant;
import kd.bos.workflow.engine.TableNameConstant;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.params.EntityQueryParams;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.history.separatestorage.common.AbstractCollector;
import kd.bos.workflow.engine.impl.persistence.entity.history.separatestorage.common.DefaultSqlSelector;
import kd.bos.workflow.engine.impl.persistence.entity.history.separatestorage.common.EntitySelector;
import kd.bos.workflow.engine.impl.persistence.entity.history.separatestorage.common.ISelector;
import kd.bos.workflow.feature.taskfield.util.TaskExtendFieldUtil;
import kd.bos.workflow.service.impl.ThreadLocalVariables;

public class HistoricTaskInstanceCollector
extends AbstractCollector {
    public DataSet getHandledTasksByAssigneeid(String uid, String billType, String entityNumber, int start, int limit, String filterSql, String showType, List<Object> paramsList, String orderBy) {
        List<String> separateStorageKeys = this.getSeparateStorageKeys();
        ArrayList<ISelector> iSelectors = new ArrayList<ISelector>(separateStorageKeys.size());
        separateStorageKeys.forEach(key -> iSelectors.add(this.getHandledTasksByAssigneeid((String)key, uid, billType, entityNumber, start, limit, filterSql, showType, paramsList, orderBy)));
        DataSet result = this.serialCollect(iSelectors);
        if (result != null) {
            StringBuilder orderBySb = new StringBuilder();
            if (WfUtils.isNotEmpty(orderBy)) {
                orderBySb.append(this.getAliasOrderByStr(orderBy, "handled")).append(",");
            }
            orderBySb.append("ENDTIME desc");
            result = result.orderBy(orderBySb.toString().split(",")).limit(start, limit);
        }
        return result;
    }

    public DataSet getHandledTasksUnionCountByAssigneeid(String uid, String billType, String entityNumber, String filterSql, List<Object> paramsList) {
        List<String> separateStorageKeys = this.getSeparateStorageKeys();
        ArrayList<ISelector> iSelectors = new ArrayList<ISelector>(separateStorageKeys.size());
        separateStorageKeys.forEach(key -> iSelectors.add(this.getHandledTasksUnionCountByAssigneeid((String)key, uid, billType, entityNumber, filterSql, paramsList)));
        DataSet result = this.serialCollect(iSelectors);
        return result;
    }

    public DataSet getHandledTaskByFolderId(long folderId, int start, int limit, String filterSql, List<Object> paramsList, String orderBy) {
        List<String> separateStorageKeys = this.getSeparateStorageKeys();
        ArrayList<ISelector> iSelectors = new ArrayList<ISelector>(separateStorageKeys.size());
        separateStorageKeys.forEach(key -> iSelectors.add(this.getHandledTaskByFolderId((String)key, folderId, start, limit, filterSql, paramsList, orderBy)));
        DataSet result = this.serialCollect(iSelectors);
        if (result != null) {
            String orderByStr = this.getAliasOrderByStr(orderBy, "handled");
            orderByStr = WfUtils.isNotEmpty(orderByStr) ? orderByStr : "id desc";
            result = result.orderBy(orderByStr.split(",")).limit(start, limit);
        }
        return result;
    }

    public DataSet getHandledTaskCountByFolderId(long folderId, String filterSql, List<Object> paramsList) {
        List<String> separateStorageKeys = this.getSeparateStorageKeys();
        ArrayList<ISelector> iSelectors = new ArrayList<ISelector>(separateStorageKeys.size());
        separateStorageKeys.forEach(key -> iSelectors.add(this.getHandledTaskCountByFolderId((String)key, folderId, filterSql, paramsList)));
        DataSet result = this.serialCollect(iSelectors);
        return result;
    }

    public DataSet getHandledTasksByAssigneeidAndSingleRelationQuery(String uid, String billType, String entityNumber, int start, int limit, String filterSql, String showType, List<Object> paramsList, String orderBy) {
        List<String> separateStorageKeys = this.getSeparateStorageKeys();
        ArrayList<ISelector> iSelectors = new ArrayList<ISelector>(separateStorageKeys.size());
        separateStorageKeys.forEach(key -> iSelectors.add(this.getHandledTasksByAssigneeidAndSingleRelationQuery((String)key, uid, billType, entityNumber, start, limit, filterSql, showType, paramsList, orderBy)));
        DataSet result = this.serialCollect(iSelectors);
        if (result != null) {
            StringBuilder orderBySb = new StringBuilder();
            if (WfUtils.isNotEmpty(orderBy)) {
                orderBySb.append(this.getAliasOrderByStr(orderBy, "handled")).append(",");
            }
            orderBySb.append("ENDTIME desc");
            result = result.orderBy(orderBySb.toString().split(",")).limit(start, limit);
        }
        return result;
    }

    public DataSet getHandledTasksUnionCountByAssigneeidAndSingleRelationQuery(String uid, String billType, String entityNumber, String filterSql, List<Object> paramsList) {
        List<String> separateStorageKeys = this.getSeparateStorageKeys();
        ArrayList<ISelector> iSelectors = new ArrayList<ISelector>(separateStorageKeys.size());
        separateStorageKeys.forEach(key -> iSelectors.add(this.getHandledTasksUnionCountByAssigneeidAndSingleRelationQuery((String)key, uid, billType, entityNumber, filterSql, paramsList)));
        DataSet result = this.serialCollect(iSelectors);
        return result;
    }

    public DataSet getHandledTaskByFolderIdAndSingleRelationQuery(Long folderId, int start, int limit, String filterSql, List<Object> paramsList, String orderBy) {
        List<String> separateStorageKeys = this.getSeparateStorageKeys();
        ArrayList<ISelector> iSelectors = new ArrayList<ISelector>(separateStorageKeys.size());
        separateStorageKeys.forEach(key -> iSelectors.add(this.getHandledTaskByFolderIdAndSingleRelationQuery((String)key, folderId, start, limit, filterSql, paramsList, orderBy)));
        DataSet result = this.serialCollect(iSelectors);
        if (result != null) {
            String orderByStr = this.getAliasOrderByStr(orderBy, "handled");
            orderByStr = WfUtils.isNotEmpty(orderByStr) ? orderByStr : "id desc";
            result = result.orderBy(orderByStr.split(",")).limit(start, limit);
        }
        return result;
    }

    public DataSet getHandledTaskCountByFolderIdAndSingleRelationQuery(long folderId, String filterSql, List<Object> paramsList) {
        List<String> separateStorageKeys = this.getSeparateStorageKeys();
        ArrayList<ISelector> iSelectors = new ArrayList<ISelector>(separateStorageKeys.size());
        separateStorageKeys.forEach(key -> iSelectors.add(this.getHandledTaskCountByFolderIdAndSingleRelationQuery((String)key, folderId, filterSql, paramsList)));
        DataSet result = this.serialCollect(iSelectors);
        return result;
    }

    private DefaultSqlSelector getHandledTaskCountByFolderIdAndSingleRelationQuery(String separateStorageKey, long folderId, String filterSql, List<Object> paramsList) {
        String hiCommentTableName = TableNameConstant.getHiCommentTableName(separateStorageKey);
        String hiCommentMultiLTableName = String.format("%s_l", hiCommentTableName);
        long currentUserId = Long.parseLong(RequestContext.get().getUserId());
        String lang = RequestContext.get().getLang().toString();
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select count(1) count ");
        sql.append("from t_wf_rtrelation c ");
        sql.append("inner join ").append(hiCommentTableName).append(" a on c.ftaskid = a.ftaskid and c.fruleid = ? and a.fuserid = ? ");
        sql.append("inner join ").append(hiCommentMultiLTableName).append(" b on a.fid = b.fid and b.flocaleid = ? ");
        sql.append("where c.fruleid = ? ");
        sql.append("and a.fendtype != 'mobile' ");
        params.addAll(Arrays.asList(folderId, currentUserId, lang, folderId));
        if (WfUtils.isNotEmpty(filterSql)) {
            sql.append(filterSql);
            params.addAll(paramsList);
        }
        return this.createDefaultSelector("WfTaskCenterCustom.queryGridData", sql.toString(), params, separateStorageKey);
    }

    private DefaultSqlSelector getHandledTaskByFolderIdAndSingleRelationQuery(String separateStorageKey, Long folderId, int start, int limit, String filterSql, List<Object> paramsList, String orderBy) {
        String hiCommentEntityNumber = EntityNumberConstant.getHiCommentEntityNumber(separateStorageKey);
        String hiCommentTableName = TableNameConstant.getHiCommentTableName(separateStorageKey);
        String hiCommentMultiLTableName = String.format("%s_l", hiCommentTableName);
        long currentUserId = Long.parseLong(RequestContext.get().getUserId());
        String lang = RequestContext.get().getLang().toString();
        String masterTableAlias = "a";
        String multiLangTableAlias = "b";
        String participantTableAlias = "c";
        String participantMultiLangTableAlias = "e";
        String sourceNameSQL = WfMultiLangUtils.getGeneralLangSQL(hiCommentEntityNumber, masterTableAlias, multiLangTableAlias, "fsourcename", "sourcename", "sourcename");
        String entityNameSQL = WfMultiLangUtils.getGeneralLangSQL(hiCommentEntityNumber, masterTableAlias, multiLangTableAlias, "fentityname", "entityname", "entityname");
        String startNameSQL = WfMultiLangUtils.getGeneralLangSQL(hiCommentEntityNumber, masterTableAlias, multiLangTableAlias, "FSTARTNAME", "startname", "startname");
        String subjectSQL = WfMultiLangUtils.getGeneralLangSQL(hiCommentEntityNumber, masterTableAlias, multiLangTableAlias, "fcurrentsubject", "SUBJECT", "currentsubject");
        String nameSQL = WfMultiLangUtils.getGeneralLangSQL(hiCommentEntityNumber, masterTableAlias, multiLangTableAlias, "factivityname", "NAME", "activityname");
        String senderNameSQL = WfMultiLangUtils.getGeneralLangSQL(hiCommentEntityNumber, masterTableAlias, multiLangTableAlias, "fsendername", "sendername", "sendername");
        String senderNameFormatSQL = WfMultiLangUtils.getGeneralLangSQL(hiCommentEntityNumber, masterTableAlias, multiLangTableAlias, "fsendernameformat", "sendernameformat", "sendernameformat");
        String startNameFormatSQL = WfMultiLangUtils.getGeneralLangSQL(hiCommentEntityNumber, masterTableAlias, multiLangTableAlias, "fstartnameformat", "startnameformat", "startnameformat");
        String presentAssigneeSQL = WfMultiLangUtils.getGeneralLangSQL(hiCommentEntityNumber, masterTableAlias, multiLangTableAlias, "fpresentassignee", "presentassignee", "presentassignee");
        String currentSubjectSQL = WfMultiLangUtils.getGeneralLangSQL("wf_ruletaskrelation", participantTableAlias, participantMultiLangTableAlias, "fcurrentsubject", "currentsubject", "currentsubject");
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select top ").append(start + limit).append(" ");
        sql.append("a.ftaskid id, a.fbillno billno, ").append(sourceNameSQL).append(", ").append(entityNameSQL).append(", ").append(startNameSQL).append(", ").append(subjectSQL).append(", ").append(nameSQL).append(", ");
        sql.append("a.fhandlestate handlestate, ").append(senderNameSQL).append(", ").append(senderNameFormatSQL).append(", ").append(startNameFormatSQL).append(", ");
        sql.append("a.fcreatedate createdate, ").append(presentAssigneeSQL).append(", ").append(currentSubjectSQL).append(", ");
        sql.append("a.fprocesstype processtype, ");
        sql.append("a.ftime endtime ");
        sql.append("from t_wf_rtrelation c ");
        sql.append("left join t_wf_rtrelation_l e on c.fid = e.fid and e.flocaleid = ? and c.fruleid = ? ");
        sql.append("inner join ").append(hiCommentTableName).append(" a on c.ftaskid = a.ftaskid and a.fuserid = ? ");
        sql.append("inner join ").append(hiCommentMultiLTableName).append(" b on b.fid = a.fid and b.flocaleid = ? ");
        sql.append("where c.fruleid = ? ");
        sql.append("and a.fendtype != 'mobile' and a.fuserid > 0 and a.fexecutiontype not in ('skip', 'byAuto') ");
        params.addAll(Arrays.asList(lang, folderId, currentUserId, lang, folderId));
        if (WfUtils.isNotEmpty(filterSql)) {
            sql.append(filterSql);
            params.addAll(paramsList);
        }
        if (WfUtils.isNotEmpty(orderBy)) {
            sql.append(" order by ").append(orderBy).append(";");
        } else {
            sql.append(" order by ").append("a.fid desc;");
        }
        return this.createDefaultSelector("WfTaskCenterCustom.queryGridData", sql.toString(), params, separateStorageKey);
    }

    private DefaultSqlSelector getHandledTasksUnionCountByAssigneeidAndSingleRelationQuery(String separateStorageKey, String uid, String billType, String entityNumber, String filterSql, List<Object> paramsList) {
        String hiCommentTableName = TableNameConstant.getHiCommentTableName(separateStorageKey);
        String hiCommentSplitTableName = String.format("%s_A", hiCommentTableName);
        String hiCommentMultiLTableName = String.format("%s_l", hiCommentTableName);
        StringBuilder sql = new StringBuilder();
        sql.append("select count(1) count from ").append(hiCommentTableName).append(" a ");
        sql.append("LEFT JOIN ").append(hiCommentSplitTableName).append(" f on a.fid = f.fid ");
        sql.append("INNER JOIN ").append(hiCommentMultiLTableName).append(" b ON a.FID = b.FID and b.flocaleid = ? ");
        sql.append("where a.fuserid=? ");
        sql.append("and a.ftype in ('message','comment','forceReject','coordinate', 'converted', 'event') ");
        sql.append("and a.fexecutiontype in ('byHand','byExpireAuto','skip','forceReject','jump','enterBoundary','frozen','abandon','cancel','addSignBefore','compensation','manualdraw','manualpush', ' ') ");
        sql.append("and a.fisdisplay = '1' and a.fendtype != 'mobile' ");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(RequestContext.get().getLang().toString());
        params.add(Long.valueOf(uid));
        if (WfUtils.isNotEmpty(entityNumber)) {
            sql.append("and a.fentitynumber=? ");
            params.add(entityNumber);
        }
        if (WfUtils.isNotEmpty(billType)) {
            sql.append("and a.fbilltype=? ");
            params.add(billType);
        }
        if (WfUtils.isNotEmpty(filterSql)) {
            sql.append(filterSql);
            params.addAll(paramsList);
        }
        return this.createDefaultSelector("WFTASK.hitasksCount", sql.toString(), params, separateStorageKey);
    }

    private DefaultSqlSelector getHandledTasksByAssigneeidAndSingleRelationQuery(String separateStorageKey, String uid, String billType, String entityNumber, int start, int limit, String filterSql, String showType, List<Object> paramsList, String orderBy) {
        String hiCommentEntityNumber = EntityNumberConstant.getHiCommentEntityNumber(separateStorageKey);
        String hiCommentTableName = TableNameConstant.getHiCommentTableName(separateStorageKey);
        String hiCommentSplitTableName = String.format("%s_A", hiCommentTableName);
        String hiCommentMultiLTableName = String.format("%s_l", hiCommentTableName);
        String masterTableAlias = "a";
        String multiLangTableAlias = "b";
        String sourceNameSQL = WfMultiLangUtils.getGeneralLangSQL(hiCommentEntityNumber, masterTableAlias, multiLangTableAlias, "fsourcename", "sourcename", "sourcename");
        String entityNameSQL = WfMultiLangUtils.getGeneralLangSQL(hiCommentEntityNumber, masterTableAlias, multiLangTableAlias, "fentityname", "entityname", "entityname");
        String startNameSQL = WfMultiLangUtils.getGeneralLangSQL(hiCommentEntityNumber, masterTableAlias, multiLangTableAlias, "FSTARTNAME", "startname", "startname");
        String subjectSQL = WfMultiLangUtils.getGeneralLangSQL(hiCommentEntityNumber, masterTableAlias, multiLangTableAlias, "fcurrentsubject", "subject", "currentsubject");
        String nameSQL = WfMultiLangUtils.getGeneralLangSQL(hiCommentEntityNumber, masterTableAlias, multiLangTableAlias, "factivityname", "name", "activityname");
        String senderNameSQL = WfMultiLangUtils.getGeneralLangSQL(hiCommentEntityNumber, masterTableAlias, multiLangTableAlias, "fsendername", "sendername", "sendername");
        String senderNameFormatSQL = WfMultiLangUtils.getGeneralLangSQL(hiCommentEntityNumber, masterTableAlias, multiLangTableAlias, "fsendernameformat", "sendernameformat", "sendernameformat");
        String startNameFormatSQL = WfMultiLangUtils.getGeneralLangSQL(hiCommentEntityNumber, masterTableAlias, multiLangTableAlias, "fstartnameformat", "startnameformat", "startnameformat");
        String presentAssigneeSQL = WfMultiLangUtils.getGeneralLangSQL(hiCommentEntityNumber, masterTableAlias, multiLangTableAlias, "fpresentassignee", "presentassignee", "presentassignee");
        String currentSubjectSQL = WfMultiLangUtils.getGeneralLangSQL(hiCommentEntityNumber, masterTableAlias, multiLangTableAlias, "fcurrentsubject", "currentsubject", "currentsubject");
        String billEntityNumber = StringUtils.isNotBlank((CharSequence)entityNumber) ? entityNumber : billType;
        String businessFieldSql = "";
        if (TaskExtendFieldUtil.isNeedQueryBusinessField(billEntityNumber)) {
            JSONObject json = TaskExtendFieldUtil.getTaskBusinessSelectFields(hiCommentEntityNumber, billEntityNumber, masterTableAlias, multiLangTableAlias, "f");
            businessFieldSql = json.getString("taskBusinessFieldStr");
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT top ").append(start + limit).append(" a.ftaskid id,").append("a.fbillno billno,").append("a.FSTARTERID initiatorId,").append("a.FPROCESSINGPAGE processingpage,").append("a.fprocessingmobilepage processingmobilepage,").append("a.FBUSINESSKEY businesskey,").append("a.FBUSINESSKEY url,").append("a.FCATEGORY category,").append("a.FHANDLESTATE handlestate,").append("a.FCREATEDATE createdate,").append("a.FBUSINESSKEY userImgUrl,").append("a.FBUSINESSKEY openId,").append("a.ftype d_type,").append("a.FTIME ENDTIME,").append(sourceNameSQL).append(",").append(entityNameSQL).append(",").append(senderNameFormatSQL).append(",").append(startNameFormatSQL).append(",").append(startNameSQL).append(",").append(subjectSQL).append(",").append(nameSQL).append(",").append(senderNameSQL).append(",").append(presentAssigneeSQL).append(",").append(businessFieldSql).append("a.fprocesstype processtype").append(", ").append("a.fextendformat bizformat").append(", ").append(currentSubjectSQL).append(" FROM ").append(hiCommentTableName).append(" a");
        if (WfUtils.isNotEmpty(businessFieldSql) || filterSql.contains("f.")) {
            sql.append(" LEFT JOIN ").append(hiCommentSplitTableName).append(" f on a.fid = f.fid");
        }
        sql.append(" LEFT JOIN ").append(hiCommentMultiLTableName).append(" b on a.fid = b.fid and b.flocaleid = ? ").append(" where a.FUSERID = ? and a.ftype in ('message','comment','forceReject','coordinate', 'converted', 'event') ").append("and a.FEXECUTIONTYPE in ('byHand','byExpireAuto','skip','forceReject','jump','enterBoundary','frozen','abandon','cancel','addSignBefore','compensation','manualdraw','manualpush', ' ') ").append("and a.FISDISPLAY = '1'");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(RequestContext.get().getLang().toString());
        params.add(Long.valueOf(uid));
        if (WfUtils.isNotEmpty(showType)) {
            String endType = "";
            if ("mobile".equals(showType)) {
                endType = "pc";
            } else if ("pc".equals(showType)) {
                endType = "mobile";
            }
            sql.append(" AND a.fendtype != '").append(endType).append("' ");
        }
        if (WfUtils.isNotEmpty(billType)) {
            sql.append(" AND a.fbilltype = '").append(billType).append("' ");
        }
        if (WfUtils.isNotEmpty(entityNumber)) {
            sql.append(" AND a.fentitynumber = ? ");
            params.add(entityNumber);
        }
        if (WfUtils.isNotEmpty(filterSql)) {
            sql.append(" ").append(filterSql).append(" ");
            params.addAll(paramsList);
        }
        sql.append(" order by ");
        if (WfUtils.isNotEmpty(orderBy)) {
            sql.append(orderBy).append(",");
        }
        sql.append(" a.FTIME desc");
        return this.createDefaultSelector("WfTaskCenter.wf_task.queryGridData", sql.toString(), params, separateStorageKey);
    }

    private DefaultSqlSelector getHandledTaskCountByFolderId(String separateStorageKey, long folderId, String filterSql, List<Object> paramsList) {
        String hiTaskTableName = TableNameConstant.getHiTaskInstTableName(separateStorageKey);
        String hiTaskMultiLTableName = String.format("%s_l", hiTaskTableName);
        long currentUserId = Long.parseLong(RequestContext.get().getUserId());
        String lang = RequestContext.get().getLang().toString();
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select count(1) count ");
        sql.append("from t_wf_rtrelation c ");
        sql.append("inner join ").append(hiTaskTableName).append(" a on c.ftaskid = a.fid and c.fruleid = ? and a.fassigneeid = ? ");
        sql.append("inner join ").append(hiTaskMultiLTableName).append(" b on a.fid = b.fid and b.flocaleid = ? ");
        sql.append("where c.fruleid = ? ");
        sql.append("and a.fendtype != 'mobile' and a.fendtime is not null ");
        params.addAll(Arrays.asList(folderId, currentUserId, lang, folderId));
        if (WfUtils.isNotEmpty(filterSql)) {
            sql.append(filterSql);
            params.addAll(paramsList);
        }
        return this.createDefaultSelector("WfTaskCenterCustom.queryGridData", sql.toString(), params, separateStorageKey);
    }

    private DefaultSqlSelector getHandledTaskByFolderId(String separateStorageKey, long folderId, int start, int limit, String filterSql, List<Object> paramsList, String orderBy) {
        String hiTaskEntityNumber = EntityNumberConstant.getHiTaskInstEntityNumber(separateStorageKey);
        String hiTaskTableName = TableNameConstant.getHiTaskInstTableName(separateStorageKey);
        String hiTaskMultiLTableName = String.format("%s_l", hiTaskTableName);
        long currentUserId = Long.parseLong(RequestContext.get().getUserId());
        String lang = RequestContext.get().getLang().toString();
        String masterTableAlias = "a";
        String multiLangTableAlias = "b";
        String participantTableAlias = "c";
        String participantMultiLangTableAlias = "e";
        String sourceNameSQL = WfMultiLangUtils.getGeneralLangSQL(hiTaskEntityNumber, masterTableAlias, multiLangTableAlias, "fsourcename", "sourcename", "sourcename");
        String entityNameSQL = WfMultiLangUtils.getGeneralLangSQL(hiTaskEntityNumber, masterTableAlias, multiLangTableAlias, "fentityname", "entityname", "entityname");
        String startNameSQL = WfMultiLangUtils.getGeneralLangSQL(hiTaskEntityNumber, masterTableAlias, multiLangTableAlias, "FSTARTNAME", "startname", "startname");
        String subjectSQL = WfMultiLangUtils.getGeneralLangSQL(hiTaskEntityNumber, masterTableAlias, multiLangTableAlias, "FSUBJECT", "SUBJECT", "subject");
        String nameSQL = WfMultiLangUtils.getGeneralLangSQL(hiTaskEntityNumber, masterTableAlias, multiLangTableAlias, "FNAME", "NAME", "name");
        String senderNameSQL = WfMultiLangUtils.getGeneralLangSQL(hiTaskEntityNumber, masterTableAlias, multiLangTableAlias, "fsendername", "sendername", "sendername");
        String senderNameFormatSQL = WfMultiLangUtils.getGeneralLangSQL("wf_task", masterTableAlias, multiLangTableAlias, "fsendernameformat", "sendernameformat", "sendernameformat");
        String startNameFormatSQL = WfMultiLangUtils.getGeneralLangSQL("wf_task", masterTableAlias, multiLangTableAlias, "fstartnameformat", "startnameformat", "startnameformat");
        String presentAssigneeSQL = WfMultiLangUtils.getGeneralLangSQL(hiTaskEntityNumber, masterTableAlias, multiLangTableAlias, "fpresentassignee", "presentassignee", "presentassignee");
        String currentSubjectSQL = WfMultiLangUtils.getGeneralLangSQL("wf_ruletaskrelation", participantTableAlias, participantMultiLangTableAlias, "fcurrentsubject", "currentsubject", "currentsubject");
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select top ").append(start + limit).append(" ");
        sql.append("a.fid id, a.fbillno billno, ").append(sourceNameSQL).append(", ").append(entityNameSQL).append(", ").append(startNameSQL).append(", ").append(subjectSQL).append(", ").append(nameSQL).append(", ");
        sql.append("a.fhandlestate handlestate, ").append(senderNameSQL).append(", ").append(senderNameFormatSQL).append(", ").append(startNameFormatSQL).append(", ");
        sql.append("a.fcreatedate createdate, ").append(presentAssigneeSQL).append(", ").append(currentSubjectSQL).append(", ");
        sql.append("a.fprocesstype processtype, ");
        sql.append("a.fendtime endtime ");
        sql.append("from t_wf_rtrelation c ");
        sql.append("left join t_wf_rtrelation_l e on c.fid = e.fid and e.flocaleid = ? and c.fruleid = ? ");
        sql.append("inner join ").append(hiTaskTableName).append(" a on c.ftaskid = a.fid and a.fassigneeid = ? ");
        sql.append("inner join ").append(hiTaskMultiLTableName).append(" b on b.fid = a.fid and b.flocaleid = ? ");
        sql.append("where c.fruleid = ? ");
        sql.append("and a.fendtype != 'mobile' and a.fassigneeid > 0 and a.fendtime is not null and a.fexecutiontype not in ('skip', 'byAuto') ");
        params.addAll(Arrays.asList(lang, folderId, currentUserId, lang, folderId));
        if (WfUtils.isNotEmpty(filterSql)) {
            sql.append(filterSql);
            params.addAll(paramsList);
        }
        if (WfUtils.isNotEmpty(orderBy)) {
            sql.append(" order by ").append(orderBy).append(";");
        } else {
            sql.append(" order by ").append("a.fid desc;");
        }
        return this.createDefaultSelector("WfTaskCenterCustom.queryGridData", sql.toString(), params, separateStorageKey);
    }

    private DefaultSqlSelector getHandledTasksUnionCountByAssigneeid(String separateStorageKey, String uid, String billType, String entityNumber, String filterSql, List<Object> paramsList) {
        String hiCommentTableName = TableNameConstant.getHiCommentTableName(separateStorageKey);
        String hiTaskTableName = TableNameConstant.getHiTaskInstTableName(separateStorageKey);
        String hiTaskSplitTableName = String.format("%s_A", hiTaskTableName);
        String hiTaskMultiLTableName = String.format("%s_l", hiTaskTableName);
        String lang = RequestContext.get().getLang().toString();
        String noCodeFlow = ThreadLocalVariables.get();
        StringBuilder sql = new StringBuilder();
        sql.append("select count(1) count from ").append(hiCommentTableName).append(" d ");
        sql.append("INNER JOIN ").append(hiTaskTableName).append(" a ON a.fid = d.FTASKID and d.fuserid=? and d.ftype != 'suggestion' ");
        sql.append("LEFT JOIN ").append(hiTaskSplitTableName).append(" f on a.fid = f.fid ");
        sql.append("LEFT JOIN ").append(hiTaskMultiLTableName).append(" b ON a.FID = b.FID and b.flocaleid = ? ");
        sql.append("where d.fuserid=? and d.ftype != 'suggestion' ");
        sql.append("and a.fexecutiontype != ? and a.fisdisplay = '1' and a.fendtype != 'mobile' ");
        sql.append(WfUtils.isEmpty(entityNumber) ? " " : "and a.fentitynumber=? ");
        sql.append(WfUtils.isEmpty(noCodeFlow) ? " " : "and a.fprocesstype=? ");
        sql.append(WfUtils.isEmpty(billType) ? " " : "and a.fbilltype=? ");
        sql.append(WfUtils.isEmpty(filterSql) ? "" : filterSql);
        ArrayList<Object> params = new ArrayList<Object>();
        if (WfUtils.isEmpty(entityNumber)) {
            params.addAll(Arrays.asList(Long.valueOf(uid), lang, Long.valueOf(uid), "byAuto"));
        } else {
            params.addAll(Arrays.asList(Long.valueOf(uid), lang, Long.valueOf(uid), "byAuto", entityNumber));
        }
        if (WfUtils.isNotEmpty(noCodeFlow)) {
            params.add(ModelType.NoCodeFlow.name());
        }
        if (WfUtils.isNotEmpty(billType)) {
            params.add(billType);
        }
        params.addAll(paramsList);
        return this.createDefaultSelector("WFTASK.hitasksCount", sql.toString(), params, separateStorageKey);
    }

    private DefaultSqlSelector getHandledTasksByAssigneeid(String separateStorageKey, String uid, String billType, String entityNumber, int start, int limit, String filterSql, String showType, List<Object> paramsList, String orderBy) {
        String hiTaskEntityNumber = EntityNumberConstant.getHiTaskInstEntityNumber(separateStorageKey);
        String hiCommentEntityNumber = EntityNumberConstant.getHiCommentEntityNumber(separateStorageKey);
        String hiCommentTableName = TableNameConstant.getHiCommentTableName(separateStorageKey);
        String hiCommentMultiLTableName = String.format("%s_l", hiCommentTableName);
        String hiTaskTableName = TableNameConstant.getHiTaskInstTableName(separateStorageKey);
        String hiTaskMultiLTableName = String.format("%s_l", hiTaskTableName);
        String hiTaskSplitTableName = String.format("%s_A", hiTaskTableName);
        String lang = RequestContext.get().getLang().toString();
        String endType = "";
        if ("mobile".equals(showType)) {
            endType = "pc";
        } else if ("pc".equals(showType)) {
            endType = "mobile";
        }
        String noCodeFlow = ThreadLocalVariables.get();
        boolean flag = WfUtils.isEmpty(entityNumber);
        String masterTableAlias = "a";
        String multiLangTableAlias = "b";
        String sourceNameSQL = WfMultiLangUtils.getGeneralLangSQL(hiTaskEntityNumber, masterTableAlias, multiLangTableAlias, "fsourcename", "sourcename", "sourcename");
        String entityNameSQL = WfMultiLangUtils.getGeneralLangSQL(hiTaskEntityNumber, masterTableAlias, multiLangTableAlias, "fentityname", "entityname", "entityname");
        String startNameSQL = WfMultiLangUtils.getGeneralLangSQL(hiTaskEntityNumber, masterTableAlias, multiLangTableAlias, "FSTARTNAME", "startname", "startname");
        String subjectSQL = WfMultiLangUtils.getGeneralLangSQL(hiTaskEntityNumber, masterTableAlias, multiLangTableAlias, "FSUBJECT", "subject", "subject");
        String nameSQL = WfMultiLangUtils.getGeneralLangSQL(hiTaskEntityNumber, masterTableAlias, multiLangTableAlias, "FNAME", "name", "name");
        String senderNameSQL = WfMultiLangUtils.getGeneralLangSQL(hiTaskEntityNumber, masterTableAlias, multiLangTableAlias, "fsendername", "sendername", "sendername");
        String senderNameFormatSQL = WfMultiLangUtils.getGeneralLangSQL("wf_task", masterTableAlias, multiLangTableAlias, "fsendernameformat", "sendernameformat", "sendernameformat");
        String startNameFormatSQL = WfMultiLangUtils.getGeneralLangSQL("wf_task", masterTableAlias, multiLangTableAlias, "fstartnameformat", "startnameformat", "startnameformat");
        String presentAssigneeSQL = WfMultiLangUtils.getGeneralLangSQL(hiTaskEntityNumber, masterTableAlias, multiLangTableAlias, "fpresentassignee", "presentassignee", "presentassignee");
        String currentSubjectSQL = WfMultiLangUtils.getGeneralLangSQL(hiCommentEntityNumber, "d", "e", "fcurrentsubject", "currentsubject", "currentsubject");
        String billEntityNumber = StringUtils.isNotBlank((CharSequence)entityNumber) ? entityNumber : billType;
        String businessFieldSql = "";
        if (TaskExtendFieldUtil.isNeedQueryBusinessField(billEntityNumber)) {
            JSONObject json = TaskExtendFieldUtil.getTaskBusinessSelectFields(hiTaskEntityNumber, billEntityNumber, masterTableAlias, multiLangTableAlias, "f");
            businessFieldSql = json.getString("taskBusinessFieldStr");
        }
        String sql = "SELECT top " + (start + limit) + " a.FID id,a.fbillno billno," + sourceNameSQL + "," + entityNameSQL + "," + senderNameFormatSQL + "," + startNameFormatSQL + "," + startNameSQL + ",a.FSTARTERID initiatorId," + subjectSQL + ",a.fprocessingmobilepage processingmobilepage,a.FPROCESSINGPAGE processingpage,a.FBUSINESSKEY businesskey,a.FBUSINESSKEY url,a.FHANDLESTATE handlestate,a.fprocesstype processtype,a.FCATEGORY category," + nameSQL + "," + senderNameSQL + ",a.FCREATEDATE createdate,a.FBUSINESSKEY userImgUrl,a.FBUSINESSKEY openId,d.ftype d_type,d.FTIME ENDTIME, " + presentAssigneeSQL + "," + currentSubjectSQL + "," + businessFieldSql + "a.fextendformat bizformat, a.fendtime  FROM " + hiCommentTableName + " d LEFT JOIN " + hiCommentMultiLTableName + " e on d.fid = e.fid and e.flocaleid = ? and d.FUSERID = ? and d.ftype != 'suggestion' INNER JOIN " + hiTaskTableName + " a ON a.fid = d.FTASKID";
        if (WfUtils.isNotEmpty(businessFieldSql) || filterSql.contains("f.")) {
            sql = sql + " LEFT JOIN " + hiTaskSplitTableName + " f ON a.fid = f.fid";
        }
        sql = sql + " LEFT JOIN " + hiTaskMultiLTableName + " b ON a.FID = b.FID AND b.FLOCALEID = ? where d.FUSERID = ? and d.ftype != 'suggestion' and a.FEXECUTIONTYPE != ? and a.FISDISPLAY = '1'" + (WfUtils.isEmpty(endType) ? "" : " AND a.fendtype != ? ") + (WfUtils.isEmpty(billType) ? "" : " AND a.fbilltype = ? ") + (flag ? "" : "and a.fentitynumber=? ") + (WfUtils.isEmpty(noCodeFlow) ? "" : " and a.fprocesstype = ? ") + (WfUtils.isNotEmpty(filterSql) ? " " + filterSql : " ") + " order by " + (WfUtils.isEmpty(orderBy) ? "" : orderBy + ",") + " d.FTIME desc";
        ArrayList<Object> params = new ArrayList<Object>();
        params.addAll(Arrays.asList(lang, Long.valueOf(uid), lang, Long.valueOf(uid), "byAuto"));
        if (WfUtils.isNotEmpty(endType)) {
            params.add(endType);
        }
        if (WfUtils.isNotEmpty(billType)) {
            params.add(billType);
        }
        if (!flag) {
            params.add(entityNumber);
        }
        if (WfUtils.isNotEmpty(noCodeFlow)) {
            params.add(noCodeFlow);
        }
        params.addAll(paramsList);
        return this.createDefaultSelector("WfTaskCenter.wf_task.queryGridData", sql, params, separateStorageKey);
    }

    @Override
    protected String getOriginalEntityNumber() {
        return "wf_hitaskinst";
    }

    public DataSet getHandledTasks(EntityQueryParams entityQueryParams) {
        List<String> separateStorageKeys = this.getSeparateStorageKeys(entityQueryParams.getSource());
        ArrayList<ISelector> iSelectors = new ArrayList<ISelector>(separateStorageKeys.size());
        separateStorageKeys.forEach(key -> iSelectors.add(this.getHandledTask((String)key, entityQueryParams)));
        DataSet result = this.serialCollect(iSelectors);
        if (result != null) {
            StringBuilder orderBy = new StringBuilder();
            String orderBySb = entityQueryParams.getMainEntityQueryParams().getOriginalOrderBySql();
            if (WfUtils.isNotEmpty(orderBySb)) {
                orderBy.append(orderBySb);
                if (!orderBySb.contains("endtime")) {
                    orderBy.append(",").append("time desc");
                }
            } else {
                orderBy.append("time desc");
            }
            result = result.orderBy(orderBy.toString().split(",")).limit(0, entityQueryParams.getLimit());
        }
        return result;
    }

    public int getHandledTaskCount(EntityQueryParams entityQueryParams) {
        List<String> separateStorageKeys = this.getSeparateStorageKeys(entityQueryParams.getSource());
        ArrayList<ISelector> iSelectors = new ArrayList<ISelector>(separateStorageKeys.size());
        separateStorageKeys.forEach(key -> iSelectors.add(this.getHandledTaskCount((String)key, entityQueryParams)));
        return this.serialCollectDataCount(iSelectors);
    }

    private EntitySelector getHandledTaskCount(String separateStorageKey, EntityQueryParams entityQueryParams) {
        String hiCommentEntityNumber = EntityNumberConstant.getHiCommentEntityNumber(separateStorageKey);
        QFilter[] qFilters = this.buildHisTaskQfilter(entityQueryParams);
        return this.createEntitySelector("WfTaskCenter.wf_task.queryGridData", hiCommentEntityNumber, qFilters, separateStorageKey);
    }

    private EntitySelector getHandledTask(String separateStorageKey, EntityQueryParams entityQueryParams) {
        String hiCommentEntityNumber = EntityNumberConstant.getHiCommentEntityNumber(separateStorageKey);
        String queryFields = entityQueryParams.getMainEntityQueryParams().getQueryALLFields();
        if (WfUtils.isEmpty(queryFields)) {
            queryFields = "taskid id,taskid,billno,starterid initiatorId,processingpage,processingmobilepage,businesskey,category,source,handlestate,createdate,sourcename,entityname,startname,currentsubject,activityname,sendername,sendernameformat,startnameformat,presentassignee,time endtime,time,type d_type,currentsubject subject,businesskey url,businesskey userImgUrl,businesskey openId, activityname name";
            if (WfUtils.isNotEmpty(entityQueryParams.getMainEntityQueryParams().getQueryPartFields())) {
                queryFields = queryFields + "," + entityQueryParams.getMainEntityQueryParams().getQueryPartFields();
            }
        }
        QFilter[] qFilters = this.buildHisTaskQfilter(entityQueryParams);
        StringBuilder order = new StringBuilder();
        String orderby = entityQueryParams.getMainEntityQueryParams().getOrderBySql();
        if (WfUtils.isNotEmpty(orderby)) {
            order.append(orderby);
            if (!orderby.contains("time")) {
                order.append(",").append("time desc");
            }
        } else {
            order.append("time desc");
        }
        return this.createEntitySelector("WfTaskCenter.wf_task.queryGridData", hiCommentEntityNumber, queryFields, qFilters, order.toString(), entityQueryParams.getStart(), entityQueryParams.getLimit(), separateStorageKey);
    }

    private QFilter[] buildHisTaskQfilter(EntityQueryParams entityQueryParams) {
        String endType = "";
        String showType = entityQueryParams.getEndType();
        if ("mobile".equals(showType)) {
            endType = "pc";
        } else if ("pc".equals(showType)) {
            endType = "mobile";
        }
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        List<QFilter> params = entityQueryParams.getMainEntityQueryParams().getQFilter();
        if (params != null && params.size() > 0) {
            qFilterList.addAll(params);
        }
        String noCodeFlow = ThreadLocalVariables.get();
        QFilter qFilter = new QFilter("display", "=", (Object)"1");
        if (WfUtils.isNotEmpty(endType)) {
            qFilter.and(new QFilter("endtype", "!=", (Object)endType));
        }
        qFilterList.add(qFilter);
        if (WfUtils.isNotEmpty(noCodeFlow)) {
            qFilterList.add(new QFilter("processtype", "=", (Object)noCodeFlow));
        }
        return (QFilter[])qFilterList.stream().toArray(QFilter[]::new);
    }
}

