/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.history.separatestorage.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.thread.ThreadTruck;
import kd.bos.threads.ThreadPools;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.history.separatestorage.common.DefaultSqlSelector;
import kd.bos.workflow.engine.impl.persistence.entity.history.separatestorage.common.EntitySelector;
import kd.bos.workflow.engine.impl.persistence.entity.history.separatestorage.common.ICollector;
import kd.bos.workflow.engine.impl.persistence.entity.history.separatestorage.common.ISelector;
import kd.bos.workflow.engine.impl.persistence.separatestorage.FieldNameAliasMapper;
import kd.bos.workflow.engine.impl.persistence.separatestorage.SeparateStorageType;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.nocode.NoCodeFlowUtil;

public abstract class AbstractCollector
implements ICollector {
    private static final Log logger = LogFactory.getLog(AbstractCollector.class);

    @Override
    public DataSet serialCollect(List<ISelector> selectors) {
        if (WfUtils.isEmptyForCollection(selectors)) {
            logger.debug(String.format("selectors list is empty. current collector:[%s]", this.getClass().getSimpleName()));
            return null;
        }
        DataSet result = null;
        ISelector selector = null;
        for (ISelector iSelector : selectors) {
            try {
                selector = iSelector;
                String expr = "\"" + selector.getSeparateStorageKey() + "\"";
                DataSet ds = selector.getDataSet();
                ds = ds.addField(expr, "separateStorageKey");
                result = result == null ? ds : result.union(ds);
            }
            catch (Exception e) {
                logger.error(String.format("Data serial collect error. current collector:[%s], current separateStorageKey:[%s], error msg:[%s]", this.getClass().getSimpleName(), selector == null ? "" : selector.getSeparateStorageKey(), WfUtils.getExceptionStacktrace(e)));
            }
        }
        return result;
    }

    @Override
    public int serialCollectDataCount(List<ISelector> selectors) {
        if (WfUtils.isEmptyForCollection(selectors)) {
            logger.warn(String.format("selectors list is empty. current collector:[%s]", this.getClass().getSimpleName()));
            return 0;
        }
        int count = 0;
        ISelector selector = null;
        for (ISelector iSelector : selectors) {
            try {
                selector = iSelector;
                count += selector.getDataCount();
            }
            catch (Exception e) {
                logger.error(String.format("Data serial collect error. current collector:[%s], current separateStorageKey:[%s], error msg:[%s]", this.getClass().getSimpleName(), selector == null ? "" : selector.getSeparateStorageKey(), WfUtils.getExceptionStacktrace(e)));
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet parallelCollect(List<ISelector> selectors) {
        if (WfUtils.isEmptyForCollection(selectors)) {
            logger.debug(String.format("selectors list is empty. current collector:[%s]", this.getClass().getSimpleName()));
            return null;
        }
        int separateStorageKeysNum = SeparateStorageType.getSeparateStorageKeysNum();
        int nThreads = separateStorageKeysNum > 0 ? separateStorageKeysNum : 1;
        ExecutorService es = ThreadPools.newExecutorService((String)"WF_PARALLEL_COLLECT_DATA", (int)nThreads);
        ConcurrentHashMap resultMap = new ConcurrentHashMap(selectors.size());
        DataSet unionResult = null;
        boolean closeDataSet = false;
        try {
            CountDownLatch cdl = new CountDownLatch(selectors.size());
            for (ISelector iSelector : selectors) {
                es.submit(() -> {
                    try {
                        DataSet dataSet = selector.getDataSet();
                        resultMap.put(selector.getSeparateStorageKey(), dataSet);
                    }
                    catch (Exception e) {
                        logger.error(String.format("data collect error. current collector:[%s], current separateStorageKey:[%s], error msg:[%s]", this.getClass().getSimpleName(), selector.getSeparateStorageKey(), WfUtils.getExceptionStacktrace(e)));
                    }
                    finally {
                        cdl.countDown();
                    }
                });
            }
            try {
                cdl.await();
            }
            catch (InterruptedException interruptedException) {
                logger.error(String.format("data collector main thread await error [%s]", WfUtils.getExceptionStacktrace(interruptedException)));
                closeDataSet = true;
                throw new WFEngineException("data collector main thread await error.", interruptedException);
            }
            if (!resultMap.isEmpty()) {
                for (Map.Entry entry : resultMap.entrySet()) {
                    try {
                        DataSet dataSet = (DataSet)entry.getValue();
                        unionResult = unionResult == null ? dataSet : unionResult.union(dataSet);
                    }
                    catch (Exception e) {
                        logger.error(String.format("dataSet union error. current collector:[%s], error msg:[%s]", this.getClass().getSimpleName(), WfUtils.getExceptionStacktrace(e)));
                    }
                }
            }
        }
        finally {
            es.shutdown();
            if (closeDataSet) {
                if (unionResult != null) {
                    unionResult.close();
                }
                if (!resultMap.isEmpty()) {
                    resultMap.values().forEach(DataSet::close);
                }
            }
        }
        return unionResult;
    }

    protected DefaultSqlSelector createDefaultSelector(String algoKey, DBRoute dbRoute, String sql, List<Object> params, String separateStorageKey) {
        return new DefaultSqlSelector(algoKey, dbRoute, sql, params, separateStorageKey);
    }

    protected DefaultSqlSelector createDefaultSelector(String sql, List<Object> params, String separateStorageKey) {
        String algoKey = String.format("%s_%s", this.getClass().getName(), separateStorageKey);
        return this.createDefaultSelector(algoKey, WfUtils.WFS, sql, params, separateStorageKey);
    }

    protected DefaultSqlSelector createDefaultSelector(String algoKey, String sql, List<Object> params, String separateStorageKey) {
        return this.createDefaultSelector(algoKey, WfUtils.WFS, sql, params, separateStorageKey);
    }

    protected EntitySelector createEntitySelector(String algoKey, String entity, String queryFields, QFilter[] qFilters, String orderBy, int start, int limit, String separateStorageKey) {
        return new EntitySelector(algoKey, entity, queryFields, qFilters, orderBy, start, limit, separateStorageKey);
    }

    protected EntitySelector createEntitySelector(String algoKey, String entity, QFilter[] qFilters, String separateStorageKey) {
        return new EntitySelector(algoKey, entity, qFilters, separateStorageKey);
    }

    protected List<String> getSeparateStorageKeys() {
        ArrayList<String> separateStorageKeys = new ArrayList<String>();
        if (NoCodeFlowUtil.hasNoCodeLicense() && WfConfigurationUtil.enableSeparateStorage()) {
            separateStorageKeys = SeparateStorageType.getSeparateStorageKeys();
        } else {
            separateStorageKeys.add(SeparateStorageType.ORIGINAL.getKey());
        }
        return separateStorageKeys;
    }

    protected List<String> getSeparateStorageKeys(String source) {
        if ("messageCenter".equals(source)) {
            return this.getSeparateStorageKeys();
        }
        ArrayList<String> separateStorageKeys = new ArrayList<String>();
        Object noCode = ThreadTruck.get((Object)"separateStorageKey");
        if (noCode != null && SeparateStorageType.NOCODE.getKey().equals(noCode)) {
            separateStorageKeys.add(SeparateStorageType.NOCODE.getKey());
            return separateStorageKeys;
        }
        separateStorageKeys.add(SeparateStorageType.ORIGINAL.getKey());
        return separateStorageKeys;
    }

    protected String getAliasOrderByStr(String orderBy, String type) {
        if (StringUtils.isBlank((CharSequence)orderBy) || StringUtils.isBlank((CharSequence)type)) {
            return orderBy;
        }
        Map<String, String> aliasFieldNameMap = FieldNameAliasMapper.getAliasFieldNameMap(type);
        String[] orderByArray = orderBy.trim().split(",");
        StringBuilder result = new StringBuilder();
        for (String orderByItem : orderByArray) {
            String[] os = orderByItem.split(" ");
            if (os.length != 2) continue;
            result.append(aliasFieldNameMap.get(os[0])).append(" ").append(os[1]).append(",");
        }
        return result.substring(0, result.length() - 1);
    }

    protected abstract String getOriginalEntityNumber();
}

