/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.job;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.AbstractJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;

public abstract class AbstractJobEntityImpl
extends AbstractEntity
implements AbstractJobEntity,
Serializable {
    protected static Log logger = LogFactory.getLog(AbstractJobEntityImpl.class);
    private static final long serialVersionUID = 1L;
    private static final String EVENT = "event";
    protected ExecutionEntity execution;
    protected String executorServer;
    protected Date endDate;
    private int maxIterations;
    protected String appNumForSubApp;
    protected String queueName;

    public String getAppNumForSubApp() {
        return this.appNumForSubApp;
    }

    public void setAppNumForSubApp(String appNumForSubApp) {
        this.appNumForSubApp = appNumForSubApp;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public AbstractJobEntityImpl() {
    }

    public AbstractJobEntityImpl(DynamicObject dynamicObject) {
        super(dynamicObject);
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        persistentState.put("executionId", this.getExecutionId());
        persistentState.put("processInstanceId", this.getProcessInstanceId());
        persistentState.put("processDefinitionId", this.getProcessDefinitionId());
        persistentState.put("businessKey", this.getBusinessKey());
        persistentState.put("operation", this.getOperation());
        persistentState.put("repeat", this.getRepeat());
        persistentState.put("jobHandlerType", this.getJobHandlerType());
        persistentState.put("jobHandlerConfiguration", this.getJobHandlerConfiguration());
        persistentState.put("entityNumber", this.getEntityNumber());
        return persistentState;
    }

    @Override
    public void setExecution(ExecutionEntity execution) {
        this.setExecutionId(execution.getId());
        this.setProcessInstanceId(execution.getProcessInstanceId());
        this.setProcessDefinitionId(execution.getProcessDefinitionId());
    }

    @Override
    @SimplePropertyAttribute(name="duedate")
    public Date getDuedate() {
        return this.dynamicObject.getDate("duedate");
    }

    @Override
    public void setDuedate(Date duedate) {
        this.dynamicObject.set("duedate", (Object)duedate);
    }

    @Override
    @SimplePropertyAttribute(name="executionId")
    public Long getExecutionId() {
        String type = this.getJobType();
        if (EVENT.equals(type)) {
            return 0L;
        }
        return this.normalizeId(this.dynamicObject.getLong("executionId"));
    }

    @Override
    public void setExecutionId(Long executionId) {
        this.dynamicObject.set("executionId", (Object)executionId);
    }

    @Override
    @SimplePropertyAttribute(name="retries")
    public int getRetries() {
        try {
            return this.dynamicObject.getInt("retries");
        }
        catch (Exception e) {
            logger.info(e.getMessage());
            return 0;
        }
    }

    @Override
    public void setRetries(int retries) {
        try {
            this.dynamicObject.set("retries", (Object)retries);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    @Override
    @SimplePropertyAttribute(name="processInstanceId")
    public Long getProcessInstanceId() {
        String type = this.getJobType();
        if (EVENT.equals(type)) {
            return 0L;
        }
        return this.normalizeId(this.dynamicObject.getLong("processInstanceId"));
    }

    @Override
    public void setProcessInstanceId(Long processInstanceId) {
        this.dynamicObject.set("processInstanceId", (Object)processInstanceId);
    }

    @Override
    @SimplePropertyAttribute(name="exclusive")
    public boolean isExclusive() {
        return this.dynamicObject.getBoolean("exclusive");
    }

    @Override
    public void setExclusive(boolean isExclusive) {
        this.dynamicObject.set("exclusive", (Object)isExclusive);
    }

    @Override
    @SimplePropertyAttribute(name="processDefinitionId")
    public Long getProcessDefinitionId() {
        String type = this.getJobType();
        if (EVENT.equals(type)) {
            return 0L;
        }
        return this.normalizeId(this.dynamicObject.getLong("processDefinitionId"));
    }

    @Override
    public void setProcessDefinitionId(Long processDefinitionId) {
        this.dynamicObject.set("processDefinitionId", (Object)processDefinitionId);
    }

    @Override
    @SimplePropertyAttribute(name="repeat")
    public String getRepeat() {
        return this.dynamicObject.getString("repeat");
    }

    @Override
    public void setRepeat(String repeat) {
        this.dynamicObject.set("repeat", (Object)repeat);
    }

    @Override
    public Date getEndDate() {
        return this.endDate;
    }

    @Override
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    @Override
    @SimplePropertyAttribute(name="jobHandlerType")
    public String getJobHandlerType() {
        return this.dynamicObject.getString("jobHandlerType");
    }

    @Override
    public void setJobHandlerType(String jobHandlerType) {
        this.dynamicObject.set("jobHandlerType", (Object)jobHandlerType);
    }

    @Override
    @SimplePropertyAttribute(name="jobHandlerConfiguration")
    public String getJobHandlerConfiguration() {
        return this.dynamicObject.getString("jobHandlerConfiguration");
    }

    @Override
    public void setJobHandlerConfiguration(String jobHandlerConfiguration) {
        this.dynamicObject.set("jobHandlerConfiguration", (Object)jobHandlerConfiguration);
    }

    @Override
    @SimplePropertyAttribute(name="jobType")
    public String getJobType() {
        return this.dynamicObject.getString("jobType");
    }

    @Override
    public void setJobType(String jobType) {
        this.dynamicObject.set("jobType", (Object)jobType);
    }

    @Override
    public int getMaxIterations() {
        return this.maxIterations;
    }

    @Override
    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    @Override
    @SimplePropertyAttribute(name="entityNumber")
    public String getEntityNumber() {
        return this.dynamicObject.getString("entityNumber");
    }

    @Override
    public void setEntityNumber(String entityNumber) {
        this.dynamicObject.set("entityNumber", (Object)entityNumber);
    }

    @Override
    @SimplePropertyAttribute(name="exceptionMessage")
    public String getExceptionMessage() {
        return this.dynamicObject.getString("exceptionMessage");
    }

    @Override
    public void setExceptionMessage(String exceptionMessage) {
        this.dynamicObject.set("exceptionMessage", (Object)exceptionMessage);
    }

    @Override
    @SimplePropertyAttribute(name="businessKey")
    public String getBusinessKey() {
        return this.dynamicObject.getString("businessKey");
    }

    @Override
    public void setBusinessKey(String businessKey) {
        this.dynamicObject.set("businessKey", (Object)businessKey);
    }

    @Override
    @SimplePropertyAttribute(name="operation")
    public String getOperation() {
        return this.dynamicObject.getString("operation");
    }

    @Override
    public void setOperation(String operation) {
        this.dynamicObject.set("operation", (Object)operation);
    }

    @Override
    @SimplePropertyAttribute(name="elementId")
    public String getElementId() {
        return this.dynamicObject.getString("elementId");
    }

    @Override
    public void setElementId(String elementId) {
        this.dynamicObject.set("elementId", (Object)elementId);
    }

    @Override
    @SimplePropertyAttribute(name="srcjobid")
    public long getSrcJobId() {
        return this.dynamicObject.getLong("srcjobid");
    }

    @Override
    public void setSrcJobId(long srcJobId) {
        this.dynamicObject.set("srcjobid", (Object)srcJobId);
    }

    @Override
    @SimplePropertyAttribute(name="rootTraceNo")
    public String getRootTraceNo() {
        return this.dynamicObject.getString("rootTraceNo");
    }

    @Override
    public void setRootTraceNo(String rootTraceNo) {
        this.dynamicObject.set("rootTraceNo", (Object)rootTraceNo);
    }

    public ExecutionEntity getExecution() {
        String type = this.getJobType();
        if (EVENT.equals(type)) {
            return null;
        }
        if (this.execution == null) {
            this.execution = (ExecutionEntity)Context.getCommandContext().getExecutionEntityManager().findById(this.getExecutionId());
        }
        return this.execution;
    }

    @Override
    public void setExecutorServer(String executorServer) {
        this.executorServer = executorServer;
    }

    @Override
    public String getExecutorServer() {
        return this.executorServer;
    }

    @Override
    @SimplePropertyAttribute(name="biztraceno")
    public String getBizTraceNo() {
        return this.dynamicObject.getString("biztraceno");
    }

    @Override
    public void setBizTraceNo(String bizTraceNo) {
        this.dynamicObject.set("biztraceno", (Object)bizTraceNo);
    }

    public String toString() {
        return this.getClass().getName() + " [id=" + this.getId() + "]";
    }
}

