/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.job;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.job.AbstractWfJobEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.job.DeadLetterJobEntity;

public class DeadLetterJobEntityImpl
extends AbstractWfJobEntityImpl
implements DeadLetterJobEntity {
    private static final long serialVersionUID = 1L;
    private String dynObjTypeName;

    public DeadLetterJobEntityImpl() {
    }

    public DeadLetterJobEntityImpl(String dynObjTypeName) {
        this.dynObjTypeName = dynObjTypeName;
        try {
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)this.getDynObjTypeName());
            this.dynamicObject = new DynamicObject((DynamicObjectType)type);
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
    }

    @Override
    public String getDynObjTypeName() {
        if (WfUtils.isNotEmpty(this.dynObjTypeName)) {
            return this.dynObjTypeName;
        }
        return super.getDynObjTypeName();
    }

    public DeadLetterJobEntityImpl(DynamicObject dynamicObject) {
        super(dynamicObject);
    }

    @Override
    public Object getPersistentState() {
        Map persistentState = (Map)super.getPersistentState();
        persistentState.put("errorCode", this.getErrorCode());
        persistentState.put("errorType", this.getErrorType());
        persistentState.put("solution", this.getSolution());
        persistentState.put("exceptionStackMessage", this.getExceptionStackMessage());
        persistentState.put("subject", this.getSubject());
        persistentState.put("entrabillname", this.getEntrabillname());
        persistentState.put("keyversion", this.getKeyversion());
        persistentState.put("elementName", this.getElementName());
        return persistentState;
    }

    @Override
    public String toString() {
        return "DeadLetterJobEntity [id=" + this.getId() + "]";
    }

    @SimplePropertyAttribute(name="exceptionStackMessage")
    public String getExceptionStacktrace() {
        return this.dynamicObject.getString("exceptionStackMessage");
    }

    public void setExceptionStacktrace(String exception) {
        this.dynamicObject.set("exceptionStackMessage", (Object)exception);
    }

    @Override
    @SimplePropertyAttribute(name="errorCode")
    public String getErrorCode() {
        return this.dynamicObject.getString("errorCode");
    }

    @Override
    public void setErrorCode(String errorCode) {
        this.dynamicObject.set("errorCode", (Object)errorCode);
    }

    @Override
    @SimplePropertyAttribute(name="errorType")
    public String getErrorType() {
        return this.dynamicObject.getString("errorType");
    }

    @Override
    public void setErrorType(String errorType) {
        this.dynamicObject.set("errorType", (Object)errorType);
    }

    @Override
    @SimplePropertyAttribute(name="solution")
    public String getSolution() {
        return this.dynamicObject.getString("solution");
    }

    @Override
    public void setSolution(String solution) {
        this.dynamicObject.set("solution", (Object)solution);
    }

    @Override
    @SimplePropertyAttribute(name="exceptionStackMessage")
    public String getExceptionStackMessage() {
        return this.dynamicObject.getString("exceptionStackMessage");
    }

    @Override
    public void setExceptionStackMessage(String exceptionStackMessage) {
        this.dynamicObject.set("exceptionStackMessage", (Object)exceptionStackMessage);
    }

    @Override
    public void setSubject(ILocaleString subject) {
        this.dynamicObject.set("subject", (Object)WfUtils.subILocaleString(subject, 1900));
    }

    @Override
    @SimplePropertyAttribute(name="subject")
    public ILocaleString getSubject() {
        return this.dynamicObject.getLocaleString("subject");
    }

    @Override
    public void setEntrabillname(ILocaleString entrabillname) {
        this.dynamicObject.set("entrabillname", (Object)entrabillname);
    }

    @Override
    @SimplePropertyAttribute(name="entrabillname")
    public ILocaleString getEntrabillname() {
        return this.dynamicObject.getLocaleString("entrabillname");
    }

    @Override
    public void setKeyversion(ILocaleString keyversion) {
        this.dynamicObject.set("keyversion", (Object)keyversion);
    }

    @Override
    @SimplePropertyAttribute(name="keyversion")
    public ILocaleString getKeyversion() {
        return this.dynamicObject.getLocaleString("keyversion");
    }

    @Override
    @SimplePropertyAttribute(name="elementName")
    public ILocaleString getElementName() {
        return this.dynamicObject.getLocaleString("elementName");
    }

    @Override
    public void setElementName(ILocaleString elementName) {
        this.dynamicObject.set("elementName", (Object)elementName);
    }

    @Override
    @SimplePropertyAttribute(name="orgUnitId")
    public Long getOrgUnitId() {
        return this.dynamicObject.getLong("orgUnitId");
    }

    @Override
    public void setOrgUnitId(Long orgUnitId) {
        this.dynamicObject.set("orgUnitId", (Object)orgUnitId);
    }

    @Override
    @SimplePropertyAttribute(name="orgviewid")
    public String getOrgViewId() {
        return this.dynamicObject.getString("orgviewid");
    }

    @Override
    public void setOrgViewId(String orgViewId) {
        this.dynamicObject.set("orgviewid", (Object)orgViewId);
    }

    @Override
    @SimplePropertyAttribute(name="processtype")
    public String getProcessType() {
        return this.dynamicObject.getString("processtype");
    }

    @Override
    public void setProcessType(String processType) {
        this.dynamicObject.set("processtype", (Object)processType);
    }
}

