/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.job;

import java.util.Arrays;
import java.util.List;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.persistence.CachedEntityMatcher;
import kd.bos.workflow.engine.impl.persistence.CountingExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.DeadLetterJobsByExecutionIdMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.DeadLetterJobsByProcessInstanceIdMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.job.DeadLetterJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.DeadLetterJobEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.job.DeadLetterJobEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.RuntimeUtil;

public class DeadLetterJobEntityManagerImpl
extends AbstractEntityManager<DeadLetterJobEntity>
implements DeadLetterJobEntityManager {
    protected CachedEntityMatcher<DeadLetterJobEntity> deadLetterByExecutionIdMatcher = new DeadLetterJobsByExecutionIdMatcher();
    protected CachedEntityMatcher<DeadLetterJobEntity> deadLetterByProcessInstanceIdMatcher = new DeadLetterJobsByProcessInstanceIdMatcher();

    public DeadLetterJobEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public DeadLetterJobEntity create(String dynObjTypeName) {
        return new DeadLetterJobEntityImpl(dynObjTypeName);
    }

    @Override
    public Class<? extends DeadLetterJobEntity> getManagedEntityClass() {
        return DeadLetterJobEntityImpl.class;
    }

    @Override
    public String getSelectFields() {
        return "id,jobType,exclusive,executionId,processInstanceId,processDefinitionId,exceptionMessage,entityNumber,businessKey,operation,errorCode,errorType,solution,exceptionStackMessage,duedate,repeat,jobHandlerType,jobHandlerConfiguration,createdate,modifydate,elementid,subject,entrabillname,keyversion,srcjobid,rootTraceNo,elementName,biztraceno,orgunitid,orgviewid,retries,processtype";
    }

    @Override
    public List<DeadLetterJobEntity> findJobsByExecutionId(Long executionId) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("executionId", executionId);
        return this.findByQueryBuilder(eb);
    }

    @Override
    public List<DeadLetterJobEntity> findJobsByProcessInstanceId(Long processInstanceId) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("processInstanceId", processInstanceId);
        return this.findByQueryBuilder(eb);
    }

    @Override
    public void insert(DeadLetterJobEntity jobEntity, boolean fireCreateEvent) {
        if (jobEntity.getExecutionId() != null) {
            CountingExecutionEntity countingExecutionEntity;
            ExecutionEntity execution = (ExecutionEntity)this.getExecutionEntityManager().findById(jobEntity.getExecutionId());
            if (this.isExecutionRelatedEntityCountEnabledGlobally() && this.isExecutionRelatedEntityCountEnabled(countingExecutionEntity = (CountingExecutionEntity)((Object)execution))) {
                countingExecutionEntity.setDeadLetterJobCount(countingExecutionEntity.getDeadLetterJobCount() + 1);
            }
        }
        super.insert(jobEntity, fireCreateEvent);
    }

    @Override
    public void insert(DeadLetterJobEntity jobEntity) {
        this.insert(jobEntity, true);
    }

    @Override
    public void delete(DeadLetterJobEntity jobEntity) {
        CountingExecutionEntity executionEntity;
        super.delete(jobEntity);
        if (jobEntity.getExecutionId() != null && this.isExecutionRelatedEntityCountEnabledGlobally() && this.isExecutionRelatedEntityCountEnabled(executionEntity = (CountingExecutionEntity)this.getExecutionEntityManager().findById(jobEntity.getExecutionId()))) {
            executionEntity.setDeadLetterJobCount(executionEntity.getDeadLetterJobCount() - 1);
        }
        if (this.getEventDispatcher().isEnabled()) {
            this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_DELETED, this));
        }
    }

    @Override
    public boolean existRunningDeadLetterJob(Long processInstanceId) {
        EntityQueryBuilder eb = this.createQueryBuilder().setSelectFields("id").addFilter("processInstanceId", processInstanceId).addFilter("jobHandlerType", "in", RuntimeUtil.getRunningJobStr());
        List rt = this.findByQueryBuilder(eb);
        return rt != null && rt.size() > 0;
    }

    @Override
    public List<DeadLetterJobEntity> findRunningJobsByProcessInstanceId(Long processInstanceId) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("processInstanceId", processInstanceId).addFilter("jobHandlerType", "in", Arrays.asList(RuntimeUtil.getRunningJobStr()));
        return this.getList(eb, this.deadLetterByProcessInstanceIdMatcher, processInstanceId, true);
    }
}

