/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.job;

import kd.bos.algo.Row;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.DeadLetterJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.FailedJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.FailedJobEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.job.FailedJobEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.TimerJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;

public class FailedJobEntityManagerImpl
extends AbstractEntityManager<FailedJobEntity>
implements FailedJobEntityManager {
    private static final String FBIZTRACENO = "FBIZTRACENO";
    public static final String FBUSINESSKEY = "FBUSINESSKEY";
    public static final String FEXECUTIONID = "FEXECUTIONID";
    public static final String FPROCESSINSTANCEID = "FPROCESSINSTANCEID";
    public static final String FPROCDEFID = "FPROCDEFID";
    public static final String FELEMENTID = "FELEMENTID";
    public static final String FOPERATION = "FOPERATION";
    public static final String FENTITYNUMBER = "FENTITYNUMBER";
    public static final String FTYPE = "FTYPE";
    public static final String FHANDLERTYPE = "FHANDLERTYPE";
    public static final String FHANDLERCFG = "FHANDLERCFG";
    public static final String FROOTTRACENO = "FROOTTRACENO";
    public static final String FEXCEPTIONMSG = "FEXCEPTIONMSG";
    public static final String FCREATEDATE = "FCREATEDATE";

    public FailedJobEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public Class<? extends FailedJobEntity> getManagedEntityClass() {
        return FailedJobEntityImpl.class;
    }

    @Override
    public String getSelectFields() {
        return "id, jobtype, executionid, processinstanceid, processdefinitionid, occurrencetime, jobhandlertype, jobhandlerconfiguration, modifydate, operation, elementid, elementname, subject, entrabillname, keyversion, errortype, roottraceno, errorcode, exceptionstackmessage, exceptionmessage, entitynumber, businesskey, createdate, solution, retries, channeltype, biztraceno";
    }

    private FailedJobEntity getFailedJobFromDeadLetterJob(DeadLetterJobEntity deadJob) {
        FailedJobEntity failedJob = (FailedJobEntity)this.create();
        failedJob.setId(deadJob.getId());
        failedJob.setBusinessKey(deadJob.getBusinessKey());
        failedJob.setExecutionId(deadJob.getExecutionId());
        failedJob.setProcessInstanceId(deadJob.getProcessInstanceId());
        failedJob.setProcessDefinitionId(deadJob.getProcessDefinitionId());
        failedJob.setSubject(deadJob.getSubject());
        failedJob.setElementId(deadJob.getElementId());
        failedJob.setElementName(deadJob.getElementName());
        failedJob.setKeyversion(deadJob.getKeyversion());
        failedJob.setOperation(deadJob.getOperation());
        String entityNumber = deadJob.getEntityNumber();
        failedJob.setEntityNumber(entityNumber);
        failedJob.setEntrabillname((ILocaleString)WfUtils.getEntityNameProperty(entityNumber, null));
        failedJob.setJobType(deadJob.getJobType());
        failedJob.setJobHandlerType(deadJob.getJobHandlerType());
        failedJob.setJobHandlerConfiguration(deadJob.getJobHandlerConfiguration());
        failedJob.setSolution(deadJob.getSolution());
        failedJob.setErrorCode(deadJob.getErrorCode());
        failedJob.setErrorType(deadJob.getErrorType());
        failedJob.setRootTraceNo(deadJob.getRootTraceNo());
        failedJob.setExceptionMessage(String.format(ResManager.loadKDString((String)"\u201c\u5f02\u5e38\u65f6\u201d\u5f02\u5e38\uff0c\u8be6\u60c5\uff1a%s\u3002", (String)"FailedJobEntityManagerImpl_1", (String)"bos-wf-engine", (Object[])new Object[0]), deadJob.getExceptionMessage()));
        failedJob.setExceptionStackMessage(deadJob.getExceptionStackMessage());
        failedJob.setOccurrenceTime(deadJob.getCreateDate());
        failedJob.setBizTraceNo(deadJob.getBizTraceNo());
        return failedJob;
    }

    @Override
    public FailedJobEntity createFailedJobByDeadLetterJob(DeadLetterJobEntity deadJob) {
        this.logger.debug("createFailedJobByDeadLetterJob...");
        FailedJobEntity failedJob = this.getFailedJobFromDeadLetterJob(deadJob);
        this.insertFailedJob(failedJob);
        return failedJob;
    }

    @Override
    public FailedJobEntity createFailedJobByDeadLetterJob(Row row) {
        FailedJobEntity failedJob = (FailedJobEntity)this.create();
        failedJob.setId(row.getLong("FID"));
        failedJob.setBusinessKey(row.getString(FBUSINESSKEY));
        failedJob.setExecutionId(row.getLong(FEXECUTIONID));
        Long processInstanceId = row.getLong(FPROCESSINSTANCEID);
        failedJob.setProcessInstanceId(processInstanceId);
        failedJob.setProcessDefinitionId(row.getLong(FPROCDEFID));
        failedJob.setSubject((ILocaleString)new LocaleString(row.getString("FSUBJECT")));
        String elementId = row.getString(FELEMENTID);
        failedJob.setElementId(elementId);
        String elementName = row.getString("FELEMENTNAME");
        this.setElementName(failedJob, elementId, processInstanceId, elementName);
        failedJob.setKeyversion((ILocaleString)new LocaleString(row.getString("FNAME")));
        failedJob.setOperation(row.getString(FOPERATION));
        String entityNumber = row.getString(FENTITYNUMBER);
        failedJob.setEntityNumber(entityNumber);
        failedJob.setEntrabillname((ILocaleString)WfUtils.getEntityNameProperty(entityNumber, null));
        failedJob.setJobType(row.getString(FTYPE));
        failedJob.setJobHandlerType(row.getString(FHANDLERTYPE));
        failedJob.setJobHandlerConfiguration(row.getString(FHANDLERCFG));
        failedJob.setSolution(row.getString("FSOLUTION"));
        failedJob.setErrorCode(row.getString("FERRORCODE"));
        failedJob.setErrorType(row.getString("FERRORTYPE"));
        failedJob.setRootTraceNo(row.getString(FROOTTRACENO));
        failedJob.setExceptionMessage(String.format(ResManager.loadKDString((String)"\u201c\u5f02\u5e38\u65f6\u201d\u5f02\u5e38\uff0c\u8be6\u60c5\uff1a%s\u3002", (String)"FailedJobEntityManagerImpl_1", (String)"bos-wf-engine", (Object[])new Object[0]), row.getString(FEXCEPTIONMSG)));
        failedJob.setExceptionStackMessage(row.getString("FEXCEPTIONSTACKMSG"));
        failedJob.setOccurrenceTime(row.getDate(FCREATEDATE));
        failedJob.setBizTraceNo(row.getString(FBIZTRACENO));
        this.insertFailedJob(failedJob);
        return failedJob;
    }

    private void setElementName(FailedJobEntity failedJob, String elementId, Long processInstanceId, String elementName) {
        String multiKey = BpmnModelUtil.getActivityNameMultiKey(elementId);
        ILocaleString localeName = BpmnModelUtil.getMultiLangFieldValue(processInstanceId, multiKey, elementName);
        if (WfUtils.isEmpty(localeName)) {
            localeName = new LocaleString(elementName);
        }
        failedJob.setElementName(localeName);
    }

    private FailedJobEntity getFailedJobFromTimerJob(TimerJobEntity timerJob) {
        BpmnModel model = ProcessDefinitionUtil.getBpmnModel(timerJob.getProcessDefinitionId(), timerJob.getProcessInstanceId());
        FailedJobEntity failedJob = (FailedJobEntity)this.create();
        failedJob.setId(timerJob.getId());
        failedJob.setBusinessKey(timerJob.getBusinessKey());
        failedJob.setExecutionId(timerJob.getExecutionId());
        Long processInstanceId = timerJob.getProcessInstanceId();
        failedJob.setProcessInstanceId(processInstanceId);
        failedJob.setProcessDefinitionId(timerJob.getProcessDefinitionId());
        String elementId = timerJob.getElementId();
        failedJob.setElementId(elementId);
        String elementName = model.getFlowElement(timerJob.getElementId()).getName();
        this.setElementName(failedJob, elementId, processInstanceId, elementName);
        failedJob.setOperation(timerJob.getOperation());
        failedJob.setEntityNumber(timerJob.getEntityNumber());
        this.setSubjectAndNames(failedJob, timerJob.getProcessInstanceId());
        failedJob.setJobType(timerJob.getJobType());
        failedJob.setJobHandlerType(timerJob.getJobHandlerType());
        failedJob.setJobHandlerConfiguration(timerJob.getJobHandlerConfiguration());
        failedJob.setRootTraceNo(timerJob.getRootTraceNo());
        failedJob.setExceptionMessage(String.format(ResManager.loadKDString((String)"\u91cd\u8bd5\u65f6\u5f02\u5e38\uff0c\u8be6\u60c5\uff1a%s\u3002", (String)"FailedJobEntityManagerImpl_2", (String)"bos-wf-engine", (Object[])new Object[0]), timerJob.getExceptionMessage()));
        failedJob.setOccurrenceTime(timerJob.getCreateDate());
        failedJob.setBizTraceNo(timerJob.getBizTraceNo());
        return failedJob;
    }

    @Override
    public FailedJobEntity createFailedJobByTimerJob(TimerJobEntity timerJob) {
        this.logger.debug("createFailedJobByTimerJob...");
        FailedJobEntity failedJob = this.getFailedJobFromTimerJob(timerJob);
        this.insertFailedJob(failedJob);
        return failedJob;
    }

    @Override
    public FailedJobEntity createFailedJobByTimerJob(Row row) {
        FailedJobEntity failedJob = (FailedJobEntity)this.create();
        failedJob.setId(row.getLong("FID"));
        failedJob.setBusinessKey(row.getString(FBUSINESSKEY));
        failedJob.setExecutionId(row.getLong(FEXECUTIONID));
        Long procInstId = row.getLong(FPROCESSINSTANCEID);
        Long procDefId = row.getLong(FPROCDEFID);
        failedJob.setProcessInstanceId(procInstId);
        failedJob.setProcessDefinitionId(procDefId);
        String elementId = row.getString(FELEMENTID);
        failedJob.setElementId(elementId);
        BpmnModel model = ProcessDefinitionUtil.getBpmnModel(procDefId, procInstId);
        String elementName = model.getFlowElement(row.getString(FELEMENTID)).getName();
        this.setElementName(failedJob, elementId, procInstId, elementName);
        failedJob.setOperation(row.getString(FOPERATION));
        failedJob.setEntityNumber(row.getString(FENTITYNUMBER));
        this.setSubjectAndNames(failedJob, procInstId);
        failedJob.setJobType(row.getString(FTYPE));
        failedJob.setJobHandlerType(row.getString(FHANDLERTYPE));
        failedJob.setJobHandlerConfiguration(row.getString(FHANDLERCFG));
        failedJob.setRootTraceNo(row.getString(FROOTTRACENO));
        failedJob.setExceptionMessage(String.format(ResManager.loadKDString((String)"\u91cd\u8bd5\u65f6\u5f02\u5e38\uff0c\u8be6\u60c5\uff1a%s\u3002", (String)"FailedJobEntityManagerImpl_2", (String)"bos-wf-engine", (Object[])new Object[0]), row.getString(FEXCEPTIONMSG)));
        failedJob.setOccurrenceTime(row.getDate(FCREATEDATE));
        failedJob.setBizTraceNo(row.getString(FBIZTRACENO));
        this.insertFailedJob(failedJob);
        return failedJob;
    }

    private void insertFailedJob(FailedJobEntity failedJob) {
        try {
            if (!this.exist(failedJob.getId())) {
                this.insert(failedJob);
            }
        }
        catch (Exception e) {
            this.logger.error(String.format("\u521b\u5efa\u6216\u65b0\u589e\u5f02\u5e38\u5f85\u529e\u5931\u8d25\uff01\u539f\u56e0\uff1a%s", WfUtils.getExceptionStacktrace(e)));
        }
    }

    @Deprecated
    private FailedJobEntity getFailedJobFromJobEntity(JobEntity jobEntity) {
        BpmnModel model = ProcessDefinitionUtil.getBpmnModel(jobEntity.getProcessDefinitionId(), jobEntity.getProcessInstanceId());
        FailedJobEntity failedJob = (FailedJobEntity)this.create();
        failedJob.setId(jobEntity.getRootJobId());
        failedJob.setBusinessKey(jobEntity.getBusinessKey());
        failedJob.setExecutionId(jobEntity.getExecutionId());
        Long processInstanceId = jobEntity.getProcessInstanceId();
        failedJob.setProcessInstanceId(processInstanceId);
        failedJob.setProcessDefinitionId(jobEntity.getProcessDefinitionId());
        String elementId = jobEntity.getElementId();
        failedJob.setElementId(elementId);
        String elementName = model.getFlowElement(jobEntity.getElementId()).getName();
        this.setElementName(failedJob, elementId, processInstanceId, elementName);
        failedJob.setOperation(jobEntity.getOperation());
        failedJob.setEntityNumber(jobEntity.getEntityNumber());
        this.setSubjectAndNames(failedJob, jobEntity.getProcessInstanceId());
        failedJob.setJobType(jobEntity.getJobType());
        failedJob.setJobHandlerType(jobEntity.getJobHandlerType());
        failedJob.setJobHandlerConfiguration(jobEntity.getJobHandlerConfiguration());
        failedJob.setRootTraceNo(jobEntity.getRootTraceNo());
        failedJob.setExceptionMessage(String.format(ResManager.loadKDString((String)"\u6267\u884c\u65f6\u521b\u5efa\uff0c\u72b6\u6001\uff1a%1$s\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a%2$s\u3002", (String)"FailedJobEntityManagerImpl_3", (String)"bos-wf-engine", (Object[])new Object[0]), jobEntity.getState(), jobEntity.getExceptionMessage()));
        failedJob.setOccurrenceTime(jobEntity.getCreateDate());
        failedJob.setBizTraceNo(jobEntity.getBizTraceNo());
        return failedJob;
    }

    private void setSubjectAndNames(FailedJobEntity failedJob, Long procInstId) {
        ILocaleString subject = null;
        ILocaleString name = null;
        ILocaleString entraBillName = null;
        ExecutionEntity execution = (ExecutionEntity)this.getExecutionEntityManager().findById(procInstId);
        if (execution != null) {
            subject = execution.getSubject();
            name = execution.getName();
            entraBillName = execution.getEntraBillName();
        } else {
            HistoricProcessInstanceEntity procInst = (HistoricProcessInstanceEntity)this.getHistoricProcessInstanceEntityManager().findById(procInstId);
            subject = procInst.getSubject();
            name = procInst.getName();
            entraBillName = procInst.getEntraBillName();
        }
        failedJob.setSubject(subject);
        failedJob.setKeyversion(name);
        failedJob.setEntrabillname(entraBillName);
    }

    @Override
    @Deprecated
    public FailedJobEntity createFailedJobByJobEntity(JobEntity jobEntity) {
        this.logger.debug("createFailedJobByJobEntity...");
        FailedJobEntity failedJob = this.getFailedJobFromJobEntity(jobEntity);
        this.insertFailedJob(failedJob);
        return failedJob;
    }

    @Override
    @Deprecated
    public FailedJobEntity createFailedJobByJobEntity(Row row) {
        FailedJobEntity failedJob = (FailedJobEntity)this.create();
        failedJob.setId(row.getLong("FROOTJOBID"));
        failedJob.setBusinessKey(row.getString(FBUSINESSKEY));
        failedJob.setExecutionId(row.getLong(FEXECUTIONID));
        Long procInstId = row.getLong(FPROCESSINSTANCEID);
        Long procDefId = row.getLong(FPROCDEFID);
        failedJob.setProcessInstanceId(procInstId);
        failedJob.setProcessDefinitionId(procDefId);
        String elementId = row.getString(FELEMENTID);
        failedJob.setElementId(elementId);
        BpmnModel model = ProcessDefinitionUtil.getBpmnModel(procDefId, procInstId);
        String elementName = model.getFlowElement(elementId).getName();
        this.setElementName(failedJob, elementId, procInstId, elementName);
        failedJob.setOperation(row.getString(FOPERATION));
        failedJob.setEntityNumber(row.getString(FENTITYNUMBER));
        this.setSubjectAndNames(failedJob, procInstId);
        failedJob.setJobType(row.getString(FTYPE));
        failedJob.setJobHandlerType(row.getString(FHANDLERTYPE));
        failedJob.setJobHandlerConfiguration(row.getString(FHANDLERCFG));
        failedJob.setRootTraceNo(row.getString(FROOTTRACENO));
        failedJob.setExceptionMessage(String.format(ResManager.loadKDString((String)"\u6267\u884c\u65f6\u521b\u5efa\uff0c\u72b6\u6001\uff1a%1$s\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a%2$s\u3002", (String)"FailedJobEntityManagerImpl_3", (String)"bos-wf-engine", (Object[])new Object[0]), row.getString("FSTATE"), row.getString(FEXCEPTIONMSG)));
        failedJob.setOccurrenceTime(row.getDate(FCREATEDATE));
        failedJob.setBizTraceNo(row.getString(FBIZTRACENO));
        this.insertFailedJob(failedJob);
        return failedJob;
    }

    @Override
    public JobEntity getJobEntityFromFailedJob(Long id) {
        FailedJobEntity failedJob = (FailedJobEntity)this.findById(id);
        return this.getJobEntityFromFailedJob(failedJob);
    }

    @Override
    public JobEntity getJobEntityFromFailedJob(FailedJobEntity failedJob) {
        this.logger.debug("getJobEntityFromFailedJob...");
        JobEntity jobEntity = (JobEntity)this.getJobEntityManager().create();
        jobEntity.setJobType(failedJob.getJobType());
        jobEntity.setRetries(failedJob.getRetries());
        jobEntity.setExecutionId(failedJob.getExecutionId());
        jobEntity.setProcessInstanceId(failedJob.getProcessInstanceId());
        jobEntity.setProcessDefinitionId(failedJob.getProcessDefinitionId());
        jobEntity.setExclusive(false);
        jobEntity.setBusinessKey(failedJob.getBusinessKey());
        jobEntity.setEntityNumber(failedJob.getEntityNumber());
        jobEntity.setJobHandlerType(failedJob.getJobHandlerType());
        jobEntity.setElementId(failedJob.getElementId());
        jobEntity.setJobHandlerConfiguration(failedJob.getJobHandlerConfiguration());
        jobEntity.setId(failedJob.getId());
        return jobEntity;
    }
}

