/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.job;

import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.asyncexecutor.RepeatJobModel;
import kd.bos.workflow.engine.impl.persistence.entity.job.AbstractWfJobEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;

public class JobEntityImpl
extends AbstractWfJobEntityImpl
implements JobEntity {
    private static final long serialVersionUID = 1L;
    private String dynObjTypeName;
    public static final int MAX_EXCEPTION_MESSAGE_LENGTH = 255;
    public static final boolean DEFAULT_EXCLUSIVE = true;
    public static final String JOB_CONFIGURATION = "_CONFIGURATIONID_";
    public static final String JOB_TYPE_EVENT = "event";
    public static final String JOB_TYPE_MESSAGE = "message";
    public static final String JOB_TYPE_TIMER = "timer";
    public static final String JOB_TYPE_TASK_MESSAGE = "taskMessage";
    public static final String JOB_TYPE_TASK_TIMER = "taskTimer";

    public JobEntityImpl() {
    }

    public JobEntityImpl(String dynObjTypeName) {
        this.dynObjTypeName = dynObjTypeName;
        try {
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)this.getDynObjTypeName());
            this.dynamicObject = new DynamicObject((DynamicObjectType)type);
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
    }

    public JobEntityImpl(DynamicObject dynamicObject) {
        super(dynamicObject);
        this.dynObjTypeName = dynamicObject.getDataEntityType().getName();
    }

    @Override
    public String getDynObjTypeName() {
        if (WfUtils.isNotEmpty(this.dynObjTypeName)) {
            return this.dynObjTypeName;
        }
        return super.getDynObjTypeName();
    }

    @Override
    public Object getPersistentState() {
        Map persistentState = (Map)super.getPersistentState();
        persistentState.put("lockOwnerId", this.getLockOwnerId());
        persistentState.put("lockExpirationTime", this.getLockExpirationTime());
        persistentState.put("state", this.getState());
        persistentState.put("executor", this.getExecutor());
        persistentState.put("success", this.isSuccess());
        persistentState.put("endTime", this.getEndTime());
        persistentState.put("duration", this.getDuration());
        persistentState.put("source", this.getSource());
        persistentState.put("rootJobId", this.getRootJobId());
        return persistentState;
    }

    @Override
    public void setExecution(ExecutionEntity execution) {
        super.setExecution(execution);
        execution.getJobs().add(this);
    }

    @Override
    @SimplePropertyAttribute(name="lockOwnerId")
    public String getLockOwnerId() {
        return this.dynamicObject.getString("lockOwnerId");
    }

    @Override
    public void setLockOwnerId(String lockOwnerId) {
        this.dynamicObject.set("lockOwnerId", (Object)lockOwnerId);
    }

    @Override
    @SimplePropertyAttribute(name="lockExpirationTime")
    public Date getLockExpirationTime() {
        return this.dynamicObject.getDate("lockExpirationTime");
    }

    @Override
    public void setLockExpirationTime(Date claimedUntil) {
        this.dynamicObject.set("lockExpirationTime", (Object)claimedUntil);
    }

    @Override
    @SimplePropertyAttribute(name="executor")
    public String getExecutor() {
        return this.dynamicObject.getString("executor");
    }

    @Override
    public void setExecutor(String executor) {
        this.dynamicObject.set("executor", (Object)executor);
    }

    @Override
    @SimplePropertyAttribute(name="success")
    public boolean isSuccess() {
        return this.dynamicObject.getBoolean("success");
    }

    @Override
    public void setSuccess(boolean success) {
        this.dynamicObject.set("success", (Object)success);
    }

    @Override
    @SimplePropertyAttribute(name="endTime")
    public Date getEndTime() {
        return this.dynamicObject.getDate("endTime");
    }

    @Override
    public void setEndTime(Date endTime) {
        this.dynamicObject.set("endTime", (Object)endTime);
    }

    @Override
    @SimplePropertyAttribute(name="duration")
    public long getDuration() {
        return this.dynamicObject.getLong("duration");
    }

    @Override
    public void setDuration(long duration) {
        this.dynamicObject.set("duration", (Object)duration);
    }

    @Override
    @SimplePropertyAttribute(name="state")
    public String getState() {
        return this.dynamicObject.getString("state");
    }

    @Override
    public void setState(String state) {
        this.dynamicObject.set("state", (Object)state);
    }

    @Override
    public void setSource(String source) {
        this.dynamicObject.set("source", (Object)source);
    }

    @Override
    @SimplePropertyAttribute(name="source")
    public String getSource() {
        return this.dynamicObject.getString("source");
    }

    @Override
    public void setRootJobId(Long messageid) {
        this.dynamicObject.set("rootJobId", (Object)messageid);
    }

    @Override
    @SimplePropertyAttribute(name="rootJobId")
    public Long getRootJobId() {
        return this.normalizeId(this.dynamicObject.getLong("rootJobId"));
    }

    @Override
    public String toString() {
        return "JobEntity [id=" + this.getId() + "]";
    }

    @Override
    public RepeatJobModel getRepeatJobModel() {
        Map t;
        Map payload;
        if (WfUtils.isNotEmpty(this.getJobHandlerConfiguration()) && (payload = (Map)SerializationUtils.fromJsonString((String)this.getJobHandlerConfiguration(), Map.class)) != null && payload.get("_lockKey_") != null && (t = (Map)payload.get("_lockKey_")) != null && !t.isEmpty()) {
            String o = (String)t.get(RepeatJobModel.REPEATJOBSTRATEGYKEY);
            String type = (String)t.get(RepeatJobModel.TYPE);
            return new RepeatJobModel((String)t.get(RepeatJobModel.LOCKKEY), RepeatJobModel.JobLockedStrategy.valueOf(o), type);
        }
        return null;
    }

    @Override
    public Long getEventId() {
        if (this.dynamicObject != null) {
            return this.dynamicObject.getLong("processInstanceId");
        }
        return 0L;
    }

    @Override
    public void setOrgUnitId(Long id) {
        this.dynamicObject.set("orgUnitId", (Object)id);
    }

    @Override
    @SimplePropertyAttribute(name="orgUnitId")
    public Long getOrgUnitId() {
        return this.dynamicObject.getLong("orgUnitId");
    }

    @Override
    @SimplePropertyAttribute(name="orgviewid")
    public String getOrgViewId() {
        return this.dynamicObject.getString("orgviewid");
    }

    @Override
    public void setOrgViewId(String orgViewId) {
        this.dynamicObject.set("orgviewid", (Object)orgViewId);
    }
}

