/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.job;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.dlock.DLockInfo;
import kd.bos.mservice.monitor.ServiceInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.impl.Page;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cmd.job.DeadLetterJobLastHandleCmd;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.db.BatchVerifySqlInfo;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.jobexecutor.JobDAO;
import kd.bos.workflow.engine.impl.jobexecutor.JobUtil;
import kd.bos.workflow.engine.impl.persistence.CountingExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.SuspendJobsByProcInstMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobStateEnum;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.runtime.ExecuteJob;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.util.WfCommonUtil;

public class JobEntityManagerImpl
extends AbstractEntityManager<JobEntity>
implements JobEntityManager {
    private SuspendJobsByProcInstMatcher suspendJobMatcher = new SuspendJobsByProcInstMatcher();

    public JobEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public JobEntityImpl create(String dynObjTypeName) {
        return new JobEntityImpl(dynObjTypeName);
    }

    @Override
    public boolean insertJobEntity(JobEntity timerJobEntity) {
        return this.doInsert(timerJobEntity, true);
    }

    @Override
    public void insert(JobEntity jobEntity, boolean fireCreateEvent) {
        this.doInsert(jobEntity, fireCreateEvent);
    }

    protected boolean doInsert(JobEntity jobEntity, boolean fireCreateEvent) {
        super.insert(jobEntity, fireCreateEvent);
        if (WfUtils.isEmpty(jobEntity.getRootJobId())) {
            jobEntity.setRootJobId(jobEntity.getId());
        }
        return true;
    }

    @Override
    public List<JobEntity> findJobsToExecute(Page page) {
        ArrayList<JobEntity> result = new ArrayList<JobEntity>();
        Date now = this.getClock().getCurrentTime();
        Object val = WfConfigurationUtil.getConfigCenterVal("acquireStep");
        int step = 2;
        try {
            if (val != null) {
                step = Integer.parseInt(String.valueOf(val));
            }
        }
        catch (Exception e) {
            this.logger.warn("val\u5728step\u7c7b\u578b\u8f6c\u6362\u65f6\u51fa\u9519\uff01\u539f\u56e0\uff1a%s" + e.getMessage());
        }
        val = WfConfigurationUtil.getConfigCenterVal("acquire.limit");
        int limit = 200;
        try {
            if (val != null) {
                limit = Integer.parseInt(String.valueOf(val));
            }
        }
        catch (Exception e) {
            this.logger.warn("val\u5728limit\u7c7b\u578b\u8f6c\u6362\u65f6\u51fa\u9519\uff01\u539f\u56e0\uff1a%s" + e.getMessage());
        }
        Date startTime = new Date(now.getTime() - (long)step * 24L * 60L * 60L * 1000L);
        ArrayList<String> param = new ArrayList<String>();
        param.add(JobStateEnum.CREATED.getNumber());
        param.add(JobStateEnum.PREEXECUTING.getNumber());
        param.add(JobStateEnum.EXECUTING.getNumber());
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("lockExpirationTime", ">=", startTime).addFilter("lockExpirationTime", "<=", now).addFilter("state", "in", param).orderBy("lockExpirationTime asc").setLimit(limit);
        List ret = this.findByQueryBuilder(eb, false);
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        if (ret != null && ret.size() > 0) {
            List services = WfCommonUtil.getServiceNodes();
            for (JobEntity entity : ret) {
                if (WfUtils.isEmpty(entity.getId())) continue;
                DLockInfo tmp = DLock.getLockInfo((String)String.format(this.getLockKey(), entity.getRootJobId()));
                if (tmp != null) {
                    this.logger.debug(String.format("job[%s] \u6b63\u5728\u88ab\u6267\u884c,\u4e0d\u4f1a\u91cd\u590d\u53d1\u9001\u6d88\u606f\u3002", entity.getId()));
                    continue;
                }
                if ((JobStateEnum.PREEXECUTING.getNumber().equals(entity.getState()) || JobStateEnum.EXECUTING.getNumber().equals(entity.getState())) && !this.checkJobExecutorAlive(entity, services)) continue;
                try {
                    if (entity.getCreateDate() != null && new Date(WfUtils.now().getTime() - 86400000L).after(entity.getCreateDate())) {
                        WFEngineException e = new WFEngineException(new RuntimeException(ResManager.loadKDString((String)"\u5e95\u5c42\u7ec4\u4ef6\u5f02\u5e38", (String)"EvtJobEntityManagerImpl_1", (String)"bos-wf-engine", (Object[])new Object[0])), WFErrorCode.jobUnKnowError(), new Object[0]);
                        this.moveDeadLetterJob(entity, e);
                        continue;
                    }
                    JobUtil.setJobLockProperty(entity, this.processEngineConfiguration, this.getAsyncExecutor());
                    if (JobStateEnum.EXECUTING.getNumber().equalsIgnoreCase(entity.getState())) {
                        entity.setState(JobStateEnum.PREEXECUTING.getNumber());
                    }
                    params.add(new Object[]{entity.getLockExpirationTime(), entity.getLockOwnerId(), entity.getRetries(), entity.getState(), entity.getId()});
                    result.add(entity);
                }
                catch (Exception e) {
                    this.logger.error(String.format("job[%s] occurs error when acquiring query in wfs job, error msg is [%s]", entity.getId(), WfUtils.getExceptionStacktrace(e)));
                }
            }
        }
        if (!params.isEmpty()) {
            this.updateJob(params);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moveDeadLetterJob(JobEntity entity, WFEngineException e) {
        String markId = String.format("wf/movetodeadjob/%s", entity.getId());
        boolean flag = false;
        try {
            if (WfCacheHelper.putCurrentExecuteBySceneAndKey(markId) > 0) {
                flag = true;
                new DeadLetterJobLastHandleCmd(entity, (Throwable)((Object)e), false).execute(Context.getCommandContext());
            }
        }
        finally {
            if (flag) {
                WfCacheHelper.removeCurrentExecuteBySceneAndKey(markId);
            }
        }
    }

    protected String getLockKey() {
        return "wf/jobexecute/%s";
    }

    protected void updateJob(List<Object[]> params) {
        JobDAO jobDao = (JobDAO)TypesContainer.getOrRegisterSingletonInstance((String)JobDAO.class.getName());
        jobDao.update(DBRoute.workflow.getRouteKey(), params);
    }

    protected boolean checkJobExecutorAlive(JobEntity entity, List<ServiceInfo> services) {
        boolean jobContinue = false;
        boolean alive = WfCommonUtil.isServiceNodeAlive(services, (String)entity.getExecutor());
        if (alive) {
            this.logger.info(String.format("job[%s] \u6b63\u5728\u6267\u884c\u4e2d\uff0c\u6267\u884c\u673a\u72b6\u6001\u6b63\u5e38\uff0c\u66f4\u65b0\u7f13\u5b58\u3002", entity.getId()));
            WfCacheHelper.putCurrentExecuteJobState(entity.getId(), entity.getBusinessKey(), entity.getEntityNumber());
        } else {
            jobContinue = true;
            this.logger.info(String.format("job[%s] \u6b63\u5728\u6267\u884c\u4e2d\uff0c\u539f\u6267\u884c\u673a\u5df2\u5b95\u673a\uff0c\u5220\u9664\u7f13\u5b58\u3002", entity.getId()));
            WfCacheHelper.removeCurrentExecuteJobState(entity.getId(), entity.getBusinessKey());
        }
        return jobContinue;
    }

    @Override
    public List<JobEntity> findJobsByExecutionId(Long executionId) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("executionId", executionId).addFilter("state", "in", new String[]{JobStateEnum.CREATED.getNumber(), JobStateEnum.PREEXECUTING.getNumber(), JobStateEnum.EXECUTING.getNumber()});
        List<JobEntity> ret = this.findByQueryBuilder(eb);
        return ret;
    }

    @Override
    public List<JobEntity> findJobsByProcessInstanceId(Long processInstanceId) {
        return this.findJobsByProcessInstanceId(processInstanceId, null);
    }

    @Override
    public List<JobEntity> findJobsByProcessInstanceId(Long processInstanceId, String fields) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("processInstanceId", processInstanceId).addFilter("state", "in", new String[]{JobStateEnum.CREATED.getNumber(), JobStateEnum.PREEXECUTING.getNumber(), JobStateEnum.EXECUTING.getNumber()});
        if (WfUtils.isNotEmpty(fields)) {
            eb.setSelectFields(fields);
        }
        return this.getList(eb, this.suspendJobMatcher, processInstanceId, true);
    }

    @Override
    public List<JobEntity> findJobByMsgTypeAndBusKey(String[] type, String businessKey) {
        List<JobEntity> list = new ArrayList<JobEntity>();
        if (type != null && type.length > 0) {
            QFilter q1 = new QFilter("businessKey", "=", (Object)businessKey);
            QFilter q2 = new QFilter("jobHandlerType", "in", (Object)type);
            QFilter q3 = new QFilter("state", "in", (Object)new String[]{JobStateEnum.CREATED.getNumber(), JobStateEnum.PREEXECUTING.getNumber(), JobStateEnum.EXECUTING.getNumber()});
            QFilter[] q = new QFilter[]{q1, q2, q3};
            list = this.findByQueryFilters(q);
        }
        return list;
    }

    @Override
    public void delete(JobEntity jobEntity) {
        super.delete(jobEntity);
        if (this.getEventDispatcher().isEnabled()) {
            this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_DELETED, this));
        }
    }

    @Override
    public void delete(JobEntity entity, boolean fireDeleteEvent) {
        CountingExecutionEntity executionEntity;
        if (WfUtils.isNotEmpty(entity.getExecutionId()) && this.isExecutionRelatedEntityCountEnabledGlobally() && this.isExecutionRelatedEntityCountEnabled(executionEntity = (CountingExecutionEntity)this.getExecutionEntityManager().findById(entity.getExecutionId()))) {
            executionEntity.setJobCount(executionEntity.getJobCount() - 1);
        }
        super.delete(entity, fireDeleteEvent);
    }

    protected void removeExecutionLink(JobEntity jobEntity) {
        ExecutionEntity execution;
        if (WfUtils.isNotEmpty(jobEntity.getExecutionId()) && (execution = (ExecutionEntity)this.getExecutionEntityManager().findById(jobEntity.getExecutionId())) != null) {
            execution.getJobs().remove(jobEntity);
        }
    }

    @Override
    public Class<? extends JobEntity> getManagedEntityClass() {
        return JobEntityImpl.class;
    }

    @Override
    public String getSelectFields() {
        return "id,jobType,lockExpirationTime,exclusive,lockOwnerId,executionid,processinstanceid,processdefinitionid,retries,entityNumber,businessKey,operation,exceptionmessage,duedate,repeat,jobhandlertype,jobhandlerconfiguration,createdate,modifydate,elementid,srcjobid,rootTraceNo,executor,success,endTime,duration,state,source,rootJobId,biztraceno,orgunitid,orgviewid";
    }

    @Override
    public JobEntity findLastestJobByRootJobId(Long rootJobId) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("rootJobId", rootJobId).orderBy("createDate desc");
        List list = this.findByQueryBuilder(eb);
        if (list != null && list.size() > 0) {
            return (JobEntity)list.get(0);
        }
        return null;
    }

    @Override
    public void deleteJobByBusinessKey(String businessKey) {
        QFilter[] filters = new QFilter[]{new QFilter("businessKey", "=", (Object)businessKey)};
        this.deleteByFilters(filters);
    }

    @Override
    public List<JobEntity> findJobsByProcInstId(Long procInstId, String fields) {
        EntityQueryBuilder queryBuilder = this.createQueryBuilder();
        queryBuilder.addFilter("processInstanceId", procInstId);
        queryBuilder.addFilter("state", "in", new String[]{JobStateEnum.CREATED.getNumber(), JobStateEnum.PREEXECUTING.getNumber(), JobStateEnum.EXECUTING.getNumber()});
        queryBuilder.setSelectFields(WfUtils.isNotEmpty(fields) ? fields : this.getSelectFields());
        return this.findByQueryBuilder(queryBuilder);
    }

    @Override
    public List<JobEntity> findJobsByBusinessKey(String businessKey, String fields) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("businessKey", businessKey).addFilter("state", "in", new String[]{JobStateEnum.CREATED.getNumber(), JobStateEnum.PREEXECUTING.getNumber(), JobStateEnum.EXECUTING.getNumber()}).setSelectFields(WfUtils.isEmpty(fields) ? this.getSelectFields() : fields);
        return this.findByQueryBuilder(eb);
    }

    @Override
    public List<JobEntity> findJobsByBusinessKeys(List<String> businessKeys, String fields) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("businessKey", "in", businessKeys.toArray(new String[businessKeys.size()])).addFilter("state", "in", new String[]{JobStateEnum.CREATED.getNumber(), JobStateEnum.PREEXECUTING.getNumber(), JobStateEnum.EXECUTING.getNumber()}).setSelectFields(WfUtils.isEmpty(fields) ? this.getSelectFields() : fields);
        return this.findByQueryBuilder(eb);
    }

    @Override
    public List<JobEntity> findFinshedJobsByBusinessKeys(List<String> businessKeys) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("businessKey", "in", businessKeys).addFilter("state", "in", new String[]{JobStateEnum.COMPLETED.getNumber(), JobStateEnum.ERRORED.getNumber()});
        return this.findByQueryBuilder(eb);
    }

    @Override
    public List<JobEntity> findFinshedJobsByEntityNumbersAndBusinessKeys(List<String> entityNumbers, List<String> businessKeys) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("businessKey", "in", businessKeys).addFilter("state", "in", new String[]{JobStateEnum.COMPLETED.getNumber(), JobStateEnum.ERRORED.getNumber()}).addFilter("entityNumber", "in", entityNumbers).addFilter("jobHandlerType", "!=", "delay-broadcast").orderBy("id asc");
        return this.findByQueryBuilder(eb);
    }

    @Override
    public void saveOrUpdateByVerifySql(ExecuteJob job, boolean ifWillInsert) {
        String sql = null;
        String tableName = "t_wf_jobrecord";
        String tableName1 = "t_wf_deadletterjob";
        if (job.getJobType().equals("taskMessage") || job.getJobType().equals("taskTimer")) {
            tableName = "t_wf_taskjobrecord";
            tableName1 = "t_wf_taskdeadletterjob";
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(1);
        if (ifWillInsert) {
            sql = "insert into " + tableName + "(fid, ftype, flockexptime, flockownerid, fexclusive, fexecutionid, fprocessinstanceid, fprocdefid, fretries, fduedate, frepeat, fhandlertype, fbusinesskey, foperation, fentitynumber, felementid, fcreatedate, fmodifydate, fsrcjobid, froottraceno, fexecutor, fsuccess, fendtime, fduration, fstate, fsource, frootjobid, fexceptionmsg, fhandlercfg, fbiztraceno, forgunitid, forgviewid)select ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,? where not exists (select 1 from " + tableName + " where fid = ?) and not exists (select 1 from " + tableName1 + " where fid = ?)";
            params.add(new Object[]{job.getId(), this.defultString(job.getJobType()), job.getLockExpirationTime(), this.defultString(job.getLockOwnerId()), Character.valueOf(job.isExclusive() ? (char)'1' : '0'), this.defultLong(job.getExecutionId()), this.defultLong(job.getProcessInstanceId()), this.defultLong(job.getProcessDefinitionId()), job.getRetries(), job.getDuedate(), this.defultString(job.getRepeat()), this.defultString(job.getJobHandlerType()), this.defultString(job.getBusinessKey()), this.defultString(job.getOperation()), this.defultString(job.getEntityNumber()), this.defultString(job.getElementId()), job.getCreateDate(), job.getModifyDate(), this.defultLong(job.getSrcJobId()), this.defultString(job.getRootTraceNo()), this.defultString(job.getExecutor()), Character.valueOf(job.isSuccess() ? (char)'1' : '0'), Context.getProcessEngineConfiguration().getClock().getCurrentTime(), this.defultLong(job.getDuration()), this.defultString(job.getState()), this.defultString(job.getSource()), this.defultLong(((JobEntity)job).getRootJobId()), job.getExceptionMessage(), job.getJobHandlerConfiguration(), this.defultString(job.getBizTraceNo()), this.defultLong(((JobEntity)job).getOrgUnitId()), this.defultString(((JobEntity)job).getOrgViewId()), job.getId(), job.getId()});
        } else {
            sql = "update " + tableName + " set fstate = ?,fexceptionmsg = ?,fendtime = ?,fduration = ?,fexclusive = ?,forgunitid = ?,forgviewid = ?,fbiztraceno = ?,fretries = ?,fsuccess = ? where fid = ? and fstate in ('created','received','executing')";
            params.add(new Object[]{this.defultString(job.getState()), this.defultString(job.getExceptionMessage()), Context.getProcessEngineConfiguration().getClock().getCurrentTime(), this.defultLong(job.getDuration()), Character.valueOf(job.isExclusive() ? (char)'1' : '0'), this.defultLong(((JobEntity)job).getOrgUnitId()), this.defultString(((JobEntity)job).getOrgViewId()), this.defultString(job.getBizTraceNo()), job.getRetries(), Character.valueOf(job.isSuccess() ? (char)'1' : '0'), job.getId()});
        }
        this.getDbSqlSession().addVerifySqlInfos(new BatchVerifySqlInfo(sql, params, 1, !ifWillInsert, job.getClass(), job.getId()));
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_UPDATED, job));
        }
    }

    private Long defultLong(Long inputLong) {
        if (inputLong == null) {
            return 0L;
        }
        return inputLong;
    }

    private String defultString(String inputString) {
        if (inputString == null) {
            return " ";
        }
        return inputString;
    }
}

