/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.job;

import java.util.List;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.persistence.CachedEntityMatcher;
import kd.bos.workflow.engine.impl.persistence.CountingExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.FindSuspendJobsByProcInstMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.job.SuspendedJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.SuspendedJobEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.job.SuspendedJobEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;

public class SuspendedJobEntityManagerImpl
extends AbstractEntityManager<SuspendedJobEntity>
implements SuspendedJobEntityManager {
    protected CachedEntityMatcher<SuspendedJobEntity> suspendJobsByProcInstMatcher = new FindSuspendJobsByProcInstMatcher();

    public SuspendedJobEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public Class<? extends SuspendedJobEntity> getManagedEntityClass() {
        return SuspendedJobEntityImpl.class;
    }

    @Override
    public String getSelectFields() {
        return "id,jobType,exclusive,executionid,processinstanceid,processdefinitionid,retries,entityNumber,businessKey,operation,exceptionmessage,duedate,repeat,jobhandlertype,jobhandlerconfiguration,createdate,modifydate,active,elementid,srcjobid,rootTraceNo,biztraceno";
    }

    @Override
    public List<SuspendedJobEntity> findJobsByExecutionId(Long id) {
        EntityQueryBuilder qb = this.createQueryBuilder().addFilter("executionId", id);
        return this.findByQueryBuilder(qb);
    }

    @Override
    public List<SuspendedJobEntity> findJobsByProcessInstanceId(Long id) {
        EntityQueryBuilder qb = this.createQueryBuilder().addFilter("processInstanceId", id);
        return this.findByQueryBuilder(qb, this.suspendJobsByProcInstMatcher, id, true);
    }

    @Override
    public List<SuspendedJobEntity> findJobByMsgTypeAndBusKey(String[] type, String businessKey) {
        QFilter q1 = new QFilter("businessKey", "=", (Object)businessKey);
        QFilter q2 = new QFilter("jobType", "in", (Object)type);
        QFilter[] q = new QFilter[]{q1, q2};
        List<SuspendedJobEntity> ret = this.findByQueryFilters(q, this.getSelectFields(), null);
        return ret;
    }

    @Override
    public void insert(SuspendedJobEntity jobEntity, boolean fireCreateEvent) {
        ExecutionEntity execution;
        if (jobEntity.getExecutionId() != null && this.isExecutionRelatedEntityCountEnabled(execution = (ExecutionEntity)this.getExecutionEntityManager().findById(jobEntity.getExecutionId()))) {
            CountingExecutionEntity countingExecutionEntity = (CountingExecutionEntity)((Object)execution);
            countingExecutionEntity.setSuspendedJobCount(countingExecutionEntity.getSuspendedJobCount() + 1);
        }
        super.insert(jobEntity, fireCreateEvent);
    }

    @Override
    public void insert(SuspendedJobEntity jobEntity) {
        this.insert(jobEntity, true);
    }

    @Override
    public void delete(SuspendedJobEntity jobEntity) {
        CountingExecutionEntity executionEntity;
        super.delete(jobEntity);
        if (jobEntity.getExecutionId() != null && this.isExecutionRelatedEntityCountEnabledGlobally() && this.isExecutionRelatedEntityCountEnabled(executionEntity = (CountingExecutionEntity)this.getExecutionEntityManager().findById(jobEntity.getExecutionId()))) {
            executionEntity.setSuspendedJobCount(executionEntity.getSuspendedJobCount() - 1);
        }
        if (this.getEventDispatcher().isEnabled()) {
            this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_DELETED, this));
        }
    }
}

