/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.job;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.impl.Page;
import kd.bos.workflow.engine.impl.calendar.BusinessCalendar;
import kd.bos.workflow.engine.impl.calendar.CycleBusinessCalendar;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.jobexecutor.TimerEventHandler;
import kd.bos.workflow.engine.impl.persistence.CountingExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.TimerJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.TimerJobEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.job.TimerJobEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.service.WfTraceType;
import org.apache.commons.lang.StringUtils;

public class TimerJobEntityManagerImpl
extends AbstractEntityManager<TimerJobEntity>
implements TimerJobEntityManager {
    public TimerJobEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public Class<? extends TimerJobEntity> getManagedEntityClass() {
        return TimerJobEntityImpl.class;
    }

    @Override
    public String getSelectFields() {
        return "id,jobType,lockExpirationTime,exclusive,lockOwnerId,executionid,processinstanceid,processdefinitionid,retries,entityNumber,businessKey,operation,exceptionmessage,duedate,repeat,jobhandlertype,jobhandlerconfiguration,createdate,modifydate,elementid,srcjobid,rootTraceNo,biztraceno";
    }

    @Override
    public TimerJobEntity createAndCalculateNextTimer(JobEntity timerEntity, VariableScope variableScope) {
        int repeatValue = this.calculateRepeatValue(timerEntity);
        if (repeatValue != 0) {
            Date newTimer;
            if (repeatValue > 0) {
                this.setNewRepeat(timerEntity, repeatValue);
            }
            if ((newTimer = this.calculateNextTimer(timerEntity, variableScope)) != null && this.isValidTime(timerEntity, newTimer, variableScope)) {
                TimerJobEntity te = this.createTimer(timerEntity);
                te.setDuedate(newTimer);
                return te;
            }
        }
        return null;
    }

    @Override
    public List<TimerJobEntity> findTimerJobsToExecute(Page page) {
        int intVal;
        int retrySize = 100;
        int timingSize = 300;
        Object retryLimit = WfConfigurationUtil.getConfigCenterVal("workflow.timerjob.querylimit");
        Object timingLimit = WfConfigurationUtil.getConfigCenterVal("workflow.timerjob.timingquerylimit");
        if (null != retryLimit) {
            intVal = Integer.parseInt(retryLimit.toString());
            int n = retrySize = intVal > retrySize ? intVal : retrySize;
        }
        if (null != timingLimit) {
            intVal = Integer.parseInt(timingLimit.toString());
            timingSize = intVal > timingSize ? intVal : timingSize;
        }
        EntityQueryBuilder<TimerJobEntity> waitEq = this.createTimerQueryBuilder().addFilter("jobHandlerType", "async-timing").setLimit(timingSize);
        EntityQueryBuilder<TimerJobEntity> timerStartEq = this.createTimerQueryBuilder().addFilter("jobHandlerType", "timer-start-event").setLimit(retrySize);
        EntityQueryBuilder<TimerJobEntity> otherEq = this.createTimerQueryBuilder().addFilter("jobHandlerType", "not in", new String[]{"async-timing", "timer-start-event"}).setLimit(retrySize);
        List<TimerJobEntity> timingModelJobs = this.findByQueryBuilder(waitEq);
        timingModelJobs.addAll(this.findByQueryBuilder(timerStartEq));
        timingModelJobs.addAll(this.findByQueryBuilder(otherEq));
        return timingModelJobs;
    }

    private EntityQueryBuilder<TimerJobEntity> createTimerQueryBuilder() {
        Date now = this.getClock().getCurrentTime();
        EntityQueryBuilder<TimerJobEntity> queryBuilder = this.createQueryBuilder();
        queryBuilder.addFilter("duedate", "<=", now);
        String lockTag = WfConfigurationUtil.getLockTag();
        if (WfUtils.isNotEmpty(lockTag)) {
            queryBuilder.addFilter("lockOwnerId", lockTag);
        }
        return queryBuilder;
    }

    @Override
    public List<TimerJobEntity> findJobsByTypeAndProcessDefinitionId(String jobHandlerType, Long processDefinitionId) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("jobHandlerType", jobHandlerType).addFilter("processDefinitionId", processDefinitionId);
        return this.findByQueryBuilder(eb);
    }

    @Override
    public List<TimerJobEntity> findTimerStartJobsByProcessDefinitionKey(String processDefinitionKey, String fields) {
        QFilter[] filters = new QFilter[]{new QFilter("key", "=", (Object)processDefinitionKey)};
        List processDefinitions = this.getProcessDefinitionEntityManager().findByQueryFilters(filters, "id", null);
        if (processDefinitions.isEmpty()) {
            return null;
        }
        ArrayList<Long> processDefinitionIds = new ArrayList<Long>(processDefinitions.size());
        for (ProcessDefinitionEntity processDefinition : processDefinitions) {
            processDefinitionIds.add(processDefinition.getId());
        }
        EntityQueryBuilder queryBuilder = this.createQueryBuilder().addFilter("jobHandlerType", "timer-start-event").addFilter("processDefinitionId", "in", processDefinitionIds);
        if (fields != null) {
            queryBuilder.setSelectFields(fields);
        }
        return this.findByQueryBuilder(queryBuilder);
    }

    @Override
    public List<TimerJobEntity> findJobsByTypeAndProcessDefinitionKey(String jobHandlerType, String processDefinitionKey) {
        String sql = "select J.FID,J.FTYPE,J.FLOCKEXPTIME,J.FLOCKOWNERID,J.FEXCLUSIVE,J.FEXECUTIONID,J.FPROCESSINSTANCEID,J.FPROCDEFID,J.FRETRIES,J.FEXCEPTIONMSG,J.FDUEDATE,J.FREPEAT,J.FHANDLERTYPE,J.FHANDLERCFG,J.FBUSINESSKEY,J.FOPERATION,J.FENTITYNUMBER,J.FELEMENTID,J.FCREATEDATE,J.FMODIFYDATE,J.FSRCJOBID,J.FROOTTRACENO  from T_WF_TIMERJOB J inner join T_WF_PROCDEF P on J.FPROCDEFID = P.FID where J.FHANDLERTYPE = ? and P.FKEY = ?";
        return this.findEntityBySQLFilter(sql, new Object[]{processDefinitionKey, jobHandlerType});
    }

    @Override
    public List<TimerJobEntity> findJobsByExecutionId(Long id) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("executionId", id);
        return this.findByQueryBuilder(eb);
    }

    @Override
    public List<TimerJobEntity> findJobsByProcessInstanceId(Long id, String fields) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("processInstanceId", id);
        if (WfUtils.isNotEmpty(fields)) {
            eb.setSelectFields(fields);
        }
        return this.findByQueryBuilder(eb);
    }

    @Override
    public List<TimerJobEntity> findJobsByProcessInstanceId(Long id) {
        return this.findJobsByProcessInstanceId(id, null);
    }

    @Override
    public boolean insertTimerJobEntity(TimerJobEntity timerJobEntity) {
        return this.doInsert(timerJobEntity, true);
    }

    @Override
    public void insert(TimerJobEntity jobEntity) {
        this.insert(jobEntity, true);
    }

    @Override
    public void insert(TimerJobEntity jobEntity, boolean fireCreateEvent) {
        this.doInsert(jobEntity, fireCreateEvent);
    }

    protected boolean doInsert(TimerJobEntity jobEntity, boolean fireCreateEvent) {
        super.insert(jobEntity, fireCreateEvent);
        return true;
    }

    @Override
    public void delete(TimerJobEntity jobEntity) {
        CountingExecutionEntity executionEntity;
        super.delete(jobEntity);
        if (jobEntity.getExecutionId() != null && this.isExecutionRelatedEntityCountEnabledGlobally() && this.isExecutionRelatedEntityCountEnabled(executionEntity = (CountingExecutionEntity)this.getExecutionEntityManager().findById(jobEntity.getExecutionId()))) {
            executionEntity.setTimerJobCount(executionEntity.getTimerJobCount() - 1);
        }
        if (this.getEventDispatcher().isEnabled()) {
            this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_DELETED, this));
        }
    }

    protected TimerJobEntity createTimer(JobEntity te) {
        WfTraceType.WfTraceJobInfo jobInfo;
        TimerJobEntity newTimerEntity = (TimerJobEntity)this.create();
        newTimerEntity.setJobHandlerConfiguration(te.getJobHandlerConfiguration());
        newTimerEntity.setJobHandlerType(te.getJobHandlerType());
        newTimerEntity.setExclusive(te.isExclusive());
        newTimerEntity.setRepeat(te.getRepeat());
        newTimerEntity.setRetries(te.getRetries());
        newTimerEntity.setEndDate(te.getEndDate());
        newTimerEntity.setLockOwnerId(te.getLockOwnerId());
        newTimerEntity.setElementId(te.getElementId());
        newTimerEntity.setEntityNumber(te.getEntityNumber());
        newTimerEntity.setBusinessKey(te.getBusinessKey());
        newTimerEntity.setExecutionId(te.getExecutionId());
        newTimerEntity.setProcessInstanceId(te.getProcessInstanceId());
        newTimerEntity.setProcessDefinitionId(te.getProcessDefinitionId());
        String lockTag = WfConfigurationUtil.getLockTag();
        if (WfUtils.isNotEmpty(lockTag)) {
            newTimerEntity.setLockOwnerId(lockTag);
        }
        if ((jobInfo = WfTraceType.getOrCreate().getJobInfo()) != null) {
            newTimerEntity.setSrcJobId(jobInfo.getCurrentJobId());
        }
        newTimerEntity.setJobType("timer");
        return newTimerEntity;
    }

    protected void setNewRepeat(JobEntity timerEntity, int newRepeatValue) {
        List<String> expression = Arrays.asList(timerEntity.getRepeat().split("/"));
        expression = expression.subList(1, expression.size());
        StringBuilder repeatBuilder = new StringBuilder("R");
        repeatBuilder.append(newRepeatValue);
        for (String value : expression) {
            repeatBuilder.append('/');
            repeatBuilder.append(value);
        }
        timerEntity.setRepeat(repeatBuilder.toString());
    }

    protected boolean isValidTime(JobEntity timerEntity, Date newTimerDate, VariableScope variableScope) {
        String calendarName = this.getBusinessCalendarName(TimerEventHandler.geCalendarNameFromConfiguration(timerEntity.getJobHandlerConfiguration()), variableScope);
        BusinessCalendar businessCalendar = this.getProcessEngineConfiguration().getBusinessCalendarManager().getBusinessCalendar(calendarName);
        return businessCalendar.validateDuedate(timerEntity.getRepeat(), timerEntity.getMaxIterations(), timerEntity.getEndDate(), newTimerDate);
    }

    protected Date calculateNextTimer(JobEntity timerEntity, VariableScope variableScope) {
        String calendarName = this.getBusinessCalendarName(TimerEventHandler.geCalendarNameFromConfiguration(timerEntity.getJobHandlerConfiguration()), variableScope);
        BusinessCalendar businessCalendar = this.getProcessEngineConfiguration().getBusinessCalendarManager().getBusinessCalendar(calendarName);
        return businessCalendar.resolveDuedate(timerEntity.getRepeat(), timerEntity.getMaxIterations());
    }

    protected int calculateRepeatValue(JobEntity timerEntity) {
        int times = -1;
        List<String> expression = Arrays.asList(timerEntity.getRepeat().split("/"));
        if (expression.size() > 1 && expression.get(0).startsWith("R") && expression.get(0).length() > 1 && (times = Integer.parseInt(expression.get(0).substring(1))) > 0) {
            --times;
        }
        return times;
    }

    protected String getBusinessCalendarName(String calendarName, VariableScope variableScope) {
        String businessCalendarName = CycleBusinessCalendar.NAME;
        if (StringUtils.isNotEmpty((String)calendarName)) {
            businessCalendarName = (String)Context.getProcessEngineConfiguration().getExpressionManager().createExpression(calendarName).getValue(variableScope);
        }
        return businessCalendarName;
    }

    @Override
    public List<TimerJobEntity> findJobsByBusinessKey(String businessKey, String fields) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("businessKey", businessKey).setSelectFields(WfUtils.isEmpty(fields) ? this.getSelectFields() : fields);
        return this.findByQueryBuilder(eb);
    }

    @Override
    public List<TimerJobEntity> findJobsByBusinessKeys(List<String> businessKeys, String fields) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("businessKey", "in", businessKeys).setSelectFields(WfUtils.isEmpty(fields) ? this.getSelectFields() : fields);
        return this.findByQueryBuilder(eb);
    }

    @Override
    public TimerJobEntity create(String dynObjTypeName) {
        return new TimerJobEntityImpl(dynObjTypeName);
    }
}

