/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.management;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.bpmn.deployer.VersionUtils;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.persistence.entity.design.ExpressionExtEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntityManagerImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.RoleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.RoleEntityManager;
import kd.bos.workflow.exception.WFErrorCode;

public class CommonCondRuleEntityManagerImpl
extends ConditionalRuleEntityManagerImpl {
    private static final String LONGINFO = "role: %s not exists!";

    public CommonCondRuleEntityManagerImpl(ProcessEngineConfigurationImpl configuration) {
        super(configuration);
    }

    @Override
    protected void mapToEntityMgr() {
    }

    @Override
    public void insert(ConditionalRuleEntity entity, boolean fireCreateEvent) {
        this.logger.debug("--\uff1abegin insert ConditionalRuleEntity!");
        entity.setVersion(VersionUtils.getNextVersion(entity.getVersion()));
        this.logger.debug("--\uff1aset ConditionalRuleEntity's version! " + entity.getVersion());
        entity.setValidtime(this.getClock().getCurrentTime());
        this.logger.debug("--\uff1ainvoke super.pureInsert()!");
        List<ConditionalEntity> details = entity.getEntryentity();
        for (ConditionalEntity i : details) {
            i.setId(null);
            if (i.getParamnumber().contains("mc_wfRole") && WfUtils.isNotEmpty(i.getValue()) && !"fieldVal".equals(i.getValuetype())) {
                List roles = SerializationUtils.fromJsonStringToList((String)i.getValue(), Map.class);
                RoleEntityManager roleManager = this.getCommandContext().getRoleEntityManager();
                for (Map m : roles) {
                    if (!WfUtils.isNotEmptyString(m.get("value"))) continue;
                    Long roleId = Long.parseLong(m.get("value").toString());
                    RoleEntity re = (RoleEntity)roleManager.findById(roleId);
                    if (re == null) {
                        this.logger.debug(String.format(LONGINFO, roleId));
                        continue;
                    }
                    int useCount = re.getUseCount();
                    re.setUseCount(++useCount);
                    roleManager.update(re);
                }
            }
            this.updateExpCountForCondition(i, "add");
        }
        entity.setEntryentity(details);
        super.pureInsert(entity, fireCreateEvent);
        this.logger.debug("--\uff1abegin insert HistoricConditionalRuleEntityManager!");
        this.getHistoricConditionalRuleEntityManager().insert(this.getHistoricCondRule(entity));
        this.logger.debug("--\uff1aafter insert HistoricConditionalRuleEntityManager!");
    }

    private void updateExpCountForCondition(ConditionalEntity i, String addOrDelete) {
        Pattern pattern;
        Matcher matcher;
        String paramNumber;
        if (i.getParamnumber().contains("mc_") && ((paramNumber = i.getParamnumber()).contains("value=") || paramNumber.contains("value =")) && (matcher = (pattern = Pattern.compile("value=([\\w\\.]+)")).matcher(paramNumber)).find()) {
            String expression = matcher.group(1).trim();
            if (expression.contains(".")) {
                List<String> props = Arrays.asList(expression.split("\\."));
                for (String p : props) {
                    if (!p.startsWith("mc_")) continue;
                    if ("add".equals(addOrDelete)) {
                        this.addExpUseCount(p);
                        continue;
                    }
                    this.deleteExpUseCount(p);
                }
            } else if (expression.startsWith("mc_")) {
                if ("add".equals(addOrDelete)) {
                    this.addExpUseCount(expression);
                } else {
                    this.deleteExpUseCount(expression);
                }
            }
        }
    }

    private void addExpUseCount(String expression) {
        ExpressionExtEntity expressionExtEntity = this.getCommandContext().getExpressionExtEntityManager().findByNumber(expression);
        if (expressionExtEntity != null) {
            Integer useCount = expressionExtEntity.getUsecount();
            if (useCount == null || useCount == 0) {
                expressionExtEntity.setUsecount(1);
            } else {
                expressionExtEntity.setUsecount(1 + useCount);
            }
            this.getCommandContext().getExpressionExtEntityManager().update(expressionExtEntity);
        }
    }

    private void deleteExpUseCount(String expression) {
        ExpressionExtEntity expressionExtEntity = this.getCommandContext().getExpressionExtEntityManager().findByNumber(expression);
        if (expressionExtEntity != null) {
            Integer useCount = expressionExtEntity.getUsecount();
            if (useCount == null || useCount <= 0) {
                throw new KDException(WFErrorCode.conditionSaveError(), new Object[]{String.format(ResManager.loadKDString((String)"\u5220\u9664\u6761\u4ef6\u8868\u8fbe\u5f0f\u201c%s\u201d\uff0c\u8be5\u8868\u8fbe\u5f0f\u672a\u88ab\u5f15\u7528\u3002", (String)"CommonCondRuleEntityManagerImpl_1", (String)"bos-wf-engine", (Object[])new Object[0]), expression)});
            }
            expressionExtEntity.setUsecount(useCount - 1);
            this.getCommandContext().getExpressionExtEntityManager().update(expressionExtEntity);
        }
    }

    @Override
    public ConditionalRuleEntity update(ConditionalRuleEntity entity, boolean fireUpdateEvent) {
        String version = entity.getVersion();
        Date time = this.processEngineConfiguration.getProcessEngineConfiguration().getClock().getCurrentTime();
        this.getHistoricConditionalRuleEntityManager().setInvalidTime(entity.getId(), version, time);
        entity.setVersion(VersionUtils.getNextVersion(entity.getVersion()));
        entity.setValidtime(time);
        HashMap<String, Integer> roleIdMapCount = new HashMap<String, Integer>();
        for (ConditionalEntity conditionalEntity : entity.getEntryentity()) {
            if (conditionalEntity.getParamnumber().contains("mc_wfRole") && WfUtils.isNotEmpty(conditionalEntity.getValue()) && !"fieldVal".equals(conditionalEntity.getValuetype())) {
                List roles = SerializationUtils.fromJsonStringToList((String)conditionalEntity.getValue(), Map.class);
                for (Object m : roles) {
                    if (!WfUtils.isNotEmptyString(m.get("value"))) continue;
                    String roleIdStr = m.get("value").toString();
                    if (roleIdMapCount.get(roleIdStr) != null) {
                        int count = (Integer)roleIdMapCount.get(roleIdStr) + 1;
                        roleIdMapCount.put(roleIdStr, count);
                        continue;
                    }
                    roleIdMapCount.put(roleIdStr, 1);
                }
            }
            this.updateExpCountForCondition(conditionalEntity, "add");
        }
        List<ConditionalEntity> details = ((ConditionalRuleEntity)this.findById(entity.getId())).getEntryentity();
        for (ConditionalEntity i : details) {
            if (i.getParamnumber().contains("mc_wfRole") && WfUtils.isNotEmpty(i.getValue()) && !"fieldVal".equals(i.getValuetype())) {
                List roles = SerializationUtils.fromJsonStringToList((String)i.getValue(), Map.class);
                for (Map m : roles) {
                    if (!WfUtils.isNotEmptyString(m.get("value"))) continue;
                    String roleIdStr = m.get("value").toString();
                    if (roleIdMapCount.get(roleIdStr) != null) {
                        int count = (Integer)roleIdMapCount.get(roleIdStr) - 1;
                        roleIdMapCount.put(roleIdStr, count);
                        continue;
                    }
                    roleIdMapCount.put(roleIdStr, -1);
                }
            }
            this.updateExpCountForCondition(i, "delete");
        }
        if (!roleIdMapCount.isEmpty()) {
            RoleEntityManager roleEntityManager = this.getCommandContext().getRoleEntityManager();
            for (Map.Entry roleIdMap : roleIdMapCount.entrySet()) {
                String sroleId = (String)roleIdMap.getKey();
                RoleEntity re = (RoleEntity)roleEntityManager.findById(Long.parseLong(sroleId));
                if (re == null) {
                    this.logger.debug(String.format(LONGINFO, sroleId));
                    continue;
                }
                int countInMap = (Integer)roleIdMap.getValue();
                int useCount = re.getUseCount() + countInMap;
                re.setUseCount(useCount < 0 ? 0 : useCount);
                roleEntityManager.update(re);
            }
        }
        super.pureUpdate(entity, fireUpdateEvent);
        this.getHistoricConditionalRuleEntityManager().insert(this.getHistoricCondRule(entity));
        return entity;
    }

    @Override
    public void delete(ConditionalRuleEntity entity, boolean fireDeleteEvent) {
        List<ConditionalEntity> details = entity.getEntryentity();
        this.logger.debug("begin count wfRole...");
        for (ConditionalEntity i : details) {
            if (i.getParamnumber().contains("mc_wfRole") && WfUtils.isNotEmpty(i.getValue()) && !"fieldVal".equals(i.getValuetype())) {
                List roles = SerializationUtils.fromJsonStringToList((String)i.getValue(), Map.class);
                RoleEntityManager roleManager = this.getCommandContext().getRoleEntityManager();
                for (Map m : roles) {
                    if (!WfUtils.isNotEmptyString(m.get("value"))) continue;
                    RoleEntity re = (RoleEntity)roleManager.findById(Long.parseLong(m.get("value").toString()));
                    if (re == null) {
                        this.logger.debug(String.format(LONGINFO, m.get("value")));
                        continue;
                    }
                    int useCount = re.getUseCount();
                    re.setUseCount(--useCount < 0 ? 0 : useCount);
                    roleManager.update(re);
                }
            }
            this.updateExpCountForCondition(i, "delete");
        }
        this.logger.debug("after count wfRole, begin delete conditionalrule...");
        super.pureDelete(entity, fireDeleteEvent);
        this.logger.debug("begin delete historic conditionalrule...");
        this.getHistoricConditionalRuleEntityManager().deleteHistoricCondRulesByCondRuleId(entity.getId());
    }

    public void saveOrUpdate(ConditionalRuleEntity entity) {
        if (WfUtils.isEmpty(entity.getId())) {
            this.insert(entity, false);
        } else {
            ConditionalRuleEntity condition = (ConditionalRuleEntity)this.findById(entity.getId());
            condition.setShowtext(entity.getShowtext());
            condition.setExpression(entity.getExpression());
            condition.setPlugin(entity.getPlugin());
            condition.setDescription(entity.getDescription());
            condition.setEntryentity(entity.getEntryentity());
            this.update(condition, false);
        }
    }
}

