/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.management;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.persistence.CachedEntityMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.ConditionalRuleMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricConditionalRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricConditionalRuleEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.CommonCondRuleEntityManagerImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntityManagerFactory;
import kd.bos.workflow.engine.impl.util.QueryWrapper;
import kd.bos.workflow.engine.pojo.StartUpConditionText;

public class ConditionalRuleEntityManagerImpl
extends AbstractEntityManager<ConditionalRuleEntity>
implements ConditionalRuleEntityManager {
    protected CachedEntityMatcher<ConditionalRuleEntity> condRuleMatcher = new ConditionalRuleMatcher();
    protected Map<String, ConditionalRuleEntityManagerImpl> concreteManagerMap = new HashMap<String, ConditionalRuleEntityManagerImpl>();

    public ConditionalRuleEntityManagerImpl(ProcessEngineConfigurationImpl configuration) {
        super(configuration);
    }

    @Override
    public Class<? extends ConditionalRuleEntity> getManagedEntityClass() {
        return ConditionalRuleEntityImpl.class;
    }

    @Override
    public String getSelectFields() {
        return "id,procdefid,showtext,type,description,elementid,validtime,expression,plugin,version,creatorid,createdate,modifierid,modifydate,property,entryentity.id, entryentity.leftbracket, entryentity.paramnumber, entryentity.operation, entryentity.value, entryentity.rightbracket, entryentity.logic,entryentity.valuetype,entryentity.entitynumber,entryentity.seq";
    }

    @Override
    public void insert(ConditionalRuleEntity entity, boolean fireCreateEvent) {
        this.getConcreteManager(entity.getType()).insert(entity, fireCreateEvent);
    }

    @Override
    public ConditionalRuleEntity update(ConditionalRuleEntity entity, boolean fireUpdateEvent) {
        return this.getConcreteManager(entity.getType()).update(entity, fireUpdateEvent);
    }

    @Override
    public void delete(ConditionalRuleEntity entity, boolean fireDeleteEvent) {
        this.getConcreteManager(entity.getType()).delete(entity, fireDeleteEvent);
    }

    public void pureInsert(ConditionalRuleEntity entity, boolean fireCreateEvent) {
        super.insert(entity, fireCreateEvent);
    }

    public ConditionalRuleEntity pureUpdate(ConditionalRuleEntity entity, boolean fireUpdateEvent) {
        return super.update(entity, fireUpdateEvent);
    }

    public void pureDelete(ConditionalRuleEntity entity, boolean fireDeleteEvent) {
        super.delete(entity, fireDeleteEvent);
    }

    @Override
    public List<ConditionalRuleEntity> findCondRulesByFilters(Map<String, Object> filters, Object parameter, boolean checkCache) {
        return this.findByQueryBuilder(this.createQueryBuilder(filters), this.condRuleMatcher, parameter, checkCache);
    }

    public EntityQueryBuilder<ConditionalRuleEntity> createQueryBuilder(Map<String, Object> filters) {
        EntityQueryBuilder<ConditionalRuleEntity> queryBuilder = this.createQueryBuilder();
        for (Map.Entry<String, Object> entry : filters.entrySet()) {
            queryBuilder.addFilter(entry.getKey(), entry.getValue());
        }
        return queryBuilder;
    }

    protected HistoricConditionalRuleEntity getHistoricCondRule(ConditionalRuleEntity entity) {
        HistoricConditionalRuleEntityImpl hisEntity = new HistoricConditionalRuleEntityImpl();
        hisEntity.setProcdefid(entity.getProcdefid());
        hisEntity.setConditionalRuleId(entity.getId());
        hisEntity.setShowtext(entity.getShowtext());
        hisEntity.setDescription(entity.getDescription());
        hisEntity.setValidtime(entity.getValidtime());
        hisEntity.setExpression(entity.getExpression());
        hisEntity.setPlugin(entity.getPlugin());
        hisEntity.setVersion(entity.getVersion());
        return hisEntity;
    }

    @Override
    public void saveOrUpdateConditionRule(ConditionalRuleEntity condition) {
        new CommonCondRuleEntityManagerImpl(this.processEngineConfiguration).saveOrUpdate(condition);
    }

    @Override
    public List<StartUpConditionText> batchFindStartUpCondition(List<Long> processDefinitionId) {
        QFilter[] qFilters = new QueryWrapper().in("procdefid", processDefinitionId).in("type", Lists.newArrayList((Object[])new Serializable[]{ConditionalRuleType.processStartUp.name(), ConditionalRuleType.bpmProcStartUp.name(), ConditionalRuleType.eventStartUp})).getQFilters();
        return this.findByQueryFilters(qFilters).stream().map(StartUpConditionText::from).collect(Collectors.toList());
    }

    protected ConditionalRuleEntityManagerImpl getConcreteManager(String type) {
        return this.concreteManagerMap.computeIfAbsent(type, k -> ConditionalRuleEntityManagerFactory.getConcreteManagerImpl(type, this.processEngineConfiguration));
    }
}

