/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.management;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.DeploymentEntity;

public class DeploymentEntityImpl
extends AbstractEntity
implements DeploymentEntity,
Serializable {
    private static final long serialVersionUID = -5719520229336887025L;
    private Map<String, ResourceEntity> resources;
    protected boolean isNewField;
    protected Map<Class<?>, List<Object>> deployedArtifacts;

    public DeploymentEntityImpl() {
    }

    public DeploymentEntityImpl(DynamicObject dynamicObject) {
        super(dynamicObject);
    }

    @Override
    public void addResource(ResourceEntity resource) {
        if (this.resources == null) {
            this.resources = new HashMap<String, ResourceEntity>();
        }
        this.resources.put(resource.getName(), resource);
    }

    @Override
    public Map<String, ResourceEntity> getResources() {
        if (this.resources == null && this.getId() != null) {
            List<ResourceEntity> resourcesList = Context.getCommandContext().getResourceEntityManager().findResourcesByDeploymentId(this.getId());
            this.resources = new HashMap<String, ResourceEntity>();
            if (resourcesList != null) {
                for (ResourceEntity resource : resourcesList) {
                    this.resources.put(resource.getName(), resource);
                }
            }
        }
        return this.resources;
    }

    @Override
    public Object getPersistentState() {
        String key;
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        Long id = this.getId();
        persistentState.put("id", id);
        String category = this.getCategory();
        if (category != null) {
            persistentState.put("category", category);
        }
        if ((key = this.getKey()) != null) {
            persistentState.put("key", key);
        }
        return persistentState;
    }

    @Override
    public void addDeployedArtifact(Object deployedArtifact) {
        if (this.deployedArtifacts == null) {
            this.deployedArtifacts = new HashMap();
        }
        Class<?> clazz = deployedArtifact.getClass();
        this.deployedArtifacts.computeIfAbsent(clazz, k -> new ArrayList());
        List<Object> artifacts = this.deployedArtifacts.get(clazz);
        artifacts.add(deployedArtifact);
    }

    @Override
    public <T> List<T> getDeployedArtifacts(Class<T> clazz) {
        ArrayList list = new ArrayList();
        for (Map.Entry<Class<?>, List<Object>> entry : this.deployedArtifacts.entrySet()) {
            if (!clazz.isAssignableFrom(entry.getKey())) continue;
            return entry.getValue();
        }
        return list;
    }

    @Override
    @SimplePropertyAttribute(name="name")
    public String getName() {
        return this.dynamicObject.getString("name");
    }

    @Override
    public void setName(String name) {
        this.dynamicObject.set("name", (Object)name);
    }

    @Override
    @SimplePropertyAttribute(name="category")
    public String getCategory() {
        return this.dynamicObject.getString("category");
    }

    @Override
    public void setCategory(String category) {
        this.dynamicObject.set("category", (Object)category);
    }

    @Override
    @SimplePropertyAttribute(name="key")
    public String getKey() {
        return this.dynamicObject.getString("key");
    }

    @Override
    public void setKey(String key) {
        this.dynamicObject.set("key", (Object)key);
    }

    @Override
    @SimplePropertyAttribute(name="deploymenttime")
    public Date getDeploymentTime() {
        return this.dynamicObject.getDate("deploymenttime");
    }

    @Override
    public void setDeploymentTime(Date deploymentTime) {
        this.dynamicObject.set("deploymenttime", (Object)deploymentTime);
    }

    @Override
    @SimplePropertyAttribute(name="engineversion")
    public String getEngineVersion() {
        return this.dynamicObject.getString("engineversion");
    }

    @Override
    public void setEngineVersion(String engineVersion) {
        this.dynamicObject.set("engineversion", (Object)engineVersion);
    }

    @Override
    public void setResources(Map<String, ResourceEntity> resources) {
        this.resources = resources;
    }

    @Override
    public boolean isNew() {
        return this.isNewField;
    }

    @Override
    public void setNew(boolean isNewField) {
        this.isNewField = isNewField;
    }

    public String toString() {
        return "DeploymentEntity[id=" + this.getId() + ", name=" + this.getName() + "]";
    }
}

