/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.management;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.exception.KDBizException;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.EventDefinition;
import kd.bos.workflow.bpmn.model.Message;
import kd.bos.workflow.bpmn.model.MessageEventDefinition;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.Signal;
import kd.bos.workflow.bpmn.model.SignalEventDefinition;
import kd.bos.workflow.bpmn.model.StartEvent;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.DeploymentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.DeploymentEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.DeploymentEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.EventSubscriptionEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.MessageEventSubscriptionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.SignalEventSubscriptionEntity;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.repository.ProcessDefinition;

public class DeploymentEntityManagerImpl
extends AbstractEntityManager<DeploymentEntity>
implements DeploymentEntityManager {
    public DeploymentEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public void insert(DeploymentEntity deployment) {
        this.insert(deployment, false);
        for (ResourceEntity resource : deployment.getResources().values()) {
            resource.setDeploymentId(deployment.getId());
            this.getResourceEntityManager().insert(resource);
        }
    }

    @Override
    public void deleteDeployment(Long deploymentId, boolean cascade) {
        EntityQueryBuilder eb = this.getProcessDefinitionEntityManager().createQueryBuilder().addFilter("deploymentId", deploymentId);
        List<ProcessDefinitionEntity> processDefinitions = this.getProcessDefinitionEntityManager().findByQueryBuilder(eb);
        this.updateRelatedModels(deploymentId);
        if (cascade) {
            this.deleteProcessInstancesForProcessDefinitions(processDefinitions);
        }
        for (ProcessDefinition processDefinition : processDefinitions) {
            this.deleteProcessDefinitionIdentityLinks(processDefinition);
            this.deleteEventSubscriptions(processDefinition);
            this.deleteProcessDefinitionInfo(processDefinition.getId());
            this.restorePreviousStartEventsIfNeeded(processDefinition);
        }
        this.deleteProcessDefinitionForDeployment(deploymentId);
        this.getResourceEntityManager().deleteResourcesByDeploymentId(deploymentId);
        this.delete(this.findById(deploymentId), false);
    }

    protected void updateRelatedModels(Long deploymentId) {
        EntityQueryBuilder eb = this.getModelEntityManager().createQueryBuilder().addFilter("deploymentId", deploymentId);
        List models = this.getModelEntityManager().findByQueryBuilder(eb);
        Iterator iterator = models.iterator();
        while (iterator.hasNext()) {
            ModelEntity model;
            ModelEntity modelEntity = model = (ModelEntity)iterator.next();
            modelEntity.setDeploymentId(null);
            this.getModelEntityManager().updateModel(modelEntity);
        }
    }

    protected void deleteProcessDefinitionIdentityLinks(ProcessDefinition processDefinition) {
        this.getIdentityLinkEntityManager().deleteIdentityLinksByProcDef(processDefinition.getId());
    }

    protected void deleteEventSubscriptions(ProcessDefinition processDefinition) {
        EventSubscriptionEntityManager eventSubscriptionEntityManager = this.getEventSubscriptionEntityManager();
        eventSubscriptionEntityManager.deleteEventSubscriptionsForProcessDefinition(processDefinition.getId());
    }

    protected void deleteProcessDefinitionInfo(Long processDefinitionId) {
        this.getProcessDefinitionInfoEntityManager().deleteProcessDefinitionInfo(processDefinitionId);
    }

    protected void deleteProcessDefinitionForDeployment(Long deploymentId) {
        this.getProcessDefinitionEntityManager().deleteProcessDefinitionsByDeploymentId(deploymentId);
    }

    protected void deleteProcessInstancesForProcessDefinitions(List<ProcessDefinitionEntity> processDefinitions) {
        for (ProcessDefinition processDefinition : processDefinitions) {
            this.getExecutionEntityManager().deleteProcessInstancesByProcessDefinition(processDefinition.getId(), "deleted deployment", true);
        }
    }

    protected void restorePreviousStartEventsIfNeeded(ProcessDefinition processDefinition) {
        ProcessDefinition previousProcessDefinition;
        ProcessDefinitionEntity latestProcessDefinition = this.findLatestProcessDefinition(processDefinition);
        if (processDefinition.getId().equals(latestProcessDefinition.getId()) && (previousProcessDefinition = this.findNewLatestProcessDefinitionAfterRemovalOf(processDefinition)) != null) {
            List<StartEvent> startEvents;
            BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(previousProcessDefinition.getId(), null);
            Process previousProcess = ProcessDefinitionUtil.getProcess(previousProcessDefinition.getId(), null);
            if (CollectionUtil.isNotEmpty(previousProcess.getFlowElements()) && CollectionUtil.isNotEmpty(startEvents = previousProcess.findFlowElementsOfType(StartEvent.class))) {
                for (StartEvent startEvent : startEvents) {
                    if (!CollectionUtil.isNotEmpty(startEvent.getEventDefinitions())) continue;
                    EventDefinition eventDefinition = startEvent.getEventDefinitions().get(0);
                    if (eventDefinition instanceof SignalEventDefinition) {
                        this.restoreSignalStartEvent(previousProcessDefinition, bpmnModel, startEvent, eventDefinition);
                        continue;
                    }
                    if (!(eventDefinition instanceof MessageEventDefinition)) continue;
                    this.restoreMessageStartEvent(previousProcessDefinition, bpmnModel, startEvent, eventDefinition);
                }
            }
        }
    }

    protected void restoreSignalStartEvent(ProcessDefinition previousProcessDefinition, BpmnModel bpmnModel, StartEvent startEvent, EventDefinition eventDefinition) {
        SignalEventDefinition signalEventDefinition = (SignalEventDefinition)eventDefinition;
        SignalEventSubscriptionEntity subscriptionEntity = this.getEventSubscriptionEntityManager().createSignalEventSubscription();
        Signal signal = bpmnModel.getSignal(signalEventDefinition.getSignalRef());
        if (signal != null) {
            subscriptionEntity.setEventName(signal.getName());
        } else {
            subscriptionEntity.setEventName(signalEventDefinition.getSignalRef());
        }
        subscriptionEntity.setActivityId(startEvent.getId());
        subscriptionEntity.setProcessDefinitionId(previousProcessDefinition.getId());
        this.getEventSubscriptionEntityManager().insert(subscriptionEntity);
    }

    protected void restoreMessageStartEvent(ProcessDefinition previousProcessDefinition, BpmnModel bpmnModel, StartEvent startEvent, EventDefinition eventDefinition) {
        MessageEventDefinition messageEventDefinition = (MessageEventDefinition)eventDefinition;
        if (bpmnModel.containsMessageId(messageEventDefinition.getMessageRef())) {
            Message message = bpmnModel.getMessage(messageEventDefinition.getMessageRef());
            messageEventDefinition.setMessageRef(message.getName());
        }
        MessageEventSubscriptionEntity newSubscription = this.getEventSubscriptionEntityManager().createMessageEventSubscription();
        newSubscription.setEventName(messageEventDefinition.getMessageRef());
        newSubscription.setActivityId(startEvent.getId());
        newSubscription.setConfiguration(String.valueOf(previousProcessDefinition.getId()));
        newSubscription.setProcessDefinitionId(previousProcessDefinition.getId());
        this.getEventSubscriptionEntityManager().insert(newSubscription);
    }

    protected ProcessDefinitionEntity findLatestProcessDefinition(ProcessDefinition processDefinition) {
        ProcessDefinitionEntity latestProcessDefinition = null;
        latestProcessDefinition = this.getProcessDefinitionEntityManager().findLatestProcessDefinitionByKey(processDefinition.getKey());
        return latestProcessDefinition;
    }

    protected ProcessDefinition findNewLatestProcessDefinitionAfterRemovalOf(ProcessDefinition processDefinitionToBeRemoved) {
        EntityQueryBuilder eb = this.processEngineConfiguration.getProcessDefinitionEntityManager().createQueryBuilder();
        eb.addFilter("key", processDefinitionToBeRemoved.getKey()).addFilter("version", "<", processDefinitionToBeRemoved.getVersion()).orderBy("version desc");
        eb.setStart(0).setLimit(1);
        List processDefinitions = this.getProcessDefinitionEntityManager().findByQueryBuilder(eb);
        if (processDefinitions != null && processDefinitions.size() > 0) {
            return (ProcessDefinition)processDefinitions.get(0);
        }
        return null;
    }

    @Override
    public DeploymentEntity findLatestDeploymentByName(String deploymentName) {
        String sql = "select FID,FNAME,FCATEGORY,FDEPLOYTIME,FENGINEVERSION,FNUMBER from T_WF_DEPLOYMENT D where FNAME=? order by D.FDEPLOYTIME desc";
        final DeploymentEntityImpl deployment = new DeploymentEntityImpl();
        DB.query((DBRoute)DBRoute.workflow, (String)sql, (Object[])new Object[]{deploymentName}, (ResultSetHandler)new ResultSetHandler<Object>(){

            public Object handle(ResultSet rs) {
                try {
                    if (rs.next()) {
                        deployment.setId(rs.getLong("FID"));
                        deployment.setName(rs.getString("FNAME"));
                        deployment.setCategory(rs.getString("FCATEGORY"));
                        deployment.setDeploymentTime(rs.getDate("FDEPLOYTIME"));
                        deployment.setEngineVersion(rs.getString("FENGINEVERSION"));
                        deployment.setKey(rs.getString("FNUMBER"));
                    }
                }
                catch (Exception exception) {
                    throw new KDBizException(exception.getMessage());
                }
                return null;
            }
        });
        return deployment;
    }

    @Override
    public List<String> getDeploymentResourceNames(Long deploymentId) {
        String sql = "select FNAME from T_WF_GEBYTEARRAY where FDEPLOYMENTID = ? order by FNAME asc";
        final ArrayList<String> names = new ArrayList<String>();
        DB.query((DBRoute)DBRoute.workflow, (String)sql, (Object[])new Object[]{deploymentId}, (ResultSetHandler)new ResultSetHandler<Object>(){

            public Object handle(ResultSet rs) {
                try {
                    while (rs.next()) {
                        names.add(rs.getString("FNAME"));
                    }
                }
                catch (Exception exception) {
                    throw new KDBizException(exception.getMessage());
                }
                return null;
            }
        });
        return names;
    }

    @Override
    public Class<? extends DeploymentEntity> getManagedEntityClass() {
        return DeploymentEntityImpl.class;
    }

    @Override
    public String getSelectFields() {
        return "id, name, category, key, deploymentTime, engineVersion";
    }
}

