/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.management;

import java.util.ArrayList;
import java.util.List;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.persistence.CachedEntityMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.DynamicConfigSchemeByProcDefIdMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntityManager;

public class DynamicConfigSchemeEntityManagerImpl
extends AbstractEntityManager<DynamicConfigSchemeEntity>
implements DynamicConfigSchemeEntityManager {
    public static final String SELECT_APIFIELDS = String.format("%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s", "id", "name", "number", "description", "processdefinitionid", "parentschemeid", "state", "isdefault", "modifierid", "creatorid", "createDate", "modifyDate");
    protected CachedEntityMatcher<DynamicConfigSchemeEntity> byProcDefIdMatcher = new DynamicConfigSchemeByProcDefIdMatcher();

    public DynamicConfigSchemeEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public Class<? extends DynamicConfigSchemeEntity> getManagedEntityClass() {
        return DynamicConfigSchemeEntityImpl.class;
    }

    @Override
    public String getEntityName() {
        return "wf_processdynamicconfig";
    }

    @Override
    public String getSelectFields() {
        return String.format("%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s", "id", "name", "number", "description", "processdefinitionid", "parentschemeid", "state", "isdefault", "jsonresourceid", "xmlresourceid", "conditionid", "conditiontext", "jsonpatchid", "creatorid", "createDate", "modifierid", "modifyDate", "conditionexpression", "sourcekey");
    }

    @Override
    public List<DynamicConfigSchemeEntity> getSchemesByProcDefId(Long procDefId, boolean checkCache) {
        QFilter[] filters = new QFilter[]{new QFilter("processdefinitionid", "=", (Object)procDefId)};
        return this.findByQueryBuilder(this.createEntityQueryBuilder(filters, "createdate asc"), this.byProcDefIdMatcher, procDefId, checkCache);
    }

    @Override
    public List<DynamicConfigSchemeEntity> getSchemesByProcDefId(Long procDefId, String fields, boolean checkCache) {
        QFilter[] filters = new QFilter[]{new QFilter("processdefinitionid", "=", (Object)procDefId)};
        return this.findByQueryBuilder(this.createEntityQueryBuilder(filters, fields, ""), this.byProcDefIdMatcher, procDefId, checkCache);
    }

    @Override
    public List<DynamicConfigSchemeEntity> getActiveSchemesByProcDefId(Long procDefId) {
        QFilter[] filters = new QFilter[]{new QFilter("processdefinitionid", "=", (Object)procDefId), new QFilter("state", "=", (Object)"enable")};
        return this.findByQueryFilters(filters, this.getSelectFields(), "modifydate desc");
    }

    @Override
    public DynamicConfigSchemeEntity getDefaultSchemeByProcDefId(Long procDefId) {
        QFilter[] filters = new QFilter[]{new QFilter("processdefinitionid", "=", (Object)procDefId), new QFilter("isdefault", "=", (Object)Boolean.TRUE)};
        List schemes = this.findByQueryFilters(filters);
        if (schemes != null && !schemes.isEmpty()) {
            return (DynamicConfigSchemeEntity)schemes.get(0);
        }
        this.logger.warn(String.format("\u672a\u627e\u5230\u6d41\u7a0b\u5b9a\u4e49\u201c%s\u201d\u7684\u914d\u7f6e\u65b9\u6848\u3002", procDefId));
        return null;
    }

    @Override
    public Long getParentSchemeResourceId(Long customSchemeId) {
        DynamicConfigSchemeEntity customScheme = (DynamicConfigSchemeEntity)this.findById(customSchemeId, "parentschemeid");
        DynamicConfigSchemeEntity parentScheme = (DynamicConfigSchemeEntity)this.findById(customScheme.getParentSchemeId(), "jsonresourceid");
        return parentScheme.getJsonResourceId();
    }

    @Override
    public List<DynamicConfigSchemeEntity> findSchemesByIds(String fields, List<Long> schemeIds) {
        int size = schemeIds.size();
        int batchSize = 200;
        ArrayList<DynamicConfigSchemeEntity> entities = new ArrayList<DynamicConfigSchemeEntity>(size);
        int count = size / batchSize;
        int remainder = size % batchSize;
        int index = 0;
        List<Long> ids = null;
        for (int i = 0; i < count; ++i) {
            ids = schemeIds.subList(index, index + batchSize);
            entities.addAll(this.findSchemeEntities(fields, ids));
            index += batchSize;
        }
        if (remainder > 0) {
            ids = schemeIds.subList(index, index + remainder);
            entities.addAll(this.findSchemeEntities(fields, ids));
        }
        return entities;
    }

    private List<DynamicConfigSchemeEntity> findSchemeEntities(String fields, List<Long> ids) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", ids)};
        return this.findByQueryFilters(filters, fields, null);
    }
}

