/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.management;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.OrgTypeEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.OrgTypeEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.OrgTypeEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.OrgTypeEntryEntity;

public class OrgTypeEntityManagerImpl
extends AbstractEntityManager<OrgTypeEntity>
implements OrgTypeEntityManager {
    public OrgTypeEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public Class<? extends OrgTypeEntity> getManagedEntityClass() {
        return OrgTypeEntityImpl.class;
    }

    @Override
    public String getSelectFields() {
        return "id,number,name,description,entryentity.orgid,entryentity.orgnumber,entryentity.includesubordinate,status,enable,createdate,creater,modifier,modifydate";
    }

    @Override
    public String getEntityName() {
        return "wf_orgtype";
    }

    @Override
    public boolean isOrgBelongToOrgType(Long orgId, Long orgTypeId, String orgViewType) {
        OrgTypeEntity orgTypeEntity = (OrgTypeEntity)this.findById(orgTypeId);
        return this.isOrgBelongToOrgType(orgId, orgTypeEntity, orgViewType);
    }

    private Boolean isOrgBelongToOrgType(Long orgId, OrgTypeEntity orgTypeEntity, String orgViewType) {
        if (orgTypeEntity != null && orgTypeEntity.isEnable().booleanValue()) {
            List<OrgTypeEntryEntity> col = orgTypeEntity.getOrgTypeEntryEntities();
            HashSet orgIds = new HashSet(8);
            ArrayList<Long> inputs = new ArrayList<Long>(8);
            for (OrgTypeEntryEntity obj : col) {
                Long id = obj.getOrgid();
                if (WfUtils.isEmpty(id)) continue;
                if (id.equals(orgId)) {
                    return Boolean.TRUE;
                }
                if (!obj.isIncludesubordinate().booleanValue()) continue;
                inputs.add(id);
            }
            if (!inputs.isEmpty()) {
                orgIds.addAll(OrgUnitServiceHelper.getAllSubordinateOrgs((String)orgViewType, inputs, (boolean)false));
            }
            return orgIds.contains(orgId);
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean isUserBelongToOrgType(Long userId, Long orgTypeId) {
        OrgTypeEntity orgTypeEntity = (OrgTypeEntity)this.findById(orgTypeId);
        if (orgTypeEntity != null && orgTypeEntity.isEnable().booleanValue()) {
            List<OrgTypeEntryEntity> col = orgTypeEntity.getOrgTypeEntryEntities();
            for (OrgTypeEntryEntity obj : col) {
                Long id = obj.getOrgid();
                if (!UserServiceHelper.isUserBelongTo((Long)userId, (Long)id)) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }
}

