/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.management;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.persistence.CachedEntityMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.ParticipantMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ParticipantModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ParticipantModelEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.ParticipantModelEntityManager;

public class ParticipantModelEntityManagerImpl
extends AbstractEntityManager<ParticipantModelEntity>
implements ParticipantModelEntityManager {
    protected CachedEntityMatcher<ParticipantModelEntity> participantMatcher = new ParticipantMatcher();

    public ParticipantModelEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public ParticipantModelEntity create() {
        return new ParticipantModelEntityImpl();
    }

    @Override
    public Class<? extends ParticipantModelEntity> getManagedEntityClass() {
        return ParticipantModelEntityImpl.class;
    }

    @Override
    public String getSelectFields() {
        return "id,type,conditionExpression,value,description,mainDescription,orgUnitId,roleId,businessOrgField,dimensionField,referencePerson,reportType,personRelation,referenceOrg,orgRelation,modelid,modeljsonpartid,procdefId,taskActivityId,activityname,schemeId,creatorId,createDate,modifierId,modifyDate,defaultCondition,condruleid,property,showvalue,relationType,required,reportto";
    }

    @Override
    public List<ParticipantModelEntity> findByIds(List<String> ids) {
        if (ids.isEmpty()) {
            return new ArrayList<ParticipantModelEntity>();
        }
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("id", "in", ids);
        return this.findByQueryBuilder(eb);
    }

    @Override
    public void deleteByModelId(Long modelId) {
        QFilter[] filters = new QFilter[]{new QFilter("modelid", "=", (Object)modelId)};
        this.deleteByFilters(filters);
    }

    @Override
    public void deleteByModelIdAndItemId(Long modelId, String itemId) {
        QFilter[] filters = new QFilter[]{new QFilter("taskActivityId", "=", (Object)itemId), new QFilter("procdefId", "=", (Object)0)};
        this.deleteByFilters(filters);
    }

    @Override
    public void deleteByModelIdAndIdCondition(Long modelId, String cp, String value) {
    }

    @Override
    public List<ParticipantModelEntity> findByProcInstIdAndTaskActivityId(Long procInstId, String taskActivityId) {
        HistoricProcessInstanceEntity procInstEntity = (HistoricProcessInstanceEntity)this.getHistoricProcessInstanceEntityManager().findById(procInstId);
        Long schemeId = procInstEntity.getSchemeId();
        if (WfUtils.isEmpty(schemeId)) {
            return this.findByProcessDefintionIdAndTaskActivityId(procInstEntity.getProcessDefinitionId(), taskActivityId);
        }
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("schemeId", schemeId).addFilter("taskActivityId", taskActivityId);
        return this.findByQueryBuilder(eb);
    }

    private List<ParticipantModelEntity> findByProcessDefintionIdAndTaskActivityId(Long processDefintionId, String taskActivityId) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("procdefId", processDefintionId).addFilter("taskActivityId", taskActivityId);
        return this.findByQueryBuilder(eb);
    }

    @Override
    public List<ParticipantModelEntity> findParticipantsByFilters(Map<String, Object> filters, Object parameter, boolean checkCache) {
        EntityQueryBuilder eb = this.createQueryBuilder();
        for (Map.Entry<String, Object> entry : filters.entrySet()) {
            eb.addFilter(entry.getKey(), entry.getValue());
        }
        return this.getList(eb, this.participantMatcher, parameter, checkCache);
    }

    @Override
    @Deprecated
    public List<ParticipantModelEntity> findByProcessDefintionId(Long processDefintionId, String taskActivityId) {
        return this.findByProcessDefintionIdAndTaskActivityId(processDefintionId, taskActivityId);
    }

    @Override
    public void deleteByprocdeId(Long procdefId) {
        QFilter qf = new QFilter("procdefId", "=", (Object)procdefId);
        this.deleteByFilters(new QFilter[]{qf});
    }

    @Override
    public void deleteByProcdeIdAndTaskActivityId(Long procDefId, String taskActivityId) {
        QFilter QProcdefId = new QFilter("procdefId", "=", (Object)procDefId);
        QFilter QTaskActivityId = new QFilter("taskActivityId", "=", (Object)taskActivityId);
        this.deleteByFilters(new QFilter[]{QProcdefId, QTaskActivityId});
    }

    @Override
    public String getEntityName() {
        return "wf_participantmodel";
    }
}

