/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.management;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.AllowNextPersonSettingModel;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.persistence.CachedEntityMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.ProcessConfigByDefIdEntityMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessConfigEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessConfigEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessConfigEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;

public class ProcessConfigEntityManagerImpl
extends AbstractEntityManager<ProcessConfigEntity>
implements ProcessConfigEntityManager {
    protected CachedEntityMatcher<ProcessConfigEntity> processConfigByDefIdMatcher = new ProcessConfigByDefIdEntityMatcher();

    public ProcessConfigEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public ProcessConfigEntity getOrCreateProcessConfig(Long procDefId) {
        EntityQueryBuilder qb = new EntityQueryBuilder(this.getEntityName(), new QFilter[]{new QFilter("procdefid", "=", (Object)procDefId)}, this.getSelectFields(), this.getManagedEntityClass());
        List<ProcessConfigEntity> entitys = this.getList(qb, this.processConfigByDefIdMatcher, procDefId, true);
        if (entitys != null && entitys.size() > 0) {
            return entitys.get(0);
        }
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)this.getProcessDefinitionEntityManager().findById(procDefId);
        List<ResourceEntity> resources = this.getResourceEntityManager().findResourcesByDeploymentId(processDefinition.getDeploymentId());
        Object allowNextPersonObj = null;
        if (resources != null && resources.size() > 0 && null == (allowNextPersonObj = BpmnModelUtil.getProcessProperty(resources.get(0).getData(), "properties.allowNextPersonSettingModel.allowNextPersonWhenMatch"))) {
            allowNextPersonObj = BpmnModelUtil.getProcessProperty(resources.get(0).getData(), "properties.allowNextPersonWhenStart");
        }
        boolean allowNextPerson = Boolean.TRUE.equals(allowNextPersonObj);
        return this.createProcessConfig(allowNextPerson, processDefinition);
    }

    @Override
    public ProcessConfigEntity upgardeProcessConfig(Long procDefId) {
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)this.getProcessDefinitionEntityManager().findById(procDefId);
        List<ResourceEntity> resources = this.getResourceEntityManager().findResourcesByDeploymentId(processDefinition.getDeploymentId());
        Object allowNextPersonObj = null;
        if (resources != null && resources.size() > 0 && null == (allowNextPersonObj = BpmnModelUtil.getProcessProperty(resources.get(0).getData(), "properties.allowNextPersonSettingModel.allowNextPersonWhenMatch"))) {
            allowNextPersonObj = BpmnModelUtil.getProcessProperty(resources.get(0).getData(), "properties.allowNextPersonWhenStart");
        }
        boolean allowNextPerson = Boolean.TRUE.equals(allowNextPersonObj);
        ProcessConfigEntity config = this.getOrCreateProcessConfig(procDefId);
        config.setEnable("enable".equalsIgnoreCase(processDefinition.getEnable()));
        config.setEntityNumber(processDefinition.getEntraBill());
        config.setOperation(processDefinition.getOperation());
        config.setAllowNextPerson(allowNextPerson);
        this.update(config);
        return config;
    }

    @Override
    public void deleteProcessConfigByCondRuleId(Long condRuleId) {
        this.logger.debug("delete ProcessConfig by conditionalrule: " + condRuleId);
        EntityQueryBuilder qb = new EntityQueryBuilder(this.getEntityName(), new QFilter[]{new QFilter("condruleid", "=", (Object)condRuleId)}, this.getSelectFields(), this.getManagedEntityClass());
        List<ProcessConfigEntity> entitys = this.getList(qb, this.processConfigByDefIdMatcher, condRuleId, true);
        if (entitys != null) {
            for (ProcessConfigEntity entity : entitys) {
                entity.setStartCondition(null);
                entity.setCondRuleId(0L);
                this.update(entity);
            }
        }
    }

    @Override
    public Class<? extends ProcessConfigEntity> getManagedEntityClass() {
        return ProcessConfigEntityImpl.class;
    }

    @Override
    public String getSelectFields() {
        return "id,procdefid,exceptionconfig,startcondition,condruleid,entitynumber,operation,createdate,modifydate,isallownextperson,enable,allowstart,batchnumber,batchnumname,starttype,eventnumber,processtype";
    }

    @Override
    public ProcessConfigEntity create(BpmnModel bpmnModel, ProcessDefinitionEntity processDefinition) {
        Process process = bpmnModel.getMainProcess();
        boolean allowNextPerson = this.getAllowNextPersonWhenMatch(process);
        return this.createProcessConfig(allowNextPerson, processDefinition);
    }

    private boolean getAllowNextPersonWhenMatch(Process process) {
        AllowNextPersonSettingModel allowNextPersonSettingModel;
        boolean allowNextPersonWhenMatch = false;
        if (process != null && null != (allowNextPersonSettingModel = process.getAllowNextPersonSettingModel())) {
            allowNextPersonWhenMatch = allowNextPersonSettingModel.isAllowNextPersonWhenMatch();
        }
        return allowNextPersonWhenMatch;
    }

    private ProcessConfigEntity createProcessConfig(boolean allowNextPerson, ProcessDefinitionEntity processDefinition) {
        ProcessConfigEntity processConfig = (ProcessConfigEntity)super.create();
        processConfig.setProcDefId(processDefinition.getId());
        processConfig.setEnable("enable".equalsIgnoreCase(processDefinition.getEnable()));
        processConfig.setEntityNumber(processDefinition.getEntraBill());
        processConfig.setOperation(processDefinition.getOperation());
        processConfig.setAllowNextPerson(allowNextPerson);
        processConfig.setProcessType(ModelType.AuditFlow.name());
        this.insert(processConfig);
        return processConfig;
    }

    @Override
    public ProcessConfigEntity create(BpmnModel bpmnModel, DynamicObject processDefinition, DynamicObject config) {
        boolean allowNextPerson = this.getAllowNextPersonWhenMatch(bpmnModel.getMainProcess());
        ProcessConfigEntity processConfig = (ProcessConfigEntity)super.create();
        processConfig.setAllowNextPerson(allowNextPerson);
        processConfig.setProcDefId(processDefinition.getLong("id"));
        processConfig.setEnable("enable".equalsIgnoreCase(processDefinition.getString("enable")));
        processConfig.setEntityNumber(config.getString("entitynumber"));
        processConfig.setOperation(config.getString("operation"));
        processConfig.setAllowStart(config.getBoolean("allowstart"));
        processConfig.setProcessType(config.getString("processtype"));
        processConfig.setBatchNumber(config.getString("batchnumber"));
        processConfig.setBatchNumName(config.getString("batchnumname"));
        processConfig.setEventNumber(config.getString("eventnumber"));
        processConfig.setStartType(config.getString("starttype"));
        this.insert(processConfig);
        return processConfig;
    }

    @Override
    public void insert(ProcessConfigEntity entity, boolean fireCreateEvent) {
        WfCacheHelper.updateProcessDefAllowNextParticipantWhenStart(entity.isAllowNextPerson(), entity.getProcDefId(), entity.getEntityNumber(), entity.getOperation());
        super.insert(entity, fireCreateEvent);
    }

    @Override
    public ProcessConfigEntity update(ProcessConfigEntity entity, boolean fireUpdateEvent) {
        WfCacheHelper.updateProcessDefAllowNextParticipantWhenStart(entity.isAllowNextPerson(), entity.getProcDefId(), entity.getEntityNumber(), entity.getOperation());
        return super.update(entity, fireUpdateEvent);
    }

    @Override
    public void delete(ProcessConfigEntity entity, boolean fireDeleteEvent) {
        WfCacheHelper.updateProcessDefAllowNextParticipantWhenStart(Boolean.FALSE, entity.getProcDefId(), entity.getEntityNumber(), entity.getOperation());
        super.delete(entity, fireDeleteEvent);
    }

    @Override
    public List<ProcessConfigEntity> findProcessConfigByEventAndTargetEntity(String eventNumber, String targetProcEntityNumber) {
        String sql = "select a.fid,b.FSTARTCONDITION from t_wf_procdef a INNER JOIN t_wf_processconfig b on a.fid = b.FPROCDEFID where b.fstarttype = 'event' and b.feventnumber = ? and b.FENABLE='1' and a.FENTRABILL = ? and A.fenable = ? ORDER BY a.fcreatedate DESC ";
        List configs = (List)DB.query((DBRoute)DBRoute.workflow, (String)sql, (Object[])new Object[]{eventNumber, targetProcEntityNumber, "enable"}, (ResultSetHandler)new ResultSetHandler<List<ProcessConfigEntity>>(){

            public List<ProcessConfigEntity> handle(ResultSet rs) throws SQLException {
                ArrayList<ProcessConfigEntity> ret = new ArrayList<ProcessConfigEntity>(16);
                while (rs.next()) {
                    ProcessConfigEntityImpl pc = new ProcessConfigEntityImpl();
                    pc.setProcDefId(rs.getLong("fid"));
                    pc.setStartCondition(rs.getString("FSTARTCONDITION"));
                    ret.add(pc);
                }
                return ret;
            }
        });
        return configs;
    }

    @Override
    public void updateProcessConfigEnableState(boolean isBizFlow, Long procDefId, boolean enable) {
        if (isBizFlow) {
            List configs = this.findByQueryFilters(new QFilter[]{new QFilter("procdefid", "=", (Object)procDefId)});
            if (!configs.isEmpty()) {
                for (ProcessConfigEntity config : configs) {
                    config.setEnable(enable);
                    this.update(config);
                }
            }
        } else {
            ProcessConfigEntity processConfigEntity = this.getOrCreateProcessConfig(procDefId);
            processConfigEntity.setEnable(enable);
            this.update(processConfigEntity);
        }
    }
}

