/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.management;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.ProcessDefinitionInfoMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionInfoEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionInfoEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionInfoEntityManager;

public class ProcessDefinitionInfoEntityManagerImpl
extends AbstractEntityManager<ProcessDefinitionInfoEntity>
implements ProcessDefinitionInfoEntityManager {
    private static final String ENTITYNAME = "entityname";
    protected ProcessDefinitionInfoMatcher processDefinitionInfoMatcher = new ProcessDefinitionInfoMatcher();

    public ProcessDefinitionInfoEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public void deleteProcessDefinitionInfo(Long processDefinitionId) {
        ProcessDefinitionInfoEntity processDefinitionInfo = this.findProcessDefinitionInfoByProcessDefinitionId(processDefinitionId);
        if (processDefinitionInfo != null) {
            this.delete(processDefinitionInfo);
        }
    }

    @Override
    public ProcessDefinitionInfoEntity findProcessDefinitionInfoByProcessDefinitionId(Long processDefinitionId) {
        QFilter filter = new QFilter("processDefinitionId", "=", (Object)processDefinitionId);
        QFilter[] filters = new QFilter[]{filter};
        return (ProcessDefinitionInfoEntity)this.findOneByCondition(filters, this.getSelectFields(), null);
    }

    @Override
    public List<String> findProcessDefinitionInfos(Long procDefId) {
        EntityQueryBuilder queryBuilder = this.createQueryBuilder().addFilter("processDefinitionId", procDefId);
        List<ProcessDefinitionInfoEntity> processDefinitionInfoEntities = this.findByQueryBuilder(queryBuilder, this.processDefinitionInfoMatcher, procDefId, true);
        ArrayList<String> processDefinitionInfos = new ArrayList<String>(processDefinitionInfoEntities.size());
        for (ProcessDefinitionInfoEntity entity : processDefinitionInfoEntities) {
            processDefinitionInfos.add(String.format("%s-%s", entity.getEntityNumber(), entity.getOperation()));
        }
        return processDefinitionInfos;
    }

    @Override
    public boolean existProcess(String entityNumber, String operation) {
        Boolean ret = WfCacheHelper.cacheableOfProcessDefByEntityAndOperation(entityNumber, operation);
        if (ret != null) {
            return ret;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" select a.fid from t_wf_procdef a,t_wf_procdefinfo b where a.fenable = '");
        sb.append("enable");
        sb.append('\'');
        sb.append(" and b.FENTITYNUMBER= ? and b.FOPERATION=? and a.FID = b.FPROCDEFID  ");
        List ids = (List)DB.query((DBRoute)DBRoute.workflow, (String)sb.toString(), (Object[])new Object[]{entityNumber, operation}, (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) {
                ArrayList<String> ids = new ArrayList<String>(0);
                try {
                    while (rs.next()) {
                        ids.add(rs.getString("fid"));
                    }
                }
                catch (Exception exception) {
                    throw new KDBizException(exception.getMessage());
                }
                return ids;
            }
        });
        boolean t = ids != null && ids.size() > 0;
        WfCacheHelper.putProcessToCacheDefByEntityAndOperation(entityNumber, operation, ids);
        return t;
    }

    @Override
    public Class<? extends ProcessDefinitionInfoEntity> getManagedEntityClass() {
        return ProcessDefinitionInfoEntityImpl.class;
    }

    @Override
    public String getSelectFields() {
        return "id,processDefinitionId,operation,actId,entityNumber,infoJsonId,entityName";
    }

    @Override
    public ProcessDefinitionInfoEntity findBillExceptionOperation(Long processDefId, String elemId, String operation) {
        QFilter filter1 = new QFilter("processDefinitionId", "=", (Object)processDefId);
        QFilter filter2 = new QFilter("actId", "=", (Object)elemId);
        QFilter filter3 = new QFilter("operation", "=", (Object)operation);
        QFilter[] filters = new QFilter[]{filter1, filter2, filter3};
        List ret = this.findByQueryFilters(filters);
        if (ret != null && ret.size() > 0) {
            return (ProcessDefinitionInfoEntity)ret.get(0);
        }
        return null;
    }

    @Override
    public List<String> findAllOperationsByDef(Long procDefId) {
        ArrayList<String> ret = new ArrayList<String>(16);
        QFilter filter1 = new QFilter("processDefinitionId", "=", (Object)procDefId);
        QFilter[] filters = new QFilter[]{filter1};
        List ops = this.findByQueryFilters(filters, "operation", null);
        if (ops != null && !ops.isEmpty()) {
            for (ProcessDefinitionInfoEntity entity : ops) {
                ret.add(String.format("%s-%s", entity.getEntityNumber(), entity.getOperation()));
            }
        }
        return ret;
    }

    @Override
    public DynamicObjectCollection getProcessDefinitionInfosByPage(int start, int limit, String filterSql, List<Object> paramsList) {
        DynamicObjectCollection results;
        Throwable throwable;
        DataSet dataSet;
        QFilter[] filters;
        DynamicObject[] objects;
        String sql = null;
        if (WfUtils.isEmpty(filterSql)) {
            sql = "select min(FID) id, FENTRABILL entitynumber, 'ENTRYBILLNAME' entityname from T_WF_PROCDEF where FENABLE = 'enable' AND FTYPE != 'NoCodeFlow' group by FENTRABILL;";
            try (DataSet dataSet2 = DB.queryDataSet((String)"WfManageCenter.wf_procdefinfo.queryGridData", (DBRoute)DBRoute.workflow, (String)sql, null).top(start + limit);){
                DynamicObjectCollection obj;
                DynamicObjectCollection results2 = ORM.create().toPlainDynamicObjectCollection(dataSet2, start, limit);
                MainEntityType entityType = null;
                ArrayList<String> numberList = new ArrayList<String>(results2.size());
                for (DynamicObject obj2 : results2) {
                    numberList.add(obj2.getString("entitynumber"));
                }
                QFilter[] qFilters = new QFilter[]{new QFilter("number", "in", numberList)};
                DynamicObjectCollection filteredResults = QueryServiceHelper.query((String)"bos_entitymeta", (String)"number", (QFilter[])qFilters);
                ArrayList<String> filteredResultNumberList = new ArrayList<String>(filteredResults.size());
                for (DynamicObject filteredResult : filteredResults) {
                    filteredResultNumberList.add(filteredResult.getString("number"));
                }
                Iterator resultIter = results2.iterator();
                while (resultIter.hasNext()) {
                    obj = (DynamicObject)resultIter.next();
                    String number = obj.getString("entitynumber");
                    if (!filteredResultNumberList.contains(number)) {
                        resultIter.remove();
                        continue;
                    }
                    try {
                        entityType = EntityMetadataCache.getDataEntityType((String)number);
                    }
                    catch (Exception e) {
                        entityType = null;
                        this.logger.error(WfUtils.getExceptionStacktrace(e));
                    }
                    if (entityType != null && entityType.getDisplayName() != null) {
                        obj.set(ENTITYNAME, (Object)entityType.getDisplayName().getLocaleValue());
                        continue;
                    }
                    obj.set(ENTITYNAME, (Object)number);
                }
                obj = results2;
                return obj;
            }
        }
        if (filterSql.contains("FID")) {
            sql = "SELECT FID id, FENTRABILL entitynumber, 'ENTRYBILLNAME' entityname FROM T_WF_PROCDEF WHERE " + filterSql.replaceFirst("AND", "") + ";";
            try (DataSet dataSet3 = DB.queryDataSet((String)"WfManageCenter.wf_procdefinfo.queryGridData", (DBRoute)DBRoute.workflow, (String)sql, (Object[])paramsList.toArray()).top(start + limit);){
                DynamicObjectCollection obj4;
                DynamicObjectCollection results3 = ORM.create().toPlainDynamicObjectCollection(dataSet3, start, limit);
                MainEntityType entityType = null;
                ArrayList<String> numberList = new ArrayList<String>(results3.size());
                for (DynamicObject obj3 : results3) {
                    numberList.add(obj3.getString("entitynumber"));
                }
                QFilter[] qFilters = new QFilter[]{new QFilter("number", "in", numberList)};
                DynamicObjectCollection filteredResults = QueryServiceHelper.query((String)"bos_entitymeta", (String)"number", (QFilter[])qFilters);
                ArrayList<String> filteredResultNumberList = new ArrayList<String>(filteredResults.size());
                for (DynamicObject filteredResult : filteredResults) {
                    filteredResultNumberList.add(filteredResult.getString("number"));
                }
                for (DynamicObjectCollection obj4 : results3) {
                    String number = obj4.getString("entitynumber");
                    if (!filteredResultNumberList.contains(number)) continue;
                    try {
                        entityType = EntityMetadataCache.getDataEntityType((String)number);
                    }
                    catch (Exception e) {
                        this.logger.error(WfUtils.getExceptionStacktrace(e));
                    }
                    if (entityType != null && entityType.getDisplayName() != null) {
                        obj4.set(ENTITYNAME, (Object)entityType.getDisplayName().getLocaleValue());
                        continue;
                    }
                    obj4.set(ENTITYNAME, (Object)number);
                }
                obj4 = results3;
                return obj4;
            }
        }
        String lang = RequestContext.get().getLang().toString();
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT A.FNUMBER number, B.FNAME name, A.fmasterid masterid, A.ftype type  FROM T_META_FORMDESIGN A ");
        sb.append("INNER JOIN T_META_FORMDESIGN_L B ON A.FID = B.FID AND B.FLOCALEID = ? ");
        sb.append("WHERE ").append(filterSql.replaceFirst("AND", ""));
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(lang);
        params.addAll(paramsList);
        StringBuilder numbers = new StringBuilder();
        HashSet<String> masteridList = new HashSet<String>(1);
        try (DataSet ds = DB.queryDataSet((String)"WfManageCenter.wf_procdefinfo.getEntityNumberAndName", (DBRoute)DBRoute.meta, (String)sb.toString(), (Object[])params.toArray());){
            for (Row row : ds) {
                String masterid = row.getString("masterid");
                String type = row.getString("type");
                if (WfUtils.isNotEmptyString(masterid) && "2".equals(type)) {
                    masteridList.add(masterid);
                    continue;
                }
                numbers.append('\'').append(row.getString("number")).append("',");
            }
        }
        if (!masteridList.isEmpty() && (objects = BusinessDataServiceHelper.load((String)"bos_formmeta", (String)"id, number", (QFilter[])(filters = new QFilter[]{new QFilter("id", "in", masteridList)}))) != null && objects.length > 0) {
            for (DynamicObject obj : objects) {
                numbers.append('\'').append(obj.getString("number")).append("',");
            }
        }
        if (numbers.length() > 0) {
            numbers.deleteCharAt(numbers.length() - 1);
            sql = "SELECT min(FID) id, FENTRABILL entitynumber, 'ENTRYBILLNAME' entityname FROM T_WF_PROCDEF WHERE FENABLE = 'enable' AND FTYPE != 'NoCodeFlow' AND FENTRABILL IN (" + numbers + ") group by FENTRABILL;";
            dataSet = DB.queryDataSet((String)"WfManageCenter.wf_procdefinfo.queryGridData", (DBRoute)DBRoute.workflow, (String)sql).top(start + limit);
            throwable = null;
            try {
                results = ORM.create().toPlainDynamicObjectCollection(dataSet, start, limit);
                for (DynamicObject obj : results) {
                    String number = obj.getString("entitynumber");
                    obj.set(ENTITYNAME, (Object)EntityMetadataCache.getDataEntityType((String)number).getDisplayName().getLocaleValue());
                }
                Iterator iterator = results;
                return iterator;
            }
            catch (Throwable results4) {
                throwable = results4;
                throw results4;
            }
            finally {
                if (dataSet != null) {
                    if (throwable != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
        }
        sql = "SELECT FID id, FENTRABILL entitynumber, 'ENTRYBILLNAME' entityname FROM T_WF_PROCDEF WHERE 1!=1;";
        dataSet = DB.queryDataSet((String)"WfManageCenter.wf_procdefinfo.noGridData", (DBRoute)DBRoute.workflow, (String)sql).top(0);
        throwable = null;
        try {
            DynamicObjectCollection dynamicObjectCollection = results = ORM.create().toPlainDynamicObjectCollection(dataSet, start, limit);
            return dynamicObjectCollection;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            if (dataSet != null) {
                if (throwable != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
    }

    @Override
    public Set<String> getEntityNumberInProcess() {
        return this.getEntityNumberInProcess(false);
    }

    @Override
    public Set<String> getEntityNumberInProcess(boolean isContainBizFlow) {
        HashSet<String> resultSet = new HashSet<String>();
        QFilter qFilter1 = new QFilter("enable", "=", (Object)"enable");
        if (isContainBizFlow) {
            qFilter1.and(new QFilter("type", "!=", (Object)"NoCodeFlow"));
        } else {
            qFilter1.and(new QFilter("type", "=", (Object)"AuditFlow"));
        }
        QFilter qFilter2 = new QFilter("key", "!=", (Object)"freeflowtpl");
        QFilter[] qFilters = new QFilter[]{qFilter1, qFilter2};
        DynamicObjectCollection processDefDyna = QueryServiceHelper.query((String)"wf_processdefinition", (String)"entrabill", (QFilter[])qFilters);
        if (processDefDyna != null && !processDefDyna.isEmpty()) {
            for (DynamicObject processDef : processDefDyna) {
                resultSet.add(processDef.getString("entrabill"));
            }
        }
        return resultSet;
    }

    @Override
    public Long getProcessDefinitionInfosCount(String filterSql, List<Object> paramsList) {
        Iterator iter;
        long count = 0L;
        String sql = null;
        if (WfUtils.isEmpty(filterSql)) {
            sql = "select count(DISTINCT FENTRABILL) count from t_wf_procdef where FENABLE = 'enable' AND FTYPE != 'NoCodeFlow' ";
            try (DataSet ds = DB.queryDataSet((String)"wf_procdefinfo.ProcdefinfoCount", (DBRoute)DBRoute.workflow, (String)sql, null);){
                Iterator iter2 = ds.iterator();
                if (iter2.hasNext()) {
                    count = ((Row)iter2.next()).getLong("count");
                }
            }
            return count;
        }
        if (filterSql.contains("FID")) {
            sql = "SELECT COUNT(DISTINCT FENTRABILL) COUNT FROM T_WF_PROCDEF WHERE " + filterSql.replaceFirst("AND", "") + ";";
            try (DataSet ds = DB.queryDataSet((String)"wf_procdefinfo.ProcdefinfoCount", (DBRoute)DBRoute.workflow, (String)sql, (Object[])paramsList.toArray());){
                Iterator iter3 = ds.iterator();
                if (iter3.hasNext()) {
                    count = ((Row)iter3.next()).getLong("count");
                }
            }
            return count;
        }
        String lang = RequestContext.get().getLang().toString();
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT A.FNUMBER number FROM T_META_FORMDESIGN A ");
        sb.append("INNER JOIN T_META_FORMDESIGN_L B ON A.FID = B.FID AND B.FLOCALEID = ? ");
        sb.append("WHERE ").append(filterSql.replaceFirst("AND", ""));
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(lang);
        params.addAll(paramsList);
        StringBuilder numbers = new StringBuilder();
        try (DataSet ds = DB.queryDataSet((String)"wf_procdefinfo.getEntityNumber", (DBRoute)DBRoute.meta, (String)sb.toString(), (Object[])params.toArray());){
            iter = ds.iterator();
            while (iter.hasNext()) {
                numbers.append('\'').append(((Row)iter.next()).getString("number")).append("',");
            }
        }
        if (numbers.length() > 0) {
            numbers.deleteCharAt(numbers.length() - 1);
            sql = "SELECT COUNT(DISTINCT FENTRABILL) COUNT FROM T_WF_PROCDEF WHERE FENABLE = 'enable' AND FTYPE != 'NoCodeFlow' AND FENTRABILL IN (" + numbers + ")";
            ds = DB.queryDataSet((String)"wf_procdefinfo.ProcdefinfoCount", (DBRoute)DBRoute.workflow, (String)sql);
            var11_23 = null;
            try {
                iter = ds.iterator();
                if (iter.hasNext()) {
                    count = ((Row)iter.next()).getLong("count");
                }
            }
            catch (Throwable throwable) {
                var11_23 = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (var11_23 != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            var11_23.addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        return count;
    }

    @Override
    public Map<String, Set<String>> findAllOperations(Set<String> entityNumbers) {
        HashMap<String, Set<String>> entityOperMap = new HashMap<String, Set<String>>(entityNumbers.size());
        String sql = this.getFindAllOperationsSQL(entityNumbers);
        try (DataSet ds = DB.queryDataSet((String)"wf_procdefinfo.findAllOperations", (DBRoute)DBRoute.workflow, (String)sql);){
            for (Row row : ds) {
                String entityNumber = row.getString("FENTITYNUMBER");
                String operation = row.getString("FOPERATION");
                HashSet<String> operations = (HashSet<String>)entityOperMap.get(entityNumber);
                if (operations == null) {
                    operations = new HashSet<String>();
                    entityOperMap.put(entityNumber, operations);
                }
                operations.add(operation);
            }
        }
        return entityOperMap;
    }

    private String getFindAllOperationsSQL(Set<String> entityNumbers) {
        int index = 0;
        int size = entityNumbers.size();
        StringBuilder sql = new StringBuilder("SELECT DISTINCT FENTITYNUMBER,FOPERATION FROM T_WF_PROCDEFINFO WHERE FENTITYNUMBER IN (");
        for (String entityNumber : entityNumbers) {
            sql.append('\'').append(entityNumber).append('\'');
            if (index < size - 1) {
                sql.append(',');
            }
            ++index;
        }
        sql.append(')');
        return sql.toString();
    }

    @Override
    public Set<Long> findProcDefIdsByEntityAndOperation(String entityNumber, String operation) {
        HashSet<Long> procDefIds = new HashSet<Long>(16);
        String sql = "SELECT DISTINCT FPROCDEFID FROM T_WF_PROCDEFINFO WHERE FENTITYNUMBER = ? AND FOPERATION = ?;";
        try (DataSet ds = DB.queryDataSet((String)"wf_procdefinfo.findProcDefIdsByEntityAndOperation", (DBRoute)DBRoute.workflow, (String)sql, (Object[])new Object[]{entityNumber, operation});){
            Iterator iter = ds.iterator();
            while (iter.hasNext()) {
                procDefIds.add(((Row)iter.next()).getLong("FPROCDEFID"));
            }
        }
        return procDefIds;
    }
}

