/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.management;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessInfoDetailEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessInfoDetailEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessInfoEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessInfoEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessInfoEntityManager;
import kd.bos.workflow.engine.management.batchsetting.BatchSettingUtil;

public class ProcessInfoEntityManagerImpl
extends AbstractEntityManager<ProcessInfoEntity>
implements ProcessInfoEntityManager {
    private String fields = String.format("%s,%s,%s,%s", "procdefid", "schemeid", "resourceid", "schemetype");
    private String entryFields = "details.activityid,details.activityname,details.activitynumber,details.activitytype,details.activitytypename,details.activityentityid,details.activitytemplateid";

    public ProcessInfoEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public Class<? extends ProcessInfoEntity> getManagedEntityClass() {
        return ProcessInfoEntityImpl.class;
    }

    @Override
    public String getSelectFields() {
        return "procdefid,schemeid,schemetype,orgid,resourceid,processtype,entityid," + this.entryFields;
    }

    @Override
    public List<Long> findToBeInitializedProcDefIds(boolean includeOngoing) {
        ArrayList<Long> procDefIds = new ArrayList<Long>(32);
        String sql = "SELECT DISTINCT FID FROM T_WF_PROCDEF WHERE FENABLE = 'enable' AND FTYPE = 'AuditFlow' AND FID NOT IN (SELECT FPROCDEFID FROM T_WF_PROCESSINFO);";
        try (DataSet ds = DB.queryDataSet((String)"wf.engine.batchsetting.findToBeInitialized", (DBRoute)DBRoute.workflow, (String)sql);){
            for (Row row : ds) {
                procDefIds.add(row.getLong("FID"));
            }
        }
        if (includeOngoing) {
            sql = "SELECT DISTINCT P.FID PFID FROM T_WF_PROCDEF P INNER JOIN T_WF_EXECUTION E ON E.FPROCDEFID = P.FID WHERE P.FENABLE = 'disable' AND P.FTYPE = 'AuditFlow';";
            ds = DB.queryDataSet((String)"wf.engine.batchsetting.findToBeInitializedIncludeOngoing", (DBRoute)DBRoute.workflow, (String)sql);
            var5_5 = null;
            try {
                for (Row row : ds) {
                    procDefIds.add(row.getLong("PFID"));
                }
            }
            catch (Throwable throwable) {
                var5_5 = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (var5_5 != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            var5_5.addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        procDefIds.remove(Long.valueOf("886006942529487872"));
        return procDefIds;
    }

    @Override
    public List<ProcessInfoEntity> findProcessInfoEntities(List<Long> ids) {
        int size = ids.size();
        int batchSize = 200;
        ArrayList<ProcessInfoEntity> entities = new ArrayList<ProcessInfoEntity>(size);
        int count = size / batchSize;
        int remainder = size % batchSize;
        int index = 0;
        List<Long> temp = null;
        for (int i = 0; i < count; ++i) {
            temp = ids.subList(index, index + batchSize);
            entities.addAll(this.findProcessInfos(temp));
            index += batchSize;
        }
        if (remainder > 0) {
            temp = ids.subList(index, index + remainder);
            entities.addAll(this.findProcessInfos(temp));
        }
        return entities;
    }

    private List<ProcessInfoEntity> findProcessInfos(List<Long> infoIds) {
        EntityQueryBuilder queryBuilder = this.createQueryBuilder();
        queryBuilder.addFilter("id", "in", infoIds);
        queryBuilder.setSelectFields(this.fields);
        return this.findByQueryBuilder(queryBuilder);
    }

    @Override
    public ProcessInfoEntity findProcessInfoWithDetailsBySchemeId(Long schemeId) {
        QFilter[] filters = new QFilter[]{new QFilter("schemeid", "=", (Object)schemeId)};
        List processInfos = this.findByQueryFilters(filters, String.format("id,orgid,%s", this.entryFields), null);
        if (processInfos == null || processInfos.isEmpty()) {
            return null;
        }
        return (ProcessInfoEntity)processInfos.get(0);
    }

    @Override
    public List<ProcessInfoDetailEntity> findFilteredProcessInfoDetailEntities(List<Long> detailIds) {
        ArrayList<ProcessInfoDetailEntity> entities = new ArrayList<ProcessInfoDetailEntity>(detailIds.size());
        String inCondition = BatchSettingUtil.getInCondition(detailIds);
        String sql = String.format("SELECT FID,FACTIVITYID FROM T_WF_PROCESSINFODETAIL WHERE FENTRYID IN %s ;", inCondition);
        try (DataSet ds = DB.queryDataSet((String)"wf.engine.batchsetting.findFilteredActivityIds", (DBRoute)DBRoute.workflow, (String)sql);){
            Iterator iter = ds.iterator();
            ProcessInfoDetailEntityImpl entity = null;
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                entity = new ProcessInfoDetailEntityImpl();
                entity.setProcessInfoId(row.getLong("FID"));
                entity.setActivityId(row.getString("FACTIVITYID"));
                entities.add(entity);
            }
        }
        return entities;
    }

    @Override
    public Map<Long, List<ProcessInfoDetailEntity>> findCustomSchemeActivities(List<Long> customSchemeInfoIds) {
        HashMap<Long, List<ProcessInfoDetailEntity>> activitiesMap = new HashMap<Long, List<ProcessInfoDetailEntity>>(customSchemeInfoIds.size());
        String inCondition = BatchSettingUtil.getInCondition(customSchemeInfoIds);
        ArrayList<ProcessInfoDetailEntityImpl> activities = null;
        String sql = String.format("SELECT FID,FACTIVITYID,FACTIVITYTYPE FROM T_WF_PROCESSINFODETAIL WHERE FID IN %s ;", inCondition);
        try (DataSet ds = DB.queryDataSet((String)"wf.engine.batchsetting.findCustomSchemeActivityIds", (DBRoute)DBRoute.workflow, (String)sql);){
            for (Row row : ds) {
                Long fid = row.getLong("FID");
                activities = (ArrayList<ProcessInfoDetailEntityImpl>)activitiesMap.get(fid);
                if (activities == null) {
                    activities = new ArrayList<ProcessInfoDetailEntityImpl>(32);
                    activitiesMap.put(fid, activities);
                }
                ProcessInfoDetailEntityImpl entity = new ProcessInfoDetailEntityImpl();
                entity.setProcessInfoId(fid);
                entity.setActivityId(row.getString("FACTIVITYID"));
                entity.setActivityType(row.getString("FACTIVITYTYPE"));
                activities.add(entity);
            }
        }
        return activitiesMap;
    }

    @Override
    public void deleteProcessInfoByProcDefId(Long procDefId) {
        if (procDefId == null) {
            return;
        }
        QFilter[] filters = new QFilter[]{new QFilter("procdefid", "=", (Object)procDefId)};
        this.deleteByFilters(filters);
    }

    @Override
    public void deleteProcessInfoBySchemeId(Long schemeId) {
        if (schemeId == null) {
            return;
        }
        QFilter[] filters = new QFilter[]{new QFilter("schemeid", "=", (Object)schemeId)};
        this.deleteByFilters(filters);
    }

    @Override
    public boolean isInitialized(Long procDefId) {
        if (procDefId == null) {
            return true;
        }
        QFilter[] filters = new QFilter[]{new QFilter("procdefid", "=", (Object)procDefId)};
        long count = this.countByFilter("id", filters, false);
        return count > 0L;
    }
}

