/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.management;

import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.CommonCondRuleEntityManagerImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessConfigEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessConfigEntityManager;

public class ProcessStartUpCondRuleEntityManagerImpl
extends CommonCondRuleEntityManagerImpl {
    public ProcessStartUpCondRuleEntityManagerImpl(ProcessEngineConfigurationImpl configuration) {
        super(configuration);
    }

    @Override
    public void insert(ConditionalRuleEntity entity, boolean fireCreateEvent) {
        this.saveOrUpdate(entity, fireCreateEvent, true);
    }

    @Override
    public ConditionalRuleEntity update(ConditionalRuleEntity entity, boolean fireUpdateEvent) {
        return this.saveOrUpdate(entity, fireUpdateEvent, false);
    }

    @Override
    public void delete(ConditionalRuleEntity entity, boolean fireDeleteEvent) {
        this.logger.debug("--\uff1abegin delete ConditionalRuleEntity! " + entity);
        super.delete(entity, fireDeleteEvent);
        this.logger.debug("--\uff1abegin delete ProcessConfig! " + entity);
        this.getProcessConfigEntityManager().deleteProcessConfigByCondRuleId(entity.getId());
    }

    protected ConditionalRuleEntity saveOrUpdate(ConditionalRuleEntity entity, boolean fireCreateEvent, boolean insert) {
        String condition;
        ProcessConfigEntityManager procConfManager = this.getProcessConfigEntityManager();
        ProcessConfigEntity processConfig = procConfManager.getOrCreateProcessConfig(entity.getProcdefid());
        String string = condition = WfUtils.isNotEmpty(entity.getExpression()) ? entity.getExpression() : entity.getPlugin();
        if (insert) {
            this.logger.debug("--\uff1abegin insert ConditionalRuleEntity! " + entity);
            super.insert(entity, fireCreateEvent);
            this.logger.debug("--\uff1aafter insert ProcessConfigEntity! " + processConfig);
        } else {
            this.logger.debug("--\uff1abegin update ConditionalRuleEntity! " + entity);
            super.update(entity, fireCreateEvent);
            this.logger.debug("--\uff1aafter update ProcessConfigEntity! " + processConfig);
        }
        processConfig.setStartCondition(condition);
        processConfig.setCondRuleId(entity.getId());
        procConfManager.update(processConfig);
        return entity;
    }
}

