/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.management;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.persistence.CachedEntityMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.RoleEntityByNameMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.management.RoleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.RoleEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.RoleEntityManager;

public class RoleEntityManagerImpl
extends AbstractEntityManager<RoleEntity>
implements RoleEntityManager {
    protected CachedEntityMatcher<RoleEntity> roleEntityByFiltersMatcher = new RoleEntityByNameMatcher();
    private static final String ID = "id";
    private static final String APPROVALPOSITION = "approvalposition";
    private static final String USER = "user";

    public RoleEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public RoleEntity create() {
        return new RoleEntityImpl();
    }

    @Override
    public RoleEntity create(DynamicObject dynamicObject) {
        return new RoleEntityImpl(dynamicObject);
    }

    @Override
    public Class<? extends RoleEntity> getManagedEntityClass() {
        return RoleEntityImpl.class;
    }

    @Override
    public String getSelectFields() {
        return "id, number, name, orgUnit, usecount,  manager, description, roledimension, modifydate, modifier, createdate, creater, roletype, roleentry.org, roleentry.user, roleentry.alternatetype, roleentry.alternateuser,roleentry.userposition,roleentry.functiontype, roleentry.approvalposition, roleentry.includadminsub, roleentry.param";
    }

    @Override
    public String getEntityName() {
        return "wf_role";
    }

    @Override
    public boolean isUserBelongToRole(Long userId, Long roleId) {
        RoleEntity roleEntity = (RoleEntity)this.findById(roleId);
        return this.isUserBelongToRole(userId, roleEntity);
    }

    @Override
    public boolean isUsersBelongToRole(List<Long> userIds, Long roleId) {
        RoleEntity roleEntity = (RoleEntity)this.findById(roleId);
        return this.isUsersBelongToRole(userIds, roleEntity);
    }

    @Override
    public boolean isUserBelongToRole(Long userId, String roleNumber) {
        if (WfUtils.isEmpty(userId) || WfUtils.isEmptyString(roleNumber)) {
            return false;
        }
        EntityQueryBuilder queryBuilder = new EntityQueryBuilder(this.getEntityName(), this.getSelectFields());
        queryBuilder.addFilter("number", roleNumber);
        RoleEntity roleEntity = (RoleEntity)this.findOneByCondition(queryBuilder);
        return this.isUserBelongToRole(userId, roleEntity);
    }

    private boolean isUserBelongToRole(Long userId, RoleEntity roleEntity) {
        if (roleEntity == null) {
            return false;
        }
        DynamicObjectCollection col = roleEntity.getRoleEntry();
        String roleType = roleEntity.getRoleType();
        for (DynamicObject obj : col) {
            Set<DynamicObject> users = this.getUsers(roleType, obj);
            for (DynamicObject user : users) {
                if (!userId.equals(user.getLong(ID))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isUsersBelongToRole(List<Long> userIds, RoleEntity roleEntity) {
        if (Objects.isNull(roleEntity)) {
            return Boolean.FALSE;
        }
        HashSet roleUserIds = Sets.newHashSetWithExpectedSize((int)16);
        roleEntity.getRoleEntry().forEach(c -> this.getUsers(roleEntity.getRoleType(), (DynamicObject)c).forEach(u -> roleUserIds.add(u.getLong(ID))));
        return roleUserIds.containsAll(userIds);
    }

    @Override
    public List<RoleEntity> findRoleByName(String roleName) {
        QFilter[] filters = new QFilter[]{new QFilter("name", "=", (Object)roleName)};
        EntityQueryBuilder eb = this.createQueryBuilder();
        eb.addFilters(filters);
        return this.getList(eb, this.roleEntityByFiltersMatcher, roleName, true);
    }

    private Set<DynamicObject> getUsers(String roleType, DynamicObject roleEntry) {
        HashSet<DynamicObject> users = new HashSet<DynamicObject>(1);
        if (APPROVALPOSITION.equals(roleType)) {
            DynamicObject position = roleEntry.getDynamicObject(APPROVALPOSITION);
            Optional.ofNullable(position).ifPresent(p -> {
                HashSet<Long> ids = new HashSet<Long>();
                ids.add(p.getLong(ID));
                Map peopleUnderPosition = UserServiceHelper.getPeopleUnderPosition(ids);
                peopleUnderPosition.values().forEach(users::addAll);
            });
        } else {
            DynamicObject user = roleEntry.getDynamicObject(USER);
            Optional.ofNullable(user).ifPresent(users::add);
        }
        return users;
    }

    @Override
    public List<RoleEntity> findRoleByUserId(List<Long> userIds, Boolean includePositionRole) {
        ArrayList<RoleEntity> roles = new ArrayList<RoleEntity>();
        if (WfUtils.isEmptyForCollection(userIds)) {
            return roles;
        }
        QFilter uidFilter = new QFilter("roleentry.user", "in", userIds);
        List userRoles = this.findByQueryFilters(new QFilter[]{uidFilter});
        if (WfUtils.isNotEmptyForCollection(userRoles)) {
            roles.addAll(userRoles);
        }
        if (!includePositionRole.booleanValue()) {
            return roles;
        }
        DynamicObjectCollection positions = QueryServiceHelper.query((String)"bos_userposition", (String)"post", (QFilter[])new QFilter[]{new QFilter(USER, "in", userIds)});
        if (positions == null || positions.isEmpty()) {
            return roles;
        }
        ArrayList positionIds = new ArrayList(positions.size());
        positions.stream().filter(p -> WfUtils.isNotEmpty(p.getLong("post"))).forEach(p -> positionIds.add(p.getLong("post")));
        if (WfUtils.isEmptyForCollection(positionIds)) {
            return roles;
        }
        List positionRoles = this.findByQueryFilters(new QFilter[]{new QFilter("roleentry.approvalposition", "in", (Object)positionIds.toArray(new Object[0]))});
        if (WfUtils.isNotEmptyForCollection(positionRoles)) {
            roles.addAll(positionRoles);
        }
        return roles;
    }
}

