/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.management;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.impl.bpmn.deployer.VersionUtils;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.management.ManagementConstants;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessConfigEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;

public interface SuspensionState {
    public String getStateCode();

    public String getName();

    public static class SuspensionStateUtil {
        public static String getProcessDefinitionState(String state) {
            String enable = ManagementConstants.SUSPENDED.getStateCode().equals(state) ? "disable" : "enable";
            return enable;
        }

        public static void setSuspensionState(ProcessDefinitionEntity processDefinitionEntity, SuspensionState state) {
            ProcessDefinitionEntity lastProcessDefinition;
            String enable = SuspensionStateUtil.getProcessDefinitionState(state.getStateCode());
            if (processDefinitionEntity.getEnable().equals(enable)) {
                return;
            }
            if (ManagementConstants.ACTIVE.getStateCode().equals(state.getStateCode()) && (lastProcessDefinition = Context.getCommandContext().getProcessDefinitionEntityManager().findProcDefByModelIdAndVersion(processDefinitionEntity.getModelId(), VersionUtils.getPrevVersion(processDefinitionEntity.getVersion()))) != null) {
                Context.getCommandContext().getProcessEngineConfiguration().getRepositoryService().suspendProcessDefinitionById(lastProcessDefinition.getId());
            }
            processDefinitionEntity.setEnable(enable);
            SuspensionStateUtil.dispatchStateChangeEvent(processDefinitionEntity, state);
            ProcessConfigEntityManager processConfigManager = Context.getCommandContext().getProcessConfigEntityManager();
            processConfigManager.updateProcessConfigEnableState(ModelType.BizFlow.name().equals(processDefinitionEntity.getType()), processDefinitionEntity.getId(), "enable".equalsIgnoreCase(enable));
        }

        public static void setSuspensionState(ExecutionEntity executionEntity, SuspensionState state) {
            if (executionEntity.getSuspensionState().equals(state.getStateCode())) {
                return;
            }
            executionEntity.setSuspensionState(state.getStateCode());
            SuspensionStateUtil.dispatchStateChangeEvent(executionEntity, state);
        }

        public static void setSuspensionState(TaskEntity taskEntity, SuspensionState state) {
            if (taskEntity.getSuspensionState().equals(state.getStateCode())) {
                return;
            }
            taskEntity.setSuspensionState(state.getStateCode());
            SuspensionStateUtil.dispatchStateChangeEvent(taskEntity, state);
        }

        protected static void dispatchStateChangeEvent(Object entity, SuspensionState state) {
            if (Context.getCommandContext() != null && Context.getCommandContext().getEventDispatcher().isEnabled()) {
                ActivitiEventType eventType = null;
                eventType = state == ManagementConstants.ACTIVE ? ActivitiEventType.ENTITY_ACTIVATED : ActivitiEventType.ENTITY_SUSPENDED;
                Context.getCommandContext().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(eventType, entity));
            }
        }

        public static String getStateCaption(String code) {
            if (ManagementConstants.ACTIVE.getStateCode().equalsIgnoreCase(code)) {
                return ResManager.loadKDString((String)"\u6b63\u5728\u8fd0\u884c", (String)"SuspensionState_1", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            if (ManagementConstants.SUSPENDED.getStateCode().equalsIgnoreCase(code)) {
                return ResManager.loadKDString((String)"\u6302\u8d77", (String)"SuspensionState_2", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            return "";
        }
    }

    public static class SuspensionStateImpl
    implements SuspensionState {
        public final String stateCode;
        protected final String name;

        public SuspensionStateImpl(String suspensionCode, String string) {
            this.stateCode = suspensionCode;
            this.name = string;
        }

        @Override
        public String getStateCode() {
            return this.stateCode;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Integer.parseInt(this.stateCode);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SuspensionStateImpl other = (SuspensionStateImpl)obj;
            return this.stateCode.equals(other.stateCode);
        }

        public String toString() {
            return this.name;
        }
    }
}

