/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.management.delegatesetting;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.management.delegatesetting.DelegateSettingEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.delegatesetting.DelegateSettingEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.delegatesetting.DelegateSettingEntityManager;
import kd.bos.workflow.engine.impl.util.CollectionUtil;

public class DelegateSettingEntityManagerImpl
extends AbstractEntityManager<DelegateSettingEntity>
implements DelegateSettingEntityManager {
    public DelegateSettingEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public Class<? extends DelegateSettingEntity> getManagedEntityClass() {
        return DelegateSettingEntityImpl.class;
    }

    @Override
    public String getSelectFields() {
        return "id,assignorid,trusteeid,scope,processdefinitionid,delegatenodeid,delegatenodename,entrabillid,delegaterule,delegateexpression,deleruleshowtext,sendmsgtoassignor,receivetodotask,status,delegatetodo,createdate,creatorid,modifydate,modifierid,starttime,endtime,islatestversion,source";
    }

    @Override
    public List<DelegateSettingEntity> getEnableDelegateByAssignorId(Long assignorId) {
        EntityQueryBuilder<DelegateSettingEntity> queryBuilder = this.getCommonQueryBuilder(assignorId);
        return this.findByQueryBuilder(queryBuilder);
    }

    @Override
    public Map<Long, List<DelegateSettingEntity>> getEnableDelegateByAssignorIds(List<Long> assignorIds) {
        HashMap<Long, List<DelegateSettingEntity>> assignorIdAndDelegateSettingEntitysMap = new HashMap<Long, List<DelegateSettingEntity>>(assignorIds.size());
        EntityQueryBuilder queryBuilder = this.createQueryBuilder();
        queryBuilder.addFilter("status", "=", Character.valueOf('1'));
        queryBuilder.addFilter("assignorid", "in", assignorIds);
        Date currentDate = WfUtils.now();
        queryBuilder.addFilter("starttime", "<=", currentDate);
        queryBuilder.addFilter("endtime", ">=", currentDate);
        List resultList = this.findByQueryBuilder(queryBuilder);
        for (Long assignorId : assignorIds) {
            ArrayList<DelegateSettingEntity> delegateSettings = new ArrayList<DelegateSettingEntity>();
            for (DelegateSettingEntity result : resultList) {
                if (!assignorId.equals(result.getAssignorId())) continue;
                delegateSettings.add(result);
            }
            assignorIdAndDelegateSettingEntitysMap.put(assignorId, delegateSettings);
        }
        return assignorIdAndDelegateSettingEntitysMap;
    }

    @Override
    public List<DelegateSettingEntity> getEnableDelegateEmptyPorcAndBillByAssignorId(Long assignorId) {
        EntityQueryBuilder<DelegateSettingEntity> queryBuilder = this.getCommonQueryBuilder(assignorId);
        queryBuilder.addFilter("processdefinitionid", "=", 0L);
        queryBuilder.addFilter("entrabillid", "=", Character.valueOf(' '));
        return this.findByQueryBuilder(queryBuilder);
    }

    @Override
    public List<DelegateSettingEntity> getEnableDelegateByAssignorIdAndProcDefId(Long assignorId, Long procDefId) {
        EntityQueryBuilder<DelegateSettingEntity> queryBuilder = this.getCommonQueryBuilder(assignorId);
        queryBuilder.addFilter("processdefinitionid", "=", procDefId);
        queryBuilder.addFilter("delegatenodeid", "=", Character.valueOf(' '));
        return this.findByQueryBuilder(queryBuilder);
    }

    @Override
    public List<DelegateSettingEntity> getEnableDelegateByAssignorIdAndProcDefIds(Long assignorId, List<Long> procDefIds) {
        EntityQueryBuilder<DelegateSettingEntity> queryBuilder = this.getCommonQueryBuilder(assignorId);
        queryBuilder.addFilter("processdefinitionid", "in", procDefIds);
        queryBuilder.addFilter("delegatenodeid", "=", Character.valueOf(' '));
        return this.findByQueryBuilder(queryBuilder);
    }

    @Override
    public List<DelegateSettingEntity> getEnableDelegateByAssignorIdAndActivityId(Long assignorId, Long procDefId, String activityId) {
        EntityQueryBuilder<DelegateSettingEntity> queryBuilder = this.getCommonQueryBuilder(assignorId);
        queryBuilder.addFilter("processdefinitionid", "=", procDefId);
        queryBuilder.addFilter("delegatenodeid", "=", activityId);
        return this.findByQueryBuilder(queryBuilder);
    }

    @Override
    public List<DelegateSettingEntity> getAllEnableDelegateByProcDefIds(List<Long> procDefIds) {
        EntityQueryBuilder queryBuilder = this.createQueryBuilder();
        queryBuilder.addFilter("processdefinitionid", "in", procDefIds);
        queryBuilder.addFilter("status", "=", Character.valueOf('1'));
        Date currentDate = WfUtils.now();
        queryBuilder.addFilter("starttime", "<=", currentDate);
        queryBuilder.addFilter("endtime", ">", currentDate);
        return this.findByQueryBuilder(queryBuilder);
    }

    @Override
    public List<DelegateSettingEntity> getEnableDelegateByAssignorIdAndActivityId(Long assignorId, List<Long> procDefIds, String activityId) {
        EntityQueryBuilder<DelegateSettingEntity> queryBuilder = this.getCommonQueryBuilder(assignorId);
        queryBuilder.addFilter("processdefinitionid", "in", procDefIds);
        queryBuilder.addFilter("delegatenodeid", "=", activityId);
        return this.findByQueryBuilder(queryBuilder);
    }

    @Override
    public List<DelegateSettingEntity> getEnableDelegateByAssignorIdAndEntraBillId(Long assignorId, String entraBillId) {
        EntityQueryBuilder<DelegateSettingEntity> queryBuilder = this.getCommonQueryBuilder(assignorId);
        queryBuilder.addFilter("entrabillid", "=", entraBillId);
        return this.findByQueryBuilder(queryBuilder);
    }

    @Override
    public List<DelegateSettingEntity> getEnableDelegateByEntraBillId(String entraBillId) {
        EntityQueryBuilder queryBuilder = this.createQueryBuilder();
        queryBuilder.addFilter("entrabillid", "=", entraBillId);
        queryBuilder.addFilter("status", "=", Character.valueOf('1'));
        Date currentDate = WfUtils.now();
        queryBuilder.addFilter("starttime", "<=", currentDate);
        queryBuilder.addFilter("endtime", ">", currentDate);
        return this.findByQueryBuilder(queryBuilder);
    }

    @Override
    public EntityQueryBuilder<DelegateSettingEntity> getCommonQueryBuilder(Long assignorId) {
        EntityQueryBuilder<DelegateSettingEntity> queryBuilder = this.createQueryBuilder();
        queryBuilder.addFilter("status", "=", Character.valueOf('1'));
        queryBuilder.addFilter("assignorid", "=", assignorId);
        Date currentDate = WfUtils.now();
        queryBuilder.addFilter("starttime", "<=", currentDate);
        queryBuilder.addFilter("endtime", ">=", currentDate);
        return queryBuilder;
    }

    @Override
    public List<DelegateSettingEntity> getEnableDelegateSettingEntities(Long curDelegateId) {
        EntityQueryBuilder queryBuilder = this.createQueryBuilder();
        queryBuilder.addFilter("id", "!=", curDelegateId);
        queryBuilder.addFilter("status", "=", Character.valueOf('1'));
        return this.findByQueryBuilder(queryBuilder);
    }

    @Override
    public boolean isAllDelegateEnable(List<Long> delegateIds) {
        Map<String, List> delegateStatusMap = this.findDelegateStatusByIds(delegateIds);
        List isEnables = delegateStatusMap.get("enables");
        List delegates = delegateStatusMap.get("delegates");
        return CollectionUtil.isNotEmpty(isEnables) && CollectionUtil.isNotEmpty(delegates) && isEnables.size() == delegates.size();
    }

    @Override
    public boolean isAllDelegateDisable(List<Long> delegateIds) {
        Map<String, List> delegateStatusMap = this.findDelegateStatusByIds(delegateIds);
        List isDisables = delegateStatusMap.get("disables");
        List delegates = delegateStatusMap.get("delegates");
        return CollectionUtil.isNotEmpty(isDisables) && CollectionUtil.isNotEmpty(delegates) && isDisables.size() == delegates.size();
    }

    @Override
    public Map<String, List> findDelegateStatusByIds(List<Long> delegateIds) {
        HashMap<String, List> delegateStatusMap = new HashMap<String, List>();
        EntityQueryBuilder queryBuilder = this.createQueryBuilder();
        queryBuilder.addFilter("id", "in", delegateIds);
        List delegates = this.findByQueryBuilder(queryBuilder);
        ArrayList<String> isEnables = new ArrayList<String>();
        ArrayList<String> isDisables = new ArrayList<String>();
        if (CollectionUtil.isNotEmpty(delegates)) {
            for (DelegateSettingEntity delegate : delegates) {
                String status = delegate.getStatus();
                if ("1".equals(status)) {
                    isEnables.add(status);
                    continue;
                }
                isDisables.add(status);
            }
        }
        delegateStatusMap.put("enables", isEnables);
        delegateStatusMap.put("disables", isDisables);
        delegateStatusMap.put("delegates", delegates);
        return delegateStatusMap;
    }

    @Override
    public Map<Long, DelegateSettingEntity> findByIds(List<Long> delegateIds) {
        EntityQueryBuilder eqb = this.createEntityQueryBuilder(new QFilter[]{new QFilter("id", "in", delegateIds)});
        List delegates = this.findByQueryBuilder(eqb);
        return delegates.stream().collect(Collectors.toMap(Entity::getId, obj -> obj));
    }

    @Override
    public void enableDelegateSetting(Long id) {
        DelegateSettingEntity entity = (DelegateSettingEntity)this.findById(id);
        entity.setStatus("1");
        this.update(entity);
    }
}

