/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.monitor.worktransfer;

import java.text.SimpleDateFormat;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.lang.Lang;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.bpmn.behavior.TaskBehaviorUtil;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.RoleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.monitor.worktransfer.WorksTransferLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.monitor.worktransfer.WorksTransferLogEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.monitor.worktransfer.WorksTransferLogEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;

public class WorksTransferLogEntityManagerImpl
extends AbstractEntityManager<WorksTransferLogEntity>
implements WorksTransferLogEntityManager {
    public WorksTransferLogEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public Class<? extends WorksTransferLogEntity> getManagedEntityClass() {
        return WorksTransferLogEntityImpl.class;
    }

    @Override
    public String getSelectFields() {
        return "id,batchnomsg,number,name,procversion,billno,taskid,processdefinitionid,roleid,origauditorid,origauditorname,newauditorid,newauditorname,type,activityid,activityname,creatorid,createdate,modifierid,modifydate";
    }

    @Override
    public void insertWorksTransferLog(Long origAuditorId, String newAuditorIds, Long taskId, Long procDefId, Long roleId, String activityId, String transferType) {
        WorksTransferLogEntity worksTransferLogEntity = (WorksTransferLogEntity)this.create();
        ILocaleString batchNoMsg = this.getBatchNoMsg();
        if (!WfUtils.isEmpty(batchNoMsg)) {
            worksTransferLogEntity.setBatchNoMsg(batchNoMsg);
        }
        this.setExecutionWorksTransferLog(taskId, transferType, worksTransferLogEntity);
        procDefId = this.setTaskWorksTransferLog(taskId, procDefId, worksTransferLogEntity);
        this.setProcDefWorksTransferLog(procDefId, activityId, worksTransferLogEntity);
        this.setRoleWorksTransferLog(roleId, worksTransferLogEntity);
        worksTransferLogEntity.setOrigAuditorId(origAuditorId);
        ILocaleString origAuditorName = WfUtils.findUserName(origAuditorId);
        if (!WfUtils.isEmpty(origAuditorName)) {
            worksTransferLogEntity.setOrigAuditorName(origAuditorName);
        }
        worksTransferLogEntity.setNewAuditorId(WfUtils.subStringForMax(newAuditorIds, 2000));
        ILocaleString newAuditorName = this.getNewAuditorName(newAuditorIds);
        worksTransferLogEntity.setNewAuditorName(WfUtils.subILocaleString(newAuditorName, 2000));
        worksTransferLogEntity.setType(transferType);
        Long currentUserId = Long.valueOf(RequestContext.get().getUserId());
        worksTransferLogEntity.setCreatorId(currentUserId);
        worksTransferLogEntity.setModifierId(currentUserId);
        this.insert(worksTransferLogEntity);
        String entityNumber = "";
        if ("task".equalsIgnoreCase(transferType)) {
            entityNumber = "wf_taskintransits";
        } else if ("process".equalsIgnoreCase(transferType)) {
            entityNumber = "wf_participativeprocdef";
        } else if ("role".equalsIgnoreCase(transferType)) {
            entityNumber = "wf_participativerole";
        } else if ("execution".equalsIgnoreCase(transferType)) {
            entityNumber = "wf_execution_tc";
        }
        String lang = RequestContext.get().getLang().toString();
        WfUtils.addOpLog(entityNumber, "batchTransfer", new MultiLangEnumBridge("\u6279\u91cf\u79fb\u4ea4", "WorksTransferLogEntityManagerImpl_1", "bos-wf-engine"), new MultiLangEnumBridge("\u6d41\u7a0b\uff1a%1$s,%2$s\u6279\u91cf\u79fb\u4ea4\u7ed9%3$s\u6210\u529f", "WorksTransferLogEntityManagerImpl_2", "bos-wf-engine"), WfMultiLangUtils.getValueFromLocalString(worksTransferLogEntity.getName(), lang), WfMultiLangUtils.getValueFromLocalString(worksTransferLogEntity.getOrigAuditorName(), lang), WfMultiLangUtils.getValueFromLocalString(worksTransferLogEntity.getNewAuditorName(), lang));
    }

    private void setExecutionWorksTransferLog(Long taskId, String transferType, WorksTransferLogEntity worksTransferLogEntity) {
        if ("execution".equalsIgnoreCase(transferType)) {
            worksTransferLogEntity.setProcessInstanceId(taskId);
            worksTransferLogEntity.setTaskId(0L);
            ExecutionEntity execution = this.getExecutionEntityManager().findProcessInstanceById(worksTransferLogEntity.getProcessInstanceId());
            if (execution != null) {
                worksTransferLogEntity.setBillNo(execution.getBillNo());
            }
        }
    }

    private Long setTaskWorksTransferLog(Long taskId, Long procDefId, WorksTransferLogEntity worksTransferLogEntity) {
        if (!WfUtils.isEmpty(taskId)) {
            worksTransferLogEntity.setTaskId(taskId);
            TaskEntity task = (TaskEntity)this.getTaskEntityManager().findById(taskId);
            if (task != null) {
                worksTransferLogEntity.setBillNo(task.getBillNo());
                worksTransferLogEntity.setActivityId(WfUtils.subStringForMax(task.getTaskDefinitionKey(), 2000));
                worksTransferLogEntity.setActivityName(WfUtils.subILocaleString(task.getName(), 2000));
                if (WfUtils.isEmpty(procDefId)) {
                    procDefId = task.getProcessDefinitionId();
                }
            }
        }
        return procDefId;
    }

    private void setProcDefWorksTransferLog(Long procDefId, String activityId, WorksTransferLogEntity worksTransferLogEntity) {
        if (!WfUtils.isEmpty(procDefId)) {
            worksTransferLogEntity.setProcessDefinitionId(procDefId);
            ProcessDefinitionEntity procDefEntity = (ProcessDefinitionEntity)this.getProcessDefinitionEntityManager().findById(procDefId);
            if (procDefEntity != null) {
                worksTransferLogEntity.setNumber(procDefEntity.getKey());
                worksTransferLogEntity.setName(procDefEntity.getName());
                worksTransferLogEntity.setProcVersion(procDefEntity.getVersion());
                if (WfUtils.isEmpty(worksTransferLogEntity.getActivityId()) && !WfUtils.isEmpty(activityId)) {
                    worksTransferLogEntity.setActivityId(WfUtils.subStringForMax(activityId, 2000));
                    if (WfUtils.isEmpty(worksTransferLogEntity.getActivityName())) {
                        String multiKey = BpmnModelUtil.getActivityNameMultiKey(activityId);
                        ResourceEntity resource = (ResourceEntity)this.getResourceEntityManager().findById(procDefEntity.getResourceId());
                        ILocaleString activityName = BpmnModelUtil.getMultiLangFieldValueFromResource(resource, multiKey, "");
                        worksTransferLogEntity.setActivityName(WfUtils.subILocaleString(activityName, 2000));
                    }
                }
            }
        }
    }

    private void setRoleWorksTransferLog(Long roleId, WorksTransferLogEntity worksTransferLogEntity) {
        if (!WfUtils.isEmpty(roleId)) {
            worksTransferLogEntity.setRoleId(roleId);
            RoleEntity role = (RoleEntity)this.getRoleEntityManager().findById(roleId);
            if (role != null) {
                worksTransferLogEntity.setNumber(role.getNumber());
                worksTransferLogEntity.setName((ILocaleString)new LocaleString(role.getName()));
            }
        }
    }

    private ILocaleString getBatchNoMsg() {
        LocaleString batchNoMsg = new LocaleString();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        String dateString = sdf.format(WfUtils.now());
        Long currentUserId = Long.valueOf(RequestContext.get().getUserId());
        ILocaleString currentUserName = WfUtils.findUserName(currentUserId);
        ILocaleString tranferMsg = WfUtils.getPromptWordLocaleString("%1$s%2$s\u7684\u79fb\u4ea4", "WorksTransferLogEntityManagerImpl_0", "bos-wf-engine");
        if (!WfUtils.isEmpty(currentUserName)) {
            for (Lang lang : WfUtils.getSupportLangs()) {
                String lan = lang.toString();
                batchNoMsg.setItem(lan, (Object)String.format((String)tranferMsg.get((Object)lan), dateString, currentUserName.get((Object)lan)));
            }
        }
        return batchNoMsg;
    }

    private ILocaleString getNewAuditorName(String newAuditorIds) {
        return TaskBehaviorUtil.getMultiNameById(newAuditorIds);
    }

    @Override
    public List<WorksTransferLogEntity> getWorksTransferLog(Long processInstanceId) {
        EntityQueryBuilder queryBuilder = this.createQueryBuilder().setSelectFields("newauditorid,origauditorid").addFilter("processinstanceid", processInstanceId).addFilter("type", "execution").orderBy(String.format("%s DESC, %s DESC", "createDate", "id"));
        List<WorksTransferLogEntity> entities = this.findByQueryBuilder(queryBuilder, false);
        if (entities == null || entities.isEmpty()) {
            return null;
        }
        return entities;
    }
}

