/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.operationlog;

import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.ModelDataChangeLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.ModelDataChangeLogEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.ModelDataChangeLogEntityManager;

public class ModelDataChangeLogEntityManagerImpl
extends AbstractEntityManager<ModelDataChangeLogEntity>
implements ModelDataChangeLogEntityManager {
    public ModelDataChangeLogEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public Class<? extends ModelDataChangeLogEntity> getManagedEntityClass() {
        return ModelDataChangeLogEntityImpl.class;
    }

    @Override
    public String getSelectFields() {
        return String.format("%s,%s,%s,%s,%s,%s", "procdefid", "schemeid", "resourceid", "content", "modifierid", "modifydate");
    }

    @Override
    public void recordChangeLog(Long procdefId, Long schemeId, Long resourceId, String data) {
        ModelDataChangeLogEntity changeLog = (ModelDataChangeLogEntity)this.create();
        changeLog.setProcdefId(procdefId);
        changeLog.setSchemeId(schemeId);
        changeLog.setResourceId(resourceId);
        changeLog.setContent(data);
        this.insert(changeLog);
    }

    @Override
    public void deleteChangeLogsByProcDefId(Long procDefId) {
        if (procDefId == null) {
            return;
        }
        QFilter[] filters = new QFilter[]{new QFilter("procdefid", "=", (Object)procDefId)};
        this.deleteByFilters(filters);
    }

    @Override
    public void deleteChangeLogsBySchemeId(Long schemeId) {
        if (schemeId == null) {
            return;
        }
        QFilter[] filters = new QFilter[]{new QFilter("schemeid", "=", (Object)schemeId)};
        this.deleteByFilters(filters);
    }
}

