/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.operationlog;

import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.IModelModifyLog;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.ModelModifyLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.ModelModifyLogEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.ModelModifyLogEntityManager;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ModelModifyLogUtils;

public class ModelModifyLogEntityManagerImpl
extends AbstractEntityManager<ModelModifyLogEntity>
implements ModelModifyLogEntityManager {
    public ModelModifyLogEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public Class<? extends ModelModifyLogEntity> getManagedEntityClass() {
        return ModelModifyLogEntityImpl.class;
    }

    @Override
    public String getSelectFields() {
        return "id,revision,procdefid,procnum,schemeid,elementid,elementname,group,groupname,property,propertyname,modifierid,modifydate,operation,oldval,content,type,comment,elementtype,elementtypename";
    }

    @Override
    public Integer generateLatestVersion(Long schemeId) {
        String sql = "SELECT MAX(FREVISION) as revision FROM t_wf_modelmodifylog WHERE FSCHEMEID = ? AND FTYPE = ?;";
        Integer maxVersion = 0;
        try (DataSet ds = DB.queryDataSet((String)"wf.engine.generateSchemeRecordLatestVersion", (DBRoute)DBRoute.workflow, (String)sql, (Object[])new Object[]{schemeId, "dynconfscheme"});){
            Iterator iter = ds.iterator();
            if (iter.hasNext()) {
                Row row = (Row)iter.next();
                maxVersion = row.getInteger("revision");
            }
        }
        return maxVersion != null ? maxVersion + 1 : 1;
    }

    @Override
    public ModelModifyLogEntity generateEntity(ResourceEntity resourceEntity, IModelModifyLog entity, Process process, Map<String, Object> eleParams) {
        Object groupName;
        ModelModifyLogEntity mmlEntity = (ModelModifyLogEntity)this.create();
        mmlEntity.setProcdefId(entity.getProcDefId());
        mmlEntity.setProcnum(process.getNumber());
        mmlEntity.setSchemeId(entity.getSchemeId());
        String elementId = null;
        if (eleParams.get("flowElementId") instanceof String) {
            elementId = (String)eleParams.get("flowElementId");
            mmlEntity.setElementId(elementId);
        }
        String elementName = null;
        if (eleParams.get("flowElementName") instanceof String) {
            elementName = (String)eleParams.get("flowElementName");
        }
        if (WfUtils.isEmpty(elementName)) {
            elementName = elementId;
        }
        String multiKey = BpmnModelUtil.getActivityNameMultiKey(elementId);
        ILocaleString localElementeName = BpmnModelUtil.getMultiLangFieldValueFromResource(resourceEntity, multiKey, elementName);
        mmlEntity.setElementName(localElementeName);
        String property = null;
        if (eleParams.get("property") instanceof String) {
            property = (String)eleParams.get("property");
            mmlEntity.setProperty(property);
        }
        ILocaleString propName = null;
        if (eleParams.get("propertyName") instanceof ILocaleString) {
            propName = (ILocaleString)eleParams.get("propertyName");
            mmlEntity.setPropertyName(propName);
        }
        String group = null;
        if (eleParams.get("group") instanceof String) {
            group = (String)eleParams.get("group");
            mmlEntity.setGroup(group);
        }
        if ((groupName = eleParams.get("groupName")) instanceof ILocaleString) {
            mmlEntity.setGroupName((ILocaleString)eleParams.get("groupName"));
        } else if (groupName instanceof String) {
            mmlEntity.setGroupName((ILocaleString)new LocaleString(groupName.toString()));
        }
        String operation = null;
        if (eleParams.get("operation") instanceof String) {
            operation = (String)eleParams.get("operation");
            mmlEntity.setOperation(operation);
        }
        String elementType = null;
        if (eleParams.get("elementType") instanceof String) {
            elementType = (String)eleParams.get("elementType");
            mmlEntity.setElementType(elementType);
        }
        ILocaleString elementTypeName = null;
        if (eleParams.get("elementTypeName") instanceof ILocaleString) {
            elementTypeName = (ILocaleString)eleParams.get("elementTypeName");
            mmlEntity.setElementTypeName(elementTypeName);
        }
        String oldVal = null;
        if (eleParams.get("oldValue") instanceof String) {
            oldVal = (String)eleParams.get("oldValue");
            mmlEntity.setDetailOldval(oldVal);
        }
        String newVal = null;
        if (eleParams.get("newValue") instanceof String) {
            newVal = (String)eleParams.get("newValue");
            mmlEntity.setDetailContent(newVal);
        }
        String path = null;
        if (eleParams.get("path") instanceof String) {
            path = (String)eleParams.get("path");
        }
        String semanticOldVal = ModelModifyLogUtils.handleSpecial(path, elementType, oldVal);
        mmlEntity.setOldval(semanticOldVal);
        String semanticNewVal = ModelModifyLogUtils.handleSpecial(path, elementType, newVal);
        mmlEntity.setContent(semanticNewVal);
        mmlEntity.setType("dynconfscheme");
        Integer revision = null;
        if (eleParams.get("revision") instanceof Integer) {
            revision = (Integer)eleParams.get("revision");
            mmlEntity.setRevision(revision);
        }
        return mmlEntity;
    }
}

