/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.operationlog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.lang.Lang;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.bpmn.converter.util.CollectionUtils;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.db.BatchSQLInfo;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntityManager;

public class OperationLogEntityManagerImpl
extends AbstractEntityManager<OperationLogEntity>
implements OperationLogEntityManager {
    private static final String DEFAULT_ORDERBY = "createdate asc";
    public static final String SELECT_FIELDS = String.format("%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s", "id", "commentid", "bizidentifykey", "taskid", "activityid", "step", "ownerid", "assigneeid", "type", "procdefid", "procinstid", "businesskey", "billno", "terminalway", "owner", "assignee", "activityname", "opinion", "note", "biznote", "resultnumber", "resultname", "decisiontype", "ispublic", "createDate", "modifydate", "nopinion", "notesummary");
    private static final String[] OPERATIONLOGLISTPROPERTYS = new String[]{"id", "assignee", "owner", "activityname", "opinion", "nopinion", "notesummary", "createdate", "terminalway", "type", "activityid", "resultname"};
    private static final Class[] OPERATIONLOGLISTPROPERTYTYPES = new Class[]{Long.class, String.class, String.class, String.class, String.class, String.class, String.class, Date.class, String.class, String.class, String.class, String.class};

    public OperationLogEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public String getEntityName() {
        return "wf_operationlog";
    }

    @Override
    public Class<? extends OperationLogEntity> getManagedEntityClass() {
        return OperationLogEntityImpl.class;
    }

    @Override
    public String getSelectFields() {
        return SELECT_FIELDS;
    }

    @Override
    public int calculateLogStep(Long processInstanceId) {
        if (processInstanceId == 0L) {
            return 0;
        }
        Integer step = 0;
        String sql = "SELECT max(fstep) as STEP FROM t_wf_operationlog WHERE fprocinstid = ? ";
        Object[] params = new Object[]{processInstanceId};
        try (DataSet ds = DB.queryDataSet((String)"wf.calculateLogStep", (DBRoute)WfUtils.WFS, (String)sql, (Object[])params);){
            Row row;
            Iterator iter = ds.iterator();
            if (iter.hasNext() && (row = (Row)iter.next()) != null) {
                step = row.getInteger("STEP");
            }
        }
        if (null == step) {
            return 1;
        }
        step = step + 1;
        return step;
    }

    @Override
    public DynamicObjectCollection getOperationLogList(int start, int limit, String filterSql, List<Object> paramsList, String orderBy) {
        String lang = RequestContext.get().getLang().toString();
        String masterTableAlias = "a";
        String multiLangTableAlias = "b";
        String assigneeSQL = WfMultiLangUtils.getGeneralLangSQL("wf_operationlog", masterTableAlias, multiLangTableAlias, "fassignee", "assignee", "assignee");
        String ownerSQL = WfMultiLangUtils.getGeneralLangSQL("wf_operationlog", masterTableAlias, multiLangTableAlias, "fowner", "owner", "owner");
        String activityNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_operationlog", masterTableAlias, multiLangTableAlias, "factivityname", "activityname", "activityname");
        String opinionSQL = WfMultiLangUtils.getGeneralLangSQL("wf_operationlog", masterTableAlias, multiLangTableAlias, "fopinion", "opinion", "opinion");
        String nOpinionSQL = WfMultiLangUtils.getGeneralLangSQL("wf_operationlog", masterTableAlias, multiLangTableAlias, "fnopinion", "nopinion", "nopinion");
        String noteSummarySQL = WfMultiLangUtils.getGeneralLangSQL("wf_operationlog", masterTableAlias, multiLangTableAlias, "fnote_summary", "notesummary", "notesummary");
        String resultNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_operationlog", masterTableAlias, multiLangTableAlias, "fresultname", "resultname", "resultname");
        StringBuilder sql = new StringBuilder();
        sql.append("select a.fid id, ");
        sql.append(assigneeSQL).append(", ");
        sql.append(ownerSQL).append(", ");
        sql.append(activityNameSQL).append(", ");
        sql.append(opinionSQL).append(", ");
        sql.append(nOpinionSQL).append(", ");
        sql.append(noteSummarySQL).append(", ");
        sql.append("a.fcreatedate createdate, a.fterminalway terminalway, a.ftype type, a.factivityid activityid ");
        sql.append(",  ").append(resultNameSQL).append("  ");
        sql.append("from t_wf_operationlog a left join t_wf_operationlog_l b on a.fid = b.fid ");
        sql.append("where b.flocaleid = ? ");
        if (!WfUtils.isEmpty(filterSql)) {
            sql.append(filterSql).append(" ");
        }
        if (WfUtils.isNotEmpty(orderBy)) {
            sql.append("order by ").append(orderBy);
        }
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(lang);
        params.addAll(paramsList);
        try (DataSet ds = DB.queryDataSet((String)"OperationLogEntityManagerImpl.getOperationLogList", (DBRoute)WfUtils.WFS, (String)sql.toString(), (Object[])params.toArray());){
            DynamicObjectCollection results = ORM.create().toPlainDynamicObjectCollection(ds, start, limit);
            if (null == results || results.getDynamicObjectType() == null || 0 == results.size()) {
                DynamicObjectType dt = new DynamicObjectType();
                DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection(dt, new Object());
                return dynamicObjectCollection;
            }
            for (DynamicObject dynObj : results) {
                if (null == dynObj || !WfUtils.isNotEmptyString(dynObj.get("nopinion"))) continue;
                dynObj.set("opinion", dynObj.get("nopinion"));
            }
            Iterator iterator = results;
            return iterator;
        }
    }

    @Override
    public DynamicObjectCollection getHiOperationLogList(int start, int limit, String orderBy, List<QFilter> qFilters) {
        DynamicObjectType dt = new DynamicObjectType("wf_operationlog");
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection(dt, null);
        if (WfUtils.isEmptyForCollection(qFilters)) {
            return dynamicObjectCollection;
        }
        String selectFeilds = String.format("%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s", "id", "assignee", "owner", "activityname", "opinion", "nopinion", "notesummary", "createdate", "terminalway", "type", "activityid", "resultname");
        Object dynObjects = QueryServiceHelper.query((String)"wf_operationlog", (String)selectFeilds, (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]), (String)orderBy);
        if (WfUtils.isEmptyForCollection((Collection)dynObjects)) {
            dynObjects = this.getHiOperationLogsFromWide(qFilters, orderBy);
        }
        if (WfUtils.isEmptyForCollection((Collection)dynObjects)) {
            return dynamicObjectCollection;
        }
        DynamicObjectCollection result = new DynamicObjectCollection();
        DynamicObjectType dynamicObjectType = this.getDynamicObjectTyte();
        Iterator iterator = dynObjects.iterator();
        while (iterator.hasNext()) {
            DynamicObject dynamicObject = (DynamicObject)iterator.next();
            DynamicObject dyn = new DynamicObject(dynamicObjectType);
            dyn.set("id", dynamicObject.get("id"));
            dyn.set("assignee", (Object)dynamicObject.get("assignee").toString());
            dyn.set("owner", (Object)dynamicObject.get("owner").toString());
            dyn.set("activityname", (Object)dynamicObject.get("activityname").toString());
            dyn.set("opinion", (Object)dynamicObject.get("opinion").toString());
            dyn.set("nopinion", (Object)dynamicObject.get("nopinion").toString());
            dyn.set("notesummary", (Object)dynamicObject.get("notesummary").toString());
            dyn.set("createdate", (Object)dynamicObject.getDate("createdate"));
            dyn.set("terminalway", (Object)dynamicObject.getString("terminalway"));
            dyn.set("type", (Object)dynamicObject.getString("type"));
            dyn.set("activityid", (Object)dynamicObject.getString("activityid"));
            dyn.set("resultname", (Object)dynamicObject.get("resultname").toString());
            String opinion = dyn.getString("opinion");
            String nopinion = dyn.getString("nopinion");
            if (WfUtils.isEmpty(nopinion)) {
                dyn.set("nopinion", (Object)opinion);
            }
            result.add((Object)dyn);
        }
        return result;
    }

    private DynamicObjectType getDynamicObjectTyte() {
        DynamicObjectType dynamicObjectType = new DynamicObjectType("PlainObject");
        String[] propertys = OPERATIONLOGLISTPROPERTYS;
        Class[] propertyTypes = OPERATIONLOGLISTPROPERTYTYPES;
        for (int p = 0; p < propertys.length; ++p) {
            DynamicSimpleProperty dynamicSimpleProperty = new DynamicSimpleProperty(propertys[p], propertyTypes[p], null);
            dynamicObjectType.addProperty((DynamicProperty)dynamicSimpleProperty);
        }
        return dynamicObjectType;
    }

    private List<DynamicObject> getHiOperationLogsFromWide(List<QFilter> qFilters, String orderBy) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(10);
        if (WfUtils.isEmptyForCollection(qFilters)) {
            return result;
        }
        qFilters = this.getAllFilters(qFilters);
        Long procInstId = null;
        int procInstIdIndex = 0;
        for (int i = 0; i < qFilters.size(); ++i) {
            if (!qFilters.get(i).getProperty().equals("procinstid")) continue;
            procInstId = (Long)qFilters.get(i).getValue();
            procInstIdIndex = i;
            break;
        }
        if (WfUtils.isEmpty(procInstId)) {
            return result;
        }
        qFilters.remove(procInstIdIndex);
        return this.getHistoricProcCompactEntityManager().getOperationLogList(procInstId, qFilters, orderBy);
    }

    @Override
    public List<OperationLogEntity> findCirculationOperationLog(Long taskId, String selectFeilds) {
        List<OperationLogEntity> result = null;
        if (WfUtils.isEmpty(taskId)) {
            return result;
        }
        QFilter f1 = new QFilter("taskid", "=", (Object)taskId);
        QFilter f2 = new QFilter("ownerid", "=", (Object)RequestContext.get().getCurrUserId()).or(new QFilter("ownerid", "=", (Object)0L));
        QFilter f3 = new QFilter("type", "=", (Object)"circulation");
        EntityQueryBuilder eb = this.createQueryBuilder().addFilters(new QFilter[]{f1, f2, f3});
        if (WfUtils.isNotEmpty(selectFeilds)) {
            eb.setSelectFields(selectFeilds);
        }
        eb.orderBy(DEFAULT_ORDERBY);
        result = this.findByQueryBuilder(eb);
        if (WfUtils.isNotEmptyForCollection(result)) {
            return result;
        }
        return this.getHistoricProcCompactEntityManager().getOperationLogsByTaskIdAndType(taskId, "circulation", DEFAULT_ORDERBY);
    }

    @Override
    public List<OperationLogEntity> findOperationLogByBusinessKeyAndType(String selectFeilds, String businessKey, Long userId, String type) {
        List<OperationLogEntity> result = null;
        if (WfUtils.isEmpty(businessKey) || WfUtils.isEmpty(userId) || WfUtils.isEmpty(type)) {
            return result;
        }
        QFilter f1 = new QFilter("businesskey", "=", (Object)businessKey);
        QFilter f2 = new QFilter("ownerid", "=", (Object)userId);
        QFilter f3 = new QFilter("type", "=", (Object)type);
        EntityQueryBuilder eb = this.createQueryBuilder().addFilters(new QFilter[]{f1, f2, f3});
        if (WfUtils.isNotEmpty(selectFeilds) && !selectFeilds.toLowerCase().contains("createdate")) {
            selectFeilds = selectFeilds + "," + "createdate";
            eb.setSelectFields(selectFeilds);
        }
        eb.orderBy(DEFAULT_ORDERBY);
        result = this.findByQueryBuilder(eb);
        result.addAll(this.getHistoricProcCompactEntityManager().findOperationLogByBusinessKeyAndType(businessKey, userId, type));
        result.sort((opera1, opera2) -> opera1.getCreateDate().after(opera2.getCreateDate()) ? 1 : -1);
        return result;
    }

    @Override
    public List<OperationLogEntity> findOperationLogByProcInstId(Long procInstId, String selectFeilds, String orderBy) {
        List<OperationLogEntity> result = null;
        if (WfUtils.isEmpty(procInstId)) {
            return result;
        }
        EntityQueryBuilder eb = this.createQueryBuilder().addFilters(new QFilter[]{new QFilter("procinstid", "=", (Object)procInstId)});
        if (WfUtils.isNotEmpty(selectFeilds)) {
            eb.setSelectFields(selectFeilds);
        }
        if (WfUtils.isNotEmpty(orderBy)) {
            eb.orderBy(orderBy);
        }
        if (WfUtils.isEmptyForCollection(result = this.findByQueryBuilder(eb))) {
            return this.getHistoricProcCompactEntityManager().getOperationLogsFromWide(procInstId, orderBy);
        }
        return result;
    }

    @Override
    public List<OperationLogEntity> findOperationLogByType(Long procInstId, String type, String selectFeilds, String orderBy) {
        List<OperationLogEntity> result = null;
        if (WfUtils.isEmpty(procInstId) || WfUtils.isEmpty(type)) {
            return result;
        }
        EntityQueryBuilder eb = this.createQueryBuilder().addFilters(new QFilter[]{new QFilter("procinstid", "=", (Object)procInstId), new QFilter("type", "=", (Object)type)});
        if (WfUtils.isNotEmpty(selectFeilds)) {
            eb.setSelectFields(selectFeilds);
        }
        if (WfUtils.isNotEmpty(orderBy)) {
            eb.orderBy(orderBy);
        }
        if (WfUtils.isEmptyForCollection(result = this.findByQueryBuilder(eb))) {
            return this.getHistoricProcCompactEntityManager().getOperationLogsFromWideByType(procInstId, type, orderBy);
        }
        return result;
    }

    @Override
    public List<OperationLogEntity> findOperationLogByBusinessKey(String businessKey, String selectFeilds, String orderBy) {
        List<OperationLogEntity> result = null;
        if (WfUtils.isEmpty(businessKey)) {
            return result;
        }
        EntityQueryBuilder eb = this.createQueryBuilder().addFilters(new QFilter[]{new QFilter("businesskey", "=", (Object)businessKey)});
        if (WfUtils.isNotEmpty(selectFeilds)) {
            Set<String> queryFeilds = this.getSelectField(selectFeilds, orderBy);
            StringJoiner queryFeildStr = new StringJoiner(",");
            for (String queryFeild : queryFeilds) {
                queryFeildStr.add(queryFeild);
            }
            eb.setSelectFields(queryFeildStr.toString());
        }
        if (WfUtils.isNotEmpty(orderBy)) {
            eb.orderBy(orderBy);
        }
        result = this.findByQueryBuilder(eb);
        result.addAll(this.getHistoricProcCompactEntityManager().findOperationLogByBusinessKey(businessKey));
        this.sortOperationLogs(result, orderBy);
        return result;
    }

    @Override
    public List<OperationLogEntity> findOperationLogByTaskId(Long procInstId, Long taskId, String selectFeilds, String orderBy) {
        List<OperationLogEntity> result = null;
        if (WfUtils.isEmpty(taskId)) {
            return result;
        }
        EntityQueryBuilder eb = this.createQueryBuilder().addFilters(new QFilter[]{new QFilter("taskid", "=", (Object)taskId)});
        if (WfUtils.isNotEmpty(selectFeilds)) {
            eb.setSelectFields(selectFeilds);
        }
        if (WfUtils.isNotEmpty(orderBy)) {
            eb.orderBy(orderBy);
        }
        if (WfUtils.isEmptyForCollection(result = this.findByQueryBuilder(eb))) {
            return this.getHistoricProcCompactEntityManager().findOperationLogByTaskId(procInstId, taskId, orderBy);
        }
        return result;
    }

    private void sortOperationLogs(List<OperationLogEntity> operationLogs, String orderByStr) {
        if (WfUtils.isEmpty(orderByStr) || WfUtils.isEmptyForCollection(operationLogs)) {
            return;
        }
        if (WfUtils.isNotEmpty(orderByStr = orderByStr.trim().toLowerCase(Locale.ENGLISH))) {
            String[] orderBys = orderByStr.split(",");
            operationLogs.sort((op1, op2) -> this.getOrderResult((OperationLogEntity)op1, (OperationLogEntity)op2, orderBys));
        }
    }

    private int getOrderResult(OperationLogEntity op1, OperationLogEntity op2, String[] orderBys) {
        int result = 0;
        for (String orderBy : orderBys) {
            orderBy = orderBy.trim();
            String field = "";
            boolean reverseOrder = false;
            if (orderBy.endsWith("desc")) {
                reverseOrder = true;
                field = orderBy.substring(0, orderBy.indexOf("desc")).trim();
            } else {
                field = orderBy.endsWith("asc") ? orderBy.substring(0, orderBy.indexOf("asc")).trim() : orderBy;
            }
            switch (field) {
                case "id": {
                    result = op1.getId() < op2.getId() ? -1 : 1;
                    break;
                }
                case "step": {
                    result = op1.getStep() - op2.getStep();
                    break;
                }
                case "createdate": {
                    result = op1.getCreateDate().equals(op2.getCreateDate()) ? 0 : (op1.getCreateDate().after(op2.getCreateDate()) ? 1 : -1);
                    break;
                }
            }
            if (result == 0) continue;
            if (!reverseOrder) break;
            result = -result;
            break;
        }
        return result;
    }

    private Set<String> getSelectField(String fields, String orderBy) {
        String[] orderByFeilds;
        HashSet<String> result = new HashSet<String>(16);
        result.addAll(Arrays.asList(fields.split(",")));
        if (WfUtils.isEmpty(orderBy)) {
            return result;
        }
        orderBy = orderBy.trim().toLowerCase(Locale.ENGLISH);
        for (String orderByFeild : orderByFeilds = orderBy.split(",")) {
            String feild = orderByFeild.trim();
            if (feild.endsWith("desc")) {
                result.add(feild.substring(0, feild.indexOf("desc")).trim());
                continue;
            }
            if (feild.endsWith("asc")) {
                result.add(feild.substring(0, feild.indexOf("asc")).trim());
                continue;
            }
            result.add(feild);
        }
        return result;
    }

    private List<QFilter> getAllFilters(List<QFilter> qfs) {
        ArrayList<QFilter> nextFilters = new ArrayList<QFilter>(10);
        ArrayList<QFilter> allQFilters = new ArrayList<QFilter>(10);
        ArrayList<QFilter> orQFilters = new ArrayList<QFilter>(10);
        while (WfUtils.isNotEmptyForCollection(qfs)) {
            nextFilters.clear();
            for (QFilter qf : qfs) {
                if (!orQFilters.contains(qf)) {
                    if (qf.getValue() instanceof QEmptyValue) {
                        allQFilters.add(new QFilter(qf.getProperty(), "is null", null));
                    } else {
                        allQFilters.add(new QFilter(qf.getProperty(), qf.getCP(), qf.getValue()));
                    }
                }
                List nests = qf.getNests(false);
                for (QFilter.QFilterNest nest : nests) {
                    nextFilters.add(nest.getFilter());
                    if (nest.isAnd()) continue;
                    orQFilters.add(nest.getFilter());
                }
            }
            qfs.clear();
            qfs.addAll(nextFilters);
        }
        return allQFilters;
    }

    @Override
    public void addProcessRelationPerson(Long processInstanceId, List<Long> assigneeIds, int batchCount) {
        EntityQueryBuilder queryBuilder = this.createQueryBuilder();
        StringBuilder fields = new StringBuilder();
        fields.append("billno").append(",").append("procdefid").append(",").append("businesskey").append(",").append("step");
        queryBuilder.setSelectFields(fields.toString()).addFilters(new QFilter[]{new QFilter("procinstid", "=", (Object)processInstanceId)}).orderBy("step desc").setLimit(1);
        String billNo = null;
        Long procDefId = null;
        int step = 0;
        String businessKey = null;
        List entities = this.findByQueryBuilder(queryBuilder);
        if (null != entities && !entities.isEmpty()) {
            OperationLogEntity entityLog = (OperationLogEntity)entities.get(0);
            billNo = entityLog.getBillNo();
            procDefId = entityLog.getProcDefId();
            step = entityLog.getStep();
            businessKey = entityLog.getBusinessKey();
        }
        Date date = new Date();
        String batchSql = "insert into t_wf_operationlog(fid, fassigneeid ,fassignee ,fbusinesskey ,fcreatedate ,fmodifydate ,fnopinion ,fprocinstid ,fterminalway ,ftype ,fbillno ,fprocdefid ,fstep ) values(?,?,?,?,?,?,?,?,?,?,?,?,?); ";
        int paramSize = assigneeIds.size();
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(paramSize);
        long[] ids = DBServiceHelper.genLongIds((String)"t_wf_operationlog", (int)paramSize);
        String batchSql_l = "insert into t_wf_operationlog_l(fpkid ,fid ,flocaleid ,fassignee ,fnopinion) values(?,?,?,?,?) ";
        Lang[] langs = WfMultiLangUtils.getSupportLangs();
        int paramSize_l = paramSize * langs.length;
        ArrayList<Object[]> paramsList_l = new ArrayList<Object[]>(paramSize_l);
        String[] pkIds = DBServiceHelper.genStringIds((String)"t_wf_operationlog", (int)paramSize_l);
        LocaleString nOpinion = new LocaleString(ResManager.loadKDString((String)"\u6dfb\u52a0\u6d41\u7a0b\u5173\u8054\u4eba", (String)"OperationLogEntityManagerImpl_0", (String)"bos-wf-engine", (Object[])new Object[0]));
        for (int i = 0; i < paramSize; ++i) {
            Long assigneeId = assigneeIds.get(i);
            ILocaleString assignee = WfUtils.findUserName(assigneeId);
            Object[] param = new Object[]{ids[i], assigneeId.toString(), WfUtils.isEmpty(assignee.getLocaleValue()) ? "" : assignee.getLocaleValue(), businessKey, date, date, WfUtils.isEmpty(nOpinion.getLocaleValue()) ? "" : nOpinion.getLocaleValue(), processInstanceId, "api", "addProcessRelationPerson", billNo, procDefId, step + i + 1};
            paramsList.add(param);
            int j = 0;
            for (Lang lang : langs) {
                String langStr = lang.toString();
                Object[] param_l = new Object[]{pkIds[j], ids[i], langStr, WfUtils.isEmpty((String)assignee.getItem(langStr)) ? "" : assignee.getItem(langStr), WfUtils.isEmpty((String)nOpinion.getItem(langStr)) ? "" : nOpinion.getItem(langStr)};
                paramsList_l.add(param_l);
                ++j;
            }
        }
        BatchSQLInfo batchSQLInfo = new BatchSQLInfo(batchSql, paramsList, batchCount);
        this.addBatchSQLInfo(batchSQLInfo);
        BatchSQLInfo batchSQLInfo_l = new BatchSQLInfo(batchSql_l, paramsList_l, batchCount);
        this.addBatchSQLInfo(batchSQLInfo_l);
    }

    @Override
    public List<OperationLogEntity> findOperationLogByOwnIdOrAssigneeId(Long procInstId, Long ownId, String assigneeId) {
        if (WfUtils.isEmpty(procInstId) || WfUtils.isEmpty(ownId)) {
            return null;
        }
        EntityQueryBuilder eb = this.createQueryBuilder().addFilters(new QFilter[]{new QFilter("procinstid", "=", (Object)procInstId)});
        List<OperationLogEntity> operationLogList = this.findByQueryBuilder(eb);
        if (CollectionUtils.isEmpty(operationLogList)) {
            return this.getHistoricProcCompactEntityManager().findOperationLogByOwnIdOrAssigneeId(procInstId, ownId, assigneeId);
        }
        ArrayList<OperationLogEntity> result = new ArrayList<OperationLogEntity>();
        operationLogList.forEach(operationLog -> {
            String[] assigneeIdArr;
            List<String> assigneeIdList;
            if (StringUtils.isNotBlank((CharSequence)operationLog.getAssigneeId()) && StringUtils.isNotBlank((CharSequence)assigneeId) && (assigneeIdList = Arrays.asList(assigneeIdArr = operationLog.getAssigneeId().split(","))).contains(assigneeId)) {
                result.add((OperationLogEntity)operationLog);
                return;
            }
            if (null != ownId && null != operationLog.getOwnerId() && ownId.equals(operationLog.getOwnerId())) {
                result.add((OperationLogEntity)operationLog);
            }
        });
        return result;
    }
}

