/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.proctpl;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateCategoryEntity;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateCategoryEntityConstants;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateCategoryEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateCategoryEntityManager;

public class ProcTemplateCategoryEntityManagerImpl
extends AbstractEntityManager<ProcTemplateCategoryEntity>
implements ProcTemplateCategoryEntityManager {
    public ProcTemplateCategoryEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public Class<? extends ProcTemplateCategoryEntity> getManagedEntityClass() {
        return ProcTemplateCategoryEntityImpl.class;
    }

    @Override
    public String getSelectFields() {
        return String.format("%s,%s,%s,%s,%s,%s,%s,%s,%s", "createDate", "modifyDate", "name", "number", "parent", "creatorid", "modifierid", "processtype", "applicationid");
    }

    @Override
    public List<ProcTemplateCategoryEntity> findAllProcTemplateCategories(String fields) {
        String orderBy = String.format("%s ASC", "id");
        EntityQueryBuilder queryBuilder = this.createQueryBuilder();
        queryBuilder.addFilter("id", "!=", ProcTemplateCategoryEntityConstants.CATEGORY_NOCODE);
        queryBuilder.addFilter("parent", "!=", ProcTemplateCategoryEntityConstants.CATEGORY_NOCODE);
        queryBuilder.setSelectFields(fields).orderBy(orderBy);
        return this.findByQueryBuilder(queryBuilder);
    }

    @Override
    public ProcTemplateCategoryEntity createProcTemplateCategory(DynamicObject dynObj) {
        ProcTemplateCategoryEntity entity = (ProcTemplateCategoryEntity)this.create();
        entity.setId(dynObj.getLong("id"));
        entity.setNumber(dynObj.getString("number"));
        entity.setName(dynObj.getLocaleString("name"));
        entity.setParentId(dynObj.getLong("parent_id"));
        return entity;
    }

    @Override
    public ProcTemplateCategoryEntity findProcTemplateCategoryByAppId(String appId, String fields) {
        EntityQueryBuilder queryBuilder = this.createQueryBuilder();
        queryBuilder.addFilter("applicationid", appId);
        if (fields != null) {
            queryBuilder.setSelectFields(fields);
        }
        queryBuilder.orderBy("id desc");
        List result = this.findByQueryBuilder(queryBuilder);
        if (!result.isEmpty()) {
            return (ProcTemplateCategoryEntity)result.get(0);
        }
        return null;
    }
}

