/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.proctpl;

import java.util.Collection;
import java.util.List;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.persistence.CachedEntityMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.ProcTemplateByIdMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.ProcTemplatesByIdsMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateEntity;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateEntityManager;

public class ProcTemplateEntityManagerImpl
extends AbstractEntityManager<ProcTemplateEntity>
implements ProcTemplateEntityManager {
    private CachedEntityMatcher<ProcTemplateEntity> procTemplateByIdMatcher = new ProcTemplateByIdMatcher();
    private CachedEntityMatcher<ProcTemplateEntity> procTemplatesByIdsMatcher = new ProcTemplatesByIdsMatcher();

    public ProcTemplateEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public Class<? extends ProcTemplateEntity> getManagedEntityClass() {
        return ProcTemplateEntityImpl.class;
    }

    @Override
    public String getSelectFields() {
        return String.format("%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s", "createDate", "modifyDate", "name", "number", "identification", "entity", "description", "level", "category", "org", "creatorid", "modifierid", "parent", "resourceid", "copyfrom", "processtype", "status", "preset", "parentversion");
    }

    @Override
    public void delete(ProcTemplateEntity entity) {
        Long resourceId = entity.getResourceId();
        this.getResourceEntityManager().delete(resourceId);
        super.delete(entity);
    }

    @Override
    public ProcTemplateEntity getProcTemplateById(Long templateId) {
        EntityQueryBuilder queryBuilder = this.createQueryBuilder();
        queryBuilder.addFilter("id", templateId);
        List<ProcTemplateEntity> entities = this.findByQueryBuilder(queryBuilder, this.procTemplateByIdMatcher, templateId, true);
        if (!entities.isEmpty()) {
            return entities.get(0);
        }
        return null;
    }

    @Override
    public List<ProcTemplateEntity> getProcTemplatesByIds(Collection<Long> templateIds, String fields) {
        EntityQueryBuilder queryBuilder = this.createQueryBuilder().addFilter("id", "in", templateIds);
        if (fields != null) {
            queryBuilder.setSelectFields(fields);
        }
        return this.findByQueryBuilder(queryBuilder, this.procTemplatesByIdsMatcher, templateIds, true);
    }

    @Override
    public List<ProcTemplateEntity> getProcTemplatesByCategoryId(Long categoryId, String fields) {
        EntityQueryBuilder queryBuilder = this.createQueryBuilder();
        if (fields != null) {
            queryBuilder.setSelectFields(fields);
        }
        queryBuilder.addFilter("category", categoryId);
        return this.findByQueryBuilder(queryBuilder);
    }
}

