/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.proctpl;

import java.util.List;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateReleaseLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateReleaseLogEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateReleaseLogEntityManager;

public class ProcTemplateReleaseLogEntityManagerImpl
extends AbstractEntityManager<ProcTemplateReleaseLogEntity>
implements ProcTemplateReleaseLogEntityManager {
    public ProcTemplateReleaseLogEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public Class<? extends ProcTemplateReleaseLogEntity> getManagedEntityClass() {
        return ProcTemplateReleaseLogEntityImpl.class;
    }

    @Override
    public ProcTemplateReleaseLogEntity getLatestReleaseLog(Long procTplId) {
        EntityQueryBuilder<ProcTemplateReleaseLogEntity> queryBuilder = this.getEntityQueryBuilder();
        queryBuilder.setLimit(1);
        queryBuilder.orderBy(String.format("%s DESC", "version"));
        queryBuilder.addFilter("proctpl", "=", procTplId);
        List<ProcTemplateReleaseLogEntity> entities = this.findByQueryBuilder(queryBuilder);
        if (!entities.isEmpty()) {
            return entities.get(0);
        }
        return null;
    }

    @Override
    public ProcTemplateReleaseLogEntity getReleaseLog(Long procTplId, Integer version) {
        EntityQueryBuilder<ProcTemplateReleaseLogEntity> queryBuilder = this.getEntityQueryBuilder();
        queryBuilder.addFilter("proctpl", procTplId);
        queryBuilder.addFilter("version", version);
        List<ProcTemplateReleaseLogEntity> entities = this.findByQueryBuilder(queryBuilder);
        if (!entities.isEmpty()) {
            return entities.get(0);
        }
        return null;
    }

    private EntityQueryBuilder<ProcTemplateReleaseLogEntity> getEntityQueryBuilder() {
        EntityQueryBuilder<ProcTemplateReleaseLogEntity> queryBuilder = this.createQueryBuilder();
        queryBuilder.setSelectFields(String.format("%s,%s,%s", "version", "newresourceid", "oldresourceid"));
        return queryBuilder;
    }

    @Override
    public void deleteByProcTplId(Long procTplId) {
        QFilter[] filters = new QFilter[]{new QFilter("proctpl", "=", (Object)procTplId)};
        this.deleteByFilters(filters);
    }

    @Override
    public String getSelectFields() {
        return String.format("%s,%s,%s,%s,%s,%s", "proctpl", "version", "oldresourceid", "newresourceid", "creatorid", "createdate");
    }
}

