/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.runtime;

import java.util.HashMap;
import java.util.Map;

public class BillRelationInfo {
    String businesskey;
    String entityNumber;
    Map<String, String> srcBills = new HashMap<String, String>();
    Map<String, String> targetBills = new HashMap<String, String>();

    public boolean isBrother(BillRelationInfo info) {
        if (this.srcBills.isEmpty() || info.getSrcBills().isEmpty()) {
            return false;
        }
        for (String src : this.srcBills.keySet()) {
            if (info.getSrcBills().containsKey(src)) continue;
            return false;
        }
        return info.isBrother(this);
    }

    public boolean isWife(BillRelationInfo info) {
        if (this.targetBills.isEmpty() || info.getTargetBills().isEmpty()) {
            return false;
        }
        for (String src : this.targetBills.keySet()) {
            if (info.getTargetBills().containsKey(src)) continue;
            return false;
        }
        return info.isWife(this);
    }

    public String getSrcDesc() {
        StringBuilder desc = new StringBuilder();
        for (Map.Entry<String, String> entry : this.srcBills.entrySet()) {
            desc.append(entry.getKey()).append('-').append(entry.getValue()).append(',');
        }
        return desc.toString();
    }

    public String getBusinesskey() {
        return this.businesskey;
    }

    public void setBusinesskey(String businesskey) {
        this.businesskey = businesskey;
    }

    public String getEntityNumber() {
        return this.entityNumber;
    }

    public void setEntityNumber(String entityNumber) {
        this.entityNumber = entityNumber;
    }

    public Map<String, String> getSrcBills() {
        return this.srcBills;
    }

    public void setSrcBill(String entityNumber, String businesskey) {
        this.srcBills.put(businesskey, entityNumber);
    }

    public Map<String, String> getTargetBills() {
        return this.targetBills;
    }

    public void setTargetBill(String entityNumber, String businesskey) {
        this.targetBills.put(businesskey, entityNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BillRelationInfo [businesskey=");
        sb.append(this.businesskey);
        sb.append(", entityNumber=");
        sb.append(this.entityNumber);
        sb.append(", srcBills=");
        sb.append(this.srcBills);
        sb.append(", targetBills=");
        sb.append(this.targetBills);
        sb.append(']');
        return sb.toString();
    }
}

