/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.runtime;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bec.engine.pojo.BusinessObject;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bizflow.graph.model.BillRelation;
import kd.bos.workflow.bizflow.graph.util.BizFlowGraphUtil;
import kd.bos.workflow.bizflow.util.BizFlowUtil;
import kd.bos.workflow.bpmn.model.AutoTask;
import kd.bos.workflow.bpmn.model.BillTask;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.StartEvent;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.bpmn.behavior.TaskBehaviorUtil;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.CirculateRelationEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.CirculateRelationEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.CirculateRelationEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.CirculateRelationsDBModel;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFMountException;

public class CirculateRelationEntityManagerImpl
extends AbstractEntityManager<CirculateRelationEntity>
implements CirculateRelationEntityManager {
    public CirculateRelationEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public Class<? extends CirculateRelationEntity> getManagedEntityClass() {
        return CirculateRelationEntityImpl.class;
    }

    @Override
    public String getSelectFields() {
        return String.format("%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s", "entitynumber", "businesskey", "sourceid", "biztraceno", "procinstid", "parentprocinstid", "executionid", "activityid", "actinstid", "bizeventid", "biztracedesc", "acttype", "billno", "status", "type", "procidentifier", "bizidentifier", "creatorid", "createdate", "modifierid", "modifydate");
    }

    @Override
    public void recordCirculateRelationShip(ExecutionEntity execution, FlowElement currentElement) {
        if ("false".equals(WfConfigurationUtil.getConfigCenterVal("workflow.relationGraph.recordRelationData"))) {
            return;
        }
        if (!this.isMatchedElementType(currentElement)) {
            return;
        }
        try {
            Map<String, Set<String>> srcBills = BizFlowUtil.getDirectSourceBills(execution.getEntityNumber(), execution.getBusinessKey());
            BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(execution.getProcessDefinitionId(), execution.getSchemeId(), execution.getProcessInstanceId());
            if (!srcBills.isEmpty()) {
                boolean autoCreate = Boolean.TRUE.equals(execution.getVariable("autoCreateSourceRelation"));
                Map<String, Boolean> existsState = this.getSourceExistsState(srcBills);
                HashSet<String> notExistsBillIds = new HashSet<String>(16);
                for (Map.Entry<String, Boolean> entry : existsState.entrySet()) {
                    if (entry.getValue().booleanValue()) continue;
                    notExistsBillIds.add(entry.getKey());
                }
                String bizTraceNo = execution.getBizTraceNo();
                HashMap<String, String> fieldMap = new HashMap<String, String>(srcBills.size());
                if (autoCreate) {
                    BizFlowGraphUtil.initEntityBillNoField(fieldMap, srcBills.keySet());
                }
                String billNo = execution.getBillNo();
                for (Map.Entry<String, Set<String>> entry : srcBills.entrySet()) {
                    String entityNumber = entry.getKey();
                    Sets.SetView billIds = Sets.intersection(notExistsBillIds, entry.getValue());
                    HashMap<String, String> billNoMap = new HashMap<String, String>(billIds.size());
                    if (autoCreate && !billIds.isEmpty()) {
                        String billNoField = (String)fieldMap.get(entityNumber);
                        BizFlowGraphUtil.initEntityBillNoMap(entityNumber, (Set<String>)billIds, billNoField, billNoMap);
                    }
                    for (String srcBill : entry.getValue()) {
                        CirculateRelationEntity entity = this.createEntity(bpmnModel, execution);
                        entity.setSourceBillId(srcBill);
                        entity.setBillNo(billNo);
                        if (!existsState.get(srcBill).booleanValue()) {
                            if (autoCreate) {
                                CirculateRelationEntity sourceEntity = this.autoCreateSourceRelation(entityNumber, srcBill, (String)billNoMap.get(srcBill), bizTraceNo);
                                this.insertEntity(sourceEntity);
                            } else {
                                entity.setSourceBillId(null);
                            }
                        }
                        this.insertEntity(entity);
                    }
                }
            } else {
                CirculateRelationEntity entity = this.createEntity(bpmnModel, execution, currentElement);
                this.insertEntity(entity);
            }
        }
        catch (Exception e) {
            throw new WFMountException(WFErrorCode.getMountRelationException(), new String[]{execution.getEntityNumber(), execution.getBusinessKey(), WfUtils.getExceptionStacktrace(e)});
        }
    }

    private Map<String, Boolean> getSourceExistsState(Map<String, Set<String>> srcBills) {
        HashSet sourceBillIds = new HashSet(16);
        for (Map.Entry<String, Set<String>> entry : srcBills.entrySet()) {
            sourceBillIds.addAll(entry.getValue());
        }
        HashMap<String, Boolean> stateMap = new HashMap<String, Boolean>(sourceBillIds.size());
        for (String bill : sourceBillIds) {
            stateMap.put(bill, false);
        }
        QFilter[] qFilterArray = new QFilter[]{new QFilter("businesskey", "in", sourceBillIds)};
        List entities = this.findByQueryFilters(qFilterArray, "businesskey", null);
        for (CirculateRelationEntity entity : entities) {
            stateMap.put(entity.getBusinessKey(), true);
        }
        return stateMap;
    }

    private boolean isMatchedElementType(FlowElement currentElement) {
        return currentElement instanceof BillTask || currentElement instanceof StartEvent || currentElement instanceof UserTask || currentElement instanceof CallActivity || currentElement instanceof AutoTask;
    }

    private boolean isMatchedActivityType(String type) {
        return "BillTask".equals(type) || "StartSignalEvent".equals(type) || "UserTask".equals(type) || "CallActivity".equals(type) || "AutoTask".equals(type);
    }

    private void insertEntity(CirculateRelationEntity entity) {
        QFilter[] filters = new QFilter[]{new QFilter("entitynumber", "=", (Object)entity.getEntityNumber()), new QFilter("businesskey", "=", (Object)entity.getBusinessKey()), new QFilter("sourceid", "=", (Object)entity.getSourceBillId()), WfUtils.isNotEmpty(entity.getBizTraceNo()) ? new QFilter("biztraceno", "=", (Object)entity.getBizTraceNo()) : new QFilter("procinstid", "=", (Object)entity.getProcinstId())};
        List result = this.findByQueryFilters(filters, this.getSelectFields(), null);
        if (result == null || result.isEmpty()) {
            this.insert(entity);
        } else {
            CirculateRelationEntity relationEntity = (CirculateRelationEntity)result.get(0);
            relationEntity.setActInstId(entity.getActInstId());
            relationEntity.setActivityId(entity.getActivityId());
            relationEntity.setActivityType(entity.getActivityType());
            this.update(relationEntity);
            this.logger.debug(String.format("entityNumber: %s businessKey: %s hiactInstId: %s empty sourceId exists!", entity.getEntityNumber(), entity.getBusinessKey(), entity.getActInstId()));
        }
    }

    private CirculateRelationEntity createEntity(BpmnModel bpmnModel, ExecutionEntity execution) {
        return this.createEntity(bpmnModel, execution, execution.getCurrentFlowElement());
    }

    private CirculateRelationEntity createEntity(BpmnModel bpmnModel, ExecutionEntity execution, FlowElement currentElement) {
        CirculateRelationEntity entity = (CirculateRelationEntity)this.create();
        entity.setBillNo(execution.getBillNo());
        entity.setEntityNumber(execution.getEntityNumber());
        entity.setBusinessKey(execution.getBusinessKey());
        entity.setBizTraceNo(execution.getBizTraceNo());
        entity.setProcinstId(execution.getProcessInstanceId());
        entity.setExecutionId(execution.getId());
        entity.setActInstId(execution.getCurrentActInstId());
        entity.setStatus("underway");
        entity.setType("bizflow");
        entity.setProcIdentifier(bpmnModel.getMainProcess().getBusinessId());
        if (currentElement != null) {
            entity.setBizIdentifier(currentElement.getBizIdentifyKey());
            entity.setActivityId(currentElement.getId());
            entity.setActivityType(currentElement.getType());
        }
        return entity;
    }

    private CirculateRelationEntity autoCreateSourceRelation(String entityNumber, String businessKey, String billNo, String bizTraceNo) {
        CirculateRelationEntity entity = (CirculateRelationEntity)this.create();
        entity.setEntityNumber(entityNumber);
        entity.setBusinessKey(businessKey);
        entity.setBillNo(billNo);
        entity.setBizTraceNo(bizTraceNo);
        entity.setStatus("complete");
        entity.setType("bizflow");
        return entity;
    }

    @Override
    public List<BillRelation> getBillCirculateRelations(Long processInstanceId, String businessKey) {
        ArrayList<BillRelation> datas = new ArrayList<BillRelation>(16);
        HistoricProcessInstanceEntity processInstance = (HistoricProcessInstanceEntity)this.getHistoricProcessInstanceEntityManager().findById(processInstanceId);
        String bizTraceNo = processInstance != null ? processInstance.getBizTraceNo() : null;
        EntityQueryBuilder<CirculateRelationEntity> queryBuilder = this.getBasicQueryBuilder(processInstanceId, bizTraceNo);
        List<CirculateRelationEntity> relations = this.findByQueryBuilder(queryBuilder);
        CirculateRelationsDBModel dbModel = new CirculateRelationsDBModel(relations);
        HashMap<String, String> entityMap = new HashMap<String, String>();
        HashMap<String, BillRelation> relationMap = new HashMap<String, BillRelation>(16);
        if (WfUtils.isNotEmpty(businessKey)) {
            List<CirculateRelationEntity> entities = dbModel.findByBusinessKey(businessKey);
            HashSet<String> businessKeys = new HashSet<String>(16);
            for (CirculateRelationEntity entity : entities) {
                BillRelation relation = (BillRelation)relationMap.get(entity.getBusinessKey());
                if (relation == null) {
                    relation = this.getBillRelation(dbModel, entity, entityMap, relationMap, businessKeys);
                    relationMap.put(entity.getBusinessKey(), relation);
                }
                if (WfUtils.isEmpty(entity.getSourceBillId())) {
                    datas.add(relation);
                    continue;
                }
                this.addSourceBillRelations(datas, dbModel, entity, relation, entityMap, relationMap, businessKeys);
            }
        } else {
            List<CirculateRelationEntity> entities = dbModel.findBySourceId(" ");
            if (entities.isEmpty()) {
                return datas;
            }
            HashSet<String> businessKeys = new HashSet<String>(16);
            businessKeys.add(" ");
            for (CirculateRelationEntity entity : entities) {
                BillRelation relation = (BillRelation)relationMap.get(entity.getBusinessKey());
                if (relation != null) continue;
                relation = this.getBillRelation(dbModel, entity, entityMap, relationMap, businessKeys);
                relationMap.put(entity.getBusinessKey(), relation);
                datas.add(relation);
            }
        }
        return datas;
    }

    private void addSourceBillRelations(List<BillRelation> datas, CirculateRelationsDBModel dbModel, CirculateRelationEntity entity, BillRelation relation, Map<String, String> entityMap, Map<String, BillRelation> relationMap, Set<String> businessKeys) {
        List<CirculateRelationEntity> parents = dbModel.findByBusinessKey(entity.getSourceBillId());
        if (parents.isEmpty()) {
            this.logger.warn(String.format("source %s cann't found. businessKey: %s", entity.getSourceBillId(), entity.getBusinessKey()));
        } else {
            for (CirculateRelationEntity parent : parents) {
                BillRelation parentRelation = relationMap.get(parent.getBusinessKey());
                if (parentRelation == null) {
                    parentRelation = this.getBillRelation(dbModel, parent, entityMap, relationMap, businessKeys, false);
                    relationMap.put(parent.getBusinessKey(), parentRelation);
                }
                parentRelation.getTargets().add(relation);
                if (WfUtils.isEmpty(parent.getSourceBillId())) {
                    datas.add(parentRelation);
                    continue;
                }
                this.addSourceBillRelations(datas, dbModel, parent, parentRelation, entityMap, relationMap, businessKeys);
            }
        }
    }

    private EntityQueryBuilder<CirculateRelationEntity> getBasicQueryBuilder(Long processInstanceId, String bizTraceNo) {
        EntityQueryBuilder queryBuilder = this.createQueryBuilder();
        if (WfUtils.isNotEmpty(bizTraceNo)) {
            queryBuilder.addFilter("biztraceno", bizTraceNo);
        } else {
            queryBuilder.addFilter("procinstid", processInstanceId);
        }
        return queryBuilder.orderBy(String.format("%s ASC", "id"));
    }

    private List<CirculateRelationEntity> findTargetBillDatas(CirculateRelationsDBModel dbModel, CirculateRelationEntity entity) {
        return dbModel.findBySourceId(entity.getBusinessKey());
    }

    private BillRelation getBillRelation(CirculateRelationsDBModel dbModel, CirculateRelationEntity entity, Map<String, String> entityMap, Map<String, BillRelation> relationMap, Set<String> businessKeys) {
        return this.getBillRelation(dbModel, entity, entityMap, relationMap, businessKeys, true);
    }

    private BillRelation getBillRelation(CirculateRelationsDBModel dbModel, CirculateRelationEntity entity, Map<String, String> entityMap, Map<String, BillRelation> relationMap, Set<String> businessKeys, boolean recursion) {
        BillRelation data = new BillRelation();
        data.setId(entity.getId());
        data.setBillNo(entity.getBillNo());
        data.setStatus(entity.getStatus());
        data.setActivityType(entity.getActivityType());
        data.setActivityInstId(entity.getActInstId());
        data.setBusinessKey(entity.getBusinessKey());
        data.setUniqueKey(entity.getEntityNumber(), entity.getBusinessKey());
        data.setEntityNumber(entity.getEntityNumber());
        data.setEntityName(BizFlowUtil.getEntityName(entityMap, entity.getEntityNumber()));
        if (businessKeys.contains(entity.getBusinessKey())) {
            this.logger.debug(String.format("%s(%s) already queried.", entity.getBusinessKey(), entity.getEntityNumber()));
            return data;
        }
        List<CirculateRelationEntity> entities = this.findTargetBillDatas(dbModel, entity);
        businessKeys.add(entity.getBusinessKey());
        if (recursion && !entities.isEmpty()) {
            for (CirculateRelationEntity et : entities) {
                BillRelation relation = relationMap.get(et.getBusinessKey());
                if (relation == null) {
                    relation = this.getBillRelation(dbModel, et, entityMap, relationMap, businessKeys);
                    relationMap.put(et.getBusinessKey(), relation);
                }
                data.getTargets().add(relation);
            }
        }
        return data;
    }

    @Override
    public void updateCriculateRelation(HistoricActivityInstanceEntity hisActInst) {
        String type = hisActInst.getActivityType();
        if (!this.isMatchedActivityType(type)) {
            this.logger.debug(String.format("sourceElementId: %s, activityType: %s", hisActInst.getSourceElementId(), type));
            return;
        }
        HistoricProcessInstanceEntity hisProcInst = (HistoricProcessInstanceEntity)this.getHistoricProcessInstanceEntityManager().findById(hisActInst.getProcessInstanceId(), "processtype");
        if (!ModelType.BizFlow.name().equals(hisProcInst.getProcessType())) {
            this.logger.debug(String.format("businessKey: %s, processInstanceId: %s, hiactinstId: %s is not BizFlow.", hisActInst.getBusinessKey(), hisActInst.getProcessInstanceId(), hisActInst.getId()));
            return;
        }
        List<CirculateRelationEntity> result = this.findCirculateRelationsByEntityAndBusinessKey(hisActInst.getBusinessKey(), hisActInst.getEntityNumber());
        if (result == null || result.isEmpty()) {
            this.logger.debug(String.format("EntityNumber: %s BusinessKey: %s ActInstId: %s can not found!", hisActInst.getEntityNumber(), hisActInst.getBusinessKey(), hisActInst.getSourceElementId()));
        } else {
            CirculateRelationEntity relationEntity = null;
            if (result.size() == 1 && ("StartSignalEvent".equals((relationEntity = result.get(0)).getActivityType()) || WfUtils.isEmpty(hisActInst.getSourceElementId()))) {
                relationEntity.setActInstId(hisActInst.getId());
                relationEntity.setActivityId(hisActInst.getActivityId());
                relationEntity.setActivityType(hisActInst.getActivityType());
                BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(hisActInst.getProcessDefinitionId(), hisActInst.getProcessInstanceId());
                relationEntity.setBizIdentifier(bpmnModel.getFlowElement(hisActInst.getActivityId()).getBizIdentifyKey());
                this.update(relationEntity);
                return;
            }
            for (CirculateRelationEntity entity : result) {
                if (hisActInst.getSourceElementId() == null || !hisActInst.getSourceElementId().equals(entity.getActInstId())) continue;
                relationEntity = entity;
                relationEntity.setActInstId(hisActInst.getId());
                this.update(relationEntity);
            }
        }
    }

    @Override
    public List<CirculateRelationEntity> findCirculateRelationsByEntityAndBusinessKey(String srcBusinessKey, String srcEntityNumber) {
        QFilter[] filters = new QFilter[]{new QFilter("businesskey", "=", (Object)srcBusinessKey), new QFilter("entitynumber", "=", (Object)srcEntityNumber)};
        List ret = this.findByQueryFilters(filters, this.getSelectFields(), null);
        return ret == null ? Collections.emptyList() : ret;
    }

    @Override
    public List<CirculateRelationEntity> findCirculateRelationsByBusinessKeys(Set<String> tarIds) {
        QFilter[] filters = new QFilter[2];
        filters[0] = new QFilter("businesskey", "in", tarIds);
        List ret = this.findByQueryFilters(filters, this.getSelectFields(), null);
        return ret == null ? Collections.emptyList() : ret;
    }

    @Override
    public CirculateRelationEntity createCirculateRelationEntity(CirculateRelationEntity src, BusinessObject bo) {
        if (bo == null || WfUtils.isEmpty(bo.getBusinessKey())) {
            return null;
        }
        String billNo = TaskBehaviorUtil.getTaskBillNo(bo.getEntityNumber(), bo.getBusinessKey());
        CirculateRelationEntity entity = this.innerCreateBySrc(src, billNo, bo.getEntityNumber(), bo.getBusinessKey());
        this.insert(entity);
        return entity;
    }

    private CirculateRelationEntity innerCreateBySrc(CirculateRelationEntity src, String billNo, String entityNumber, String businessKey) {
        CirculateRelationEntity entity = (CirculateRelationEntity)this.create();
        entity.setBillNo(billNo);
        entity.setEntityNumber(entityNumber);
        entity.setBusinessKey(businessKey);
        entity.setBizTraceNo(src.getBizTraceNo());
        entity.setProcinstId(src.getProcinstId());
        entity.setExecutionId(src.getExecutionId());
        entity.setActInstId(src.getActInstId());
        entity.setStatus("complete");
        entity.setType("bizflow");
        entity.setProcIdentifier(src.getProcIdentifier());
        entity.setBizIdentifier(src.getBizIdentifier());
        entity.setActivityId(src.getActivityId());
        entity.setActivityType(src.getActivityType());
        entity.setSourceBillId(src.getBusinessKey());
        return entity;
    }
}

