/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.CirculateRelationEntity;

public class CirculateRelationsDBModel {
    private Map<String, List<CirculateRelationEntity>> busKeyRelationMap = new HashMap<String, List<CirculateRelationEntity>>();
    private Map<String, List<CirculateRelationEntity>> sourceIdRelationMap = new HashMap<String, List<CirculateRelationEntity>>();

    public CirculateRelationsDBModel(List<CirculateRelationEntity> entities) {
        this.initRelationMap(entities);
    }

    private void initRelationMap(List<CirculateRelationEntity> entities) {
        for (CirculateRelationEntity entity : entities) {
            String sourceId = "".equals(entity.getSourceBillId()) ? " " : entity.getSourceBillId();
            List<CirculateRelationEntity> sources = this.sourceIdRelationMap.get(sourceId);
            if (sources == null) {
                sources = new ArrayList<CirculateRelationEntity>();
                this.sourceIdRelationMap.put(sourceId, sources);
            }
            sources.add(entity);
            String businessKey = entity.getBusinessKey();
            List<CirculateRelationEntity> relations = this.busKeyRelationMap.get(businessKey);
            if (relations == null) {
                relations = new ArrayList<CirculateRelationEntity>();
                this.busKeyRelationMap.put(businessKey, relations);
            }
            relations.add(entity);
        }
    }

    public List<CirculateRelationEntity> findByBusinessKey(String businessKey) {
        ArrayList ret = this.busKeyRelationMap.get(businessKey);
        return ret != null ? ret : new ArrayList();
    }

    public List<CirculateRelationEntity> findBySourceId(String sourceId) {
        ArrayList ret = this.sourceIdRelationMap.get(sourceId);
        return ret != null ? ret : new ArrayList();
    }
}

