/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.runtime;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.DurationDetailEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.DurationDetailEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.DurationDetailEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.SuspendType;

public class DurationDetailEntityManagerImpl
extends AbstractEntityManager<DurationDetailEntity>
implements DurationDetailEntityManager {
    public DurationDetailEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public Class<? extends DurationDetailEntity> getManagedEntityClass() {
        return DurationDetailEntityImpl.class;
    }

    @Override
    public String getSelectFields() {
        return "id,processnumber,processname,businesskey,processdefinitionid,processinstanceid,activityid,activityname,activityinstanceid,taskid,suspendtime,undosuspendtime,suspendduration,calendarduration,realduration,suspendreason,suspenderid,errortype,type,creatorid,createdate,modifierid,modifydate";
    }

    @Override
    public String getEntityName() {
        return "wf_durationdetail";
    }

    @Override
    public void insertDurationDetailByTaskId(Long taskId, Long processInstanceId, ILocaleString suspendReason, String suspendType) {
        this.insertDurationDetailData(processInstanceId, taskId, suspendReason, suspendType, null);
    }

    @Override
    public void insertDurationDetail(Long processInstanceId, ILocaleString suspendReason, String suspendType, String errorType) {
        this.insertDurationDetailData(processInstanceId, null, suspendReason, suspendType, errorType);
    }

    private void insertDurationDetailData(Long processInstanceId, Long taskId, ILocaleString suspendReason, String suspendType, String errorType) {
        DurationDetailEntityManager durationDetailEntityManager = this.getDurationDetailEntityManager();
        QFilter filter1 = new QFilter("processInstanceId", "=", (Object)processInstanceId);
        QFilter filter2 = new QFilter("parentId", "!=", (Object)0L);
        QFilter[] filters = new QFilter[]{filter1, filter2};
        List executions = this.getExecutionEntityManager().findByQueryFilters(filters);
        for (ExecutionEntity executionEntity : executions) {
            if (!executionEntity.isActive()) continue;
            if (WfUtils.isNotEmpty(taskId) && !executionEntity.getCurrentTaskId().equals(taskId)) {
                return;
            }
            DurationDetailEntity durationDetailEntity = (DurationDetailEntity)durationDetailEntityManager.create();
            Long processDefinitionId = executionEntity.getProcessDefinitionId();
            ProcessDefinitionEntity procDefEntity = (ProcessDefinitionEntity)this.getProcessDefinitionEntityManager().findById(processDefinitionId, "key,name");
            if (procDefEntity != null) {
                durationDetailEntity.setProcessNumber(procDefEntity.getKey());
                durationDetailEntity.setProcessName(procDefEntity.getName());
            }
            durationDetailEntity.setBusinessKey(executionEntity.getBusinessKey());
            durationDetailEntity.setProcessDefinitionId(processDefinitionId);
            durationDetailEntity.setProcessInstanceId(processInstanceId);
            durationDetailEntity.setActivityId(executionEntity.getActivityId());
            durationDetailEntity.setActivityName(executionEntity.getActivityName());
            durationDetailEntity.setActivityInstanceId(executionEntity.getCurrentActInstId());
            durationDetailEntity.setTaskId(executionEntity.getCurrentTaskId());
            durationDetailEntity.setSuspendTime(WfUtils.now());
            durationDetailEntity.setSuspendReason(suspendReason);
            Long currentUserId = Long.valueOf(RequestContext.get().getUserId());
            durationDetailEntity.setSuspenderId(currentUserId);
            durationDetailEntity.setType(suspendType);
            durationDetailEntity.setErrorType(errorType);
            durationDetailEntity.setCreatorId(currentUserId);
            durationDetailEntity.setModifierId(currentUserId);
            durationDetailEntityManager.insert(durationDetailEntity);
        }
    }

    @Override
    public List<DurationDetailEntity> getDurationDetailsByProcessInstanceId(Long processInstanceId) {
        EntityQueryBuilder entityQueryBuilder = this.createQueryBuilder().addFilter("processInstanceId", processInstanceId);
        return this.findByQueryBuilder(entityQueryBuilder);
    }

    @Override
    public List<DurationDetailEntity> getDurationDetailsByTaskId(Long taskId) {
        EntityQueryBuilder entityQueryBuilder = this.createQueryBuilder().addFilter("taskid", taskId);
        return this.findByQueryBuilder(entityQueryBuilder);
    }

    @Override
    public List<DurationDetailEntity> getDurationDetailByProcInstIdAndActId(Long processInstanceId, String activityId) {
        QFilter filterProcInstId = new QFilter("processinstanceid", "=", (Object)processInstanceId);
        QFilter filterActId = new QFilter("activityid", "=", (Object)activityId);
        QFilter[] filters = new QFilter[]{filterProcInstId, filterActId};
        EntityQueryBuilder entityQueryBuilder = this.createQueryBuilder().addFilters(filters);
        return this.findByQueryBuilder(entityQueryBuilder);
    }

    @Override
    public long getSuspendDurationForUndoSuspendedByProcInstId(Long processInstanceId) {
        List<DurationDetailEntity> durationDetails = this.getDurationDetailsByProcessInstanceId(processInstanceId);
        return this.getTotalSuspendDuration(durationDetails);
    }

    @Override
    public long getSuspendDurationForSuspendedByProcInstId(Long processInstanceId) {
        Date suspendTime;
        DurationDetailEntity durationDetail;
        long suspendDuration = this.getSuspendDurationForUndoSuspendedByProcInstId(processInstanceId);
        EntityQueryBuilder entityQueryBuilder = this.createQueryBuilder().addFilter("processInstanceId", processInstanceId).orderBy("createdate desc");
        List durationDetails = this.findByQueryBuilder(entityQueryBuilder);
        if (durationDetails != null && !durationDetails.isEmpty() && (durationDetail = (DurationDetailEntity)durationDetails.get(0)) != null && durationDetail.getUndoSuspendTime() == null && (suspendTime = durationDetail.getSuspendTime()) != null) {
            suspendDuration += WfUtils.now().getTime() - suspendTime.getTime();
        }
        return suspendDuration;
    }

    @Override
    public long getSuspendDurationForUndoSuspendedByTaskId(Long taskId) {
        List<DurationDetailEntity> durationDetails = this.getDurationDetailsByTaskId(taskId);
        return this.getTotalSuspendDuration(durationDetails);
    }

    private long getTotalSuspendDuration(List<DurationDetailEntity> durationDetails) {
        long totalSuspendDuration = 0L;
        if (durationDetails != null && !durationDetails.isEmpty()) {
            for (DurationDetailEntity durationDetail : durationDetails) {
                Long suspendDuration = durationDetail.getSuspendDuration();
                totalSuspendDuration += suspendDuration.longValue();
            }
        }
        return totalSuspendDuration;
    }

    @Override
    public Long getSuspendDurationForUndoSuspendedByActivityInstId(Long activityInstId) {
        EntityQueryBuilder entityQueryBuilder = this.createQueryBuilder().addFilter("activityinstanceid", activityInstId);
        List<DurationDetailEntity> durationDetails = this.findByQueryBuilder(entityQueryBuilder);
        return this.getTotalSuspendDuration(durationDetails);
    }

    @Override
    public Long getManualSuspendDurationsCountByTaskId(Long taskId) {
        if (WfUtils.isEmpty(taskId)) {
            return 0L;
        }
        QFilter filter1 = new QFilter("taskid", "=", (Object)taskId);
        QFilter qFilter2 = new QFilter("type", "=", (Object)SuspendType.MANUALSUSPEND.getCode());
        QFilter qFilter3 = new QFilter("undosuspendtime", "is null", null);
        QFilter[] filters = new QFilter[]{filter1, qFilter2, qFilter3};
        return this.countByFilter("id", filters, true);
    }

    @Override
    public Map<String, String> getManualHangUpNodeIdsByProcInstId(Long processInstanceId) {
        QFilter filterProcInstId = new QFilter("processinstanceid", "=", (Object)processInstanceId);
        QFilter filterSuspendType = new QFilter("type", "=", (Object)SuspendType.MANUALSUSPEND.getCode());
        QFilter filterTime = new QFilter("undosuspendtime", "is null", null);
        QFilter[] filters = new QFilter[]{filterProcInstId, filterSuspendType, filterTime};
        EntityQueryBuilder entityQueryBuilder = this.createQueryBuilder().addFilters(filters);
        List durationDetails = this.findByQueryBuilder(entityQueryBuilder);
        HashMap<String, String> manualHangUpNodeIds = new HashMap<String, String>(durationDetails.size());
        for (DurationDetailEntity durationDetail : durationDetails) {
            manualHangUpNodeIds.put(durationDetail.getActivityId(), durationDetail.getErrorType());
        }
        return manualHangUpNodeIds;
    }
}

