/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.runtime;

import java.util.HashMap;
import java.util.List;
import kd.bos.workflow.bpmn.converter.util.CollectionUtils;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.persistence.CachedEntityMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.DynamicResourceByProcInstIdAndActivityIdEntityMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.DynamicResourceByProcessInstanceIdEntityMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricDynamicResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.DynamicResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.DynamicResourceEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.DynamicResourceEntityManager;

public class DynamicResourceEntityManagerImpl
extends AbstractEntityManager<DynamicResourceEntity>
implements DynamicResourceEntityManager {
    protected CachedEntityMatcher<DynamicResourceEntity> dynamicResourceByProcessInstanceIdMatcher = new DynamicResourceByProcessInstanceIdEntityMatcher();
    protected CachedEntityMatcher<DynamicResourceEntity> dynamicResourceByProcInstIdAndActivityIdMatcher = new DynamicResourceByProcInstIdAndActivityIdEntityMatcher();

    public DynamicResourceEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public Class<? extends DynamicResourceEntity> getManagedEntityClass() {
        return DynamicResourceEntityImpl.class;
    }

    @Override
    public String getSelectFields() {
        return "id,name,content,processDefineId,processInstanceId,activityId,activityInstanceId,createDate,modifyDate,type,ownerId,taskId";
    }

    @Override
    public void insert(DynamicResourceEntity dynamicResourceEntity, boolean fireCreateEvent) {
        super.insert(dynamicResourceEntity, fireCreateEvent);
        this.getHistoryManager().recordDynResourceCreated(dynamicResourceEntity);
    }

    @Override
    public DynamicResourceEntity update(DynamicResourceEntity dynamicResourceEntity, boolean fireCreateEvent) {
        dynamicResourceEntity = super.update(dynamicResourceEntity, fireCreateEvent);
        this.getHistoryManager().recordDynResourceUpdated(dynamicResourceEntity);
        return dynamicResourceEntity;
    }

    @Override
    public List<DynamicResourceEntity> findByProcessInstanceId(Long processInstanceId) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("processInstanceId", processInstanceId).orderBy("createDate asc");
        return this.findByQueryBuilder(eb, this.dynamicResourceByProcessInstanceIdMatcher, processInstanceId, true);
    }

    @Override
    public String getEntityName() {
        return "wf_dynamicresource";
    }

    @Override
    public DynamicResourceEntity findByActivityId(Long processInstanceId, String activityId) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(2);
        parameters.put("processInstanceId", processInstanceId);
        parameters.put("activityId", activityId);
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("processInstanceId", processInstanceId).addFilter("activityId", activityId);
        List<DynamicResourceEntity> list = this.findByQueryBuilder(eb, this.dynamicResourceByProcInstIdAndActivityIdMatcher, parameters, true);
        return list == null || list.size() == 0 ? null : list.get(0);
    }

    @Override
    public DynamicResourceEntity findByActivityIdAndType(Long processInstanceId, String activityId, String type) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("processInstanceId", processInstanceId).addFilter("activityId", activityId).addFilter("type", type);
        List list = this.findByQueryBuilder(eb);
        return list == null || list.size() == 0 ? null : (DynamicResourceEntity)list.get(0);
    }

    @Override
    public DynamicResourceEntity findByActivityInstId(Long processInstanceId, Long activityInstId) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("processInstanceId", processInstanceId).addFilter("activityInstanceId", activityInstId);
        List list = this.findByQueryBuilder(eb);
        return list == null || list.size() == 0 ? null : (DynamicResourceEntity)list.get(0);
    }

    @Override
    public boolean hasAddFreeFlow(Long processInstanceId, String activityId, String type) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("processInstanceId", processInstanceId).addFilter("type", type).addFilter("activityId", activityId);
        List list = this.findByQueryBuilder(eb);
        return CollectionUtils.isEmpty(list);
    }

    @Override
    public void delete(DynamicResourceEntity dynamicResource, String deleteReason, boolean cascade) {
        this.delete(dynamicResource);
        if (cascade) {
            this.getHistoricDynamicResourceEntityManager().delete(dynamicResource.getId());
        } else {
            HistoricDynamicResourceEntity historicDynamicResource = (HistoricDynamicResourceEntity)this.getHistoricDynamicResourceEntityManager().findById(dynamicResource.getId());
            if (historicDynamicResource != null) {
                historicDynamicResource.markEnded(deleteReason);
                this.getHistoricDynamicResourceEntityManager().update(historicDynamicResource);
            }
        }
    }

    @Override
    public List<DynamicResourceEntity> findByProinstIds(List<Long> proinstIds) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("processInstanceId", "in", proinstIds);
        List<DynamicResourceEntity> list = this.findByQueryBuilder(eb);
        return list;
    }
}

