/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.runtime;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.event.EventLogEntry;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.EventLogEntryEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.EventLogEntryEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.EventLogEntryEntityManager;

public class EventLogEntryEntityManagerImpl
extends AbstractEntityManager<EventLogEntryEntity>
implements EventLogEntryEntityManager {
    private static Log logger = LogFactory.getLog(EventLogEntryEntityManagerImpl.class);

    public EventLogEntryEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public Class<? extends EventLogEntryEntity> getManagedEntityClass() {
        return EventLogEntryEntityImpl.class;
    }

    @Override
    public void insert(EventLogEntryEntity entity, boolean fireCreateEvent) {
        super.insert(entity, fireCreateEvent);
    }

    @Override
    public String getSelectFields() {
        return "id,type,processDefinitionId,jobId,billNo,processInstanceId,executionId,taskId,timeStamp,userId,data,businessKey,srcjobid,traceno,jobtype,elementId,createDate,modifyDate";
    }

    @Override
    public List<EventLogEntry> findAllEventLogEntries() {
        QFilter[] filters = new QFilter[]{};
        String selectFileds = this.getSelectFields();
        String orderby = "id asc";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"wf_eventlogentry.findAllEventLogEntries", (String)"wf_eventlogentry", (String)selectFileds, (QFilter[])filters, (String)orderby);){
            List<EventLogEntry> eventLogEntry;
            List<EventLogEntry> list = eventLogEntry = this.createEntityByDataSet(ds);
            return list;
        }
    }

    @Override
    public List<EventLogEntry> findEventLogEntries(long startLogNr, long pageSize) {
        QFilter filter1 = new QFilter("id", ">", (Object)startLogNr);
        QFilter filter2 = new QFilter("id", "<", (Object)(pageSize + startLogNr + 1L));
        QFilter[] filters = new QFilter[]{filter1, filter2};
        String selectFileds = this.getSelectFields();
        String orderby = "id asc";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"wf_eventlogentry.findEventLogEntries", (String)"wf_eventlogentry", (String)selectFileds, (QFilter[])filters, (String)orderby);){
            List<EventLogEntry> eventLogEntry;
            List<EventLogEntry> list = eventLogEntry = this.createEntityByDataSet(ds);
            return list;
        }
    }

    @Override
    public List<EventLogEntry> findEventLogEntriesByProcessInstanceId(Long processInstanceId) {
        QFilter filter1 = new QFilter("processInstanceId", "=", (Object)processInstanceId);
        QFilter[] filters = new QFilter[]{filter1};
        String selectFileds = this.getSelectFields();
        String orderby = "id asc";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"wf_eventlogentry.findEventLogEntriesByProcessInstanceId", (String)"wf_eventlogentry", (String)selectFileds, (QFilter[])filters, (String)orderby);){
            List<EventLogEntry> eventLogEntry;
            List<EventLogEntry> list = eventLogEntry = this.createEntityByDataSet(ds);
            return list;
        }
    }

    @Override
    public void deleteEventLogEntry(long logNr) {
        QFilter q = new QFilter("id", "=", (Object)String.valueOf(logNr));
        QFilter[] qFilters = new QFilter[]{q};
        this.deleteByFilters(qFilters);
    }

    @Override
    public void deleteLogsByBusinessKey(String busKey) {
        QFilter[] qFilters = new QFilter[]{new QFilter("businessKey", "=", (Object)busKey)};
        this.deleteByFilters(qFilters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<EventLogEntry> createEntityByDataSet(DataSet ds) {
        ArrayList<EventLogEntry> eventLogEntry = new ArrayList<EventLogEntry>();
        try {
            for (Row row : ds) {
                EventLogEntryEntityImpl modelEntity = new EventLogEntryEntityImpl();
                modelEntity.setId((Long)row.get("FID"));
                modelEntity.setType((String)row.get("FTYPE"));
                modelEntity.setProcessDefinitionId((Long)row.get("FPROCDEFID"));
                modelEntity.setProcessInstanceId((Long)row.get("FPROCINSTID"));
                modelEntity.setExecutionId((Long)row.get("FEXECUTIONID"));
                modelEntity.setTaskId((Long)row.get("FTASKID"));
                modelEntity.setJobId((Long)row.get("FJOBID"));
                modelEntity.setTimeStamp((Date)row.get("FTIMESTAMP"));
                eventLogEntry.add(modelEntity);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            ds.close();
        }
        return eventLogEntry;
    }

    @Override
    @Deprecated
    public void deleteLogsByJob(JobEntity timerEntity) {
        if (timerEntity == null || WfUtils.isEmpty(timerEntity.getBusinessKey())) {
            return;
        }
    }
}

