/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.Signal;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.event.EventHandler;
import kd.bos.workflow.engine.impl.persistence.CachedEntityMatcher;
import kd.bos.workflow.engine.impl.persistence.CountingExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.EventSubscriptionActivityIdMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.EventSubscriptionsByExecutionAndTypeMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.EventSubscriptionsByExecutionIdMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.EventSubscriptionsByProcInstTypeAndActivityMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.MessageEventSubscriptionsByProcInstAndEventNameMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.SignalEventSubscriptionByEventNameMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.SignalEventSubscriptionByNameAndExecutionMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.SignalEventSubscriptionByProcInstAndEventNameMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ManagementConstants;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.CompensateEventSubscriptionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.CompensateEventSubscriptionEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.EventSubscriptionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.EventSubscriptionEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.EventSubscriptionEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.MessageEventSubscriptionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.MessageEventSubscriptionEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.SignalEventSubscriptionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.SignalEventSubscriptionEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.WaitActionsEventSubscriptionEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.WaitEventSubscriptionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.WaitEventSubscriptionEntityImpl;
import kd.bos.workflow.exception.WFEngineException;

public class EventSubscriptionEntityManagerImpl
extends AbstractEntityManager<EventSubscriptionEntity>
implements EventSubscriptionEntityManager {
    private static final String SIGNAL = "signal";
    private static final String MESSAGE = "message";
    private static List<Class<? extends EventSubscriptionEntity>> ENTITY_SUBCLASSES = new ArrayList<Class<? extends EventSubscriptionEntity>>();
    protected CachedEntityMatcher<EventSubscriptionEntity> eventSubscritionsByExecutionIdMatcher = new EventSubscriptionsByExecutionIdMatcher();
    protected CachedEntityMatcher<EventSubscriptionEntity> eventSubscriptionsByProcInstTypeAndActivityMatcher = new EventSubscriptionsByProcInstTypeAndActivityMatcher();
    protected CachedEntityMatcher<EventSubscriptionEntity> eventSubscriptionsByExecutionAndTypeMatcher = new EventSubscriptionsByExecutionAndTypeMatcher();
    protected CachedEntityMatcher<EventSubscriptionEntity> signalEventSubscriptionByNameAndExecutionMatcher = new SignalEventSubscriptionByNameAndExecutionMatcher();
    protected CachedEntityMatcher<EventSubscriptionEntity> signalEventSubscriptionByProcInstAndEventNameMatcher = new SignalEventSubscriptionByProcInstAndEventNameMatcher();
    protected CachedEntityMatcher<EventSubscriptionEntity> signalEventSubscriptionByEventNameMatcher = new SignalEventSubscriptionByEventNameMatcher();
    protected CachedEntityMatcher<EventSubscriptionEntity> messageEventSubscriptionsByProcInstAndEventNameMatcher = new MessageEventSubscriptionsByProcInstAndEventNameMatcher();
    protected CachedEntityMatcher<EventSubscriptionEntity> activityIdMatcher = new EventSubscriptionActivityIdMatcher();

    public EventSubscriptionEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
        processEngineConfiguration.mapToEntityMgr("wf_eventsubscription", SignalEventSubscriptionEntityImpl.class, this);
        processEngineConfiguration.mapToEntityMgr("wf_eventsubscription", MessageEventSubscriptionEntityImpl.class, this);
        processEngineConfiguration.mapToEntityMgr("wf_eventsubscription", CompensateEventSubscriptionEntityImpl.class, this);
        processEngineConfiguration.mapToEntityMgr("wf_eventsubscription", WaitEventSubscriptionEntityImpl.class, this);
        processEngineConfiguration.mapToEntityMgr("wf_eventsubscription", WaitActionsEventSubscriptionEntityImpl.class, this);
    }

    @Override
    public Class<? extends EventSubscriptionEntity> getManagedEntityClass() {
        return EventSubscriptionEntityImpl.class;
    }

    @Override
    public List<Class<? extends EventSubscriptionEntity>> getManagedEntitySubClasses() {
        return ENTITY_SUBCLASSES;
    }

    @Override
    public EventSubscriptionEntity create() {
        return new SignalEventSubscriptionEntityImpl();
    }

    @Override
    public EventSubscriptionEntity create(DynamicObject dynamicObject) {
        String type = dynamicObject.getString("eventType");
        if ("waitevent".equals(type)) {
            return new WaitEventSubscriptionEntityImpl(dynamicObject);
        }
        if ("waitactions".equals(type)) {
            return new WaitActionsEventSubscriptionEntityImpl(dynamicObject);
        }
        return new SignalEventSubscriptionEntityImpl(dynamicObject);
    }

    @Override
    public String getEntityName() {
        return "wf_eventsubscription";
    }

    @Override
    public CompensateEventSubscriptionEntity createCompensateEventSubscription() {
        return new CompensateEventSubscriptionEntityImpl();
    }

    @Override
    public MessageEventSubscriptionEntity createMessageEventSubscription() {
        return new MessageEventSubscriptionEntityImpl();
    }

    @Override
    public SignalEventSubscriptionEntity createSignalEventSubscription() {
        return new SignalEventSubscriptionEntityImpl();
    }

    @Override
    public WaitEventSubscriptionEntity createWaitEventSubscription() {
        return new WaitEventSubscriptionEntityImpl();
    }

    @Override
    public String getSelectFields() {
        return "id,eventType,eventName,executionId,processInstanceId,activityId,configuration,processDefinitionId,version,createdate,modifydate,businesskey";
    }

    @Override
    public SignalEventSubscriptionEntity insertSignalEvent(String signalName, Signal signal, ExecutionEntity execution) {
        SignalEventSubscriptionEntity subscriptionEntity = this.createSignalEventSubscription();
        subscriptionEntity.setExecution(execution);
        if (signal != null) {
            subscriptionEntity.setEventName(signal.getName());
            if (signal.getScope() != null) {
                subscriptionEntity.setConfiguration(signal.getScope());
            }
        } else {
            subscriptionEntity.setEventName(signalName);
        }
        subscriptionEntity.setActivityId(execution.getCurrentActivityId());
        subscriptionEntity.setProcessDefinitionId(execution.getProcessDefinitionId());
        this.insert(subscriptionEntity);
        execution.getEventSubscriptions().add(subscriptionEntity);
        return subscriptionEntity;
    }

    @Override
    public MessageEventSubscriptionEntity insertMessageEvent(String messageName, ExecutionEntity execution) {
        MessageEventSubscriptionEntity subscriptionEntity = this.createMessageEventSubscription();
        subscriptionEntity.setExecution(execution);
        subscriptionEntity.setEventName(messageName);
        subscriptionEntity.setActivityId(execution.getCurrentActivityId());
        subscriptionEntity.setProcessDefinitionId(execution.getProcessDefinitionId());
        this.insert(subscriptionEntity);
        execution.getEventSubscriptions().add(subscriptionEntity);
        return subscriptionEntity;
    }

    @Override
    public CompensateEventSubscriptionEntity insertCompensationEvent(ExecutionEntity execution, String activityId) {
        CompensateEventSubscriptionEntity eventSubscription = this.createCompensateEventSubscription();
        eventSubscription.setExecution(execution);
        eventSubscription.setActivityId(activityId);
        eventSubscription.setBusinesskey(execution.getBusinessKey());
        this.insert(eventSubscription);
        return eventSubscription;
    }

    @Override
    public WaitEventSubscriptionEntity insertWaitEventSubscription(ExecutionEntity execution, String activityId, String event) {
        WaitEventSubscriptionEntity subscriptionEntity = this.createWaitEventSubscription();
        subscriptionEntity.setExecution(execution);
        subscriptionEntity.setEventName(event);
        subscriptionEntity.setActivityId(activityId);
        this.insert(subscriptionEntity);
        return subscriptionEntity;
    }

    @Override
    public void insertWaitActionsEventSubscription(ExecutionEntity execution, String activityId, String event) {
        QFilter[] filters = new QFilter[]{new QFilter("executionId", "=", (Object)execution.getId()), new QFilter("activityId", "=", (Object)activityId), new QFilter("eventName", "=", (Object)event)};
        if (this.exist(filters)) {
            this.logger.debug(String.format("Already exists. executionId: %s, activityId: %s, eventName: %s", execution.getId(), activityId, event));
            return;
        }
        WaitActionsEventSubscriptionEntityImpl waitActionsEvent = new WaitActionsEventSubscriptionEntityImpl();
        waitActionsEvent.setExecution(execution);
        waitActionsEvent.setEventName(event);
        waitActionsEvent.setActivityId(activityId);
        this.insert(waitActionsEvent);
    }

    @Override
    public void insert(EventSubscriptionEntity entity, boolean fireCreateEvent) {
        CountingExecutionEntity executionEntity;
        super.insert(entity, fireCreateEvent);
        if (entity.getExecutionId() != null && this.isExecutionRelatedEntityCountEnabledGlobally() && this.isExecutionRelatedEntityCountEnabled(executionEntity = (CountingExecutionEntity)((Object)entity.getExecution()))) {
            executionEntity.setEventSubscriptionCount(executionEntity.getEventSubscriptionCount() + 1);
        }
    }

    @Override
    public void delete(EventSubscriptionEntity entity, boolean fireDeleteEvent) {
        CountingExecutionEntity executionEntity;
        if (entity.getExecutionId() != null && this.isExecutionRelatedEntityCountEnabledGlobally() && this.isExecutionRelatedEntityCountEnabled(executionEntity = (CountingExecutionEntity)((Object)entity.getExecution()))) {
            executionEntity.setEventSubscriptionCount(executionEntity.getEventSubscriptionCount() - 1);
        }
        super.delete(entity, fireDeleteEvent);
    }

    @Override
    public List<CompensateEventSubscriptionEntity> findCompensateEventSubscriptionsByExecutionId(Long executionId) {
        return this.findCompensateEventSubscriptionsByExecutionIdAndActivityId(executionId, null);
    }

    @Override
    public List<CompensateEventSubscriptionEntity> findCompensateEventSubscriptionsByExecutionIdAndActivityId(Long executionId, String activityId) {
        List<EventSubscriptionEntity> eventSubscriptions = this.findEventSubscriptionsByExecutionAndType(executionId, "compensate");
        ArrayList<CompensateEventSubscriptionEntity> result = new ArrayList<CompensateEventSubscriptionEntity>();
        for (EventSubscriptionEntity eventSubscriptionEntity : eventSubscriptions) {
            if (!(eventSubscriptionEntity instanceof CompensateEventSubscriptionEntity) || activityId != null && !activityId.equals(eventSubscriptionEntity.getActivityId())) continue;
            result.add((CompensateEventSubscriptionEntity)eventSubscriptionEntity);
        }
        return result;
    }

    @Override
    public List<CompensateEventSubscriptionEntity> findCompensateEventSubscriptionsByProcessInstanceId(Long processInstanceId) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("processInstanceId", processInstanceId).addFilter("eventType", "compensate");
        List entitys = this.findByQueryBuilder(eb);
        ArrayList<CompensateEventSubscriptionEntity> ret = new ArrayList<CompensateEventSubscriptionEntity>(entitys.size());
        for (EventSubscriptionEntity e : entitys) {
            ret.add(new CompensateEventSubscriptionEntityImpl(e.getDynamicObject()));
        }
        return ret;
    }

    @Override
    public List<CompensateEventSubscriptionEntity> findCompensateEventSubscriptionsByProcessInstanceIdAndActivityId(Long processInstanceId, String activityId) {
        List<EventSubscriptionEntity> eventSubscriptions = this.findEventSubscriptionsByProcessInstanceAndActivityId(processInstanceId, activityId, "compensate");
        List eventSubscriptionsInCache = this.getDbSqlSession().selectCachedEntitys(CompensateEventSubscriptionEntityImpl.class);
        ArrayList<CompensateEventSubscriptionEntity> result = new ArrayList<CompensateEventSubscriptionEntity>(eventSubscriptions.size());
        HashSet<Long> ids = new HashSet<Long>(eventSubscriptions.size() + eventSubscriptionsInCache.size());
        for (EventSubscriptionEntity eventSubscriptionEntity : eventSubscriptions) {
            ids.add(eventSubscriptionEntity.getId());
            result.add(new CompensateEventSubscriptionEntityImpl(eventSubscriptionEntity.getDynamicObject()));
        }
        for (EventSubscriptionEntity e : eventSubscriptionsInCache) {
            if (!ids.contains(e.getId()) && processInstanceId.equals(e.getProcessInstanceId()) && activityId.equals(e.getActivityId())) {
                result.add(new CompensateEventSubscriptionEntityImpl(e.getDynamicObject()));
            }
            ids.add(e.getId());
        }
        return result;
    }

    @Override
    public List<EventSubscriptionEntity> findCompensateEventSubscriptionsByProcessInstanceIdPksAndActivityId(Long procInstId, List<String> businesskeys, String activityId) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("processInstanceId", procInstId).addFilter("businesskey", "in", businesskeys).addFilter("activityId", activityId).addFilter("eventType", "compensate");
        return this.findByQueryBuilder(eb);
    }

    public List<EventSubscriptionEntity> findCompensateEventSubscriptionsByProcessInstanceIdAndActivityIdInCache(Long processInstanceId, String activityId) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("processInstanceId", processInstanceId).addFilter("activityId", activityId).addFilter("activityId", "compensate");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("processInstanceId", processInstanceId);
        map.put("activityId", activityId);
        map.put("activityId", "compensate");
        List<EventSubscriptionEntity> ret = this.getList(eb, this.activityIdMatcher, map, true);
        return ret;
    }

    protected void addToExecution(EventSubscriptionEntity eventSubscriptionEntity) {
        ExecutionEntity execution = eventSubscriptionEntity.getExecution();
        if (execution != null) {
            execution.getEventSubscriptions().add(eventSubscriptionEntity);
        }
    }

    @Override
    public List<EventSubscriptionEntity> findMessageEventSubscriptionsByProcessInstanceAndEventName(Long processInstanceId, String eventName) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("processInstanceId", processInstanceId).addFilter("eventName", eventName).addFilter("eventType", MESSAGE);
        return this.findByQueryBuilder(eb);
    }

    @Override
    public List<EventSubscriptionEntity> findMessageEventSubscriptionsByBusinessKey(String businessKey, String eventName) {
        String sql = " SELECT e.FID,e.FEVENTTYPE,e.FEVENTNAME,e.FEXECUTIONID,e.FPROCINSTID,e.FACTIVITYID,e.FPROCDEFID,e.FVERSION,e.FCONFIGURATION FROM t_wf_eventsubscr e, t_wf_execution b WHERE e.FEVENTTYPE=? and b.FISACTIVE='1' and e.FEXECUTIONID = b.fid and e.feventName = ? AND b.FBUSINESSKEY = ?";
        return this.findEntityBySQLFilter(sql, new Object[]{MESSAGE, eventName, businessKey});
    }

    @Override
    public List<EventSubscriptionEntity> findSignalEventSubscriptionsByEventName(String eventName, String version) {
        boolean latest = "_LAST_".equalsIgnoreCase(version);
        String vFilter = "";
        Object[] params = null;
        if (version != null && !latest) {
            vFilter = " EVT.FVERSION = ? AND ";
            params = new Object[]{version, SIGNAL, eventName, ManagementConstants.ACTIVE.getStateCode()};
        } else {
            params = new Object[]{SIGNAL, eventName, ManagementConstants.ACTIVE.getStateCode()};
        }
        String sql = "select EVT.FID,EVT.FEVENTTYPE,EVT.FEVENTNAME,EVT.FEXECUTIONID,EVT.FPROCINSTID,EVT.FACTIVITYID,EVT.FCONFIGURATION,EVT.FPROCDEFID,EVT.FVERSION,EVT.FCREATEDATE,EVT.FMODIFYDATE  from T_WF_EVENTSUBSCR EVT left outer join T_WF_EXECUTION EXC on EVT.FEXECUTIONID = EXC.FID where " + vFilter + " EVT.FEVENTTYPE = ? and EVT.FEVENTNAME = ? and ( (EVT.FEXECUTIONID =0 ) or (EVT.FEXECUTIONID <>0 AND EXC.FSUSPENSIONSTATE = ?) ) order by EVT.FVERSION DESC";
        List<EventSubscriptionEntity> list = this.findEntityBySQLFilter(sql, params);
        if (latest && list != null && !list.isEmpty()) {
            list = new ArrayList<EventSubscriptionEntity>(list.subList(0, 1));
        }
        return list;
    }

    @Override
    public List<EventSubscriptionEntity> findSignalEventSubscriptionsByProcessInstanceAndEventName(Long processInstanceId, String eventName) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("eventType", SIGNAL).addFilter("processInstanceId", processInstanceId).addFilter("eventName", eventName);
        return this.findByQueryBuilder(eb);
    }

    @Override
    public List<EventSubscriptionEntity> findSignalEventSubscriptionsByNameAndExecution(String name, Long executionId) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("eventType", SIGNAL).addFilter("eventName", name).addFilter("executionId", executionId);
        return this.findByQueryBuilder(eb);
    }

    @Override
    public List<EventSubscriptionEntity> findEventSubscriptionsByExecutionAndType(Long executionId, String type) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("executionId", executionId).addFilter("eventType", type);
        return this.findByQueryBuilder(eb);
    }

    @Override
    public List<EventSubscriptionEntity> findEventSubscriptionsByProcessInstanceAndActivityId(Long processInstanceId, String activityId, String type) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("processInstanceId", processInstanceId).addFilter("activityId", activityId).addFilter("eventType", type);
        return this.findByQueryBuilder(eb);
    }

    @Override
    public List<EventSubscriptionEntity> findEventSubscriptionsByExecution(Long executionId) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("executionId", executionId);
        return this.findByQueryBuilder(eb);
    }

    @Override
    public List<EventSubscriptionEntity> findEventSubscriptionsByTypeAndProcessDefinitionId(String type, Long processDefinitionId) {
        QFilter filter1 = new QFilter("processDefinitionId", "=", (Object)processDefinitionId);
        if (type != null) {
            QFilter filter2 = new QFilter("eventType", "=", (Object)type);
            filter1 = filter1.and(filter2);
        }
        QFilter filter3 = new QFilter("executionId", "=", (Object)0);
        QFilter filter4 = new QFilter("processInstanceId", "=", (Object)0);
        filter1 = filter1.and(filter3).and(filter4);
        QFilter[] qFilters = new QFilter[]{filter1};
        return this.findByQueryFilters(qFilters, this.getSelectFields(), null);
    }

    @Override
    public List<EventSubscriptionEntity> findEventSubscriptionsByName(String type, String eventName) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("eventType", type).addFilter("eventName", eventName);
        return this.findByQueryBuilder(eb);
    }

    @Override
    public List<EventSubscriptionEntity> findEventSubscriptionsByNameAndExecution(String type, String eventName, Long executionId) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("eventType", type).addFilter("eventName", eventName).addFilter("executionId", executionId);
        return this.findByQueryBuilder(eb);
    }

    @Override
    public List<EventSubscriptionEntity> findEventSubscriptionsByNameAndProcessInstanceId(String type, String eventName, Long processInstanceId) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("eventType", type).addFilter("eventName", eventName);
        if (WfUtils.isNotEmpty(processInstanceId)) {
            eb.addFilter("processInstanceId", processInstanceId);
        } else {
            eb.addFilter("processInstanceId", "!=", 0L);
        }
        return this.findByQueryBuilder(eb);
    }

    @Override
    public List<EventSubscriptionEntity> findEventSubscriptionsByNameAndBizTraceNo(String type, String eventName, String bizTraceNo) {
        QFilter[] filters = new QFilter[]{new QFilter("biztraceno", "=", (Object)bizTraceNo)};
        List procInsts = this.getHistoricProcessInstanceEntityManager().findByQueryFilters(filters, "id", null);
        if (procInsts.isEmpty()) {
            return new ArrayList<EventSubscriptionEntity>();
        }
        HashSet<Long> procInstIds = new HashSet<Long>(procInsts.size());
        for (HistoricProcessInstanceEntity entity : procInsts) {
            procInstIds.add(entity.getId());
        }
        EntityQueryBuilder queryBuilder = this.createQueryBuilder();
        queryBuilder.addFilter("processInstanceId", "in", procInstIds).addFilter("eventType", type).addFilter("eventName", eventName);
        return this.findByQueryBuilder(queryBuilder);
    }

    @Override
    public MessageEventSubscriptionEntity findMessageStartEventSubscriptionByName(String messageName) {
        QFilter filter1 = new QFilter("eventType", "=", (Object)MESSAGE);
        QFilter filter2 = new QFilter("eventName", "=", (Object)messageName);
        QFilter filter3 = QFilter.isNull((String)"executionId");
        filter1 = filter1.and(filter2).and(filter3);
        QFilter[] qFilters = new QFilter[]{filter1};
        return (MessageEventSubscriptionEntity)this.findOneByCondition(qFilters, this.getSelectFields(), null);
    }

    @Override
    public void deleteEventSubscriptionsForProcessDefinition(Long processDefinitionId) {
        QFilter filter1 = new QFilter("processDefinitionId", "=", (Object)processDefinitionId);
        QFilter filter2 = QFilter.isNull((String)"executionId");
        QFilter filter3 = QFilter.isNull((String)"processInstanceId");
        filter1 = filter1.and(filter2).and(filter3);
        QFilter[] qFilters = new QFilter[]{filter1};
        this.deleteByFilters(qFilters);
    }

    @Override
    public void deleteEventSubscriptionsByProcessDefinitionId(Long processDefinitionId) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("processDefinitionId", processDefinitionId);
        List list = this.findByQueryBuilder(eb);
        for (EventSubscriptionEntity entity : list) {
            this.delete(entity);
        }
    }

    @Override
    public void eventReceived(EventSubscriptionEntity eventSubscriptionEntity, Object payload, boolean processASync) {
        if (processASync) {
            this.scheduleEventAsync(eventSubscriptionEntity, payload);
        } else {
            this.processEventSync(eventSubscriptionEntity, payload);
        }
    }

    protected void processEventSync(EventSubscriptionEntity eventSubscriptionEntity, Object payload) {
        EventHandler eventHandler = this.getProcessEngineConfiguration().getEventHandler(eventSubscriptionEntity.getEventType());
        if (eventHandler == null) {
            throw new WFEngineException("Could not find eventhandler for event of type '" + eventSubscriptionEntity.getEventType() + "'.");
        }
        this.logger.debug("handle start event, type is " + eventHandler.getClass().getName() + ",payload is[" + payload + "]");
        eventHandler.handleEvent(eventSubscriptionEntity, payload, this.getCommandContext());
    }

    protected void scheduleEventAsync(EventSubscriptionEntity eventSubscriptionEntity, Object payload) {
        JobEntity message = this.getJobManager().createStartProcessMessageJobByEventScription(eventSubscriptionEntity, payload);
        this.getJobManager().scheduleAsyncJob(message);
        this.logger.debug(String.format("write local message table,id is %s", message.getId()));
    }

    protected List<SignalEventSubscriptionEntity> toSignalEventSubscriptionEntityList(List<EventSubscriptionEntity> result) {
        ArrayList<SignalEventSubscriptionEntity> signalEventSubscriptionEntities = new ArrayList<SignalEventSubscriptionEntity>(result.size());
        for (EventSubscriptionEntity eventSubscriptionEntity : result) {
            signalEventSubscriptionEntities.add((SignalEventSubscriptionEntity)eventSubscriptionEntity);
        }
        return signalEventSubscriptionEntities;
    }

    protected List<MessageEventSubscriptionEntity> toMessageEventSubscriptionEntityList(List<EventSubscriptionEntity> result) {
        ArrayList<MessageEventSubscriptionEntity> messageEventSubscriptionEntities = new ArrayList<MessageEventSubscriptionEntity>(result.size());
        for (EventSubscriptionEntity eventSubscriptionEntity : result) {
            messageEventSubscriptionEntities.add((MessageEventSubscriptionEntity)eventSubscriptionEntity);
        }
        return messageEventSubscriptionEntities;
    }

    static {
        ENTITY_SUBCLASSES.add(MessageEventSubscriptionEntityImpl.class);
        ENTITY_SUBCLASSES.add(SignalEventSubscriptionEntityImpl.class);
        ENTITY_SUBCLASSES.add(CompensateEventSubscriptionEntityImpl.class);
        ENTITY_SUBCLASSES.add(WaitEventSubscriptionEntityImpl.class);
        ENTITY_SUBCLASSES.add(WaitActionsEventSubscriptionEntityImpl.class);
    }
}

