/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.persistence.CachedEntityMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.ExecutionConversionProcInstMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExeConversionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExeConversionEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExeConversionEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;

public class ExeConversionEntityManagerImpl
extends AbstractEntityManager<ExeConversionEntity>
implements ExeConversionEntityManager {
    protected CachedEntityMatcher<ExeConversionEntity> procInstEntityMatcher = new ExecutionConversionProcInstMatcher();

    public ExeConversionEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public Class<? extends ExeConversionEntity> getManagedEntityClass() {
        return ExeConversionEntityImpl.class;
    }

    @Override
    public String getSelectFields() {
        return "srcexecutionid,srcbusinesskey,srcentitynumber,procinstid,activityid,bizcode,type,tagexecutionid,tagbusinesskey,tagentitynumber,createdate,modifydate";
    }

    @Override
    public String getEntityName() {
        return "bpm_execonversion";
    }

    @Override
    public List<ExeConversionEntity> recordExeConversionEntity(Collection<ExecutionEntity> originalExecutions, ExecutionEntity targetBillExe, String convertType) {
        ArrayList<ExeConversionEntity> exeConversions = new ArrayList<ExeConversionEntity>(originalExecutions.size());
        for (ExecutionEntity srcExecuteExe : originalExecutions) {
            ExeConversionEntity ret = (ExeConversionEntity)this.create();
            ret.setSrcBusinesskey(srcExecuteExe.getBusinessKey());
            ret.setProcinstId(srcExecuteExe.getProcessInstanceId());
            ret.setSrcEntityNumber(srcExecuteExe.getEntityNumber());
            ret.setSrcExecutionId(srcExecuteExe.getParentId());
            ret.setActivityId(targetBillExe.getCurrentActivityId());
            ret.setTagBusinesskey(targetBillExe.getBusinessKey());
            ret.setTagEntityNumber(targetBillExe.getEntityNumber());
            ret.setBizCode(srcExecuteExe.getBizTraceNo());
            this.insert(ret);
            exeConversions.add(ret);
        }
        return exeConversions;
    }

    private List<ExeConversionEntity> findExecutionConversionByProcInstAndActivityIdsIn(List<String> activityIds, Long procinstId) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("procinstid", procinstId).addFilter("activityid", "in", activityIds);
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("procinstid", procinstId);
        List<ExeConversionEntity> ret = this.getList(eb, this.procInstEntityMatcher, map, true);
        Iterator<ExeConversionEntity> iter = ret.iterator();
        while (iter.hasNext()) {
            ExeConversionEntity tmp = iter.next();
            if (activityIds.contains(tmp.getActivityId())) continue;
            iter.remove();
        }
        return ret;
    }

    @Override
    public List<String> getSourceBusinesskeys(List<String> pks, String sourceNodeId, String currenNodeId, Long procinstId) {
        FlowElement ele;
        Object nodeId;
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModelByProcInstId(procinstId);
        ArrayList<FlowElement> preNodes = new ArrayList<FlowElement>();
        preNodes.add(bpmnModel.getFlowElement(currenNodeId));
        preNodes.addAll(BpmnModelUtil.getPreviousNodes(bpmnModel, currenNodeId));
        ArrayList<String> throughNodes = new ArrayList<String>(preNodes.size() + 1);
        Iterator iterator = preNodes.iterator();
        while (iterator.hasNext() && !sourceNodeId.equals(nodeId = (ele = (FlowElement)iterator.next()).getId())) {
            throughNodes.add((String)nodeId);
        }
        if (throughNodes.isEmpty()) {
            return pks;
        }
        List<ExeConversionEntity> conversions = this.findExecutionConversionByProcInstAndActivityIdsIn(throughNodes, procinstId);
        if (conversions.isEmpty()) {
            return pks;
        }
        HashMap<String, ArrayList<ExeConversionEntity>> targetPkMapEntity = new HashMap<String, ArrayList<ExeConversionEntity>>(conversions.size());
        for (ExeConversionEntity ec : conversions) {
            String tagPk = ec.getTagBusinesskey();
            ArrayList<ExeConversionEntity> list = (ArrayList<ExeConversionEntity>)targetPkMapEntity.get(tagPk);
            if (list == null) {
                list = new ArrayList<ExeConversionEntity>();
                targetPkMapEntity.put(tagPk, list);
            }
            list.add(ec);
        }
        List<String> cycleSrcPks = pks;
        List<String> nextCycleSrcPks = new ArrayList<String>();
        String lastNode = (String)throughNodes.get(throughNodes.size() - 1);
        int i = 0;
        while (i < 20) {
            ++i;
            boolean flag = false;
            for (String pk : cycleSrcPks) {
                List sourceExeConversion = (List)targetPkMapEntity.get(pk);
                if (sourceExeConversion == null) continue;
                for (ExeConversionEntity ecs : sourceExeConversion) {
                    nextCycleSrcPks.add(ecs.getSrcBusinesskey());
                    flag = flag || lastNode.equals(ecs.getActivityId());
                }
            }
            if (flag || nextCycleSrcPks.isEmpty()) break;
            cycleSrcPks = nextCycleSrcPks;
            nextCycleSrcPks = new ArrayList();
        }
        if (nextCycleSrcPks.isEmpty()) {
            nextCycleSrcPks = cycleSrcPks;
        }
        return nextCycleSrcPks;
    }

    @Override
    public List<ExeConversionEntity> getSourceExeConversionEntities(Long processInstanceId, String tagEntityNumber, String tagBusinessKey) {
        EntityQueryBuilder qb = this.createQueryBuilder().addFilter("procinstid", "=", processInstanceId).addFilter("tagentitynumber", "=", tagEntityNumber).addFilter("tagbusinesskey", "=", tagBusinessKey);
        return this.findByQueryBuilder(qb);
    }

    @Override
    public Map<String, HashSet<Long>> getSourceBusinesskeys(Long procInstId, String targetEntityNumber, String targetBusinesskey) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("procinstid", procInstId).addFilter("tagentitynumber", "=", targetEntityNumber).addFilter("tagbusinesskey", "=", targetBusinesskey);
        List ecs = this.findByQueryBuilder(eb);
        HashMap<String, HashSet<Long>> srcPks = new HashMap<String, HashSet<Long>>(ecs.size());
        for (ExeConversionEntity ec : ecs) {
            HashSet<Long> pks = new HashSet<Long>();
            HashSet cachedPks = srcPks.putIfAbsent(ec.getSrcEntityNumber(), pks);
            if (cachedPks != null) {
                pks = cachedPks;
            }
            pks.add(Long.valueOf(ec.getSrcBusinesskey()));
        }
        return srcPks;
    }

    @Override
    public List<String> getAllConversionBusinesskeys(Long procinstId) {
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(procinstId);
        return new ArrayList<String>(this.getAllConversionBusinessKeysByProcinsts(ids));
    }

    private Set<String> getAllConversionBusinessKeysByProcinsts(List<Long> procinstIds) {
        QFilter filter = new QFilter("procinstid", "in", procinstIds);
        List conversions = this.findByQueryFilters(new QFilter[]{filter}, String.format("%s,%s,%s", "procinstid", "tagbusinesskey", "srcbusinesskey"), "");
        HashSet<String> pks = new HashSet<String>(conversions.size());
        for (ExeConversionEntity c : conversions) {
            String srcPk = c.getSrcBusinesskey();
            String tagPk = c.getTagBusinesskey();
            if (WfUtils.isNotEmpty(srcPk)) {
                pks.add(srcPk);
            }
            if (!WfUtils.isNotEmpty(tagPk)) continue;
            pks.add(tagPk);
        }
        return pks;
    }

    @Override
    public List<ExeConversionEntity> findExecByTagBusinesskey(Set<String> targetBillIds) {
        QFilter[] qFilters = new QFilter[]{new QFilter("tagbusinesskey", "in", targetBillIds)};
        return this.findByQueryFilters(qFilters);
    }

    @Override
    public Set<String> getAllConversionBusinesskeys(String bizTraceNo) {
        QFilter[] qFilters = new QFilter[]{new QFilter("biztraceno", "=", (Object)bizTraceNo), new QFilter("processtype", "=", (Object)ModelType.BizFlow.name())};
        List hs = this.getHistoricProcessInstanceEntityManager().findByQueryFilters(qFilters, "id", null);
        ArrayList<Long> ids = new ArrayList<Long>();
        if (hs != null && !hs.isEmpty()) {
            for (HistoricProcessInstanceEntity entity : hs) {
                ids.add(entity.getId());
            }
            this.logger.debug(String.format("bizTraceNo:%s ids:%s", bizTraceNo, WfUtils.listToString(ids, ",")));
            return this.getAllConversionBusinessKeysByProcinsts(ids);
        }
        return Collections.emptySet();
    }

    @Override
    public Map<String, List<String>> getAllConversionEntityNumberAndBusinesskeys(Long procinstId) {
        QFilter filter = new QFilter("procinstid", "=", (Object)procinstId);
        List conversions = this.findByQueryFilters(new QFilter[]{filter}, String.format("%s,%s,%s,%s,%s", "procinstid", "srcentitynumber", "tagentitynumber", "tagbusinesskey", "srcbusinesskey"), "");
        HashMap<String, List<String>> result = new HashMap<String, List<String>>(conversions.size());
        for (ExeConversionEntity c : conversions) {
            ArrayList<String> tagBusinessKeys;
            String srcEntityNumber = c.getSrcEntityNumber();
            String tagEntityNumber = c.getTagEntityNumber();
            String srcPk = c.getSrcBusinesskey();
            String tagPk = c.getTagBusinesskey();
            ArrayList<String> srcBusinessKeys = (ArrayList<String>)result.get(srcEntityNumber);
            if (srcBusinessKeys == null) {
                srcBusinessKeys = new ArrayList<String>(1);
                result.put(srcEntityNumber, srcBusinessKeys);
            }
            if (WfUtils.isNotEmpty(srcPk) && !srcBusinessKeys.contains(srcPk)) {
                srcBusinessKeys.add(srcPk);
            }
            if ((tagBusinessKeys = (ArrayList<String>)result.get(tagEntityNumber)) == null) {
                tagBusinessKeys = new ArrayList<String>(1);
                result.put(tagEntityNumber, tagBusinessKeys);
            }
            if (!WfUtils.isNotEmpty(tagPk) || srcBusinessKeys.contains(tagPk)) continue;
            tagBusinessKeys.add(tagPk);
        }
        return result;
    }

    @Override
    public List<ExeConversionEntity> getAllConversionEntitys(List<Long> procinstIds) {
        if (WfUtils.isEmptyForCollection(procinstIds)) {
            return new ArrayList<ExeConversionEntity>(0);
        }
        QFilter filter = new QFilter("procinstid", "in", procinstIds);
        return this.findByQueryFilters(new QFilter[]{filter}, String.format("%s,%s,%s,%s,%s", "procinstid", "srcentitynumber", "tagentitynumber", "tagbusinesskey", "srcbusinesskey"), "");
    }
}

