/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.api.constants.WFTaskResultEnum;
import kd.bos.workflow.bpmn.model.ActivitiListener;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.bpmn.behavior.TaskBehaviorUtil;
import kd.bos.workflow.engine.impl.bpmn.helper.BPMNUtil;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.CountingExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.TimerJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ManagementConstants;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.EventSubscriptionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.VariableInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.VariableScopeImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityImpl;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.exception.WFEngineException;

@KSObject
public class ExecutionEntityImpl
extends VariableScopeImpl
implements ExecutionEntity,
CountingExecutionEntity,
AgentExecution {
    private Log logger = LogFactory.getLog(this.getClass());
    private static final long serialVersionUID = 1L;
    protected FlowElement currentFlowElement;
    protected ActivitiListener currentActivitiListener;
    private String wfPlugin;
    private Map<String, Object> wfPluginParams;
    protected TaskEntity currentTask;
    protected ExecutionEntityImpl processInstance;
    protected ExecutionEntityImpl parent;
    protected ExecutionEntityImpl superExecution;
    protected ExecutionEntityImpl subProcessInstance;
    protected ExecutionEntityImpl rootProcessInstance;
    protected List<ExecutionEntityImpl> executions;
    protected List<EventSubscriptionEntity> eventSubscriptions;
    protected List<JobEntity> jobs;
    protected List<TimerJobEntity> timerJobs;
    protected List<TaskEntity> tasks;
    protected List<IdentityLinkEntity> identityLinks;
    protected List<VariableInstanceEntity> queryVariables;
    protected String processDefinitionKey;
    protected String processDefinitionName;
    protected Integer processDefinitionVersion;
    protected Long deploymentId;
    protected String activityName;
    protected boolean forcedUpdate;
    protected String eventName;
    protected String deleteReason;
    protected boolean ended;

    public ExecutionEntityImpl() {
        this.dynamicObject.set("suspensionState", (Object)ManagementConstants.ACTIVE.getStateCode());
        this.dynamicObject.set("active", (Object)Boolean.TRUE);
        this.dynamicObject.set("scope", (Object)Boolean.TRUE);
    }

    public ExecutionEntityImpl(DynamicObject dynamicObject) {
        super(dynamicObject);
    }

    public static ExecutionEntityImpl createWithEmptyRelationshipCollections() {
        ExecutionEntityImpl execution = new ExecutionEntityImpl();
        execution.executions = new ArrayList<ExecutionEntityImpl>(1);
        execution.tasks = new ArrayList<TaskEntity>(1);
        execution.variableInstances = new HashMap(1);
        execution.jobs = new ArrayList<JobEntity>(1);
        execution.timerJobs = new ArrayList<TimerJobEntity>(1);
        execution.eventSubscriptions = new ArrayList<EventSubscriptionEntity>(1);
        execution.identityLinks = new ArrayList<IdentityLinkEntity>(1);
        return execution;
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>(28);
        persistentState.put("processDefinitionId", this.getProcessDefinitionId());
        persistentState.put("businessKey", this.getBusinessKey());
        persistentState.put("activityId", this.getActivityId());
        persistentState.put("active", this.isActive());
        persistentState.put("billexecution", this.isBillExecution());
        persistentState.put("scope", this.isScope());
        persistentState.put("eventScope", this.isEventScope());
        persistentState.put("parentId", this.getParentId());
        persistentState.put("name", this.getName());
        persistentState.put("multiInstanceRoot", this.isMultiInstanceRoot());
        persistentState.put("currentTaskId", this.getCurrentTaskId());
        persistentState.put("currentActInstId", this.getCurrentActInstId());
        persistentState.put("superExecutionId", this.getSuperExecutionId());
        persistentState.put("rootProcessInstanceId", this.getRootProcessInstanceId());
        persistentState.put("suspensionState", this.getSuspensionState());
        persistentState.put("startUserId", this.getStartUserId());
        persistentState.put("eventSubscriptionCount", this.getEventSubscriptionCount());
        persistentState.put("taskCount", this.getTaskCount());
        persistentState.put("jobCount", this.getJobCount());
        persistentState.put("timerJobCount", this.getTimerJobCount());
        persistentState.put("suspendedJobCount", this.getSuspendedJobCount());
        persistentState.put("deadLetterJobCount", this.getDeadLetterJobCount());
        persistentState.put("variableCount", this.getVariableCount());
        persistentState.put("identityLinkCount", this.getIdentityLinkCount());
        persistentState.put("activityName", this.getActivityName());
        persistentState.put("subject", this.getSubject());
        persistentState.put("schemeId", this.getSchemeId());
        persistentState.put("testingPlanId", this.getTestingPlanId());
        persistentState.put("businessid", this.getBusinessId());
        persistentState.put("starUserNameFormat", this.getStarUserNameFormat());
        persistentState.put("biztraceno", this.getBizTraceNo());
        persistentState.put("batchnumber", this.getBatchNumber());
        persistentState.put("processtype", this.getProcessType());
        persistentState.put("mainOrgId", this.getMainOrgId());
        persistentState.put("orgviewid", this.getOrgViewId());
        persistentState.put("aborttype", this.getAbortType());
        persistentState.put("issubprocess", this.isSubProcess());
        return persistentState;
    }

    @Override
    @KSMethod
    public FlowElement getCurrentFlowElement() {
        Long processDefinitionId;
        if (this.currentFlowElement == null && (processDefinitionId = this.getProcessInstance().getProcessDefinitionId()) != null) {
            Process process = ProcessDefinitionUtil.getProcess(processDefinitionId, this.getProcessInstanceId());
            this.currentFlowElement = process.getFlowElement(this.getCurrentActivityId(), true);
        }
        return this.currentFlowElement;
    }

    @Override
    public void setCurrentFlowElement(FlowElement currentFlowElement) {
        this.currentFlowElement = currentFlowElement;
        if (currentFlowElement != null) {
            this.dynamicObject.set("activityId", (Object)currentFlowElement.getId());
        } else {
            this.dynamicObject.set("activityId", null);
        }
    }

    @Override
    public ActivitiListener getCurrentActivitiListener() {
        return this.currentActivitiListener;
    }

    @Override
    public void setCurrentActivitiListener(ActivitiListener currentActivitiListener) {
        this.currentActivitiListener = currentActivitiListener;
    }

    public List<ExecutionEntityImpl> getExecutions() {
        this.ensureExecutionsInitialized();
        return this.executions;
    }

    @Override
    public void addChildExecution(ExecutionEntity executionEntity) {
        this.ensureExecutionsInitialized();
        this.executions.add((ExecutionEntityImpl)executionEntity);
    }

    protected void ensureExecutionsInitialized() {
        if (this.executions == null) {
            this.executions = Context.getCommandContext().getExecutionEntityManager().findChildExecutionsByParentExecutionId(this.getId());
        }
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute(name="businessKey")
    public String getBusinessKey() {
        String businessKey = this.dynamicObject.getString("businessKey");
        if (WfUtils.isEmpty(businessKey)) {
            businessKey = this.getProcessInstance().getBusinessKey();
        }
        return businessKey;
    }

    @Override
    public void setBusinessKey(String businessKey) {
        this.dynamicObject.set("businessKey", (Object)businessKey);
    }

    @Override
    public String getProcessInstanceBusinessKey() {
        return this.getProcessInstance().getBusinessKey();
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute(name="billno")
    public String getBillNo() {
        return this.dynamicObject.getString("billno");
    }

    @Override
    public void setBillNo(String billNo) {
        this.dynamicObject.set("billno", (Object)billNo);
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute(name="entityNumber")
    public String getEntityNumber() {
        String entityNumber = this.dynamicObject.getString("entityNumber");
        if (WfUtils.isEmpty(entityNumber)) {
            entityNumber = this.getProcessInstance().getEntityNumber();
        }
        return entityNumber;
    }

    @Override
    public void setEntityNumber(String entityNumber) {
        this.dynamicObject.set("entityNumber", (Object)entityNumber);
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute(name="processDefinitionId")
    public Long getProcessDefinitionId() {
        return this.normalizeId(this.dynamicObject.getLong("processDefinitionId"));
    }

    @Override
    public void setProcessDefinitionId(Long processDefinitionId) {
        this.dynamicObject.set("processDefinitionId", (Object)processDefinitionId);
    }

    @Override
    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    @Override
    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    @Override
    public String getProcessDefinitionName() {
        return this.processDefinitionName;
    }

    @Override
    public void setProcessDefinitionName(String processDefinitionName) {
        this.processDefinitionName = processDefinitionName;
    }

    @Override
    public Integer getProcessDefinitionVersion() {
        return this.processDefinitionVersion;
    }

    @Override
    public void setProcessDefinitionVersion(Integer processDefinitionVersion) {
        this.processDefinitionVersion = processDefinitionVersion;
    }

    @Override
    public Long getDeploymentId() {
        return this.deploymentId;
    }

    @Override
    public void setDeploymentId(Long deploymentId) {
        this.deploymentId = deploymentId;
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute(name="processInstanceId")
    public Long getProcessInstanceId() {
        return this.normalizeId(this.dynamicObject.getLong("processInstanceId"));
    }

    @Override
    public void setProcessInstanceId(Long processInstanceId) {
        this.dynamicObject.set("processInstanceId", (Object)processInstanceId);
    }

    @Override
    public ExecutionEntityImpl getProcessInstance() {
        this.ensureProcessInstanceInitialized();
        return this.processInstance;
    }

    protected void ensureProcessInstanceInitialized() {
        if (this.processInstance == null && WfUtils.isNotEmpty(this.getProcessInstanceId())) {
            this.processInstance = (ExecutionEntityImpl)Context.getCommandContext().getExecutionEntityManager().findById(this.getProcessInstanceId());
        }
    }

    @Override
    public void setProcessInstance(ExecutionEntity processInstance) {
        this.processInstance = (ExecutionEntityImpl)processInstance;
        if (processInstance != null) {
            this.dynamicObject.set("processInstanceId", (Object)this.processInstance.getId());
        }
    }

    @Override
    public boolean isProcessInstanceType() {
        return WfUtils.isEmpty(this.getParentId());
    }

    @Override
    @SimplePropertyAttribute(name="parentId")
    public Long getParentId() {
        return this.normalizeId(this.dynamicObject.getLong("parentId"));
    }

    @Override
    public void setParentId(Long parentId) {
        this.dynamicObject.set("parentId", (Object)parentId);
    }

    @Override
    public ExecutionEntityImpl getParent() {
        this.ensureParentInitialized();
        return this.parent;
    }

    protected void ensureParentInitialized() {
        if (this.parent == null && WfUtils.isNotEmpty(this.getParentId())) {
            this.parent = (ExecutionEntityImpl)Context.getCommandContext().getExecutionEntityManager().findById(this.getParentId());
        }
    }

    @Override
    public void setParent(ExecutionEntity parent) {
        this.parent = (ExecutionEntityImpl)parent;
        if (parent != null) {
            this.dynamicObject.set("parentId", (Object)parent.getId());
        } else {
            this.dynamicObject.set("parentId", null);
        }
    }

    @Override
    @SimplePropertyAttribute(name="superExecutionId")
    public Long getSuperExecutionId() {
        return this.normalizeId(this.dynamicObject.getLong("superExecutionId"));
    }

    @Override
    public void setSuperExecutionId(Long superExecutionId) {
        this.dynamicObject.set("superExecutionId", (Object)superExecutionId);
    }

    @Override
    public ExecutionEntityImpl getSuperExecution() {
        this.ensureSuperExecutionInitialized();
        return this.superExecution;
    }

    @Override
    public void setSuperExecution(ExecutionEntity superExecution) {
        this.superExecution = (ExecutionEntityImpl)superExecution;
        if (superExecution != null) {
            superExecution.setSubProcessInstance(null);
        }
        if (superExecution != null) {
            this.dynamicObject.set("superExecutionId", (Object)((ExecutionEntityImpl)superExecution).getId());
        } else {
            this.dynamicObject.set("superExecutionId", null);
        }
    }

    protected void ensureSuperExecutionInitialized() {
        if (this.superExecution == null && WfUtils.isNotEmpty(this.getSuperExecutionId())) {
            this.superExecution = (ExecutionEntityImpl)Context.getCommandContext().getExecutionEntityManager().findById(this.getSuperExecutionId());
        }
    }

    @Override
    public ExecutionEntityImpl getSubProcessInstance() {
        this.ensureSubProcessInstanceInitialized();
        return this.subProcessInstance;
    }

    @Override
    public void setSubProcessInstance(ExecutionEntity subProcessInstance) {
        this.subProcessInstance = (ExecutionEntityImpl)subProcessInstance;
    }

    protected void ensureSubProcessInstanceInitialized() {
        if (this.subProcessInstance == null) {
            this.subProcessInstance = (ExecutionEntityImpl)Context.getCommandContext().getExecutionEntityManager().findSubProcessInstanceBySuperExecutionId(this.getId());
        }
    }

    @Override
    public ExecutionEntity getRootProcessInstance() {
        this.ensureRootProcessInstanceInitialized();
        return this.rootProcessInstance;
    }

    protected void ensureRootProcessInstanceInitialized() {
        if (this.rootProcessInstance == null && WfUtils.isNotEmpty(this.getRootProcessInstanceId())) {
            this.rootProcessInstance = (ExecutionEntityImpl)Context.getCommandContext().getExecutionEntityManager().findById(this.getRootProcessInstanceId());
        }
    }

    @Override
    public void setRootProcessInstance(ExecutionEntity rootProcessInstance) {
        this.rootProcessInstance = (ExecutionEntityImpl)rootProcessInstance;
        if (rootProcessInstance != null) {
            this.dynamicObject.set("rootProcessInstanceId", (Object)rootProcessInstance.getId());
        } else {
            this.dynamicObject.set("rootProcessInstanceId", null);
        }
    }

    @Override
    @SimplePropertyAttribute(name="rootProcessInstanceId")
    public Long getRootProcessInstanceId() {
        return this.normalizeId(this.dynamicObject.getLong("rootProcessInstanceId"));
    }

    @Override
    public void setRootProcessInstanceId(Long rootProcessInstanceId) {
        this.dynamicObject.set("rootProcessInstanceId", (Object)rootProcessInstanceId);
    }

    @Override
    @KSMethod
    public TaskEntity getCurrentTask() {
        this.ensureCurrentTaskInitialized();
        return this.currentTask;
    }

    protected void ensureCurrentTaskInitialized() {
        if (this.currentTask == null && WfUtils.isNotEmpty(this.getCurrentTaskId())) {
            HistoricTaskInstanceEntity hiTask;
            try {
                this.currentTask = (TaskEntity)Context.getCommandContext().getTaskEntityManager().findById(this.getCurrentTaskId());
            }
            catch (Exception e) {
                this.logger.info(e.getMessage());
            }
            if (this.currentTask == null && (hiTask = (HistoricTaskInstanceEntity)Context.getCommandContext().getHistoricTaskInstanceEntityManager().findById(this.getCurrentTaskId())) != null) {
                String key;
                this.currentTask = new TaskEntityImpl(hiTask);
                this.currentTask.setExecution(this);
                BpmnModel model = ProcessDefinitionUtil.getBpmnModel(this.getProcessDefinitionId(), this.getProcessInstanceId());
                FlowElement elem = model.getFlowElement(this.getActivityId());
                Map<String, Object> tmp = Context.getCommandContext().getHistoricVariableInstanceEntityManager().findVariablesByTaskId(this.getCurrentTaskId());
                HashMap<String, Object> variables = new HashMap(tmp.size());
                if (elem instanceof UserTask) {
                    variables = TaskBehaviorUtil.processVariables(((UserTask)elem).getVariables(), elem);
                }
                if (tmp.get("dynParticipant") == null && tmp.get(key = hiTask.getTaskDefinitionKey().toLowerCase() + "assignparticipant") != null) {
                    variables.put("dynParticipant", tmp.get(key));
                    variables.put("CompositeDynParticipant", "TRUE");
                }
                for (Map.Entry<String, Object> entry : tmp.entrySet()) {
                    variables.put(entry.getKey(), entry.getValue());
                }
                this.currentTask.setTransientVariablesLocal(variables);
            }
        }
    }

    @Override
    public void setCurrentTask(TaskEntity currentTask) {
        this.currentTask = currentTask;
        if (currentTask != null && WfUtils.isNotEmpty(currentTask.getId())) {
            this.dynamicObject.set("currentTaskId", (Object)currentTask.getId());
        } else {
            this.dynamicObject.set("currentTaskId", null);
        }
    }

    @Override
    public void setCurrentTaskOnly(TaskEntity currentTask) {
        this.currentTask = currentTask;
    }

    @KSMethod
    @SimplePropertyAttribute(name="currentTaskId")
    public Long getCurrentTaskId() {
        return this.normalizeId(this.dynamicObject.getLong("currentTaskId"));
    }

    @Override
    public void setCurrentTaskId(Long currentTaskId) {
        this.dynamicObject.set("currentTaskId", (Object)currentTaskId);
    }

    @Override
    @SimplePropertyAttribute(name="currentActInstId")
    public Long getCurrentActInstId() {
        return this.normalizeId(this.dynamicObject.getLong("currentActInstId"));
    }

    @Override
    public void setCurrentActInstId(Long lastActInstId) {
        this.dynamicObject.set("currentActInstId", (Object)lastActInstId);
    }

    @KSMethod
    public Object getCurrentTaskResult(WFTaskResultEnum result) {
        if (this.getCurrentTask() != null) {
            return this.getCurrentTask().getVariable(result.name());
        }
        return this.getVariable(result.name());
    }

    @Override
    @SimplePropertyAttribute(name="scope")
    public boolean isScope() {
        return this.dynamicObject.getBoolean("scope");
    }

    @Override
    public void setScope(boolean isScope) {
        this.dynamicObject.set("scope", (Object)isScope);
    }

    @Override
    public void forceUpdate() {
        this.forcedUpdate = true;
    }

    @Override
    protected void initializeVariableInstanceBackPointer(VariableInstanceEntity variableInstance) {
        if (WfUtils.isNotEmpty(this.getProcessInstanceId())) {
            variableInstance.setProcessInstanceId(this.getProcessInstanceId());
        } else {
            variableInstance.setProcessInstanceId(this.getId());
        }
        variableInstance.setExecutionId(this.getId());
    }

    @Override
    protected Collection<VariableInstanceEntity> loadVariableInstances() {
        return Context.getCommandContext().getVariableInstanceEntityManager().findVariableInstancesByExecutionId(this.getId());
    }

    @Override
    protected VariableScopeImpl getParentVariableScope() {
        return this.getParent();
    }

    @Override
    protected ExecutionEntityImpl getSourceActivityExecution() {
        return this;
    }

    @Override
    protected VariableInstanceEntity createVariableInstance(String variableName, Object value, ExecutionEntity sourceActivityExecution) {
        VariableInstanceEntity result = super.createVariableInstance(variableName, value, sourceActivityExecution);
        return result;
    }

    @Override
    protected void updateVariableInstance(VariableInstanceEntity variableInstance, Object value, ExecutionEntity sourceActivityExecution) {
        super.updateVariableInstance(variableInstance, value, sourceActivityExecution);
    }

    @Override
    protected VariableInstanceEntity getSpecificVariable(String variableName) {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext == null) {
            throw new WFEngineException("lazy loading outside command context");
        }
        VariableInstanceEntity variableInstance = commandContext.getVariableInstanceEntityManager().findVariableInstanceByExecutionAndName(this.getId(), variableName);
        return variableInstance;
    }

    @Override
    protected List<VariableInstanceEntity> getSpecificVariables(Collection<String> variableNames) {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext == null) {
            throw new WFEngineException("lazy loading outside command context");
        }
        return commandContext.getVariableInstanceEntityManager().findVariableInstancesByExecutionAndNames(this.getId(), variableNames);
    }

    @Override
    public Map<String, Object> getProcessVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (this.queryVariables != null) {
            for (VariableInstanceEntity variableInstance : this.queryVariables) {
                if (variableInstance.getId() == null || variableInstance.getTaskId() != null) continue;
                variables.put(variableInstance.getName(), variableInstance.getValue());
            }
        }
        return variables;
    }

    public void setQueryVariables(List<VariableInstanceEntity> queryVariables) {
        this.queryVariables = queryVariables;
    }

    @Override
    public List<EventSubscriptionEntity> getEventSubscriptions() {
        this.ensureEventSubscriptionsInitialized();
        return this.eventSubscriptions;
    }

    protected void ensureEventSubscriptionsInitialized() {
        if (this.eventSubscriptions == null) {
            this.eventSubscriptions = Context.getCommandContext().getEventSubscriptionEntityManager().findEventSubscriptionsByExecution(this.getId());
            if (this.eventSubscriptions == null) {
                this.eventSubscriptions = new ArrayList<EventSubscriptionEntity>(0);
            }
        }
    }

    @Override
    public List<JobEntity> getJobs() {
        this.ensureJobsInitialized();
        return this.jobs;
    }

    protected void ensureJobsInitialized() {
        if (this.jobs == null || this.jobs.size() == 0) {
            this.jobs = Context.getCommandContext().getJobEntityManager().findJobsByExecutionId(this.getId());
            if (this.jobs == null) {
                this.jobs = new ArrayList<JobEntity>(0);
            }
        }
    }

    @Override
    public List<TimerJobEntity> getTimerJobs() {
        this.ensureTimerJobsInitialized();
        return this.timerJobs;
    }

    protected void ensureTimerJobsInitialized() {
        if (this.timerJobs == null) {
            this.timerJobs = Context.getCommandContext().getTimerJobEntityManager().findJobsByExecutionId(this.getId());
            if (this.timerJobs == null) {
                this.timerJobs = new ArrayList<TimerJobEntity>(0);
            }
        }
    }

    protected void ensureTasksInitialized() {
        if (this.tasks == null) {
            this.tasks = Context.getCommandContext().getTaskEntityManager().findTasksByExecutionId(this.getId());
            if (this.tasks == null) {
                this.tasks = new ArrayList<TaskEntity>(0);
            }
        }
    }

    @Override
    public List<TaskEntity> getTasks() {
        this.ensureTasksInitialized();
        return this.tasks;
    }

    @Override
    public List<IdentityLinkEntity> getIdentityLinks() {
        this.ensureIdentityLinksInitialized();
        return this.identityLinks;
    }

    protected void ensureIdentityLinksInitialized() {
        if (this.identityLinks == null) {
            this.identityLinks = Context.getCommandContext().getIdentityLinkEntityManager().findIdentityLinksByProcessInstanceId(this.getId());
            if (this.identityLinks == null) {
                this.identityLinks = new ArrayList<IdentityLinkEntity>(0);
            }
        }
    }

    @Override
    @SimplePropertyAttribute(name="activityId")
    public String getActivityId() {
        return this.dynamicObject.getString("activityId");
    }

    @Override
    public void setActivityId(String activityId) {
        this.dynamicObject.set("activityId", (Object)activityId);
    }

    @Override
    public String getCurrentActivityId() {
        return this.getActivityId();
    }

    @Override
    @SimplePropertyAttribute(name="billexecution")
    public boolean isBillExecution() {
        return this.dynamicObject.getBoolean("billexecution");
    }

    @Override
    public void setBillExecution(boolean isConcurrent) {
        this.dynamicObject.set("billexecution", (Object)isConcurrent);
    }

    @Override
    @SimplePropertyAttribute(name="active")
    public boolean isActive() {
        return this.dynamicObject.getBoolean("active");
    }

    @Override
    public void setActive(boolean isActive) {
        this.dynamicObject.set("active", (Object)isActive);
    }

    @Override
    public void inactivate() {
        this.setActive(Boolean.FALSE);
    }

    @Override
    @SimplePropertyAttribute(name="suspensionState")
    public String getSuspensionState() {
        return this.dynamicObject.getString("suspensionState");
    }

    @Override
    public void setSuspensionState(String suspensionState) {
        this.dynamicObject.set("suspensionState", (Object)suspensionState);
    }

    @Override
    public boolean isSuspended() {
        return this.dynamicObject.getString("suspensionState").equals(ManagementConstants.SUSPENDED.getStateCode());
    }

    @Override
    @SimplePropertyAttribute(name="eventScope")
    public boolean isEventScope() {
        return this.dynamicObject.getBoolean("eventScope");
    }

    @Override
    public void setEventScope(boolean isEventScope) {
        this.dynamicObject.set("eventScope", (Object)isEventScope);
    }

    @Override
    @SimplePropertyAttribute(name="multiInstanceRoot")
    public boolean isMultiInstanceRoot() {
        return this.dynamicObject.getBoolean("multiInstanceRoot");
    }

    @Override
    public void setMultiInstanceRoot(boolean isMultiInstanceRoot) {
        this.dynamicObject.set("multiInstanceRoot", (Object)isMultiInstanceRoot);
    }

    @Override
    @SimplePropertyAttribute(name="countEnabled")
    public boolean isCountEnabled() {
        return this.dynamicObject.getBoolean("countEnabled");
    }

    @Override
    public void setCountEnabled(boolean isCountEnabled) {
        this.dynamicObject.set("countEnabled", (Object)isCountEnabled);
    }

    @Override
    @SimplePropertyAttribute(name="name")
    public ILocaleString getName() {
        return this.dynamicObject.getLocaleString("name");
    }

    @Override
    public void setName(ILocaleString name) {
        this.dynamicObject.set("name", (Object)name);
    }

    @Override
    @SimplePropertyAttribute(name="description")
    public ILocaleString getDescription() {
        return this.dynamicObject.getLocaleString("description");
    }

    @Override
    public void setDescription(ILocaleString description) {
        this.dynamicObject.set("description", (Object)description);
    }

    @Override
    @SimplePropertyAttribute(name="lockTime")
    public Date getLockTime() {
        return this.dynamicObject.getDate("lockTime");
    }

    @Override
    public void setLockTime(Date lockTime) {
        this.dynamicObject.set("lockTime", (Object)lockTime);
    }

    @Override
    @SimplePropertyAttribute(name="startUserId")
    public Long getStartUserId() {
        return this.normalizeId(this.dynamicObject.getLong("startUserId"));
    }

    @Override
    public void setStartUserId(Long startUserId) {
        this.dynamicObject.set("startUserId", (Object)startUserId);
    }

    @Override
    @SimplePropertyAttribute(name="eventSubscriptionCount")
    public int getEventSubscriptionCount() {
        return this.dynamicObject.getInt("eventSubscriptionCount");
    }

    @Override
    public void setEventSubscriptionCount(int eventSubscriptionCount) {
        this.dynamicObject.set("eventSubscriptionCount", (Object)eventSubscriptionCount);
    }

    @Override
    @SimplePropertyAttribute(name="taskCount")
    public int getTaskCount() {
        return this.dynamicObject.getInt("taskCount");
    }

    @Override
    public void setTaskCount(int taskCount) {
        this.dynamicObject.set("taskCount", (Object)taskCount);
    }

    @Override
    @SimplePropertyAttribute(name="jobCount")
    public int getJobCount() {
        return this.dynamicObject.getInt("jobCount");
    }

    @Override
    public void setJobCount(int jobCount) {
        this.dynamicObject.set("jobCount", (Object)jobCount);
    }

    @Override
    @SimplePropertyAttribute(name="timerJobCount")
    public int getTimerJobCount() {
        return this.dynamicObject.getInt("timerJobCount");
    }

    @Override
    public void setTimerJobCount(int timerJobCount) {
        this.dynamicObject.set("timerJobCount", (Object)timerJobCount);
    }

    @Override
    @SimplePropertyAttribute(name="suspendedJobCount")
    public int getSuspendedJobCount() {
        return this.dynamicObject.getInt("suspendedJobCount");
    }

    @Override
    public void setSuspendedJobCount(int suspendedJobCount) {
        this.dynamicObject.set("suspendedJobCount", (Object)suspendedJobCount);
    }

    @Override
    @SimplePropertyAttribute(name="deadLetterJobCount")
    public int getDeadLetterJobCount() {
        return this.dynamicObject.getInt("deadLetterJobCount");
    }

    @Override
    public void setDeadLetterJobCount(int deadLetterJobCount) {
        this.dynamicObject.set("deadLetterJobCount", (Object)deadLetterJobCount);
    }

    @Override
    @SimplePropertyAttribute(name="variableCount")
    public int getVariableCount() {
        return this.dynamicObject.getInt("variableCount");
    }

    @Override
    public void setVariableCount(int variableCount) {
        this.dynamicObject.set("variableCount", (Object)variableCount);
    }

    @Override
    @SimplePropertyAttribute(name="identityLinkCount")
    public int getIdentityLinkCount() {
        return this.dynamicObject.getInt("identityLinkCount");
    }

    @Override
    public void setIdentityLinkCount(int identityLinkCount) {
        this.dynamicObject.set("identityLinkCount", (Object)identityLinkCount);
    }

    @Override
    public boolean isEnded() {
        return this.ended;
    }

    @Override
    public void setEnded(boolean isEnded) {
        this.ended = isEnded;
    }

    @Override
    @KSMethod
    public String getEventName() {
        return this.eventName;
    }

    @Override
    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    @Override
    public String getDeleteReason() {
        return this.deleteReason;
    }

    @Override
    public void setDeleteReason(String deleteReason) {
        this.deleteReason = deleteReason;
    }

    @Override
    @SimplePropertyAttribute(name="activityName")
    public ILocaleString getActivityName() {
        return this.dynamicObject.getLocaleString("activityName");
    }

    @Override
    public void setActivityName(ILocaleString activityName) {
        this.dynamicObject.set("activityName", (Object)activityName);
    }

    @Override
    public void setSubject(ILocaleString subject) {
        this.dynamicObject.set("subject", (Object)BPMNUtil.subStringSubject(subject));
    }

    @Override
    @SimplePropertyAttribute(name="subject")
    public ILocaleString getSubject() {
        return this.dynamicObject.getLocaleString("subject");
    }

    @Override
    public void setEntraBillName(ILocaleString entraBillName) {
        this.dynamicObject.set("entraBillName", (Object)entraBillName);
    }

    @Override
    @SimplePropertyAttribute(name="entraBillName")
    public ILocaleString getEntraBillName() {
        return this.dynamicObject.getLocaleString("entraBillName");
    }

    @Override
    public void setSchemeId(Long schemeId) {
        this.dynamicObject.set("schemeId", (Object)schemeId);
    }

    @Override
    @SimplePropertyAttribute(name="schemeId")
    public Long getSchemeId() {
        return this.normalizeId(this.dynamicObject.getLong("schemeId"));
    }

    @Override
    public void setMainOrgId(Long mainOrgId) {
        this.dynamicObject.set("mainOrgId", (Object)mainOrgId);
    }

    @Override
    @SimplePropertyAttribute(name="mainOrgId")
    public Long getMainOrgId() {
        return this.normalizeId(this.dynamicObject.getLong("mainOrgId"));
    }

    @Override
    @SimplePropertyAttribute(name="orgviewid")
    public String getOrgViewId() {
        return this.dynamicObject.getString("orgviewid");
    }

    @Override
    public void setOrgViewId(String orgViewId) {
        this.dynamicObject.set("orgviewid", (Object)orgViewId);
    }

    @Override
    public void setTestingPlanId(Long testingPlanId) {
        this.dynamicObject.set("testingPlanId", (Object)testingPlanId);
    }

    @Override
    @SimplePropertyAttribute(name="testingPlanId")
    public Long getTestingPlanId() {
        return this.normalizeId(this.dynamicObject.getLong("testingPlanId"));
    }

    @Override
    @SimplePropertyAttribute(name="creatorid")
    public Long getCreatorId() {
        Object creator = this.dynamicObject.get("creatorid");
        if (creator instanceof DynamicObject) {
            return this.normalizeId(((DynamicObject)creator).getLong("id"));
        }
        return this.normalizeId(this.dynamicObject.getLong("creatorid"));
    }

    @Override
    public void setCreatorId(Long creatorId) {
        this.dynamicObject.set("creatorid", (Object)creatorId);
    }

    @Override
    @SimplePropertyAttribute(name="modifierid")
    public Long getModifierId() {
        Object modifier = this.dynamicObject.get("modifierid");
        if (modifier instanceof DynamicObject) {
            return this.normalizeId(((DynamicObject)modifier).getLong("id"));
        }
        return this.normalizeId(this.dynamicObject.getLong("modifierid"));
    }

    @Override
    public void setModifierId(Long modifierId) {
        this.dynamicObject.set("modifierid", (Object)modifierId);
    }

    public String toString() {
        if (this.isProcessInstanceType()) {
            return "ProcessInstance[" + this.getId() + "]";
        }
        StringBuilder strb = new StringBuilder();
        if (this.isScope()) {
            strb.append("Scoped execution[ id '" + this.getId() + "' ]");
        } else if (this.isMultiInstanceRoot()) {
            strb.append("Multi instance root execution[ id '" + this.getId() + "' ]");
        } else {
            strb.append("Execution[ id '" + this.getId() + "' ]");
        }
        if (WfUtils.isNotEmpty(this.getActivityId())) {
            strb.append(" - activity '" + this.getActivityId());
        }
        if (WfUtils.isNotEmpty(this.getParentId())) {
            strb.append(" - parent '" + this.getParentId() + "'");
        }
        return strb.toString();
    }

    public List<Long> getCurrentApprover() {
        ArrayList<Long> approverIds = new ArrayList<Long>();
        TaskEntity task = this.getCurrentTask();
        if (task != null) {
            approverIds = new ArrayList(task.getParticipants());
        }
        return approverIds;
    }

    @Override
    public void setCurrentWFPlugin(String implementation) {
        this.wfPlugin = implementation;
    }

    @Override
    @KSMethod
    public String getCurrentWFPlugin() {
        return this.wfPlugin;
    }

    @Override
    public void setCurrentWFPluginParams(Map<String, Object> wfPluginParams) {
        this.wfPluginParams = wfPluginParams;
    }

    @Override
    @KSMethod
    public Map<String, Object> getCurrentWFPluginParams() {
        return this.wfPluginParams;
    }

    @KSMethod
    public List<Long> getAllApprover() {
        return this.getCurrentApprover();
    }

    @Override
    @SimplePropertyAttribute(name="biztraceno")
    public String getBizTraceNo() {
        return this.dynamicObject.getString("biztraceno");
    }

    @Override
    public void setBizTraceNo(String bizTraceNo) {
        this.dynamicObject.set("biztraceno", (Object)bizTraceNo);
    }

    @Override
    @SimplePropertyAttribute(name="billType")
    public String getBillType() {
        return this.dynamicObject.getString("billType");
    }

    @Override
    public void setBillType(String billType) {
        this.dynamicObject.set("billType", (Object)billType);
    }

    @Override
    @SimplePropertyAttribute(name="batchnumber")
    public String getBatchNumber() {
        return this.dynamicObject.getString("batchnumber");
    }

    @Override
    public void setBatchNumber(String batchNumber) {
        this.dynamicObject.set("batchnumber", (Object)WfUtils.subStringForMax(batchNumber, 255));
    }

    @Override
    @SimplePropertyAttribute(name="processtype")
    public String getProcessType() {
        return this.dynamicObject.getString("processtype");
    }

    @Override
    public void setProcessType(String processType) {
        this.dynamicObject.set("processtype", (Object)processType);
    }

    @Override
    public void setBusinessId(String businessId) {
        this.dynamicObject.set("businessid", (Object)businessId);
    }

    @Override
    @SimplePropertyAttribute(name="businessid")
    public String getBusinessId() {
        return this.dynamicObject.getString("businessid");
    }

    @Override
    @SimplePropertyAttribute(name="starUserNameFormat")
    public ILocaleString getStarUserNameFormat() {
        return this.dynamicObject.getLocaleString("starUserNameFormat");
    }

    @Override
    public void setStarUserNameFormat(ILocaleString starUserNameFormat) {
        this.dynamicObject.set("starUserNameFormat", (Object)WfUtils.subILocaleString(starUserNameFormat, 490));
    }

    public ExecutionEntityImpl clone() {
        ExecutionEntityImpl execution = new ExecutionEntityImpl();
        execution.setId(this.getId());
        execution.setActive(this.isActive());
        execution.setBusinessKey(this.getBusinessKey());
        execution.setProcessDefinitionId(this.getProcessDefinitionId());
        execution.setProcessDefinitionKey(this.getProcessDefinitionKey());
        execution.setProcessDefinitionName(this.getProcessDefinitionName());
        execution.setProcessDefinitionVersion(this.getProcessDefinitionVersion());
        execution.setDeploymentId(this.getDeploymentId());
        execution.setProcessInstance(this.getProcessInstance());
        execution.setParent(this.getParent());
        execution.setSuperExecution(this.getSuperExecution());
        execution.setSuperExecutionId(this.getSuperExecutionId());
        execution.setSubProcessInstance(this.getSubProcessInstance());
        execution.setRootProcessInstanceId(this.getRootProcessInstanceId());
        execution.setRootProcessInstance(this.getRootProcessInstance());
        execution.setProcessInstanceId(this.getProcessInstanceId());
        execution.setParentId(this.getParentId());
        execution.setEnded(this.isEnded());
        execution.setEventName(this.getEventName());
        execution.setDeleteReason(this.getDeleteReason());
        execution.setSuspensionState(this.getSuspensionState());
        execution.setEventScope(this.isEventScope());
        execution.setMultiInstanceRoot(this.isMultiInstanceRoot());
        if (this.getName() != null) {
            execution.setName(this.getName());
        }
        if (this.getDescription() != null) {
            execution.setDescription(this.getDescription());
        }
        execution.setLockTime(this.getLockTime());
        execution.setStartUserId(this.getStartUserId());
        execution.setBillNo(this.getBillNo());
        execution.setEntityNumber(this.getEntityNumber());
        execution.setCurrentTask(this.getCurrentTask());
        execution.setCurrentTaskId(this.getCurrentTaskId());
        execution.setActivityId(this.getActivityId());
        if (this.getActivityName() != null) {
            execution.setActivityName(this.getActivityName());
        }
        if (this.getSubject() != null) {
            execution.setSubject(this.getSubject());
        }
        if (this.getEntraBillName() != null) {
            execution.setEntraBillName(this.getEntraBillName());
        }
        execution.setSchemeId(this.getSchemeId());
        execution.setMainOrgId(this.getMainOrgId());
        execution.setOrgViewId(this.getOrgViewId());
        execution.setTestingPlanId(this.getTestingPlanId());
        execution.setBusinessId(this.getBusinessId());
        execution.setBizTraceNo(this.getBizTraceNo());
        execution.setBatchNumber(this.getBatchNumber());
        execution.setProcessType(this.getProcessType());
        execution.setAbortType(this.getAbortType());
        return execution;
    }

    @Override
    public ILocaleString getPresentAssignee() {
        return this.dynamicObject.getLocaleString("presentassignee");
    }

    @Override
    public void setPresentAssignee(ILocaleString presentAssignee) {
        this.dynamicObject.set("presentassignee", (Object)WfUtils.subILocaleString(presentAssignee, 1990));
    }

    @Override
    @SimplePropertyAttribute(name="aborttype")
    public int getAbortType() {
        return this.dynamicObject.getInt("aborttype");
    }

    @Override
    public void setAbortType(int abortType) {
        this.dynamicObject.set("aborttype", (Object)abortType);
    }

    @Override
    @SimplePropertyAttribute(name="priorityshow")
    public String getPriorityShow() {
        return this.dynamicObject.getString("priorityshow");
    }

    @Override
    public void setPriorityShow(String priorityShow) {
        this.dynamicObject.set("priorityshow", (Object)priorityShow);
    }

    @Override
    @SimplePropertyAttribute(name="issubprocess")
    public boolean isSubProcess() {
        return this.dynamicObject.getBoolean("issubprocess");
    }

    @Override
    public void setSubProcess(boolean isSubProcess) {
        this.dynamicObject.set("issubprocess", (Object)isSubProcess);
    }
}

