/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.runtime;

import java.lang.constant.Constable;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.engine.TableNameConstant;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.identity.UserInfo;
import kd.bos.workflow.engine.impl.asyncexecutor.JobManager;
import kd.bos.workflow.engine.impl.bpmn.behavior.TaskBehaviorUtil;
import kd.bos.workflow.engine.impl.bpmn.listener.ProcessInstanceFinishListener;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.cfg.PerformanceSettings;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cmd.precomputation.PreComputorHelper;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.params.EntityQueryParams;
import kd.bos.workflow.engine.impl.cmd.task.processassistant.ProcessAssistantUtil;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.db.BatchSQLInfo;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.DefaultCommandContextCloseListener;
import kd.bos.workflow.engine.impl.persistence.CachedEntityMatcher;
import kd.bos.workflow.engine.impl.persistence.CountingExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.SingleCachedEntityMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.ExecutionByProcessInstanceMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.ExecutionsByParentExecutionIdAndActivityIdEntityMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.ExecutionsByParentExecutionIdEntityMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.ExecutionsByProcessInstanceIdEntityMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.ExecutionsByRootProcessInstanceMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.InactiveExecutionsByProcInstMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.InactiveExecutionsInActivityAndProcInstMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.InactiveExecutionsInActivityMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.ProcessInstancesByProcessDefinitionMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.SubProcessInstanceExecutionBySuperExecutionIdMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.job.DeadLetterJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.DeadLetterJobEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.job.SuspendedJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.SuspendedJobEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.job.TimerJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.TimerJobEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ManagementConstants;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.SuspensionState;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.BillExecutionState;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.DynamicResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.DynamicResourceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.EventSubscriptionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.EventSubscriptionEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.VariableInstance;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.VariableInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.VariableInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityManager;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.RuntimeUtil;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.repository.ProcessDefinition;
import kd.bos.workflow.engine.runtime.Execution;
import kd.bos.workflow.engine.runtime.ProcessInstance;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.exception.WFObjectNotFoundException;
import kd.bos.workflow.service.impl.ThreadLocalVariables;

public class ExecutionEntityManagerImpl
extends AbstractEntityManager<ExecutionEntity>
implements ExecutionEntityManager {
    private static final String PROCESSINSTANCEID = "processInstanceId";
    private static final String ACTIVE = "active";
    private static final String INITIATORID = "initiatorId";
    private static final String CATEGORY = "category";
    protected static Log logger = LogFactory.getLog(ExecutionEntityManagerImpl.class);
    protected PerformanceSettings performanceSettings;
    protected CachedEntityMatcher<ExecutionEntity> executionsByParentIdMatcher = new ExecutionsByParentExecutionIdEntityMatcher();
    protected CachedEntityMatcher<ExecutionEntity> executionsByProcessInstanceIdMatcher = new ExecutionsByProcessInstanceIdEntityMatcher();
    protected SingleCachedEntityMatcher<ExecutionEntity> subProcessInstanceBySuperExecutionIdMatcher = new SubProcessInstanceExecutionBySuperExecutionIdMatcher();
    protected CachedEntityMatcher<ExecutionEntity> inactiveExecutionsInActivityAndProcInstMatcher = new InactiveExecutionsInActivityAndProcInstMatcher();
    protected CachedEntityMatcher<ExecutionEntity> inactiveExecutionsByProcInstMatcher = new InactiveExecutionsByProcInstMatcher();
    protected CachedEntityMatcher<ExecutionEntity> inactiveExecutionsInActivityMatcher = new InactiveExecutionsInActivityMatcher();
    protected CachedEntityMatcher<ExecutionEntity> executionByProcessInstanceMatcher = new ExecutionByProcessInstanceMatcher();
    protected CachedEntityMatcher<ExecutionEntity> executionsByRootProcessInstanceMatcher = new ExecutionsByRootProcessInstanceMatcher();
    protected CachedEntityMatcher<ExecutionEntity> executionsByParentExecutionIdAndActivityIdEntityMatcher = new ExecutionsByParentExecutionIdAndActivityIdEntityMatcher();
    protected CachedEntityMatcher<ExecutionEntity> processInstancesByProcessDefinitionMatcher = new ProcessInstancesByProcessDefinitionMatcher();

    public ExecutionEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
        this.performanceSettings = processEngineConfiguration.getPerformanceSettings();
    }

    @Override
    public Class<? extends ExecutionEntity> getManagedEntityClass() {
        return ExecutionEntityImpl.class;
    }

    @Override
    public ExecutionEntity create() {
        return ExecutionEntityImpl.createWithEmptyRelationshipCollections();
    }

    @Override
    public String getSelectFields() {
        return "id,processInstanceId,businessKey,processDefinitionId,activityId,currentActInstId,active,billexecution,scope,eventScope,multiInstanceRoot,parentId,superExecutionId,rootProcessInstanceId,suspensionState,name,startUserId,countEnabled,eventSubscriptionCount,taskCount,jobCount,timerJobCount,suspendedJobCount,deadLetterJobCount,variableCount,identityLinkCount,billno,entityNumber,currentTaskId,subject,activityName,entraBillName,mainOrgId,schemeId,testingPlanId,createdate,modifydate,creatorid,modifierid,biztraceno,billtype,businessid,batchnumber,processtype,orgviewid,starusernameformat,description,locktime,presentassignee,aborttype,priorityshow,issubprocess";
    }

    @Override
    public void delete(ExecutionEntity entity) {
        this.delete(entity, true);
    }

    @Override
    public void delete(ExecutionEntity entity, boolean fireDeleteEvent) {
        super.delete(entity, fireDeleteEvent);
        entity.setDeleted(true);
    }

    @Override
    public ExecutionEntity findSubProcessInstanceBySuperExecutionId(Long superExecutionId) {
        if (WfUtils.isEmpty(superExecutionId)) {
            return null;
        }
        if (this.performanceSettings.isEnableEagerExecutionTreeFetching()) {
            this.findByIdAndFetchExecutionTree(superExecutionId);
        }
        QFilter q1 = new QFilter("superExecutionId", "=", (Object)superExecutionId);
        QFilter q2 = new QFilter("scope", "=", (Object)Boolean.TRUE);
        QFilter[] qFilters = new QFilter[]{q1, q2};
        return (ExecutionEntity)this.findOneByCondition(qFilters, this.getSelectFields(), null);
    }

    @Override
    public List<ExecutionEntity> findChildExecutionsByParentExecutionId(Long parentExecutionId) {
        QFilter q1 = new QFilter("parentId", "=", (Object)parentExecutionId);
        QFilter[] qFilters = new QFilter[]{q1};
        EntityQueryBuilder qb = new EntityQueryBuilder(this.getEntityName(), qFilters, this.getSelectFields(), this.getManagedEntityClass());
        if (this.performanceSettings.isEnableEagerExecutionTreeFetching()) {
            this.findByIdAndFetchExecutionTree(parentExecutionId);
            return this.getListFromCache(this.executionsByParentIdMatcher, parentExecutionId);
        }
        return this.getList(qb, this.executionsByParentIdMatcher, parentExecutionId, true);
    }

    @Override
    public List<ExecutionEntity> findChildExecutionsByProcessInstanceId(Long processInstanceId) {
        QFilter q1 = new QFilter(PROCESSINSTANCEID, "=", (Object)processInstanceId);
        QFilter[] qFilters = new QFilter[]{q1};
        EntityQueryBuilder qb = new EntityQueryBuilder(this.getEntityName(), qFilters, this.getSelectFields(), this.getManagedEntityClass());
        if (this.performanceSettings.isEnableEagerExecutionTreeFetching()) {
            this.findByIdAndFetchExecutionTree(processInstanceId);
            return this.getListFromCache(this.executionsByProcessInstanceIdMatcher, processInstanceId);
        }
        return this.getList(qb, this.executionsByProcessInstanceIdMatcher, processInstanceId, true);
    }

    @Override
    public List<ExecutionEntity> findChildExecutionsBySuperExecId(Long processInstanceId) {
        QFilter q1 = new QFilter("superExecutionId", "=", (Object)processInstanceId);
        QFilter[] qFilters = new QFilter[]{q1};
        EntityQueryBuilder qb = new EntityQueryBuilder(this.getEntityName(), qFilters, this.getSelectFields(), this.getManagedEntityClass());
        if (this.performanceSettings.isEnableEagerExecutionTreeFetching()) {
            this.findByIdAndFetchExecutionTree(processInstanceId);
            return this.getListFromCache(this.executionsByProcessInstanceIdMatcher, processInstanceId);
        }
        return this.getList(qb, this.executionsByProcessInstanceIdMatcher, processInstanceId, true);
    }

    @Override
    public List<ExecutionEntity> findExecutionsByParentExecutionAndActivityIds(Long parentExecutionId, Collection<String> activityIds) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(2);
        parameters.put("parentExecutionId", parentExecutionId);
        parameters.put("activityIds", activityIds);
        EntityQueryBuilder qb = this.createQueryBuilder().addFilter("parentId", parentExecutionId).addFilter("activityId", "in", activityIds);
        if (this.performanceSettings.isEnableEagerExecutionTreeFetching()) {
            this.findByIdAndFetchExecutionTree(parentExecutionId);
            return this.getListFromCache(this.executionsByParentExecutionIdAndActivityIdEntityMatcher, parameters);
        }
        return this.getList(qb, this.executionsByParentExecutionIdAndActivityIdEntityMatcher, parameters, true);
    }

    @Override
    public ExecutionEntity findByRootProcessInstanceId(Long rootProcessInstanceId) {
        ArrayList<ExecutionEntity> executions = new ArrayList();
        EntityQueryBuilder qb = this.createQueryBuilder().addFilter("rootProcessInstanceId", rootProcessInstanceId);
        if (this.performanceSettings.isEnableEagerExecutionTreeFetching()) {
            this.findByIdAndFetchExecutionTree(rootProcessInstanceId);
            executions = this.getListFromCache(this.executionsByRootProcessInstanceMatcher, rootProcessInstanceId);
        } else {
            executions = this.getList(qb, this.executionsByRootProcessInstanceMatcher, rootProcessInstanceId, true);
        }
        return this.processExecutionTree(rootProcessInstanceId, executions);
    }

    @Override
    public List<ExecutionEntity> findExecutionsByRootProcessInstanceId(Long rootProcessInstanceId) {
        List<Object> executions = new ArrayList();
        EntityQueryBuilder qb = this.createQueryBuilder().addFilter("rootProcessInstanceId", rootProcessInstanceId);
        if (this.performanceSettings.isEnableEagerExecutionTreeFetching()) {
            this.findByIdAndFetchExecutionTree(rootProcessInstanceId);
            executions = this.getListFromCache(this.executionsByRootProcessInstanceMatcher, rootProcessInstanceId);
        } else {
            executions = this.getList(qb, this.executionsByRootProcessInstanceMatcher, rootProcessInstanceId, true);
        }
        return executions;
    }

    @Override
    public ExecutionEntity findProcessInstanceById(Long id) {
        return (ExecutionEntity)this.findById(id);
    }

    @Override
    public long getProcessInstanceCount(QFilter qfilter) {
        QFilter filter = new QFilter("scope", "=", (Object)"1");
        if (qfilter != null) {
            filter.and(qfilter);
        }
        return this.countByFilter("id", new QFilter[]{filter}, false);
    }

    @Override
    public Collection<ExecutionEntity> findInactiveExecutionsByProcessInstanceId(Long processInstanceId) {
        HashMap<String, Constable> params = new HashMap<String, Constable>(2);
        params.put(PROCESSINSTANCEID, processInstanceId);
        params.put(ACTIVE, Boolean.FALSE);
        EntityQueryBuilder qb = this.createQueryBuilder().addFilter(PROCESSINSTANCEID, processInstanceId).addFilter(ACTIVE, Boolean.FALSE);
        if (this.performanceSettings.isEnableEagerExecutionTreeFetching()) {
            this.findByIdAndFetchExecutionTree(processInstanceId);
            return this.getListFromCache(this.inactiveExecutionsByProcInstMatcher, params);
        }
        return this.getList(qb, this.inactiveExecutionsByProcInstMatcher, params, true);
    }

    @Override
    public Collection<ExecutionEntity> findInactiveExecutionsByActivityIdAndProcessInstanceId(String activityId, Long processInstanceId) {
        HashMap<String, Object> params = new HashMap<String, Object>(3);
        params.put("activityId", activityId);
        params.put(PROCESSINSTANCEID, processInstanceId);
        params.put(ACTIVE, Boolean.FALSE);
        EntityQueryBuilder qb = this.createQueryBuilder().addFilter("activityId", activityId).addFilter(PROCESSINSTANCEID, processInstanceId).addFilter(ACTIVE, Boolean.FALSE);
        if (this.performanceSettings.isEnableEagerExecutionTreeFetching()) {
            this.findByIdAndFetchExecutionTree(processInstanceId);
            return this.getListFromCache(this.inactiveExecutionsInActivityAndProcInstMatcher, params);
        }
        return this.getList(qb, this.inactiveExecutionsInActivityAndProcInstMatcher, params, true);
    }

    protected ExecutionEntity processExecutionTree(Long rootProcessInstanceId, List<ExecutionEntity> executions) {
        ExecutionEntity rootExecution = null;
        if (executions == null) {
            return rootExecution;
        }
        HashMap<Long, ExecutionEntity> executionMap = new HashMap<Long, ExecutionEntity>(executions.size());
        for (ExecutionEntity executionEntity : executions) {
            if (rootExecution == null && executionEntity != null && rootProcessInstanceId.equals(executionEntity.getId())) {
                rootExecution = executionEntity;
            }
            if (executionEntity == null || null == executionEntity.getId()) continue;
            executionMap.put(executionEntity.getId(), executionEntity);
        }
        for (ExecutionEntity executionEntity : executions) {
            if (executionEntity.getRootProcessInstanceId() != null) {
                executionEntity.setRootProcessInstance((ExecutionEntity)executionMap.get(executionEntity.getRootProcessInstanceId()));
            }
            if (executionEntity.getProcessInstanceId() != null) {
                executionEntity.setProcessInstance((ExecutionEntity)executionMap.get(executionEntity.getProcessInstanceId()));
            }
            if (executionEntity.getParentId() != null) {
                ExecutionEntity parentExecutionEntity = (ExecutionEntity)executionMap.get(executionEntity.getParentId());
                executionEntity.setParent(parentExecutionEntity);
                parentExecutionEntity.addChildExecution(executionEntity);
            }
            if (executionEntity.getSuperExecution() == null) continue;
            ExecutionEntity superExecutionEntity = (ExecutionEntity)executionMap.get(executionEntity.getSuperExecutionId());
            executionEntity.setSuperExecution(superExecutionEntity);
            superExecutionEntity.setSubProcessInstance(executionEntity);
        }
        return rootExecution;
    }

    @Override
    public ExecutionEntity createProcessInstanceExecution(ProcessDefinition processDefinition, String businessKey, String entityNumber, String initiator, Long schemeId, Long testingPlanId, Long rootProInstId, Long superExecutionId) {
        ExecutionEntity processInstanceExecution = this.create();
        if (this.isExecutionRelatedEntityCountEnabledGlobally()) {
            ((CountingExecutionEntity)((Object)processInstanceExecution)).setCountEnabled(true);
        }
        processInstanceExecution.setProcessDefinitionId(processDefinition.getId());
        processInstanceExecution.setProcessDefinitionKey(processDefinition.getKey());
        processInstanceExecution.setBusinessKey(businessKey);
        processInstanceExecution.setScope(true);
        if (initiator != null) {
            long t = Long.parseLong(initiator);
            processInstanceExecution.setStartUserId(t);
            processInstanceExecution.setCreatorId(t);
            processInstanceExecution.setModifierId(t);
        }
        if (WfUtils.isNotEmpty(schemeId)) {
            processInstanceExecution.setSchemeId(schemeId);
        }
        if (WfUtils.isNotEmpty(testingPlanId)) {
            processInstanceExecution.setTestingPlanId(testingPlanId);
        }
        processInstanceExecution.setEntityNumber(entityNumber);
        Map<String, Object> entityProperties = WfUtils.getEntityProperties(entityNumber, businessKey);
        if (!entityProperties.isEmpty()) {
            LocaleString entityName;
            String billType = (String)entityProperties.get("billType");
            if (WfUtils.isNotEmpty(billType)) {
                processInstanceExecution.setBillType(billType);
            }
            if (WfUtils.isNotEmpty((ILocaleString)(entityName = (LocaleString)entityProperties.get("entityName")))) {
                processInstanceExecution.setEntraBillName((ILocaleString)entityName);
            }
        }
        DynamicObject dynObj = WfUtils.findBusinessObject(businessKey, entityNumber, null);
        String billNo = "";
        try {
            billNo = TaskBehaviorUtil.getTaskBillNo(entityNumber, dynObj);
            processInstanceExecution.setBillNo(billNo);
        }
        catch (Exception e) {
            logger.info(String.format("\u5b9e\u4f53[%s],id[%s]\u67e5\u8be2\u4e0d\u51fabillno\u6216\u8005name\u5c5e\u6027,error:[%s]", entityNumber, businessKey, WfUtils.getExceptionStacktrace(e)));
        }
        try {
            Long org = TaskBehaviorUtil.getMainOrgId(entityNumber, dynObj);
            if (org != null) {
                processInstanceExecution.setMainOrgId(org);
            }
            String orgViewId = TaskBehaviorUtil.getMainOrgViewId(entityNumber, dynObj);
            processInstanceExecution.setOrgViewId(orgViewId);
        }
        catch (Exception e) {
            logger.info(String.format("\u5b9e\u4f53[%s],id[%s]\u67e5\u8be2\u4e0d\u51faorg\u5c5e\u6027,error:[%s]", entityNumber, businessKey, WfUtils.getExceptionStacktrace(e)));
        }
        ILocaleString nameField = this.getProcessName((ProcessDefinitionEntity)processDefinition, schemeId, billNo);
        processInstanceExecution.setName(nameField);
        this.insert(processInstanceExecution, false);
        processInstanceExecution.setProcessInstanceId(processInstanceExecution.getId());
        processInstanceExecution.setRootProcessInstanceId(processInstanceExecution.getId());
        if (WfUtils.isNotEmpty(rootProInstId)) {
            processInstanceExecution.setRootProcessInstanceId(rootProInstId);
        } else {
            processInstanceExecution.setRootProcessInstanceId(processInstanceExecution.getId());
        }
        if (WfUtils.isNotEmpty(superExecutionId)) {
            processInstanceExecution.setSuperExecutionId(superExecutionId);
        }
        processInstanceExecution.setProcessType(((ProcessDefinitionEntityImpl)processDefinition).getType());
        if (initiator != null) {
            this.getIdentityLinkEntityManager().addIdentityLink(processInstanceExecution, (Long)Long.parseLong(initiator), "starter");
        }
        if (this.getEventDispatcher().isEnabled()) {
            this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_CREATED, processInstanceExecution));
        }
        return processInstanceExecution;
    }

    private ILocaleString getProcessName(ProcessDefinitionEntity procDefEntity, Long schemeId, String billNo) {
        DynamicConfigSchemeEntity dc = (DynamicConfigSchemeEntity)Context.getCommandContext().getDynamicConfigSchemeEntityManager().findById(schemeId);
        String key = procDefEntity.getKey();
        String version = procDefEntity.getVersion();
        LocaleString nameField = null;
        ILocaleString schemeName = null;
        if (dc != null && WfUtils.isNotEmpty(schemeName = dc.getName())) {
            nameField = new LocaleString();
            for (Lang lang : WfMultiLangUtils.getSupportLangs()) {
                String schemeNameStr = (String)schemeName.get((Object)lang.name());
                if (WfUtils.isEmpty(schemeNameStr)) {
                    schemeNameStr = WfUtils.isEmpty((String)schemeName.get((Object)"GLang")) ? schemeName.toString() : (String)schemeName.get((Object)"GLang");
                }
                nameField.put((Object)lang.name(), (Object)this.getFormattedName(billNo, key, version, schemeNameStr));
            }
        } else {
            nameField = new LocaleString(this.getFormattedName(billNo, key, version, ""));
        }
        return nameField;
    }

    @Override
    public ILocaleString getProcessName(Long processDefinitionId, Long schemeId, String billNo) {
        ProcessDefinitionEntity def = (ProcessDefinitionEntity)Context.getCommandContext().getProcessDefinitionEntityManager().findById(processDefinitionId, String.format("%s,%s", "version", "key"));
        return this.getProcessName(def, schemeId, billNo);
    }

    private String getFormattedName(String billNo, String key, String version, String scheme) {
        return String.format("%s/%s/%s/%s", billNo, key, version, scheme);
    }

    @Override
    public ExecutionEntity createChildExecution(ExecutionEntity parentExecutionEntity) {
        ExecutionEntity childExecution = this.create();
        this.inheritCommonProperties(parentExecutionEntity, childExecution);
        childExecution.setParent(parentExecutionEntity);
        childExecution.setProcessDefinitionId(parentExecutionEntity.getProcessDefinitionId());
        childExecution.setProcessDefinitionKey(parentExecutionEntity.getProcessDefinitionKey());
        childExecution.setBillNo(parentExecutionEntity.getBillNo());
        childExecution.setMainOrgId(parentExecutionEntity.getMainOrgId());
        childExecution.setOrgViewId(parentExecutionEntity.getOrgViewId());
        childExecution.setName(parentExecutionEntity.getName());
        Long processInstanceId = parentExecutionEntity.getProcessInstanceId();
        childExecution.setProcessInstanceId(processInstanceId != null ? processInstanceId : parentExecutionEntity.getId());
        childExecution.setScope(false);
        childExecution.setCurrentActInstId(parentExecutionEntity.getCurrentActInstId());
        String businessKey = parentExecutionEntity.getBusinessKey();
        String entityNumber = parentExecutionEntity.getEntityNumber();
        childExecution.setEntityNumber(entityNumber);
        childExecution.setBusinessKey(businessKey);
        String billType = parentExecutionEntity.getBillType();
        ILocaleString entityName = parentExecutionEntity.getEntraBillName();
        Map<String, Object> entityProperties = WfUtils.getEntityProperties(entityNumber, businessKey);
        if (!entityProperties.isEmpty()) {
            billType = (String)entityProperties.get("billType");
            if (WfUtils.isNotEmpty(billType)) {
                childExecution.setBillType(billType);
            }
            if (WfUtils.isNotEmpty(entityName = (LocaleString)entityProperties.get("entityName"))) {
                childExecution.setEntraBillName(entityName);
            }
        }
        childExecution.setSchemeId(parentExecutionEntity.getSchemeId());
        childExecution.setTestingPlanId(parentExecutionEntity.getTestingPlanId());
        childExecution.setStartUserId(parentExecutionEntity.getStartUserId());
        childExecution.setStarUserNameFormat(parentExecutionEntity.getStarUserNameFormat());
        if (WfUtils.isNotEmpty(parentExecutionEntity.getSuperExecutionId())) {
            childExecution.setSuperExecutionId(parentExecutionEntity.getSuperExecutionId());
        }
        childExecution.setProcessType(parentExecutionEntity.getProcessType());
        childExecution.setBizTraceNo(parentExecutionEntity.getBizTraceNo());
        parentExecutionEntity.addChildExecution(childExecution);
        this.insert(childExecution, false);
        logger.debug(String.format("Child execution %s created with parent %s", childExecution, parentExecutionEntity.getId()));
        if (this.getEventDispatcher().isEnabled()) {
            this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_CREATED, childExecution));
        }
        return childExecution;
    }

    @Override
    public ExecutionEntity createSubprocessInstance(ProcessDefinition processDefinition, ExecutionEntity superExecutionEntity, String businessKey) {
        ExecutionEntity subProcessInstance = this.create();
        this.inheritCommonProperties(superExecutionEntity, subProcessInstance);
        subProcessInstance.setProcessDefinitionId(processDefinition.getId());
        subProcessInstance.setProcessDefinitionKey(processDefinition.getKey());
        subProcessInstance.setSuperExecution(superExecutionEntity);
        subProcessInstance.setRootProcessInstanceId(superExecutionEntity.getRootProcessInstanceId());
        subProcessInstance.setScope(true);
        subProcessInstance.setBusinessKey(businessKey);
        this.insert(subProcessInstance, false);
        logger.debug(String.format("Child execution %s created with super execution %s", subProcessInstance, superExecutionEntity.getId()));
        subProcessInstance.setProcessInstanceId(subProcessInstance.getId());
        superExecutionEntity.setSubProcessInstance(subProcessInstance);
        if (Context.getProcessEngineConfiguration() != null && Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_CREATED, subProcessInstance));
        }
        return subProcessInstance;
    }

    protected void inheritCommonProperties(ExecutionEntity parentExecutionEntity, ExecutionEntity childExecution) {
        if (parentExecutionEntity instanceof CountingExecutionEntity) {
            CountingExecutionEntity countingParentExecutionEntity = (CountingExecutionEntity)((Object)parentExecutionEntity);
            ((CountingExecutionEntity)((Object)childExecution)).setCountEnabled(countingParentExecutionEntity.isCountEnabled());
        }
        Long rootProcessInstanceId = parentExecutionEntity.getRootProcessInstanceId();
        childExecution.setRootProcessInstanceId(rootProcessInstanceId);
        childExecution.setActive(true);
    }

    @Override
    public void deleteProcessInstancesByProcessDefinition(Long processDefinitionId, String deleteReason, boolean cascade) {
        ArrayList<Long> processInstanceIds = new ArrayList<Long>();
        QFilter filter1 = new QFilter("processDefinitionId", "=", (Object)processDefinitionId);
        QFilter filter2 = new QFilter("parentId", "=", (Object)0);
        QFilter[] filters = new QFilter[]{filter1, filter2};
        try (DataSet cc = QueryServiceHelper.queryDataSet((String)this.createAlgoKey(), (String)this.getEntityName(), (String)"id", (QFilter[])filters, null);){
            if (cc != null) {
                Iterator iter = cc.iterator();
                while (iter.hasNext()) {
                    processInstanceIds.add((Long)((Row)iter.next()).get("id"));
                }
            }
        }
        for (Long processInstanceId : processInstanceIds) {
            this.deleteProcessInstance(processInstanceId, deleteReason, cascade);
        }
        if (cascade) {
            this.getHistoricProcessInstanceEntityManager().deleteHistoricProcessInstanceByProcessDefinitionId(processDefinitionId);
        }
    }

    @Override
    public void deleteProcessInstance(Long processInstanceId, String deleteReason, boolean cascade) {
        ExecutionEntity execution = (ExecutionEntity)this.findById(processInstanceId);
        if (execution == null) {
            throw new WFObjectNotFoundException("No process instance found for id '" + processInstanceId + "'", ProcessInstance.class);
        }
        this.deleteProcessInstanceCascade(execution, deleteReason, cascade);
    }

    protected void deleteProcessInstanceCascade(ExecutionEntity execution, String deleteReason, boolean deleteHistory) {
        ExecutionEntity processInstanceExecutionEntity;
        if (deleteReason == null) {
            deleteReason = "process instance deleted";
        }
        for (ExecutionEntity executionEntity : execution.getExecutions()) {
            if (executionEntity.isMultiInstanceRoot()) {
                for (ExecutionEntity executionEntity2 : executionEntity.getExecutions()) {
                    if (executionEntity2.getSubProcessInstance() == null) continue;
                    this.deleteProcessInstanceCascade(executionEntity2.getSubProcessInstance(), deleteReason, deleteHistory);
                }
                continue;
            }
            if (executionEntity.getSubProcessInstance() == null) continue;
            this.deleteProcessInstanceCascade(executionEntity.getSubProcessInstance(), deleteReason, deleteHistory);
        }
        this.getTaskEntityManager().deleteTasksByProcessInstanceId(execution.getId(), deleteReason, deleteHistory);
        if (this.getEventDispatcher().isEnabled()) {
            this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createCancelledEvent(execution.getProcessInstanceId(), execution.getProcessInstanceId(), null, deleteReason, execution.getBusinessKey()));
        }
        if ((processInstanceExecutionEntity = execution.getProcessInstance()) == null) {
            return;
        }
        List<ExecutionEntity> list = this.collectChildren(execution.getProcessInstance());
        for (int i = list.size() - 1; i >= 0; --i) {
            ExecutionEntity executionEntity = list.get(i);
            executionEntity.setTransientVariable("processInstanceWithdrawDeleteExcution", true);
            this.deleteExecutionAndRelatedData(executionEntity, deleteReason, false);
            executionEntity.removeTransientVariable("processInstanceWithdrawDeleteExcution");
        }
        execution.setTransientVariable("processInstanceWithdrawDeleteExcution", true);
        this.deleteExecutionAndRelatedData(execution, deleteReason, false);
        execution.removeTransientVariable("processInstanceWithdrawDeleteExcution");
        if (deleteHistory) {
            this.getHistoricProcessInstanceEntityManager().delete(execution.getId());
        }
        String endType = (String)processInstanceExecutionEntity.getVariable("endType");
        this.getHistoryManager().recordProcessInstanceEnd(processInstanceExecutionEntity.getId(), deleteReason, endType, null);
        processInstanceExecutionEntity.setDeleted(true);
    }

    @Override
    public void deleteExecutionAndRelatedData(ExecutionEntity executionEntity, String deleteReason, boolean cancel) {
        this.deleteExecutionAndRelatedData(executionEntity, deleteReason, cancel, false);
    }

    @Override
    public void deleteExecutionAndRelatedData(ExecutionEntity executionEntity, String deleteReason, boolean cancel, boolean cascade) {
        if (deleteReason == null) {
            deleteReason = "execution deleted";
        }
        this.getHistoryManager().recordActivityEnd(executionEntity, deleteReason);
        this.deleteDataForExecution(executionEntity, deleteReason, cancel, cascade);
        logger.debug(String.format("deleteExecutionAndRelatedData executionId:[%s]businesskey[%s],deleteReason[%s]", executionEntity.getId(), executionEntity.getBusinessKey(), deleteReason));
        if (executionEntity.isScope()) {
            this.deleteEventLogs(executionEntity);
        }
        if (executionEntity.isBillExecution()) {
            this.deleteBillExecution(executionEntity);
        }
        this.delete(executionEntity);
        if (this.getEventDispatcher().isEnabled() && executionEntity.isScope()) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("deleteReason", deleteReason);
            params.put("executionEntity", executionEntity);
            this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.PROCESS_DELETE, params));
        }
    }

    private void deleteBillExecution(ExecutionEntity executionEntity) {
        final String bk = executionEntity.getBusinessKey();
        final String em = executionEntity.getEntityNumber();
        logger.debug(String.format("deleteBillExecution businesskey[%s],entitynumber[%s]", bk, em));
        Context.getCommandContext().addCloseListener(new DefaultCommandContextCloseListener("upgradeWithdraw"){

            @Override
            public void closed(CommandContext commandContext) {
                super.closed(commandContext);
                WfCacheHelper.removeExecutingJobGYEntityOfCurrentBusiness(bk, em);
            }
        });
    }

    @Override
    public void deleteProcessInstanceExecutionEntity(Long processInstanceId, String currentFlowElementId, String deleteReason, boolean cascade, boolean cancel, boolean fireEvent) {
        ExecutionEntity processInstanceEntity = (ExecutionEntity)this.findById(processInstanceId);
        if (processInstanceEntity == null) {
            throw new WFObjectNotFoundException("No process instance found for id '" + processInstanceId + "'", ProcessInstance.class);
        }
        if (processInstanceEntity.isDeleted()) {
            return;
        }
        for (ExecutionEntity executionEntity : processInstanceEntity.getExecutions()) {
            if (executionEntity.getSubProcessInstance() == null) continue;
            this.deleteProcessInstanceCascade(executionEntity.getSubProcessInstance(), deleteReason, cascade);
        }
        for (ExecutionEntity executionEntity : processInstanceEntity.getExecutions()) {
            if (!executionEntity.isEventScope()) continue;
            this.deleteExecutionAndRelatedData(executionEntity, null, false);
        }
        this.deleteChildExecutions(processInstanceEntity, deleteReason, cancel);
        this.deleteExecutionAndRelatedData(processInstanceEntity, deleteReason, cancel);
        if (this.getEventDispatcher().isEnabled()) {
            this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.PROCESS_COMPLETED, processInstanceEntity));
        }
        String endType = (String)processInstanceEntity.getVariable("endType");
        this.getHistoryManager().recordProcessInstanceEnd(processInstanceEntity.getId(), deleteReason, endType, currentFlowElementId);
        processInstanceEntity.setDeleted(true);
    }

    private void deleteEventLogs(ExecutionEntity processInstanceEntity) {
        Map<String, List<String>> result;
        boolean useCleanFrame = WfConfigurationUtil.useCleanFrame();
        Long procInstId = processInstanceEntity.getProcessInstanceId();
        ArrayList<String> allEntityNumber = null;
        ArrayList<String> allPks = null;
        if (ModelType.BizFlow.name().equalsIgnoreCase(processInstanceEntity.getProcessType()) && !WfUtils.isEmptyForMap(result = this.getExeConversionEntityManager().getAllConversionEntityNumberAndBusinesskeys(procInstId))) {
            allEntityNumber = new ArrayList(result.size());
            allPks = new ArrayList(result.size());
            for (Map.Entry<String, List<String>> entry : result.entrySet()) {
                allEntityNumber.add(entry.getKey());
                allPks.addAll((Collection)entry.getValue());
            }
        }
        if (allEntityNumber == null || allEntityNumber.isEmpty()) {
            allEntityNumber = new ArrayList<String>(1);
            allEntityNumber.add(processInstanceEntity.getEntityNumber());
        }
        if (allPks == null || allPks.isEmpty()) {
            allPks = new ArrayList<String>(1);
            allPks.add(processInstanceEntity.getBusinessKey());
        }
        if (!useCleanFrame) {
            if (WfConfigurationUtil.isDirectlyClearJob()) {
                BatchSQLInfo jobinfo = new BatchSQLInfo("DELETE FROM T_WF_JOBRECORD WHERE FSTATE in ('completed','errored') AND FBUSINESSKEY = ?", 50);
                for (String string : allPks) {
                    jobinfo.addParam(new Object[]{string});
                }
                this.getJobEntityManager().addBatchSQLInfo(jobinfo);
            }
            StringBuilder deleteHivarinstSql = new StringBuilder();
            deleteHivarinstSql.append("DELETE FROM t_wf_hivarinst WHERE FPROCINSTID = ? and fname not in (");
            String keepFields = WfConfigurationUtil.getKeepFieldsInVariable();
            for (String i : keepFields.split("\\,")) {
                if (!WfUtils.isNotEmpty(i)) continue;
                deleteHivarinstSql.append('\'').append(i).append('\'').append(',');
            }
            if (deleteHivarinstSql.toString().endsWith(",")) {
                BatchSQLInfo batchSQLInfo = new BatchSQLInfo(deleteHivarinstSql.subSequence(0, deleteHivarinstSql.length() - 1) + ")", 100);
                batchSQLInfo.addParam(new Object[]{processInstanceEntity.getId()});
                logger.debug("\u6267\u884csql:" + deleteHivarinstSql + ")");
                this.getHistoricVariableInstanceEntityManager().addBatchSQLInfo(batchSQLInfo);
            }
            PreComputorHelper.deleteInstanceByProcInstId(processInstanceEntity.getProcessInstanceId());
            this.getHiUserActInstEntityManager().deleteByFilters(new QFilter[]{new QFilter("proInstId", "=", (Object)processInstanceEntity.getProcessInstanceId())});
        }
        WfCacheHelper.removeExecutingJobOfCurrentBusiness(processInstanceEntity.getBusinessKey(), processInstanceEntity.getEntityNumber());
        final String bk = processInstanceEntity.getBusinessKey();
        final String em = processInstanceEntity.getEntityNumber();
        logger.debug(String.format("deleteEventLogs businesskey[%s],entitynumber[%s]", bk, em));
        Context.getCommandContext().addCloseListener(new DefaultCommandContextCloseListener("upgradeWithdraw"){

            @Override
            public void closed(CommandContext commandContext) {
                super.closed(commandContext);
                WfCacheHelper.removeExecutingJobGYEntityOfCurrentBusiness(bk, em);
                logger.debug(String.format("removeExecutingJobGYEntityOfCurrentBusiness businesskey[%s],entitynumber[%s]", bk, em));
            }
        });
        Context.getCommandContext().addCloseListener(new ProcessInstanceFinishListener(processInstanceEntity, allEntityNumber, allPks, useCleanFrame));
    }

    @Override
    public void deleteChildExecutions(ExecutionEntity executionEntity, String deleteReason, boolean cancel) {
        List<ExecutionEntity> childExecutions = this.collectChildren(executionEntity);
        for (int i = childExecutions.size() - 1; i >= 0; --i) {
            ExecutionEntity childExecutionEntity = childExecutions.get(i);
            if (childExecutionEntity.isEnded()) continue;
            this.deleteExecutionAndRelatedData(childExecutionEntity, deleteReason, cancel);
        }
    }

    @Override
    public void deleteChildrenExecutions(Long parentExecutionId) {
        QFilter[] filters = new QFilter[]{new QFilter("parentId", "=", (Object)parentExecutionId)};
        this.deleteByFilters(filters);
    }

    @Override
    public List<ExecutionEntity> collectChildren(ExecutionEntity executionEntity) {
        ArrayList<ExecutionEntity> childExecutions = new ArrayList<ExecutionEntity>();
        List<ExecutionEntity> executions = this.findExecutionsByRootProcessInstanceId(executionEntity.getRootProcessInstanceId());
        if (WfUtils.isEmptyForCollection(executions)) {
            return childExecutions;
        }
        this.findAllChildren(executionEntity, executions, childExecutions);
        return childExecutions;
    }

    protected void findAllChildren(ExecutionEntity parentExe, List<ExecutionEntity> allData, List<ExecutionEntity> collectedChildExecution) {
        if (null == parentExe || WfUtils.isEmpty(parentExe.getId())) {
            return;
        }
        for (ExecutionEntity currentExe : allData) {
            boolean isSuperOrNot;
            boolean isParentOrNot = parentExe.getId().equals(currentExe.getParentId());
            boolean bl = isSuperOrNot = parentExe.isScope() && parentExe.getId().equals(currentExe.getSuperExecutionId());
            if (!isParentOrNot && !isSuperOrNot) continue;
            collectedChildExecution.add(currentExe);
            this.findAllChildren(currentExe, allData, collectedChildExecution);
        }
    }

    @Override
    public ExecutionEntity findFirstScope(ExecutionEntity executionEntity) {
        ExecutionEntity currentExecutionEntity = executionEntity;
        while (currentExecutionEntity != null) {
            if (currentExecutionEntity.isScope()) {
                return currentExecutionEntity;
            }
            ExecutionEntity parentExecutionEntity = currentExecutionEntity.getParent();
            if (parentExecutionEntity == null) {
                parentExecutionEntity = currentExecutionEntity.getSuperExecution();
            }
            currentExecutionEntity = parentExecutionEntity;
        }
        return null;
    }

    @Override
    public ExecutionEntity findFirstMultiInstanceRoot(ExecutionEntity executionEntity) {
        ExecutionEntity currentExecutionEntity = executionEntity;
        while (currentExecutionEntity != null) {
            if (currentExecutionEntity.isMultiInstanceRoot()) {
                return currentExecutionEntity;
            }
            ExecutionEntity parentExecutionEntity = currentExecutionEntity.getParent();
            if (parentExecutionEntity == null) {
                parentExecutionEntity = currentExecutionEntity.getSuperExecution();
            }
            currentExecutionEntity = parentExecutionEntity;
        }
        return null;
    }

    @Override
    public void deleteDataForExecution(ExecutionEntity executionEntity, String deleteReason, boolean cancel, boolean cascade) {
        DeadLetterJobEntityManager deadLetterJobEntityManager;
        List<DeadLetterJobEntity> deadLetterJobsForExecution;
        TimerJobEntityManager timerJobEntityManager;
        List<TimerJobEntity> timerJobsForExecution;
        executionEntity.setEnded(true);
        executionEntity.setActive(false);
        boolean enableExecutionRelationshipCounts = this.isExecutionRelatedEntityCountEnabled(executionEntity);
        if (executionEntity.getId().equals(executionEntity.getProcessInstanceId()) && (!enableExecutionRelationshipCounts || enableExecutionRelationshipCounts && ((CountingExecutionEntity)((Object)executionEntity)).getIdentityLinkCount() > 0)) {
            IdentityLinkEntityManager identityLinkEntityManager = this.getIdentityLinkEntityManager();
            HistoricIdentityLinkEntityManager hisIdntifyMgr = this.getProcessEngineConfiguration().getHistoricIdentityLinkEntityManager();
            List<IdentityLinkEntity> identityLinks = identityLinkEntityManager.findIdentityLinksByProcessInstanceId(executionEntity.getProcessInstanceId());
            Iterator iterator = identityLinks.iterator();
            while (iterator.hasNext()) {
                IdentityLinkEntity identityLink = (IdentityLinkEntity)iterator.next();
                identityLinkEntityManager.delete(identityLink);
                if (!cascade) continue;
                hisIdntifyMgr.delete(identityLink.getId());
            }
        }
        if (!enableExecutionRelationshipCounts || enableExecutionRelationshipCounts && ((CountingExecutionEntity)((Object)executionEntity)).getVariableCount() > 0) {
            Collection<VariableInstance> executionVariables = executionEntity.getVariableInstancesLocal().values();
            VariableInstanceEntityManager variableInstanceEntityManager = this.getVariableInstanceEntityManager();
            for (VariableInstance variableInstance : executionVariables) {
                if (!(variableInstance instanceof VariableInstanceEntity)) continue;
                VariableInstanceEntity variableInstanceEntity = (VariableInstanceEntity)variableInstance;
                variableInstanceEntityManager.delete(variableInstanceEntity);
                if (!cascade) continue;
                this.getHistoricVariableInstanceEntityManager().delete(variableInstanceEntity.getId());
            }
        }
        if (!enableExecutionRelationshipCounts || enableExecutionRelationshipCounts && ((CountingExecutionEntity)((Object)executionEntity)).getTaskCount() > 0) {
            TaskEntityManager taskEntityManager = this.getTaskEntityManager();
            List<TaskEntity> tasksForExecution = taskEntityManager.findTasksByExecutionId(executionEntity.getId());
            Object de = executionEntity.getTransientVariable("processInstanceWithdrawDeleteExcution");
            for (TaskEntity taskEntity : tasksForExecution) {
                if (de != null && ((Boolean)de).booleanValue()) {
                    taskEntity.setTransientVariable("processInstanceWithdrawDeleteExcution", de);
                }
                Context.getCommandContext().getTaskHelper().deleteTaskEntity(taskEntity, deleteReason, cascade, cancel);
                taskEntity.removeTransientVariable("processInstanceWithdrawDeleteExcution");
            }
        }
        if ((!enableExecutionRelationshipCounts || enableExecutionRelationshipCounts && ((CountingExecutionEntity)((Object)executionEntity)).getTimerJobCount() > 0) && (timerJobsForExecution = (timerJobEntityManager = this.getTimerJobEntityManager()).findJobsByExecutionId(executionEntity.getId())) != null && timerJobsForExecution.size() > 0 && !WfCacheHelper.hasJobLock("TIMEJOB", String.valueOf(executionEntity.getId()))) {
            this.updateFailedLockJobCache("TIMEJOB", String.valueOf(executionEntity.getId()));
            for (TimerJobEntity timerJobEntity : timerJobsForExecution) {
                if (RuntimeUtil.isNeedToRemoveFailedJob(timerJobEntity.getJobHandlerType(), timerJobEntity.getJobHandlerConfiguration())) continue;
                timerJobEntityManager.delete(timerJobEntity);
                if (!this.getEventDispatcher().isEnabled()) continue;
                this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createAsyncMessageEvent(ActivitiEventType.JOB_CANCELED, timerJobEntity.getJobHandlerType(), timerJobEntity.getJobHandlerConfiguration(), timerJobEntity));
            }
        }
        if (!enableExecutionRelationshipCounts || enableExecutionRelationshipCounts && ((CountingExecutionEntity)((Object)executionEntity)).getSuspendedJobCount() > 0) {
            SuspendedJobEntityManager suspendedJobEntityManager = this.getSuspendedJobEntityManager();
            List<SuspendedJobEntity> suspendedJobsForExecution = suspendedJobEntityManager.findJobsByExecutionId(executionEntity.getId());
            for (SuspendedJobEntity suspendedJobEntity : suspendedJobsForExecution) {
                suspendedJobEntityManager.delete(suspendedJobEntity);
                if (!this.getEventDispatcher().isEnabled()) continue;
                this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.JOB_CANCELED, suspendedJobEntity));
            }
        }
        if ((!enableExecutionRelationshipCounts || enableExecutionRelationshipCounts && ((CountingExecutionEntity)((Object)executionEntity)).getDeadLetterJobCount() > 0) && (deadLetterJobsForExecution = (deadLetterJobEntityManager = this.getDeadLetterJobEntityManager()).findJobsByExecutionId(executionEntity.getId())) != null && deadLetterJobsForExecution.size() > 0 && !WfCacheHelper.hasJobLock("DEADJOB", String.valueOf(executionEntity.getId()))) {
            this.updateFailedLockJobCache("DEADJOB", String.valueOf(executionEntity.getId()));
            for (DeadLetterJobEntity deadLetterJobEntity : deadLetterJobsForExecution) {
                if (RuntimeUtil.isNeedToRemoveFailedJob(deadLetterJobEntity.getJobHandlerType(), deadLetterJobEntity.getJobHandlerConfiguration())) {
                    this.getFailedJobEntityManager().createFailedJobByDeadLetterJob(deadLetterJobEntity);
                }
                deadLetterJobEntityManager.delete(deadLetterJobEntity);
                if (!this.getEventDispatcher().isEnabled()) continue;
                this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.JOB_CANCELED, deadLetterJobEntity));
            }
        }
        if (!enableExecutionRelationshipCounts || enableExecutionRelationshipCounts && ((CountingExecutionEntity)((Object)executionEntity)).getEventSubscriptionCount() > 0) {
            EventSubscriptionEntityManager eventSubscriptionEntityManager = this.getEventSubscriptionEntityManager();
            List<EventSubscriptionEntity> eventSubscriptions = eventSubscriptionEntityManager.findEventSubscriptionsByExecution(executionEntity.getId());
            for (EventSubscriptionEntity eventSubscriptionEntity : eventSubscriptions) {
                eventSubscriptionEntityManager.delete(eventSubscriptionEntity);
            }
        }
        DynamicResourceEntityManager dynamicResourceEntityManager = this.getDynamicResourceEntityManager();
        List<DynamicResourceEntity> dynResources = dynamicResourceEntityManager.findByProcessInstanceId(executionEntity.getId());
        for (DynamicResourceEntity dynamicResourceEntity : dynResources) {
            dynamicResourceEntityManager.delete(dynamicResourceEntity);
        }
    }

    private void updateFailedLockJobCache(final String type, final String executionId) {
        WfCacheHelper.putJobLock(type, executionId);
        this.getCommandContext().addCloseListener(new DefaultCommandContextCloseListener("FailedJob"){

            @Override
            public void closed(CommandContext commandContext) {
                WfCacheHelper.removeJobLock(type, executionId);
            }

            @Override
            public void closeFailure(CommandContext commandContext) {
                WfCacheHelper.removeJobLock(type, executionId);
            }
        });
    }

    @Override
    public String inProcess(String businessKey) {
        String processInstanceId = null;
        if (WfUtils.isNotEmpty(businessKey)) {
            String sql = "select top 1 fid from t_wf_execution where fbusinessKey = ?";
            processInstanceId = (String)DB.query((DBRoute)DBRoute.workflow, (String)sql, (Object[])new Object[]{businessKey}, (ResultSetHandler)new ResultSetHandler<String>(){

                public String handle(ResultSet rs) throws Exception {
                    if (rs.next()) {
                        return rs.getString("FID");
                    }
                    return null;
                }
            });
        }
        return processInstanceId;
    }

    @Override
    public List<String> getInProcessBusinessKeys(List<String> businessKeys, String selectFileds) {
        selectFileds = WfUtils.isEmpty(selectFileds) ? this.getSelectFields() : selectFileds;
        EntityQueryBuilder qb = this.createQueryBuilder().addFilter("businessKey", "in", businessKeys.toArray(new String[businessKeys.size()])).addFilter("scope", "=", Character.valueOf('1')).setSelectFields(selectFileds);
        List entitys = this.findByQueryBuilder(qb);
        ArrayList<String> businesskeys = new ArrayList<String>();
        for (ExecutionEntity e : entitys) {
            String businesskey = e.getBusinessKey();
            if (businesskeys.contains(businesskey)) continue;
            businesskeys.add(businesskey);
        }
        return businesskeys;
    }

    @Override
    public void updateProcessInstanceLockTime(Long processInstanceId) {
    }

    @Override
    public void clearProcessInstanceLockTime(Long processInstanceId) {
    }

    @Override
    public String updateProcessInstanceBusinessKey(ExecutionEntity executionEntity, String businessKey) {
        if (executionEntity.isProcessInstanceType() && businessKey != null) {
            executionEntity.setBusinessKey(businessKey);
            this.getHistoryManager().updateProcessBusinessKeyInHistory(executionEntity);
            if (this.getEventDispatcher().isEnabled()) {
                this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_UPDATED, executionEntity));
            }
            return businessKey;
        }
        return null;
    }

    @Override
    public void freezeExecutionAndRelatedData(ExecutionEntity executionEntity, String deleteReason) {
        executionEntity.setActive(false);
        boolean enableExecutionRelationshipCounts = this.isExecutionRelatedEntityCountEnabled(executionEntity);
        if (!enableExecutionRelationshipCounts || enableExecutionRelationshipCounts && ((CountingExecutionEntity)((Object)executionEntity)).getTaskCount() > 0) {
            TaskEntityManager taskEntityManager = this.getTaskEntityManager();
            List<TaskEntity> tasksForExecution = taskEntityManager.findTasksByExecutionId(executionEntity.getId());
            for (TaskEntity taskEntity : tasksForExecution) {
                taskEntity.setActive(false);
                taskEntityManager.update(taskEntity);
            }
        }
        if (!enableExecutionRelationshipCounts || enableExecutionRelationshipCounts && ((CountingExecutionEntity)((Object)executionEntity)).getJobCount() > 0) {
            JobEntityManager jobEntityManager = this.getJobEntityManager();
            JobManager jobManager = this.getJobManager();
            List<JobEntity> jobsForExecution = jobEntityManager.findJobsByExecutionId(executionEntity.getId());
            if (jobsForExecution != null && jobsForExecution.size() > 0) {
                for (JobEntity job : jobsForExecution) {
                    SuspendedJobEntity suspendedJobEntity = jobManager.moveJobToSuspendedJob(job);
                    if (suspendedJobEntity == null) continue;
                    suspendedJobEntity.setActive(false);
                }
            }
        }
        List<ExecutionEntity> childExecutions = this.findChildExecutionsByParentExecutionId(executionEntity.getId());
        for (ExecutionEntity childExecution : childExecutions) {
            this.freezeExecutionAndRelatedData(childExecution, deleteReason);
        }
        Context.getProcessEngineConfiguration().getHistoryManager().recordActivityExecutionType(executionEntity, "frozen", "FROZEN");
    }

    protected ExecutionEntity findByIdAndFetchExecutionTree(Long executionId) {
        ExecutionEntity cachedEntity = this.getEntityCache().findInCache(this.getManagedEntityClass(), executionId);
        if (cachedEntity != null) {
            return cachedEntity;
        }
        String sql = "select FID,FPROCINSTID,FBUSINESSKEY,FPARENTID,FPROCDEFID,FSUPEREXEC,FROOTPROCINSTID,FACTID,FISACTIVE,FISCONCURRENT,FISSCOPE,FISEVENTSCOPE,FISMIROOT,FSUSPENSIONSTATE,FCACHEDENTSTATE,FSTARTUSERID,FLOCKTIME,FISCOUNTENABLED,FEVTSUBSCRCOUNT,FTASKCOUNT,FJOBCOUNT,FTIMERJOBCOUNT,FSUSPJOBCOUNT,FDEADLETTERJOBCOUNT,FVARCOUNT,FIDLINKCOUNT,FENTITYNUMBER,FACTINSTID,FTASKID,FCREATEDATE,FMODIFYDATE,FMAINORGID,FSCHEMEID  from t_wf_execution where fRootProcInstId = (select fRootProcInstId from t_wf_execution where fId = ?)";
        List executionEntities = this.findEntityBySQLFilter(sql, new Object[]{executionId});
        for (ExecutionEntity executionEntity : executionEntities) {
            if (!executionId.equals(executionEntity.getId())) continue;
            return executionEntity;
        }
        return null;
    }

    @Override
    public void setProcessInstanceState(Long processInstanceId, SuspensionState newState) {
        ExecutionEntity executionEntity = (ExecutionEntity)this.findById(processInstanceId);
        if (executionEntity == null) {
            throw new WFObjectNotFoundException("Cannot find processInstance for id '" + processInstanceId + "'.", Execution.class);
        }
        if (!executionEntity.isProcessInstanceType()) {
            throw new WFEngineException("Cannot set suspension state for execution '" + processInstanceId + "': not a process instance.");
        }
        SuspensionState.SuspensionStateUtil.setSuspensionState(executionEntity, newState);
        this.update(executionEntity, false);
        List<ExecutionEntity> childExecutions = this.findChildExecutionsByProcessInstanceId(processInstanceId);
        for (ExecutionEntity executionEntity2 : childExecutions) {
            if (executionEntity2.getId().equals(processInstanceId)) continue;
            SuspensionState.SuspensionStateUtil.setSuspensionState(executionEntity2, newState);
            this.update(executionEntity2, false);
        }
        List<TaskEntity> tasks = this.getTaskEntityManager().findTasksByProcessInstanceId(processInstanceId);
        for (TaskEntity taskEntity : tasks) {
            SuspensionState.SuspensionStateUtil.setSuspensionState(taskEntity, newState);
            this.getTaskEntityManager().update(taskEntity, false);
        }
        if (newState == ManagementConstants.ACTIVE) {
            List<SuspendedJobEntity> list = this.getSuspendedJobEntityManager().findJobsByProcessInstanceId(processInstanceId);
            for (SuspendedJobEntity suspendedJob : list) {
                this.getJobManager().activateSuspendedJob(suspendedJob);
            }
        } else {
            List<TimerJobEntity> list = this.getTimerJobEntityManager().findJobsByProcessInstanceId(processInstanceId);
            for (TimerJobEntity timerJob : list) {
                this.getJobManager().moveJobToSuspendedJob(timerJob);
            }
            List<JobEntity> list2 = this.getJobEntityManager().findJobsByProcessInstanceId(processInstanceId);
            for (JobEntity job : list2) {
                this.getJobManager().moveJobToSuspendedJob(job);
            }
        }
    }

    @Override
    public DynamicObjectCollection getRootProinstancesByStartuserid(String uid, String billType, String entityNumber, int start, int limit, String filterSql, List<Object> paramsList, String orderBy) {
        String lang = RequestContext.get().getLang().toString();
        LinkedHashMap<String, DynamicObject> proinstMap = new LinkedHashMap<String, DynamicObject>();
        HashSet<Long> userIds = new HashSet<Long>();
        StringBuilder proinstIdsSB = new StringBuilder();
        String masterTableAlias = "a";
        String multiLangTableAlias = "b";
        String entraBillNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_execution", masterTableAlias, multiLangTableAlias, "fentrabillname", "entrabillnameshow", "entrabillname");
        String subjectSQL = WfMultiLangUtils.getGeneralLangSQL("wf_execution", masterTableAlias, multiLangTableAlias, "fsubject", "subjectshow", "subject");
        String activityNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_execution", masterTableAlias, multiLangTableAlias, "factivityname", "activitynameshow", "activityname");
        String presentassigneeSQL = WfMultiLangUtils.getGeneralLangSQL("wf_execution", masterTableAlias, multiLangTableAlias, "fpresentassignee", "presentassignee", "presentassignee");
        String noCodeFlow = ThreadLocalVariables.get();
        String sql = "SELECT top " + (start + limit) + " a.fid id, a.fprocinstid procinstid," + entraBillNameSQL + "," + subjectSQL + "," + presentassigneeSQL + ",a.fbillno billno,a.ftaskid taskid,a.fentitynumber entityNumber,a.fprocdefid procdefid,a.factid activityId,a.FSUSPENSIONSTATE suspensionstate,a.fcreatedate createdate,a.fbusinessKey businessKey,a.fprocesstype processtype,a.fbusinessKey url," + activityNameSQL + ",a.FACTID totalhandleduration,a.FACTID handletime,a.FSTARTUSERID startUserId,a.fbusinessKey initiatorId,a.fbusinessKey \"text\",a.fbusinessKey category,a.FPROCINSTID processinstanceid,a.fbusinessKey initiator,a.fpriorityshow priorityshow,a.fbusinessKey userImgUrl FROM t_wf_execution a LEFT JOIN t_wf_execution_l b ON a.FID = b.FID AND b.FLOCALEID = ? WHERE a.FPARENTID = 0 AND a.FSUPEREXEC = 0 AND a.FISACTIVE = '1'  AND b.FLOCALEID = ? " + (WfUtils.isEmpty(entityNumber) ? "" : " AND a.fentitynumber=? ") + " And a.fcreatorid = ? " + (WfUtils.isEmpty(billType) ? "" : " AND a.fbilltype=? ") + (WfUtils.isEmpty(noCodeFlow) ? "" : " and a.fprocesstype = ? ") + " " + (WfUtils.isEmpty(filterSql) ? "" : filterSql) + "ORDER BY " + (WfUtils.isEmpty(orderBy) ? "" : orderBy + ",") + " a.FCREATEDATE DESC";
        ArrayList<Object> params = new ArrayList<Object>();
        String hour = ResManager.loadKDString((String)"\u5c0f\u65f6", (String)"ExecutionEntityManagerImpl_1", (String)"bos-wf-engine", (Object[])new Object[0]);
        params.add(lang);
        params.add(lang);
        if (WfUtils.isNotEmpty(entityNumber)) {
            params.add(entityNumber);
        }
        params.add(Long.valueOf(uid));
        if (WfUtils.isNotEmpty(billType)) {
            params.add(billType);
        }
        if (WfUtils.isNotEmpty(noCodeFlow)) {
            params.add(noCodeFlow);
        }
        params.addAll(paramsList);
        try (DataSet ds = DB.queryDataSet((String)"WfTaskCenter.getMyApplyData", (DBRoute)DBRoute.workflow, (String)sql, (Object[])params.toArray());){
            Object url;
            DynamicObjectCollection ret = ORM.create().toPlainDynamicObjectCollection(ds, start, limit);
            for (DynamicObject o : ret) {
                Date date = o.getDate("createdate");
                if (date != null) {
                    long totalDuration = WfUtils.now().getTime() - date.getTime();
                    String totalHour = WfUtils.formatTime(totalDuration);
                    o.set("handletime", (Object)totalHour);
                }
                url = MessageServiceUtil.buildWebPageForAuditTaskUrl(o.getLong("procinstid"), "toApply", o.getString("businessKey"));
                o.set("url", url);
                long startUserId = o.getLong("startUserId");
                o.set(INITIATORID, (Object)(WfUtils.isNotEmpty(startUserId) ? startUserId : 0L));
                if (ManagementConstants.SUSPENDED.getStateCode().equals(o.get("suspensionState"))) {
                    o.set("text", (Object)ResManager.loadKDString((String)"\u5df2\u6302\u8d77", (String)"ExecutionEntityManagerImpl_2", (String)"bos-wf-engine", (Object[])new Object[0]));
                } else {
                    proinstIdsSB.append(o.get(PROCESSINSTANCEID)).append(',');
                }
                if (WfUtils.isNotEmpty(startUserId)) {
                    userIds.add(startUserId);
                }
                proinstMap.put(o.getLong(PROCESSINSTANCEID) + "", o);
            }
            if (proinstIdsSB.length() > 0) {
                String inProinstIds = "(" + proinstIdsSB.substring(0, proinstIdsSB.length() - 1) + ")";
                String sqlForUser = "SELECT a.FUSERID userId,b.FPROCINSTID procinstId,b.fcategory category,b.fhandlestate handlestate from t_wf_task b LEFT JOIN t_wf_participant a ON a.FTASKID = b.FID WHERE b.FPROCINSTID in " + inProinstIds;
                DataSet dataSet = DB.queryDataSet((String)"wf.wf_task.queryGridData", (DBRoute)DBRoute.workflow, (String)sqlForUser, null);
                url = null;
                try {
                    for (Row r : dataSet) {
                        long inititor;
                        Long proinst = r.getLong("procinstId");
                        Long userId = r.getLong("userId");
                        String category = r.getString(CATEGORY);
                        if (!WfUtils.isNotEmpty(proinst)) continue;
                        DynamicObject applyTask = (DynamicObject)proinstMap.get(proinst.toString());
                        applyTask.set(CATEGORY, (Object)category);
                        if ("SSCApprove".equals(category)) {
                            applyTask.set("text", (Object)String.format(ResManager.loadKDString((String)"\u5171\u4eab\u5ba1\u6279%s", (String)"ExecutionEntityManagerImpl_3", (String)"bos-wf-engine", (Object[])new Object[0]), GraphCodecUtils.getSSCStateName(String.valueOf(r.get("handlestate")))));
                        } else {
                            if (WfUtils.isEmpty(userId)) continue;
                            if (WfUtils.isEmptyString(applyTask.get("text"))) {
                                applyTask.set("text", (Object)userId);
                            } else {
                                String text = applyTask.get("text").toString() + "," + userId;
                                applyTask.set("text", (Object)text);
                            }
                        }
                        proinstMap.put(proinst.toString(), applyTask);
                        userIds.add(userId);
                        if (applyTask == null || (inititor = applyTask.getLong(INITIATORID)) <= 0L || inititor == userId) continue;
                        userIds.add(inititor);
                    }
                }
                catch (Throwable iter) {
                    url = iter;
                    throw iter;
                }
                finally {
                    if (dataSet != null) {
                        if (url != null) {
                            try {
                                dataSet.close();
                            }
                            catch (Throwable iter) {
                                ((Throwable)url).addSuppressed(iter);
                            }
                        } else {
                            dataSet.close();
                        }
                    }
                }
            }
            if (!userIds.isEmpty()) {
                Map<String, UserInfo> userInfo = ProcessAssistantUtil.queryUserInfos(userIds);
                UserInfo user = null;
                for (DynamicObject m : proinstMap.values()) {
                    String muserIds;
                    if (WfUtils.isEmptyString(m.get("text"))) {
                        m.set("text", (Object)ResManager.loadKDString((String)"\u6b63\u5728\u8fd0\u884c", (String)"ExecutionEntityManagerImpl_4", (String)"bos-wf-engine", (Object[])new Object[0]));
                        continue;
                    }
                    String suffix = ResManager.loadKDString((String)"\u5904\u7406", (String)"ExecutionEntityManagerImpl_5", (String)"bos-wf-engine", (Object[])new Object[0]);
                    if (m.get(CATEGORY) != null && BpmnModelUtil.instanceofAuditTask(m.get(CATEGORY).toString())) {
                        suffix = ResManager.loadKDString((String)"\u5ba1\u6279", (String)"ExecutionEntityManagerImpl_6", (String)"bos-wf-engine", (Object[])new Object[0]);
                    }
                    if ((muserIds = m.get("text").toString()).contains(",")) {
                        String[] ids = muserIds.split(",");
                        StringBuilder sb = new StringBuilder();
                        int j = 0;
                        String text = "";
                        for (int i = 0; i < ids.length; ++i) {
                            if (j > 2) {
                                text = String.format(ResManager.loadKDString((String)"%1$s%2$s\u7b49%3$s", (String)"ExecutionEntityManagerImpl_8", (String)"bos-wf-engine", (Object[])new Object[0]), WFMultiLangConstants.getWaiting(), sb.substring(0, sb.length() - 1), suffix);
                                break;
                            }
                            user = userInfo.get(ids[i]);
                            if (!WfUtils.isNotEmpty(ids[i]) || user == null || !WfUtils.isNotEmpty(user.getName())) continue;
                            ++j;
                            sb.append(user.getName());
                            sb.append(',');
                        }
                        if (WfUtils.isEmpty(text) && sb.length() > 0) {
                            text = WFMultiLangConstants.getWaiting() + sb.substring(0, sb.length() - 1) + suffix;
                        }
                        m.set("text", (Object)text);
                    } else {
                        user = userInfo.get(muserIds);
                        if (user != null && WfUtils.isNotEmpty(user.getName())) {
                            m.set("text", (Object)(WFMultiLangConstants.getWaiting() + user.getName() + suffix));
                        }
                    }
                    if ((user = userInfo.get(m.get(INITIATORID) + "")) == null) continue;
                    m.set("initiator", (Object)user.getName());
                    m.set("userImgUrl", (Object)user.getImgUrl());
                }
            }
            DynamicObjectCollection re = (DynamicObjectCollection)ret.clone();
            re.clear();
            re.addAll(proinstMap.values());
            DynamicObjectCollection dynamicObjectCollection = re;
            return dynamicObjectCollection;
        }
    }

    @Override
    public long getRootProinstancesCountByStartuserid(String uid, String billType, String entityNumber, String filterSql, List<Object> paramsList) {
        String lang = RequestContext.get().getLang().toString();
        String noCodeFlow = ThreadLocalVariables.get();
        String sql = "SELECT count(1) count from t_wf_execution a left join t_wf_execution_l b on a.fid=b.fid and b.FLOCALEID = ? WHERE a.FPARENTID=0 AND a.FSUPEREXEC=0 AND a.FISACTIVE = '1'  AND a.fcreatorid =?  AND b.FLOCALEID = ? " + (WfUtils.isEmpty(entityNumber) ? "" : "AND a.FENTITYNUMBER = ? ") + (WfUtils.isEmpty(noCodeFlow) ? "" : " and a.fprocesstype = ? ") + (WfUtils.isEmpty(billType) ? "" : "AND a.fbilltype = ? ") + (WfUtils.isEmpty(filterSql) ? "" : filterSql);
        ArrayList<Object> params = new ArrayList<Object>();
        if (WfUtils.isEmpty(entityNumber)) {
            params.addAll(Arrays.asList(lang, Long.valueOf(uid), lang));
        } else {
            params.addAll(Arrays.asList(lang, Long.valueOf(uid), lang, entityNumber));
        }
        if (WfUtils.isNotEmpty(noCodeFlow)) {
            params.add(ModelType.NoCodeFlow.name());
        }
        if (WfUtils.isNotEmpty(billType)) {
            params.add(billType);
        }
        params.addAll(paramsList);
        long count = 0L;
        try (DataSet ds = DB.queryDataSet((String)"WFTASK.executionsCount", (DBRoute)DBRoute.workflow, (String)sql, (Object[])params.toArray());){
            Iterator iter = ds.iterator();
            if (iter.hasNext()) {
                count = ((Row)iter.next()).getLong("count");
            }
        }
        return count;
    }

    @Override
    public List<ExecutionEntity> findActiveExecutionsByProcessInstanceId(Long processInstanceId) {
        EntityQueryBuilder qb = this.createQueryBuilder().addFilter(PROCESSINSTANCEID, processInstanceId).addFilter(ACTIVE, Boolean.TRUE);
        return this.findByQueryBuilder(qb);
    }

    @Override
    public List<ExecutionEntity> findProcessInstanceByBusinessKey(String businessKey) {
        QFilter q1 = new QFilter("businessKey", "=", (Object)businessKey);
        QFilter q2 = new QFilter("scope", "=", (Object)Character.valueOf('1'));
        QFilter[] qFilters = new QFilter[]{q1, q2};
        return this.findByQueryFilters(qFilters);
    }

    @Override
    public List<ExecutionEntity> findActiveExecutionsByBusinessKey(String businessKey) {
        QFilter q1 = new QFilter("businessKey", "=", (Object)businessKey);
        QFilter q2 = new QFilter(ACTIVE, "=", (Object)Character.valueOf('1'));
        QFilter q3 = new QFilter("processtype", "=", (Object)"AuditFlow");
        QFilter[] qFilters = new QFilter[]{q1, q2, q3};
        return this.findByQueryFilters(qFilters, this.getSelectFields(), "createDate desc");
    }

    @Override
    public boolean existActiveExecutionsByBusinessKey(String businessKey) {
        QFilter q1 = new QFilter("businessKey", "=", (Object)businessKey);
        QFilter[] qFilters = new QFilter[]{q1};
        return this.exist(qFilters);
    }

    @Override
    public boolean existActiveExecutionsByEntityNumberAndPkAndProcDefId(String entityNumber, String businessKey, Long processDefinitionId) {
        QFilter q1 = new QFilter("businessKey", "=", (Object)businessKey);
        QFilter q2 = new QFilter("processDefinitionId", "=", (Object)processDefinitionId);
        QFilter q3 = new QFilter("entityNumber", "=", (Object)entityNumber);
        QFilter[] qFilters = new QFilter[]{q1, q2, q3};
        return this.exist(qFilters);
    }

    @Override
    public ExecutionEntity findActiveExecutionByBusinessKeyAndActivityId(String businessKey, String activityId) {
        QFilter q1 = new QFilter("businessKey", "=", (Object)businessKey);
        QFilter q3 = new QFilter("activityId", "=", (Object)activityId);
        QFilter q2 = new QFilter(ACTIVE, "=", (Object)Character.valueOf('1'));
        QFilter[] qFilters = new QFilter[]{q1, q2, q3};
        List es = this.findByQueryFilters(qFilters);
        if (es != null && !es.isEmpty()) {
            return (ExecutionEntity)es.get(0);
        }
        return null;
    }

    @Override
    public List<Map<String, Object>> getEntityByUser(Long uid) {
        String entityNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_execution", "a", "b", "FENTRABILLNAME", "entityname", "entrabillname");
        String sql = "select distinct " + entityNameSQL + ",a.FENTITYNUMBER entitynumber, a.fbilltype billtype, a.fbusinesskey businesskey from t_wf_execution a LEFT JOIN t_wf_execution_l b ON a.FID = b.FID AND b.FLOCALEID = ? WHERE a.fcreatorid = ? AND a.FISSCOPE = '1'";
        Object[] params = new Object[]{RequestContext.get().getLang().toString(), uid};
        List<Map<String, Object>> entityMap = WfUtils.getEntityProperties(sql, params);
        return entityMap;
    }

    @Override
    public List<Long> getInProcessProcessDefinitionIds() {
        ArrayList<Long> inUseProcDefIds = new ArrayList<Long>();
        String sql = "select fprocdefid from t_wf_execution where fisscope='1' group by fprocdefid ";
        try (DataSet ds = DB.queryDataSet((String)"ExecutionEntityManagerImpl.getInProcessProcessDefinitionIds", (DBRoute)DBRoute.workflow, (String)sql, null);){
            DynamicObjectCollection result = ORM.create().toPlainDynamicObjectCollection(ds);
            if (result != null && !result.isEmpty()) {
                for (DynamicObject object : result) {
                    Long procDefId = object.getLong("fprocdefid");
                    inUseProcDefIds.add(procDefId);
                }
            }
        }
        return inUseProcDefIds;
    }

    @Override
    public long countExecutionsByProcDefId(Long procDefId) {
        QFilter[] filters = new QFilter[]{new QFilter("processDefinitionId", "=", (Object)procDefId)};
        return this.countByFilter("id", filters, false);
    }

    @Override
    public List<ExecutionEntity> findActiveExecutionsByProcessInstanceIdExceptedBusinessKey(Long processInstanceId, String businessKey) {
        EntityQueryBuilder qb = this.createQueryBuilder().addFilter(PROCESSINSTANCEID, processInstanceId).addFilter("businessKey", "!=", businessKey).addFilter(ACTIVE, Character.valueOf('1'));
        return this.findByQueryBuilder(qb);
    }

    @Override
    public List<ExecutionEntity> findActiveExecutionsByRootProcessInstanceId(Long processInstanceId) {
        QFilter q1 = new QFilter("rootProcessInstanceId", "=", (Object)processInstanceId);
        QFilter q2 = new QFilter(ACTIVE, "=", (Object)Character.valueOf('1'));
        QFilter[] qFilters = new QFilter[]{q1, q2};
        return this.findByQueryFilters(qFilters);
    }

    @Override
    public List<ExecutionEntity> findBillExecutionByBusinesskey(String businessKey) {
        QFilter q1 = new QFilter("businessKey", "=", (Object)businessKey);
        QFilter[] qFilters = new QFilter[]{q1};
        return this.findByQueryFilters(qFilters);
    }

    @Override
    public List<ExecutionEntity> findExecuteExecutionByBillExecutionIdAndPk(Long billExecutionId, String businesskey) {
        QFilter q1 = new QFilter("businessKey", "=", (Object)businesskey);
        QFilter q2 = new QFilter("parentId", "=", (Object)billExecutionId);
        return this.findByQueryFilters(new QFilter[]{q1, q2});
    }

    @Override
    public Map<String, BillExecutionState> findAllBillExecution(Long processInstanceId) {
        QFilter q1 = new QFilter(PROCESSINSTANCEID, "=", (Object)processInstanceId);
        QFilter q3 = new QFilter("processtype", "=", (Object)ModelType.BizFlow.name());
        List es = this.findByQueryFilters(new QFilter[]{q1, q3}, String.format("%s,%s,%s,%s,%s,%s,%s,%s,%s", "aborttype", ACTIVE, "billexecution", "scope", "id", "parentId", "businessKey", "activityId", "entityNumber"), "createDate");
        if (es.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Long, BillExecutionState> bills = new HashMap<Long, BillExecutionState>(es.size());
        HashMap<Long, Boolean> childs = new HashMap<Long, Boolean>(es.size());
        HashMap<Long, ExecutionEntity> invalid = new HashMap<Long, ExecutionEntity>(es.size());
        for (ExecutionEntity ee : es) {
            if (ee.isScope()) continue;
            invalid.put(ee.getId(), ee);
        }
        for (ExecutionEntity ee : es) {
            if (ee.isScope()) continue;
            if (ee.isBillExecution()) {
                bills.put(ee.getId(), new BillExecutionState(ee.getId(), ee.getEntityNumber(), ee.getBusinessKey(), ee.getActivityId(), ee.getAbortType()));
                continue;
            }
            Long parentId = ee.getParentId();
            if (!WfUtils.isNotEmpty(parentId)) continue;
            ExecutionEntity t = (ExecutionEntity)invalid.get(parentId);
            while (t != null && !t.isBillExecution()) {
                t = (ExecutionEntity)invalid.get(t.getParentId());
            }
            if (t == null) continue;
            childs.put(t.getId(), Boolean.TRUE);
        }
        if (!bills.isEmpty()) {
            HashMap<String, BillExecutionState> ret = new HashMap<String, BillExecutionState>(4);
            Set set = bills.entrySet();
            for (Map.Entry entry : set) {
                BillExecutionState bs = (BillExecutionState)entry.getValue();
                bs.setExistChild(childs.get(entry.getKey()) != null);
                ret.put(bs.getKey(), bs);
            }
            return ret;
        }
        return Collections.emptyMap();
    }

    @Override
    public List<ExecutionEntity> findBizFlowBySrcBillId(Set<String> srcBillIds) {
        QFilter[] qFilters = new QFilter[]{new QFilter("businessKey", "in", srcBillIds), new QFilter("processtype", "=", (Object)ModelType.BizFlow.name())};
        return this.findByQueryFilters(qFilters, String.format("%s,%s", "processDefinitionId", "businessKey"), null);
    }

    @Override
    public List<ExecutionEntity> findActiveBillExecutionBySourceBill(Long proInstanceId, Set<String> sourcePks) {
        QFilter[] qFilters = new QFilter[]{new QFilter(PROCESSINSTANCEID, "=", (Object)proInstanceId), new QFilter("businessKey", "in", sourcePks), new QFilter("id", "!=", (Object)proInstanceId), new QFilter("processtype", "=", (Object)ModelType.BizFlow.name()), new QFilter(ACTIVE, "=", (Object)Boolean.TRUE)};
        return this.findByQueryFilters(qFilters, String.format("%s,%s,%s,%s,%s", "id", "activityId", "entityNumber", PROCESSINSTANCEID, "businessKey"), null);
    }

    @Override
    public List<ExecutionEntity> findBizActivitySubExecutions(Long procinstId) {
        QFilter filter = new QFilter("scope", "=", (Object)Boolean.FALSE);
        QFilter procFilter = new QFilter(PROCESSINSTANCEID, "=", (Object)procinstId);
        QFilter activeFilter = new QFilter(ACTIVE, "=", (Object)Boolean.TRUE);
        QFilter processTypeFilter = new QFilter("processtype", "=", (Object)ModelType.BizFlow.name());
        return this.findByQueryFilters(new QFilter[]{procFilter, processTypeFilter, filter, activeFilter});
    }

    @Override
    public String inSameProcess(String businessKey, Long processDefinitionId) {
        String processInstanceId = null;
        if (WfUtils.isNotEmpty(businessKey) && WfUtils.isNotEmpty(processDefinitionId)) {
            String sql = "select top 1 fid from t_wf_execution where fbusinessKey = ? and fprocdefid = ?";
            processInstanceId = (String)DB.query((DBRoute)DBRoute.workflow, (String)sql, (Object[])new Object[]{businessKey, processDefinitionId}, (ResultSetHandler)new ResultSetHandler<String>(){

                public String handle(ResultSet rs) throws Exception {
                    if (rs.next()) {
                        return rs.getString("FID");
                    }
                    return null;
                }
            });
        }
        return processInstanceId;
    }

    @Override
    public DynamicObjectCollection getNoCodeFlowRootProinstancesByStartuserid(String uid, String billType, String entityNumber, int start, int limit, String filterSql, List<Object> paramsList, String orderBy) {
        String lang = RequestContext.get().getLang().toString();
        String masterTableAlias = "a";
        String multiLangTableAlias = "b";
        String startNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_execution", masterTableAlias, multiLangTableAlias, "fstarusernameformat", "startName", "starusernameformat");
        String entraBillNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_execution", masterTableAlias, multiLangTableAlias, "fentrabillname", "entityName", "entrabillname");
        String presentassigneeSQL = WfMultiLangUtils.getGeneralLangSQL("wf_execution", masterTableAlias, multiLangTableAlias, "fpresentassignee", "activityUserName", "presentassignee");
        String activityNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_execution", masterTableAlias, multiLangTableAlias, "factivityname", "activityName", "activityname");
        String noCodeFlow = ThreadLocalVariables.get();
        String sql = "SELECT top " + (start + limit) + " a.fid id,a.fbusinessKey businessKey,a.fstartuserid startUserId," + startNameSQL + ",'' startUserImgUrl," + entraBillNameSQL + ",a.fentitynumber entityNumber,a.fprocinstid procInstId,a.fprocdefid procDefId,'' procDefName,a.fcreatedate createDate,a.fsuspensionstate suspensionstate,'' handleState,'' endType,'' activityUserId," + presentassigneeSQL + ",'' activityUserImgUrl,a.factid activityId," + activityNameSQL + ",a.fbusinessKey category,a.ftaskid taskid,'' endtime,'' handletime,a.fbillno billno FROM t_wf_execution a LEFT JOIN t_wf_execution_l b ON a.FID = b.FID AND b.FLOCALEID = ? WHERE a.FPARENTID = 0 AND a.FSUPEREXEC = 0 AND a.FISACTIVE = '1'  AND b.FLOCALEID = ? " + (WfUtils.isEmpty(entityNumber) ? "" : " AND a.fentitynumber=? ") + " And a.fcreatorid = ? " + (WfUtils.isEmpty(billType) ? "" : " AND a.fbilltype=? ") + (WfUtils.isEmpty(noCodeFlow) ? "" : " and a.fprocesstype = ? ") + " " + (WfUtils.isEmpty(filterSql) ? "" : filterSql) + "ORDER BY " + (WfUtils.isEmpty(orderBy) ? "" : orderBy + ",") + " a.FCREATEDATE DESC";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(lang);
        params.add(lang);
        if (WfUtils.isNotEmpty(entityNumber)) {
            params.add(entityNumber);
        }
        params.add(Long.valueOf(uid));
        if (WfUtils.isNotEmpty(billType)) {
            params.add(billType);
        }
        params.add(ModelType.NoCodeFlow.name());
        params.addAll(paramsList);
        try (DataSet ds = DB.queryDataSet((String)"WfTaskCenter.getMyApplyData", (DBRoute)DBRoute.workflow, (String)sql, (Object[])params.toArray());){
            DynamicObjectCollection ret = ORM.create().toPlainDynamicObjectCollection(ds, start, limit);
            HashSet<Long> userIds = new HashSet<Long>(ret.size());
            HashSet<Long> procdefIds = new HashSet<Long>(ret.size());
            StringBuilder proinstIdsSB = new StringBuilder();
            LinkedHashMap<Long, DynamicObject> proinstMap = new LinkedHashMap<Long, DynamicObject>();
            for (DynamicObject dyObject : ret) {
                long startUserId = dyObject.getLong("startUserId");
                long procInstId = dyObject.getLong("procInstId");
                long procDefId = dyObject.getLong("procDefId");
                procdefIds.add(procDefId);
                userIds.add(startUserId);
                dyObject.set("startUserId", (Object)(WfUtils.isNotEmpty(startUserId) ? startUserId : 0L));
                proinstMap.put(procInstId, dyObject);
                proinstIdsSB.append(procInstId).append(',');
                Date date = dyObject.getDate("createdate");
                if (date == null) continue;
                long totalDuration = WfUtils.now().getTime() - date.getTime();
                dyObject.set("handletime", (Object)WfUtils.formatTime(totalDuration));
            }
            this.getPartipantInfoByProcinstIds(proinstIdsSB, proinstMap, userIds);
            Map<Long, String> procdefMap = ProcessAssistantUtil.getProcdefNameByProcdefId(procdefIds);
            HashMap<String, UserInfo> userInfoMap = new HashMap(ret.size());
            if (!userIds.isEmpty()) {
                userInfoMap = ProcessAssistantUtil.queryUserInfos(userIds);
            }
            this.handleData(proinstMap, procdefMap, userInfoMap);
            DynamicObjectCollection re = (DynamicObjectCollection)ret.clone();
            re.clear();
            re.addAll(proinstMap.values());
            DynamicObjectCollection dynamicObjectCollection = re;
            return dynamicObjectCollection;
        }
    }

    private void getPartipantInfoByProcinstIds(StringBuilder proinstIdsSB, Map<Long, DynamicObject> proinstMap, Set<Long> userIds) {
        if (proinstIdsSB.length() <= 0) {
            return;
        }
        String inProinstIds = "(" + proinstIdsSB.substring(0, proinstIdsSB.length() - 1) + ")";
        String sqlForUser = "select a.fuserid userid,b.fprocinstid procinstid,b.fcategory category,b.fhandlestate handlestate,c.fendtype endType,c.fendtime endtime from t_wf_task b left join " + TableNameConstant.getHiProcInstTableName() + " c on b.fprocinstid = c.fid left join t_wf_participant a on a.ftaskid = b.fid where b.fprocinstid in " + inProinstIds + " order by b.fprocinstid desc;";
        try (DataSet dataSet = DB.queryDataSet((String)"wf.wf_task.queryGridData", (DBRoute)DBRoute.workflow, (String)sqlForUser, null);){
            DynamicObjectCollection dc = ORM.create().toPlainDynamicObjectCollection(dataSet);
            for (DynamicObject o : dc) {
                Long procinstId = o.getLong("procinstId");
                if (WfUtils.isEmpty(procinstId)) continue;
                Long userId = o.getLong("userId");
                DynamicObject applyTask = proinstMap.get(procinstId);
                applyTask.set(CATEGORY, (Object)o.getString(CATEGORY));
                String activityUserId = applyTask.getString("activityUserId");
                applyTask.set("activityUserId", WfUtils.isNotEmpty(activityUserId) ? activityUserId + "," + userId : userId);
                applyTask.set("handleState", (Object)o.getString("handlestate"));
                applyTask.set("endType", (Object)o.getString("endType"));
                applyTask.set("endtime", o.get("endtime"));
                userIds.add(userId);
                proinstMap.put(procinstId, applyTask);
            }
        }
    }

    private void handleData(Map<Long, DynamicObject> proinstMap, Map<Long, String> procdefMap, Map<String, UserInfo> userInfoMap) {
        for (DynamicObject m : proinstMap.values()) {
            String activityUserId;
            if (WfUtils.isNotEmptyForMap(procdefMap)) {
                m.set("procDefName", (Object)procdefMap.get(m.getLong("procDefId")));
            }
            Long startUserId = m.getLong("startUserId");
            if (!WfUtils.isNotEmptyForMap(userInfoMap)) continue;
            if (WfUtils.isNotEmpty(startUserId)) {
                UserInfo userInfo = userInfoMap.get(startUserId.toString());
                m.set("startUserImgUrl", (Object)(userInfo != null ? userInfo.getImgUrl() : ""));
                m.set("startName", userInfo != null ? userInfo.getName() : "");
            }
            if (!WfUtils.isNotEmpty(activityUserId = m.getString("activityUserId"))) continue;
            List<String> activityUserIds = Arrays.asList(activityUserId.split(","));
            StringBuilder activityUserName = new StringBuilder();
            StringBuilder activityUserImgUrl = new StringBuilder();
            for (String str : activityUserIds) {
                UserInfo userInfo = userInfoMap.get(str);
                if (userInfo == null) continue;
                activityUserName.append(userInfo.getName()).append(StandardTips.getComma());
                activityUserImgUrl.append(userInfo.getImgUrl()).append(",");
            }
            if (activityUserName != null && activityUserName.length() > 0) {
                m.set("activityUserName", (Object)activityUserName.substring(0, activityUserName.length() - 1));
            }
            if (activityUserImgUrl == null || activityUserImgUrl.length() <= 0) continue;
            m.set("activityUserImgUrl", (Object)activityUserImgUrl.substring(0, activityUserImgUrl.length() - 1));
        }
    }

    @Override
    public DynamicObjectCollection getToApplyProcess(EntityQueryParams entityQueryParams) {
        String queryFields = entityQueryParams.getMainEntityQueryParams().getQueryALLFields();
        QFilter[] qFilters = this.buildToApplyQfilter(entityQueryParams);
        String mainOrderBy = entityQueryParams.getMainEntityQueryParams().getOrderBySql();
        StringBuilder order = new StringBuilder();
        if (WfUtils.isNotEmpty(mainOrderBy)) {
            order.append(mainOrderBy);
            if (!mainOrderBy.contains("createdate")) {
                order.append(",createdate desc");
            }
        } else {
            order.append("createdate desc");
        }
        try (DataSet ds = ORM.create().queryDataSet("algoKey", "wf_execution_tc", queryFields, qFilters, order.toString(), entityQueryParams.getStart(), entityQueryParams.getLimit());){
            DynamicObjectCollection dynamicObjectCollection = ORM.create().toPlainDynamicObjectCollection(ds);
            return dynamicObjectCollection;
        }
    }

    @Override
    public List<Long> getProcessInstanceIdsWithSubProcTag(List<Long> processInstanceIds) {
        QFilter qf1 = new QFilter("id", "in", processInstanceIds);
        QFilter qf2 = new QFilter("scope", "=", (Object)Boolean.TRUE);
        QFilter qf3 = new QFilter("issubprocess", "=", (Object)Boolean.TRUE);
        List entityList = this.findByQueryFilters(new QFilter[]{qf1, qf2, qf3}, "id", null);
        return entityList.stream().map(DelegateExecution::getId).collect(Collectors.toList());
    }

    @Override
    public Long getToApplyProcessCount(EntityQueryParams entityQueryParams) {
        QFilter[] qFilters = this.buildToApplyQfilter(entityQueryParams);
        return ORM.create().count("algoKey-gettoapplycount", "wf_execution_tc", qFilters);
    }

    private QFilter[] buildToApplyQfilter(EntityQueryParams entityQueryParams) {
        List<QFilter> mainQfilter;
        QFilter qFilter;
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        if (entityQueryParams.getUserId() == null) {
            qFilter = new QFilter("parentid", "=", (Object)0).and(new QFilter("superexecutionid", "=", (Object)0)).and(new QFilter(ACTIVE, "=", (Object)"1"));
            qFilterList.add(qFilter);
        } else {
            qFilter = new QFilter("creatorid", "=", (Object)entityQueryParams.getUserId()).and(new QFilter("parentid", "=", (Object)0)).and(new QFilter("superexecutionid", "=", (Object)0)).and(new QFilter(ACTIVE, "=", (Object)"1"));
            qFilterList.add(qFilter);
        }
        String noCodeFlow = ThreadLocalVariables.get();
        if (WfUtils.isNotEmpty(noCodeFlow)) {
            qFilterList.add(new QFilter("processtype", "=", (Object)noCodeFlow));
        }
        if ((mainQfilter = entityQueryParams.getMainEntityQueryParams().getQFilter()) != null && mainQfilter.size() > 0) {
            qFilterList.addAll(mainQfilter);
        }
        return (QFilter[])qFilterList.stream().toArray(QFilter[]::new);
    }
}

