/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.HiUserActInstCuActInstidAndProinstIdEndMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.HiUserActInstCuActidAndProinstIdEndMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.HiUserActInstCurrentExecutionIdMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.HiUserActInstProInstIdAndJoinFlagMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.HiUserActInstEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.HiUserActInstEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.HiUserActInstEntityManager;

public class HiUserActInstEntityManagerImpl
extends AbstractEntityManager<HiUserActInstEntity>
implements HiUserActInstEntityManager {
    protected HiUserActInstCuActInstidAndProinstIdEndMatcher Instmatcher = new HiUserActInstCuActInstidAndProinstIdEndMatcher();
    protected HiUserActInstCuActidAndProinstIdEndMatcher matcher = new HiUserActInstCuActidAndProinstIdEndMatcher();
    protected HiUserActInstProInstIdAndJoinFlagMatcher joinFlagMatcher = new HiUserActInstProInstIdAndJoinFlagMatcher();
    private HiUserActInstCurrentExecutionIdMatcher currentExecutionIdMatcher = new HiUserActInstCurrentExecutionIdMatcher();

    public HiUserActInstEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public Class<? extends HiUserActInstEntity> getManagedEntityClass() {
        return HiUserActInstEntityImpl.class;
    }

    @Override
    public String getEntityName() {
        return "wf_hiuseractinst";
    }

    @Override
    public String getTableName() {
        return "t_wf_hiuseractinst";
    }

    @Override
    public String getMultiLangTableName() {
        return "t_wf_hiuseractinst_l";
    }

    @Override
    public String getSelectFields() {
        return "modifydate,createdate,currentactid,lastusernodeactid,businesskey,proinstid,pathjson,lastnodecid,currentactinstid,lastnodeactinstid,endtime,executionid,taskid,lastnodename,currentnodename,currentExecutionId,joinFlag,endType";
    }

    @Override
    public List<HiUserActInstEntity> findByActivityAndProinstId(Long actInstId, Long proinstId) {
        QFilter f = new QFilter("proInstId", "=", (Object)proinstId).and(new QFilter("currentActInstId", "=", (Object)actInstId)).and(new QFilter("endTime", "is null", null));
        EntityQueryBuilder eb = this.createQueryBuilder().addFilters(new QFilter[]{f});
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("currentActInstId", actInstId);
        map.put("proInstId", proinstId);
        List<HiUserActInstEntity> entitys = this.getList(eb, this.Instmatcher, map, true);
        if (entitys == null || entitys.isEmpty()) {
            return Collections.emptyList();
        }
        if (entitys.get(0).getEndTime() == null) {
            return entitys;
        }
        return Collections.emptyList();
    }

    @Override
    public void batchUpdate(List<HiUserActInstEntity> mappers) {
        for (HiUserActInstEntity e : mappers) {
            this.update(e);
        }
    }

    @Override
    public void makeEnd(Long proinstId, Long activityInstId) {
        List<HiUserActInstEntity> entitys = this.findByActivityAndProinstId(activityInstId, proinstId);
        if (!entitys.isEmpty()) {
            for (HiUserActInstEntity e : entitys) {
                e.setEndTime(WfUtils.now());
            }
            this.batchUpdate(entitys);
        }
    }

    @Override
    public void deleteByProinstId(Long processInstanceId) {
        QFilter f = new QFilter("proInstId", "=", (Object)processInstanceId);
        this.deleteByFilters(new QFilter[]{f});
    }

    @Override
    public void deleteByLastActInstIdAndProinstId(Long processInstanceId, Long actInstId, String LastNodeActId) {
        QFilter f = new QFilter("proInstId", "=", (Object)processInstanceId).and(new QFilter("lastNodeActInstId", "=", (Object)actInstId)).and(new QFilter("endTime", "is null", null));
        this.deleteByFilters(new QFilter[]{f});
    }

    @Override
    public List<HiUserActInstEntity> findByProcAndLastNodeActInstIds(Long procInstId, List<Long> lastNodeActInstIds) {
        QFilter proInstFilter = new QFilter("proInstId", "=", (Object)procInstId);
        QFilter actInstId = new QFilter("lastNodeActInstId", "in", lastNodeActInstIds);
        return this.findByQueryFilters(new QFilter[]{proInstFilter, actInstId});
    }

    @Override
    public void recoverLastNodeMapper(Long processInstanceId, Long actInstId) {
        QFilter f = new QFilter("proInstId", "=", (Object)processInstanceId).and(new QFilter("currentActInstId", "=", (Object)actInstId)).and(new QFilter("endTime", "is not null", null));
        List mappers = this.findByQueryBuilder(this.createEntityQueryBuilder(new QFilter[]{f}));
        if (mappers != null && !mappers.isEmpty()) {
            for (HiUserActInstEntity n : mappers) {
                n.setEndTime(null);
                this.update(n);
            }
        }
    }

    @Override
    public List<HiUserActInstEntity> findByActivityIdAndProinstId(String actid, Long proinstId) {
        QFilter f = new QFilter("proInstId", "=", (Object)proinstId).and(new QFilter("currentActId", "=", (Object)actid)).and(new QFilter("endTime", "is null", null));
        EntityQueryBuilder eb = this.createQueryBuilder().addFilters(new QFilter[]{f});
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("currentActId", actid);
        map.put("proInstId", proinstId);
        List<HiUserActInstEntity> entitys = this.getList(eb, this.matcher, map, true);
        if (entitys == null || entitys.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<HiUserActInstEntity> returnData = new ArrayList<HiUserActInstEntity>();
        for (HiUserActInstEntity i : entitys) {
            if (i.getEndTime() != null) continue;
            returnData.add(i);
        }
        return returnData;
    }

    @Override
    public List<HiUserActInstEntity> findCurrentUserActInsts(Long procInstId) {
        QFilter procInstFilter = new QFilter("proInstId", "=", (Object)procInstId);
        QFilter endFilter = new QFilter("endTime", "is null", null);
        EntityQueryBuilder eb = this.createQueryBuilder().addFilters(new QFilter[]{procInstFilter, endFilter});
        return this.findByQueryBuilder(eb);
    }

    @Override
    public List<HiUserActInstEntity> findByProcInstId(Long procInstId) {
        QFilter procInstFilter = new QFilter("proInstId", "=", (Object)procInstId);
        EntityQueryBuilder eb = this.createQueryBuilder().addFilters(new QFilter[]{procInstFilter});
        return this.findByQueryBuilder(eb);
    }

    @Override
    public List<HiUserActInstEntity> findeByProInstIdAndJoinFlag(Long proInstId, String joinFlag) {
        QFilter f = new QFilter("proInstId", "=", (Object)proInstId).and(new QFilter("joinFlag", "=", (Object)joinFlag));
        EntityQueryBuilder eb = this.createQueryBuilder().addFilters(new QFilter[]{f});
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("joinFlag", joinFlag);
        map.put("proInstId", proInstId);
        List<HiUserActInstEntity> entitys = this.getList(eb, this.joinFlagMatcher, map, true);
        if (entitys == null || entitys.isEmpty()) {
            return Collections.emptyList();
        }
        if (entitys.get(0).getEndTime() == null) {
            return entitys;
        }
        return Collections.emptyList();
    }

    @Override
    public List<HiUserActInstEntity> findByCurrentExecutionId(Long currentExecutionId) {
        QFilter f = new QFilter("currentExecutionId", "=", (Object)currentExecutionId).and(new QFilter("endTime", "is null", null));
        EntityQueryBuilder eb = this.createQueryBuilder().addFilters(new QFilter[]{f});
        List<HiUserActInstEntity> entitys = this.getList(eb, this.currentExecutionIdMatcher, currentExecutionId, true);
        if (entitys == null || entitys.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<HiUserActInstEntity> returnData = new ArrayList<HiUserActInstEntity>();
        for (HiUserActInstEntity i : entitys) {
            if (i.getEndTime() != null) continue;
            returnData.add(i);
        }
        return returnData;
    }

    @Override
    public List<HiUserActInstEntity> findeByProInstIdAndBusinessKey(Long proInstId) {
        QFilter[] qFilters = new QFilter[]{new QFilter("proInstId", "=", (Object)proInstId)};
        EntityQueryBuilder eb = this.createQueryBuilder().addFilters(qFilters).orderBy("createdate desc");
        List<HiUserActInstEntity> entitys = this.findByQueryBuilder(eb);
        return entitys;
    }
}

