/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.runtime;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.task.AttributeModifyRecord;

public class IdentityLinkEntityImpl
extends AbstractEntity
implements IdentityLinkEntity,
Serializable {
    private static final long serialVersionUID = 1L;
    protected TaskEntity task;
    protected ExecutionEntity processInstance;
    protected ProcessDefinitionEntity processDef;
    Map<String, AttributeModifyRecord> attributeModifyRecords = new HashMap<String, AttributeModifyRecord>();

    public IdentityLinkEntityImpl() {
    }

    public IdentityLinkEntityImpl(DynamicObject dynamicObject) {
        super(dynamicObject);
    }

    @Override
    public Object getPersistentState() {
        super.getPersistentState();
        HashMap<String, Object> persistentState = new HashMap<String, Object>(12);
        persistentState.put("id", this.getId());
        persistentState.put("type", this.getType());
        if (this.getUserId() != null) {
            persistentState.put("userid", this.getUserId());
        }
        if (this.getTaskId() != null) {
            persistentState.put("taskid", this.getTaskId());
        }
        if (this.getProcessInstanceId() != null) {
            persistentState.put("processinstanceid", this.getProcessInstanceId());
        }
        if (this.getProcessDefId() != null) {
            persistentState.put("processdefid", this.getProcessDefId());
        }
        if (this.getParenttaskid() != null) {
            persistentState.put("parenttaskid", this.getParenttaskid());
        }
        if (this.getUserName() != null) {
            persistentState.put("username", this.getUserName());
        }
        if (this.getCompositeTaskId() != null) {
            persistentState.put("compositetaskid", this.getCompositeTaskId());
        }
        if (this.getDelegateId() != null) {
            persistentState.put("delegateid", this.getDelegateId());
        }
        if (this.isDisplay() != null) {
            persistentState.put("display", this.isDisplay());
        }
        if (this.getTrustName() != null) {
            persistentState.put("trustname", this.getTrustName());
        }
        if (this.getReadTime() != null) {
            persistentState.put("readtime", this.getReadTime());
        }
        if (this.getTaskState() != null) {
            persistentState.put("taskstate", this.getTaskState());
        }
        return persistentState;
    }

    @Override
    public boolean isUser() {
        return this.getUserId() != null;
    }

    @Override
    @SimplePropertyAttribute(name="type")
    public String getType() {
        return this.dynamicObject.getString("type");
    }

    @Override
    public void setType(String type) {
        this.dynamicObject.set("type", (Object)type);
    }

    @Override
    @SimplePropertyAttribute(name="userid")
    public Long getUserId() {
        return this.normalizeId(this.dynamicObject.getLong("userid"));
    }

    @Override
    public void setUserId(Long userId) {
        this.gatherAttributeModifyRecord("userid", userId);
        this.dynamicObject.set("userid", (Object)userId);
    }

    @Override
    @SimplePropertyAttribute(name="taskid")
    public Long getTaskId() {
        return this.normalizeId(this.dynamicObject.getLong("taskid"));
    }

    @Override
    public void setTaskId(Long taskId) {
        this.dynamicObject.set("taskid", (Object)taskId);
    }

    @Override
    @SimplePropertyAttribute(name="parenttaskid")
    public Long getParenttaskid() {
        return this.normalizeId(this.dynamicObject.getLong("parenttaskid"));
    }

    @Override
    public void setParenttaskid(Long parenttaskid) {
        this.dynamicObject.set("parenttaskid", (Object)parenttaskid);
    }

    @Override
    @SimplePropertyAttribute(name="processinstanceid")
    public Long getProcessInstanceId() {
        return this.normalizeId(this.dynamicObject.getLong("processinstanceid"));
    }

    @Override
    public void setProcessInstanceId(Long processInstanceId) {
        this.dynamicObject.set("processinstanceid", (Object)processInstanceId);
    }

    @Override
    @SimplePropertyAttribute(name="processdefid")
    public Long getProcessDefId() {
        return this.normalizeId(this.dynamicObject.getLong("processdefid"));
    }

    @Override
    public void setProcessDefId(Long processDefId) {
        this.dynamicObject.set("processdefid", (Object)processDefId);
    }

    @Override
    @SimplePropertyAttribute(name="ownerid")
    public Long getOwnerId() {
        return this.normalizeId(this.dynamicObject.getLong("ownerid"));
    }

    @Override
    public void setOwnerId(Long ownerId) {
        this.gatherAttributeModifyRecord("ownerid", ownerId);
        this.dynamicObject.set("ownerid", (Object)ownerId);
    }

    @Override
    @SimplePropertyAttribute(name="transferopinion")
    public ILocaleString getTransferOpinion() {
        return this.dynamicObject.getLocaleString("transferopinion");
    }

    @Override
    public void setTransferOpinion(ILocaleString transferOpinion) {
        this.dynamicObject.set("transferopinion", (Object)WfUtils.subILocaleString(transferOpinion, 1990));
    }

    @Override
    @SimplePropertyAttribute(name="priority")
    public Integer getPriority() {
        return this.dynamicObject.getInt("priority");
    }

    @Override
    public void setPriority(Integer priority) {
        this.dynamicObject.set("priority", (Object)priority);
    }

    @Override
    public void setUserName(ILocaleString userName) {
        this.dynamicObject.set("username", (Object)WfUtils.subILocaleString(userName, 255));
    }

    @Override
    @SimplePropertyAttribute(name="username")
    public ILocaleString getUserName() {
        return this.dynamicObject.getLocaleString("username");
    }

    @Override
    public void setUserNameFormatter(ILocaleString userNameFormatter) {
        this.dynamicObject.set("usernameformatter", (Object)WfUtils.subILocaleString(userNameFormatter, 500));
    }

    @Override
    @SimplePropertyAttribute(name="usernameformatter")
    public ILocaleString getUserNameFormatter() {
        ILocaleString userNameFormat = this.dynamicObject.getLocaleString("usernameformatter");
        if (WfUtils.isEmpty(userNameFormat)) {
            userNameFormat = this.getUserName();
        }
        return userNameFormat;
    }

    @Override
    public void setIsPublic(Boolean isPublic) {
        this.dynamicObject.set("ispublic", (Object)isPublic);
    }

    @Override
    @SimplePropertyAttribute(name="ispublic")
    public Boolean getIsPublic() {
        return this.dynamicObject.getBoolean("ispublic");
    }

    @Override
    public void setCompositeTaskId(Long compitaskid) {
        this.gatherAttributeModifyRecord("compositetaskid", compitaskid);
        this.dynamicObject.set("compositetaskid", (Object)compitaskid);
    }

    @Override
    @SimplePropertyAttribute(name="compositetaskid")
    public Long getCompositeTaskId() {
        return this.dynamicObject.getLong("compositetaskid");
    }

    @Override
    @SimplePropertyAttribute(name="delegateid")
    public Long getDelegateId() {
        return this.dynamicObject.getLong("delegateid");
    }

    @Override
    public void setDelegateId(Long delegateId) {
        this.gatherAttributeModifyRecord("delegateid", delegateId);
        this.dynamicObject.set("delegateid", (Object)delegateId);
    }

    @Override
    @SimplePropertyAttribute(name="display")
    public Boolean isDisplay() {
        return this.dynamicObject.getBoolean("display");
    }

    @Override
    public void setDisplay(Boolean isDisplay) {
        this.gatherAttributeModifyRecord("display", isDisplay);
        this.dynamicObject.set("display", (Object)isDisplay);
    }

    @Override
    @SimplePropertyAttribute(name="trustname")
    public ILocaleString getTrustName() {
        return this.dynamicObject.getLocaleString("trustname");
    }

    @Override
    public void setTrustName(ILocaleString trustName) {
        this.dynamicObject.set("trustname", (Object)trustName);
    }

    @Override
    public void setTrustNameFormat(ILocaleString trustNameFormat) {
        this.dynamicObject.set("trustnameformat", (Object)WfUtils.subILocaleString(trustNameFormat, 490));
    }

    @Override
    public ILocaleString getTrustNameFormat() {
        ILocaleString trustNameFormat = this.dynamicObject.getLocaleString("trustnameformat");
        if (WfUtils.isEmpty(trustNameFormat)) {
            trustNameFormat = this.getTrustName();
        }
        return trustNameFormat;
    }

    @Override
    public TaskEntity getTask() {
        if (this.task == null && this.getTaskId() != null) {
            this.task = (TaskEntity)Context.getCommandContext().getTaskEntityManager().findById(this.getTaskId());
        }
        return this.task;
    }

    @Override
    public void setTask(TaskEntity task) {
        this.task = task;
        this.setTaskId(task.getId());
    }

    @Override
    public ExecutionEntity getProcessInstance() {
        if (this.processInstance == null && this.getProcessInstanceId() != null) {
            this.processInstance = (ExecutionEntity)Context.getCommandContext().getExecutionEntityManager().findById(this.getProcessInstanceId());
        }
        return this.processInstance;
    }

    @Override
    public void setProcessInstance(ExecutionEntity processInstance) {
        this.processInstance = processInstance;
        this.setProcessInstanceId(processInstance.getId());
    }

    @Override
    public ProcessDefinitionEntity getProcessDef() {
        if (this.processDef == null && this.getProcessDefId() != null) {
            this.processDef = (ProcessDefinitionEntity)Context.getCommandContext().getProcessDefinitionEntityManager().findById(this.getProcessDefId());
        }
        return this.processDef;
    }

    @Override
    public void setProcessDef(ProcessDefinitionEntity processDef) {
        this.processDef = processDef;
        this.setProcessDefId(processDef.getId());
    }

    @Override
    public Long getProcessDefinitionId() {
        return this.getProcessDefId();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("IdentityLinkEntity[id=").append(this.getId());
        sb.append(", type=").append(this.getType());
        if (this.getUserId() != null) {
            sb.append(", userId=").append(String.valueOf(this.getUserId()));
        }
        if (this.getOwnerId() != null) {
            sb.append(", ownerId=").append(String.valueOf(this.getOwnerId()));
        }
        if (this.getTaskId() != null) {
            sb.append(", taskId=").append(this.getTaskId());
        }
        if (this.getProcessInstanceId() != null) {
            sb.append(", processInstanceId=").append(this.getProcessInstanceId());
        }
        if (this.getProcessDefId() != null) {
            sb.append(", processDefId=").append(this.getProcessDefId());
        }
        if (this.getTransferOpinion() != null) {
            sb.append(", transferOpinion=").append(this.getTransferOpinion());
        }
        if (this.getPriority() != null) {
            sb.append(", priority=").append(this.getPriority());
        }
        if (this.getUserName() != null) {
            sb.append(", userName=").append(this.getUserName());
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public String getDynObjTypeName() {
        return "wf_participant";
    }

    @Override
    public void setCurrentSubject(ILocaleString currentSubject) {
        this.dynamicObject.set("currentsubject", (Object)WfUtils.subILocaleString(currentSubject, 2990));
    }

    @Override
    public ILocaleString getCurrentSubject() {
        return this.dynamicObject.getLocaleString("currentsubject");
    }

    @Override
    @SimplePropertyAttribute(name="readtime")
    public Date getReadTime() {
        return this.dynamicObject.getDate("readtime");
    }

    @Override
    public void setReadTime(Date readTime) {
        this.dynamicObject.set("readtime", (Object)readTime);
    }

    @Override
    public Map<String, AttributeModifyRecord> getAttributesModifyRecords() {
        return this.attributeModifyRecords;
    }

    @Override
    public void clearAttributesModifyRecords() {
        this.attributeModifyRecords = new HashMap<String, AttributeModifyRecord>();
    }

    private void gatherAttributeModifyRecord(String attribute, Object newValue) {
        this.gatherAttributeModifyRecord(this.dynamicObject, attribute, newValue);
    }

    @Override
    public void setName(ILocaleString name) {
        this.dynamicObject.set("name", (Object)WfUtils.subILocaleString(name, 255));
    }

    @Override
    @SimplePropertyAttribute(name="name")
    public ILocaleString getName() {
        return this.dynamicObject.getLocaleString("name");
    }

    @Override
    public void setExecutionId(Long executionId) {
        this.dynamicObject.set("executionId", (Object)executionId);
    }

    @Override
    @SimplePropertyAttribute(name="executionId")
    public Long getExecutionId() {
        return this.dynamicObject.getLong("executionId");
    }

    @Override
    @SimplePropertyAttribute(name="taskDefinitionKey")
    public String getTaskDefinitionKey() {
        return this.dynamicObject.getString("taskDefinitionKey");
    }

    @Override
    public void setTaskDefinitionKey(String taskDefinitionKey) {
        this.dynamicObject.set("taskDefinitionKey", (Object)taskDefinitionKey);
    }

    @Override
    @SimplePropertyAttribute(name="mobileFormKey")
    public String getMobileFormKey() {
        return this.dynamicObject.getString("mobileFormKey");
    }

    @Override
    public void setMobileFormKey(String mobileFormKey) {
        this.dynamicObject.set("mobileFormKey", (Object)mobileFormKey);
    }

    @Override
    @SimplePropertyAttribute(name="category")
    public String getCategory() {
        return this.dynamicObject.getString("category");
    }

    @Override
    public void setCategory(String category) {
        this.dynamicObject.set("category", (Object)category);
    }

    @Override
    @SimplePropertyAttribute(name="entityNumber")
    public String getEntityNumber() {
        return this.dynamicObject.getString("entityNumber");
    }

    @Override
    public void setEntityNumber(String entityNumber) {
        this.dynamicObject.set("entityNumber", (Object)entityNumber);
    }

    @Override
    @SimplePropertyAttribute(name="entityName")
    public ILocaleString getEntityName() {
        return this.dynamicObject.getLocaleString("entityName");
    }

    @Override
    public void setEntityName(ILocaleString entityName) {
        this.dynamicObject.set("entityName", (Object)entityName);
    }

    @Override
    @SimplePropertyAttribute(name="businessKey")
    public String getBusinessKey() {
        return this.dynamicObject.getString("businessKey");
    }

    @Override
    public void setBusinessKey(String businessKey) {
        this.dynamicObject.set("businessKey", (Object)businessKey);
    }

    @Override
    @SimplePropertyAttribute(name="processingMobilePage")
    public String getProcessingMobilePage() {
        return this.dynamicObject.getString("processingMobilePage");
    }

    @Override
    public void setProcessingMobilePage(String processingMobilePage) {
        this.dynamicObject.set("processingMobilePage", (Object)processingMobilePage);
    }

    @Override
    @SimplePropertyAttribute(name="processingPage")
    public String getProcessingPage() {
        return this.dynamicObject.getString("processingPage");
    }

    @Override
    public void setProcessingPage(String processingPage) {
        this.dynamicObject.set("processingPage", (Object)processingPage);
    }

    @Override
    @SimplePropertyAttribute(name="senderId")
    public String getSenderId() {
        return this.dynamicObject.getString("senderId");
    }

    @Override
    public void setSenderId(String senderId) {
        this.dynamicObject.set("senderId", (Object)senderId);
    }

    @Override
    @SimplePropertyAttribute(name="senderName")
    public ILocaleString getSenderName() {
        return this.dynamicObject.getLocaleString("senderName");
    }

    @Override
    public void setSenderName(ILocaleString senderName) {
        this.dynamicObject.set("senderName", (Object)WfUtils.subILocaleString(senderName, 500));
    }

    @Override
    @SimplePropertyAttribute(name="startName")
    public ILocaleString getStartName() {
        return this.dynamicObject.getLocaleString("startName");
    }

    @Override
    public void setStartName(ILocaleString startName) {
        this.dynamicObject.set("startName", (Object)WfUtils.subILocaleString(startName, 200));
    }

    @Override
    public void setStartNameFormat(ILocaleString startNameFormat) {
        this.dynamicObject.set("startnameformat", (Object)WfUtils.subILocaleString(startNameFormat, 300));
    }

    @Override
    public void setSenderNameFormat(ILocaleString senderNameFormat) {
        this.dynamicObject.set("sendernameformat", (Object)WfUtils.subILocaleString(senderNameFormat, 500));
    }

    @Override
    @SimplePropertyAttribute(name="sendernameformat")
    public ILocaleString getSenderNameFormat() {
        return this.dynamicObject.getLocaleString("sendernameformat");
    }

    @Override
    public ILocaleString getStartNameFormat() {
        return this.dynamicObject.getLocaleString("startnameformat");
    }

    @Override
    @SimplePropertyAttribute(name="billNo")
    public String getBillNo() {
        return this.dynamicObject.getString("billNo");
    }

    @Override
    public void setBillNo(String billNo) {
        this.dynamicObject.set("billNo", (Object)WfUtils.subStringForMax(billNo, 200));
    }

    @Override
    @SimplePropertyAttribute(name="starterId")
    public Long getStarterId() {
        return this.normalizeId(this.dynamicObject.getLong("starterId"));
    }

    @Override
    public void setStarterId(Long starterId) {
        this.dynamicObject.set("starterId", (Object)starterId);
    }

    @Override
    public void setEndType(String endType) {
        this.dynamicObject.set("endType", (Object)endType);
    }

    @Override
    @SimplePropertyAttribute(name="endType")
    public String getEndType() {
        return this.dynamicObject.getString("endType");
    }

    @Override
    @SimplePropertyAttribute(name="participantName")
    public ILocaleString getParticipantName() {
        return this.dynamicObject.getLocaleString("participantName");
    }

    @Override
    public void setParticipantName(ILocaleString participantName) {
        this.dynamicObject.set("participantName", (Object)WfUtils.subILocaleString(participantName, 300));
    }

    @Override
    @SimplePropertyAttribute(name="groupnumber")
    public Long getGroupNumber() {
        Object groupNumber = this.dynamicObject.get("groupnumber");
        if (groupNumber instanceof DynamicObject) {
            return ((DynamicObject)groupNumber).getLong("id");
        }
        return this.dynamicObject.getLong("groupnumber");
    }

    @Override
    public void setGroupNumber(Long number) {
        this.dynamicObject.set("groupnumber", (Object)number);
    }

    @Override
    @SimplePropertyAttribute(name="biztraceno")
    public String getBizTraceNo() {
        return this.dynamicObject.getString("biztraceno");
    }

    @Override
    public void setBizTraceNo(String bizTraceNo) {
        this.dynamicObject.set("biztraceno", (Object)bizTraceNo);
    }

    @Override
    public void setBillType(String billType) {
        this.dynamicObject.set("billType", (Object)billType);
    }

    @Override
    @SimplePropertyAttribute(name="billType")
    public String getBillType() {
        return this.dynamicObject.getString("billType");
    }

    @Override
    @SimplePropertyAttribute(name="processtype")
    public String getProcessType() {
        return this.dynamicObject.getString("processtype");
    }

    @Override
    public void setProcessType(String processType) {
        this.dynamicObject.set("processtype", (Object)processType);
    }

    @Override
    @SimplePropertyAttribute(name="biz_date")
    public Date getBusinessDate() {
        return this.dynamicObject.getDate("biz_date");
    }

    @Override
    public void setBusinessDate(Date businessDate) {
        this.dynamicObject.set("biz_date", (Object)businessDate);
    }

    @Override
    @SimplePropertyAttribute(name="biz_number")
    public double getBusinessNumber() {
        return this.dynamicObject.getBigDecimal("biz_number").doubleValue();
    }

    @Override
    public void setBusinessNumber(double businessNumber) {
        this.dynamicObject.set("biz_number", (Object)businessNumber);
    }

    @Override
    @SimplePropertyAttribute(name="bizformat")
    public String getBusinessFormat() {
        return this.dynamicObject.getString("bizformat");
    }

    @Override
    public void setBusinessFormat(String businessFormat) {
        this.dynamicObject.set("bizformat", (Object)businessFormat);
    }

    @Override
    @SimplePropertyAttribute(name="biz_str1")
    public String getBusinessStr1() {
        return this.dynamicObject.getString("biz_str1");
    }

    @Override
    public void setBusinessStr1(String businessStr1) {
        this.dynamicObject.set("biz_str1", (Object)businessStr1);
    }

    @Override
    @SimplePropertyAttribute(name="biz_str2")
    public String getBusinessStr2() {
        return this.dynamicObject.getString("biz_str2");
    }

    @Override
    public void setBusinessStr2(String businessStr2) {
        this.dynamicObject.set("biz_str2", (Object)businessStr2);
    }

    @Override
    @SimplePropertyAttribute(name="biz_date2")
    public Date getBusinessDate2() {
        return this.dynamicObject.getDate("biz_date2");
    }

    @Override
    public void setBusinessDate2(Date businessDate) {
        this.dynamicObject.set("biz_date2", (Object)businessDate);
    }

    @Override
    @SimplePropertyAttribute(name="biz_number2")
    public double getBusinessNumber2() {
        return this.dynamicObject.getBigDecimal("biz_number2").doubleValue();
    }

    @Override
    public void setBusinessNumber2(double businessNumber) {
        this.dynamicObject.set("biz_number2", (Object)businessNumber);
    }

    @Override
    @SimplePropertyAttribute(name="biz_strmul1")
    public ILocaleString getBusinessMulStr1() {
        return this.dynamicObject.getLocaleString("biz_strmul1");
    }

    @Override
    public void setBusinessMulStr1(ILocaleString businessStr) {
        this.dynamicObject.set("biz_strmul1", (Object)businessStr);
    }

    @Override
    @SimplePropertyAttribute(name="biz_strmul2")
    public ILocaleString getBusinessMulStr2() {
        return this.dynamicObject.getLocaleString("biz_strmul2");
    }

    @Override
    public void setBusinessMulStr2(ILocaleString businessStr) {
        this.dynamicObject.set("biz_strmul2", (Object)businessStr);
    }

    @Override
    public void setTaskState(String taskState) {
        this.dynamicObject.set("taskstate", (Object)taskState);
    }

    @Override
    @SimplePropertyAttribute(name="taskstate")
    public String getTaskState() {
        return this.dynamicObject.getString("taskstate");
    }

    @Override
    public void setSource(String source) {
        this.dynamicObject.set("source", (Object)source);
    }

    @Override
    @SimplePropertyAttribute(name="source")
    public String getSource() {
        return this.dynamicObject.getString("source");
    }

    @Override
    public void setBizType(String bizType) {
        this.dynamicObject.set("biztype", (Object)bizType);
    }

    @Override
    @SimplePropertyAttribute(name="biztype")
    public String getBizType() {
        return this.dynamicObject.getString("biztype");
    }

    @Override
    @SimplePropertyAttribute(name="taskdisplay")
    public Boolean isTaskDisplay() {
        return this.dynamicObject.getBoolean("taskdisplay");
    }

    @Override
    public void setTaskDisplay(Boolean isTaskDisplay) {
        this.gatherAttributeModifyRecord("taskdisplay", isTaskDisplay);
        this.dynamicObject.set("taskdisplay", (Object)isTaskDisplay);
    }

    @Override
    public void setSourceName(ILocaleString sourceName) {
        this.dynamicObject.set("sourcename", (Object)sourceName);
    }

    @Override
    @SimplePropertyAttribute(name="sourcename")
    public ILocaleString getSourceName() {
        return this.dynamicObject.getLocaleString("sourcename");
    }
}

