/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.event.ActivitiEventDispatcher;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.persistence.CachedEntityMatcher;
import kd.bos.workflow.engine.impl.persistence.CountingExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.IdentityLinkByTaskIdMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.IdentityLinksByFiltersMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.IdentityLinksByParentTaskIdMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.ParticipantHelper;
import kd.bos.workflow.engine.task.AttributeModifyRecord;
import kd.bos.workflow.feature.taskfield.util.TaskExtendFieldUtil;

public class IdentityLinkEntityManagerImpl
extends AbstractEntityManager<IdentityLinkEntity>
implements IdentityLinkEntityManager {
    protected CachedEntityMatcher<IdentityLinkEntity> identityLinkByTaskIdMatcher = new IdentityLinkByTaskIdMatcher();
    protected CachedEntityMatcher<IdentityLinkEntity> identityLinkIdByFiltersMatcher = new IdentityLinksByFiltersMatcher();
    protected CachedEntityMatcher<IdentityLinkEntity> identityLinkByParentTaskIdMatcher = new IdentityLinksByParentTaskIdMatcher();

    public IdentityLinkEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public void insert(IdentityLinkEntity entity) {
        this.insert(entity, true);
    }

    @Override
    public void insert(IdentityLinkEntity entity, boolean fireCreateEvent) {
        CountingExecutionEntity executionEntity;
        this.setCurrentSubject(entity);
        this.setTaskPropertityToParticipant(entity.getTask(), entity);
        this.getDbSqlSession().insert(entity);
        ActivitiEventDispatcher eventDispatcher = this.getEventDispatcher();
        if (eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_CREATED, entity));
        }
        this.getHistoryManager().recordIdentityLinkCreated(entity);
        if (entity.getProcessInstanceId() != null && this.isExecutionRelatedEntityCountEnabledGlobally() && this.isExecutionRelatedEntityCountEnabled(executionEntity = (CountingExecutionEntity)this.getExecutionEntityManager().findById(entity.getProcessInstanceId()))) {
            executionEntity.setIdentityLinkCount(executionEntity.getIdentityLinkCount() + 1);
        }
    }

    private void setTaskPropertityToParticipant(TaskEntity taskEntity, IdentityLinkEntity entity) {
        if (taskEntity == null && WfUtils.isNotEmpty(entity.getTaskId())) {
            taskEntity = (TaskEntity)this.getTaskEntityManager().findById(entity.getTaskId());
        }
        if (taskEntity != null) {
            entity.setName(taskEntity.getName());
            entity.setExecutionId(taskEntity.getExecutionId());
            entity.setTaskDefinitionKey(taskEntity.getTaskDefinitionKey());
            entity.setMobileFormKey(taskEntity.getMobileFormKey());
            entity.setCategory(taskEntity.getCategory());
            entity.setEntityNumber(taskEntity.getEntityNumber());
            entity.setEntityName(taskEntity.getEntityName());
            entity.setBusinessKey(taskEntity.getBusinessKey());
            entity.setProcessingMobilePage(taskEntity.getProcessingMobilePage());
            entity.setProcessingPage(taskEntity.getProcessingPage());
            entity.setSenderId(taskEntity.getSenderId());
            entity.setSenderName(taskEntity.getSenderName());
            entity.setStartName(taskEntity.getStartName());
            entity.setSenderNameFormat(taskEntity.getSenderNameFormat());
            entity.setStartNameFormat(taskEntity.getStartNameFormat());
            entity.setTaskState(taskEntity.getTaskState());
            entity.setBillNo(taskEntity.getBillNo());
            entity.setStarterId(taskEntity.getStarterId());
            entity.setEndType(taskEntity.getEndType());
            entity.setParticipantName(taskEntity.getParticipantName());
            entity.setGroupNumber(taskEntity.getGroupNumber());
            entity.setBillType(taskEntity.getBillType());
            entity.setBizTraceNo(taskEntity.getBizTraceNo());
            entity.setProcessType(taskEntity.getProcessType());
            entity.setBusinessDate(taskEntity.getBusinessDate());
            entity.setBusinessNumber(taskEntity.getBusinessNumber());
            entity.setBusinessFormat(taskEntity.getBusinessFormat());
            entity.setBusinessStr1(taskEntity.getBusinessStr1());
            entity.setBusinessStr2(taskEntity.getBusinessStr2());
            entity.setBusinessDate2(taskEntity.getBusinessDate2());
            entity.setBusinessNumber2(taskEntity.getBusinessNumber2());
            entity.setBusinessMulStr1(taskEntity.getBusinessMulStr1());
            entity.setBusinessMulStr2(taskEntity.getBusinessMulStr2());
            TaskExtendFieldUtil.setExtendTaskBusinessField(entity.getDynamicObject(), taskEntity.getDynamicObject());
            entity.setSource(taskEntity.getSource());
            entity.setSourceName(taskEntity.getSourceName());
            entity.setBizType(taskEntity.getYzjGroupId());
            entity.setTaskDisplay(taskEntity.isDisplay());
        }
    }

    @Override
    public IdentityLinkEntity update(IdentityLinkEntity entity) {
        return this.update(entity, true);
    }

    @Override
    public IdentityLinkEntity update(IdentityLinkEntity entity, boolean fireCreateEvent) {
        this.getDbSqlSession().update(entity);
        ActivitiEventDispatcher eventDispatcher = this.getEventDispatcher();
        if (fireCreateEvent && this.getEventDispatcher().isEnabled()) {
            eventDispatcher.dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_UPDATED, entity));
        }
        entity.clearAttributesModifyRecords();
        return entity;
    }

    @Override
    public void updateIdentityLinksByTaskId(Map<String, AttributeModifyRecord> records, Long taskId) {
        Boolean display;
        String taskState = records.get("taskstate") == null ? null : (String)records.get("taskstate").getNewValue();
        Boolean bl = display = records.get("display") == null ? null : (Boolean)records.get("display").getNewValue();
        if (taskState == null && display == null) {
            return;
        }
        List<IdentityLinkEntity> identityLinkEntities = this.findIdentityLinksByTaskId(taskId);
        for (IdentityLinkEntity identityLinkEntity : identityLinkEntities) {
            if (taskState != null) {
                identityLinkEntity.setTaskState(taskState);
            }
            if (display != null) {
                identityLinkEntity.setTaskDisplay(display);
            }
            this.update(identityLinkEntity);
        }
    }

    @Override
    public void delete(Long id) {
        IdentityLinkEntity entity = (IdentityLinkEntity)this.findById(id);
        if (entity != null) {
            this.delete(entity);
        }
    }

    @Override
    public void delete(IdentityLinkEntity entity) {
        this.delete(entity, true);
    }

    @Override
    public void delete(IdentityLinkEntity entity, boolean fireDeleteEvent) {
        if (entity == null) {
            return;
        }
        boolean isTwiceDelete = entity.isDeleted();
        this.getDbSqlSession().delete(entity);
        ActivitiEventDispatcher eventDispatcher = this.getEventDispatcher();
        if (this.getEventDispatcher().isEnabled() && !isTwiceDelete) {
            eventDispatcher.dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_DELETED, entity));
        }
    }

    private void setCurrentSubject(IdentityLinkEntity entity) {
        TaskEntity task;
        if (WfUtils.isNotEmpty(entity.getCurrentSubject())) {
            return;
        }
        if (entity.getTask() != null) {
            entity.setCurrentSubject(entity.getTask().getSubject());
        } else if (WfUtils.isNotEmpty(entity.getTaskId()) && (task = (TaskEntity)this.getTaskEntityManager().findById(entity.getTaskId())) != null) {
            entity.setCurrentSubject(task.getSubject());
        }
    }

    public void deleteDirectIdentityLink(IdentityLinkEntity identityLink, boolean cascadeHistory) {
        this.delete(identityLink, false);
        if (cascadeHistory) {
            this.getHistoryManager().deleteHistoricIdentityLink(identityLink.getId());
        }
    }

    @Override
    public void deleteIdentityLink(IdentityLinkEntity identityLink, boolean cascadeHistory) {
        CountingExecutionEntity executionEntity;
        TaskEntity task;
        ILocaleString name;
        this.delete(identityLink, false);
        if ("participant".equalsIgnoreCase(identityLink.getType()) && WfUtils.isNotEmpty(identityLink.getUserId()) && WfUtils.isNotEmpty(identityLink.getTaskId()) && WfUtils.isNotEmpty(name = WfUtils.findUserName(identityLink.getUserId())) && (task = (TaskEntity)this.getTaskEntityManager().findById(identityLink.getTaskId())) != null) {
            if (WfConfigurationUtil.isDisplaySetting()) {
                Map<Long, ILocaleString> nameFormateMap = ParticipantHelper.getParticipantDisplayInfo(task, Collections.singletonList(identityLink.getUserId()));
                name = nameFormateMap.get(identityLink.getUserId());
            }
            ILocaleString participantName = task.getParticipantName();
            WfUtils.removeLocaleString(participantName, name);
            task.setParticipantName(participantName);
            this.getTaskEntityManager().update(task);
            HistoricTaskInstanceEntity his = (HistoricTaskInstanceEntity)this.getHistoricTaskInstanceEntityManager().findById(identityLink.getTaskId());
            his.setParticipantName(task.getParticipantName());
            this.getHistoricTaskInstanceEntityManager().update(his);
        }
        if (cascadeHistory) {
            this.getHistoryManager().deleteHistoricIdentityLink(identityLink.getId());
        }
        if (identityLink.getProcessInstanceId() != null && this.isExecutionRelatedEntityCountEnabledGlobally() && this.isExecutionRelatedEntityCountEnabled(executionEntity = (CountingExecutionEntity)this.getExecutionEntityManager().findById(identityLink.getProcessInstanceId()))) {
            executionEntity.setIdentityLinkCount(executionEntity.getIdentityLinkCount() - 1);
        }
    }

    @Override
    public IdentityLinkEntity addIdentityLink(ExecutionEntity executionEntity, Long userId, String type) {
        IdentityLinkEntity identityLinkEntity = this.create();
        executionEntity.getIdentityLinks().add(identityLinkEntity);
        identityLinkEntity.setProcessInstance(executionEntity.getProcessInstance() != null ? executionEntity.getProcessInstance() : executionEntity);
        identityLinkEntity.setUserId(userId);
        identityLinkEntity.setUserName(WfUtils.findUserName(userId));
        identityLinkEntity.setUserNameFormatter((ILocaleString)new LocaleString(""));
        identityLinkEntity.setProcessDefId(executionEntity.getProcessDefinitionId());
        identityLinkEntity.setType(type);
        this.insert(identityLinkEntity);
        return identityLinkEntity;
    }

    @Override
    public Map<Long, IdentityLinkEntity> addIdentityLinks(TaskEntity taskEntity, List<Long> userIds, String type) {
        Map<Long, ILocaleString> participantFormat = ParticipantHelper.getParticipantDisplayInfo(taskEntity, userIds);
        HashMap<Long, IdentityLinkEntity> identityLinkEntitys = new HashMap<Long, IdentityLinkEntity>(userIds.size());
        for (Long userId : userIds) {
            ILocaleString participantDisplayInfo = participantFormat.get(userId);
            IdentityLinkEntity identityLinkEntity = this.create();
            taskEntity.getIdentityLinks().add(identityLinkEntity);
            identityLinkEntity.setTask(taskEntity);
            identityLinkEntity.setUserId(userId);
            identityLinkEntity.setUserName(WfUtils.findUserName(userId));
            identityLinkEntity.setUserNameFormatter(participantDisplayInfo);
            identityLinkEntity.setType(type);
            identityLinkEntity.setProcessInstanceId(taskEntity.getProcessInstanceId());
            identityLinkEntity.setProcessDefId(taskEntity.getProcessDefinitionId());
            identityLinkEntity.setTaskId(taskEntity.getId());
            identityLinkEntity.setParenttaskid(taskEntity.getParentTaskId());
            this.insert(identityLinkEntity);
            if (userId != null && taskEntity.getProcessInstanceId() != null) {
                this.involveUser(taskEntity.getProcessInstance(), userId, "participant");
            }
            identityLinkEntitys.put(userId, identityLinkEntity);
        }
        return identityLinkEntitys;
    }

    @Override
    public IdentityLinkEntity addIdentityLink(TaskEntity taskEntity, Long userId, String type) {
        Map<Long, ILocaleString> participantFormat = ParticipantHelper.getParticipantDisplayInfo(taskEntity, Collections.singletonList(userId));
        ILocaleString participantDisplayInfo = participantFormat.get(userId);
        IdentityLinkEntity identityLinkEntity = this.create();
        taskEntity.getIdentityLinks().add(identityLinkEntity);
        identityLinkEntity.setTask(taskEntity);
        identityLinkEntity.setUserId(userId);
        identityLinkEntity.setUserName(WfUtils.findUserName(userId));
        identityLinkEntity.setUserNameFormatter(participantDisplayInfo);
        identityLinkEntity.setType(type);
        identityLinkEntity.setProcessInstanceId(taskEntity.getProcessInstanceId());
        identityLinkEntity.setProcessDefId(taskEntity.getProcessDefinitionId());
        identityLinkEntity.setTaskId(taskEntity.getId());
        identityLinkEntity.setParenttaskid(taskEntity.getParentTaskId());
        this.insert(identityLinkEntity);
        if (userId != null && taskEntity.getProcessInstanceId() != null) {
            this.involveUser(taskEntity.getProcessInstance(), userId, "participant");
        }
        return identityLinkEntity;
    }

    @Override
    public IdentityLinkEntity addIdentityLink(ProcessDefinitionEntity processDefinitionEntity, Long userId) {
        IdentityLinkEntity identityLinkEntity = this.create();
        processDefinitionEntity.getIdentityLinks().add(identityLinkEntity);
        identityLinkEntity.setProcessDef(processDefinitionEntity);
        identityLinkEntity.setUserId(userId);
        identityLinkEntity.setUserName(WfUtils.findUserName(userId));
        identityLinkEntity.setType("participant");
        this.insert(identityLinkEntity);
        return identityLinkEntity;
    }

    @Override
    public IdentityLinkEntity involveUser(ExecutionEntity executionEntity, Long userId, String type) {
        return null;
    }

    @Override
    public void addCandidateUser(TaskEntity taskEntity, Long userId) {
        this.addIdentityLink(taskEntity, userId, "participant");
    }

    @Override
    public void addCandidateUsers(TaskEntity taskEntity, Collection<Long> candidateUsers) {
        for (Long candidateUser : candidateUsers) {
            this.addCandidateUser(taskEntity, candidateUser);
        }
    }

    @Override
    public IdentityLinkEntity addUserIdentityLink(TaskEntity taskEntity, Long userId, String identityLinkType) {
        return this.addIdentityLink(taskEntity, userId, identityLinkType);
    }

    @Override
    @Deprecated
    public void deleteIdentityLink(ExecutionEntity executionEntity, Long userId, String type) {
        Long id = executionEntity.getProcessInstanceId() != null ? executionEntity.getProcessInstanceId() : executionEntity.getId();
        List<IdentityLinkEntity> identityLinks = this.findIdentityLinkByProcessInstanceUserAndType(id, userId, type);
        for (IdentityLinkEntity identityLink : identityLinks) {
            this.deleteIdentityLink(identityLink, true);
        }
        executionEntity.getIdentityLinks().removeAll(identityLinks);
    }

    @Override
    public void deleteIdentityLink(TaskEntity taskEntity, Long userId, String type) {
        List<IdentityLinkEntity> identityLinks = this.findIdentityLinkByTaskUserAndType(taskEntity.getId(), userId, type);
        ArrayList<Long> identityLinkIds = new ArrayList<Long>(identityLinks.size());
        for (IdentityLinkEntity identityLink : identityLinks) {
            this.deleteIdentityLink(identityLink, Boolean.TRUE);
            identityLinkIds.add(identityLink.getId());
        }
        ArrayList<IdentityLinkEntity> removedIdentityLinkEntities = new ArrayList<IdentityLinkEntity>();
        for (IdentityLinkEntity identityLinkEntity : taskEntity.getIdentityLinks()) {
            if (!"participant".equals(identityLinkEntity.getType()) || identityLinkIds.contains(identityLinkEntity.getId()) || userId == null || !userId.equals(identityLinkEntity.getUserId())) continue;
            this.deleteIdentityLink(identityLinkEntity, true);
            removedIdentityLinkEntities.add(identityLinkEntity);
        }
        taskEntity.getIdentityLinks().removeAll(removedIdentityLinkEntities);
    }

    @Override
    public void deleteIdentityLink(ProcessDefinitionEntity processDefinitionEntity, Long userId) {
        List<IdentityLinkEntity> identityLinks = this.findIdentityLinkByProcessDefinitionUser(processDefinitionEntity.getId(), userId);
        for (IdentityLinkEntity identityLink : identityLinks) {
            this.deleteIdentityLink(identityLink, false);
        }
    }

    @Override
    public void deleteIdentityLinksByTask(TaskEntity taskEntity) {
        List<IdentityLinkEntity> identityLinks = this.findIdentityLinksByTaskId(taskEntity.getId());
        for (IdentityLinkEntity identityLink : identityLinks) {
            this.deleteDirectIdentityLink(identityLink, false);
        }
        taskEntity.getIdentityLinks().removeAll(identityLinks);
        taskEntity.setParticipantName(WfMultiLangUtils.getMultiLangValue(" "));
    }

    @Override
    public IdentityLinkEntity create() {
        return new IdentityLinkEntityImpl();
    }

    @Override
    public IdentityLinkEntity create(DynamicObject dynamicObject) {
        return new IdentityLinkEntityImpl(dynamicObject);
    }

    @Override
    public Class<? extends IdentityLinkEntity> getManagedEntityClass() {
        return IdentityLinkEntityImpl.class;
    }

    @Override
    public String getSelectFields() {
        return "id,type,userId,taskId,processInstanceId,processDefId,ownerId,transferOpinion,parenttaskid,priority,createdate,modifydate,username,ispublic,compositetaskid,usernameformatter,delegateid,display,trustname,trustnameformat,currentsubject,readtime,name,taskdefinitionkey,mobileformkey,category,sourcename,entitynumber,entityname,businesskey,processingmobilepage,processingpage,senderid,sendername,startname,sendernameformat,startnameformat,starterid,billno,endtype,priorityshow,participantname,groupnumber,biztraceno,billtype,processtype,taskstate,executionId,source,biztype,taskdisplay,biz_date,biz_number,bizformat,biz_str1,biz_str2,biz_date2,biz_number2,biz_strmul1,biz_strmul2";
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinksByTaskId(Long taskId) {
        return this.findIdentityLinksByTaskId(taskId, null);
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinksByTaskId(Long taskId, String fields) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("taskid", taskId);
        if (WfUtils.isNotEmpty(fields)) {
            eb.setSelectFields(fields);
        }
        return this.findByQueryBuilder(eb, this.identityLinkByTaskIdMatcher, taskId, true);
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinksByParentTaskId(Long parentTaskId, Long processInstanceId, String fields) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("processinstanceid", processInstanceId).addFilter("parenttaskid", parentTaskId);
        if (WfUtils.isNotEmpty(fields)) {
            eb.setSelectFields(fields);
        }
        HashMap<String, Long> param = new HashMap<String, Long>(2);
        param.put("processInstanceId", processInstanceId);
        param.put("parentTaskId", parentTaskId);
        return this.findByQueryBuilder(eb, this.identityLinkByParentTaskIdMatcher, param, true);
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinksByFilters(QFilter[] filters, Object parameter, boolean checkCache) {
        EntityQueryBuilder eb = this.createQueryBuilder();
        eb.addFilters(filters);
        return this.getList(eb, this.identityLinkIdByFiltersMatcher, parameter, checkCache);
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinksByTaskIds(Long[] taskIds) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("taskid", "in", taskIds);
        return this.findByQueryBuilder(eb);
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinksByProcessInstanceId(Long processInstanceId) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("processinstanceid", processInstanceId);
        return this.findByQueryBuilder(eb);
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinksByProcessDefinitionId(Long processDefinitionId) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("processdefid", processDefinitionId);
        return this.findByQueryBuilder(eb);
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinkByTaskIdAndType(Long taskId, String type) {
        EntityQueryBuilder entityQueryBuilder = this.createQueryBuilder();
        entityQueryBuilder.addFilter("taskid", taskId);
        entityQueryBuilder.addFilter("type", type);
        return this.findByQueryBuilder(entityQueryBuilder);
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinkByTaskUserAndType(Long taskId, Long userId, String type) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("taskid", taskId);
        if (userId > 0L) {
            eb.addFilter("userid", userId);
        }
        if (null != type) {
            eb.addFilter("type", type);
        }
        return this.findByQueryBuilder(eb);
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinkByTaskOwnerAndType(Long taskId, Long ownerId, String type) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("taskid", taskId);
        if (ownerId > 0L) {
            eb.addFilter("ownerid", ownerId);
        }
        if (null != type) {
            eb.addFilter("type", type);
        }
        return this.findByQueryBuilder(eb);
    }

    @Override
    public List<IdentityLinkEntity> findUnDelegateIdentityLinkByTaskUserAndType(Long taskId, Long userId, String type) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("taskid", taskId).orderBy("id");
        if (userId > 0L) {
            eb.addFilter("userid", userId);
        }
        if (null != type) {
            eb.addFilter("type", type);
        }
        eb.addFilter("delegateid", 0L);
        return this.findByQueryBuilder(eb);
    }

    @Override
    public List<IdentityLinkEntity> findDelegateIdentityLinkByTaskOwnerAndType(Long taskId, Long ownerId, String type) {
        EntityQueryBuilder entityQueryBuilder = this.createQueryBuilder();
        entityQueryBuilder.addFilter("taskid", "=", taskId);
        entityQueryBuilder.addFilter("type", "=", type);
        entityQueryBuilder.addFilter("ownerid", "=", ownerId);
        entityQueryBuilder.addFilter("delegateid", "!=", 0L);
        return this.findByQueryBuilder(entityQueryBuilder);
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinkByProcessInstanceUserAndType(Long processInstanceId, Long userId, String type) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("processinstanceid", processInstanceId);
        if (userId > 0L) {
            eb.addFilter("userid", userId);
        }
        if (null != type) {
            eb.addFilter("type", type);
        }
        return this.findByQueryBuilder(eb);
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinkByProcessDefinitionUser(Long processDefinitionId, Long userId) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("processdefid", processDefinitionId);
        if (userId > 0L) {
            eb.addFilter("userid", userId);
        }
        return this.findByQueryBuilder(eb);
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinksByParentTaskId(Long parentTaskId) {
        EntityQueryBuilder entityQueryBuilder = this.createQueryBuilder();
        entityQueryBuilder.addFilter("parenttaskid", "=", parentTaskId);
        return this.findByQueryBuilder(entityQueryBuilder);
    }

    @Override
    public void deleteIdentityLinksByProcDef(Long processDefId) {
        QFilter q = new QFilter("processDefId", "=", (Object)processDefId);
        QFilter[] qFilters = new QFilter[]{q};
        this.deleteByFilters(qFilters);
    }

    @Override
    public void deleteIdentityLinksByProcessInstanceId(Long processInstanceId) {
        QFilter q = new QFilter("processinstanceid", "=", (Object)processInstanceId);
        QFilter[] qFilters = new QFilter[]{q};
        this.deleteByFilters(qFilters);
    }

    @Override
    public void deleteByFilters(QFilter[] qFilters) {
        List identityLinks = this.findByQueryFilters(qFilters);
        for (IdentityLinkEntity identityLink : identityLinks) {
            this.delete(identityLink, true);
        }
    }

    @Override
    public String getEntityName() {
        return "wf_participant";
    }
}

