/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.api.constants.WFTaskResultEnum;
import kd.bos.workflow.bpmn.model.ActivitiListener;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.bpmn.behavior.TaskBehaviorUtil;
import kd.bos.workflow.engine.impl.cmd.precomputation.NodeTempVariable;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.CountingExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.TimerJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ManagementConstants;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.EventSubscriptionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.VariableInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.VariableScopeImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityImpl;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.variable.VariableType;
import kd.bos.workflow.engine.impl.variable.VariableTypes;
import kd.bos.workflow.exception.WFEngineException;

public class PreComputatorExecutionEntityImpl
extends VariableScopeImpl
implements ExecutionEntity,
CountingExecutionEntity,
AgentExecution {
    private Log logger = LogFactory.getLog(this.getClass());
    private static final long serialVersionUID = 9031496337389418908L;
    protected FlowElement currentFlowElement;
    protected ActivitiListener currentActivitiListener;
    private String wfPlugin;
    private Map<String, Object> wfPluginParams;
    protected TaskEntity currentTask;
    protected PreComputatorExecutionEntityImpl processInstance;
    protected PreComputatorExecutionEntityImpl parent;
    protected PreComputatorExecutionEntityImpl superExecution;
    protected PreComputatorExecutionEntityImpl subProcessInstance;
    protected PreComputatorExecutionEntityImpl rootProcessInstance;
    protected List<PreComputatorExecutionEntityImpl> executions;
    protected List<EventSubscriptionEntity> eventSubscriptions;
    protected List<JobEntity> jobs;
    protected List<TimerJobEntity> timerJobs;
    protected List<TaskEntity> tasks;
    protected List<IdentityLinkEntity> identityLinks;
    protected List<VariableInstanceEntity> queryVariables;
    protected String processDefinitionKey;
    protected String processDefinitionName;
    protected Integer processDefinitionVersion;
    protected Long deploymentId;
    protected boolean forcedUpdate;
    protected String eventName;
    protected String deleteReason;
    protected boolean ended;
    private Long preId;
    private Long preProcessInstanceId;
    private Long preRootProcessInstanceId;
    private Long preProcessDefinitionId;
    private Long preParentId;
    private Long preSuperExecutionId;
    private String preActivityId;
    private boolean preActive;
    private boolean preBillExecution;
    private boolean preScope;
    private Long preCurrentActinstId;
    private String preSuspensionState;
    private ILocaleString preName;
    private ILocaleString preDescription;
    private String preBusinessKey;
    private Long preCurrentTaskId;
    private String preEntityNumber;
    private boolean preCountEnabled;
    private int preEventSubscriptionCount;
    private int preTaskCount;
    private int preJobCount;
    private int preTimerJobCount;
    private int preSuspendedJobCount;
    private int preDeadLetterJobCount;
    private int preVariableCount;
    private int preIdentityLinkCount;
    private boolean preEventScope;
    private boolean preMultiInstanceRoot;
    private Date preLockTime;
    private Long preStartUserId;
    private String preBillno;
    private ILocaleString preActivityName;
    private ILocaleString preSubject;
    private ILocaleString preEntraBillName;
    private String preBillType;
    private Long preSchemeId;
    private Long preMainOrgId;
    private String preOrgViewId;
    private Long preTestingPlanId;
    private Long preModifierId;
    private Long preCreatorId;
    private Date preCreateDate;
    private String preBusinessId;
    private DynamicObject transientBill;
    private Map<String, NodeTempVariable> tempVariableMap = new HashMap<String, NodeTempVariable>();

    public PreComputatorExecutionEntityImpl() {
        this.tempVariableMap = new HashMap<String, NodeTempVariable>();
    }

    public PreComputatorExecutionEntityImpl(PreComputatorExecutionEntityImpl execution) {
        this.preId = execution.preId;
        this.preProcessInstanceId = execution.preProcessInstanceId;
        this.preRootProcessInstanceId = execution.preRootProcessInstanceId;
        this.preProcessDefinitionId = execution.preProcessDefinitionId;
        this.preParentId = execution.preParentId;
        this.preSuperExecutionId = execution.preSuperExecutionId;
        this.preActivityId = execution.preActivityId;
        this.preActive = execution.preActive;
        this.preBillExecution = execution.preBillExecution;
        this.preScope = execution.preScope;
        this.preCurrentActinstId = execution.preCurrentActinstId;
        this.preSuspensionState = execution.preSuspensionState;
        this.preName = execution.preName;
        this.preDescription = execution.preDescription;
        this.preBusinessKey = execution.preBusinessKey;
        this.preCurrentTaskId = execution.preCurrentTaskId;
        this.preEntityNumber = execution.preEntityNumber;
        this.preCountEnabled = execution.preCountEnabled;
        this.preEventSubscriptionCount = execution.preEventSubscriptionCount;
        this.preTaskCount = execution.preTaskCount;
        this.preJobCount = execution.preJobCount;
        this.preTimerJobCount = execution.preTimerJobCount;
        this.preSuspendedJobCount = execution.preSuspendedJobCount;
        this.preDeadLetterJobCount = execution.preDeadLetterJobCount;
        this.preVariableCount = execution.preVariableCount;
        this.preIdentityLinkCount = execution.preIdentityLinkCount;
        this.preEventScope = execution.preEventScope;
        this.preMultiInstanceRoot = execution.preMultiInstanceRoot;
        this.preLockTime = execution.preLockTime;
        this.preStartUserId = execution.preStartUserId;
        this.preBillno = execution.preBillno;
        this.preActivityName = execution.preActivityName;
        this.preSubject = execution.preSubject;
        this.preEntraBillName = execution.preEntraBillName;
        this.preSchemeId = execution.preSchemeId;
        this.preMainOrgId = execution.preMainOrgId;
        this.preOrgViewId = execution.preOrgViewId;
        this.preTestingPlanId = execution.preTestingPlanId;
        this.preModifierId = execution.preModifierId;
        this.preCreatorId = execution.preCreatorId;
        this.preCreateDate = execution.preCreateDate;
        this.preBusinessId = execution.preBusinessId;
        this.preBillType = execution.preBillType;
        this.processInstance = (PreComputatorExecutionEntityImpl)execution.getProcessInstance();
        this.tempVariableMap = execution.tempVariableMap;
    }

    public PreComputatorExecutionEntityImpl(ExecutionEntityImpl execution) {
        DynamicObject dym = execution.getDynamicObject();
        this.preId = this.normalizeId(dym.getLong("id"));
        this.preProcessInstanceId = this.normalizeId(dym.getLong("processInstanceId"));
        this.preRootProcessInstanceId = this.normalizeId(dym.getLong("rootProcessInstanceId"));
        this.preProcessDefinitionId = this.normalizeId(dym.getLong("processDefinitionId"));
        this.preParentId = this.normalizeId(dym.getLong("parentId"));
        this.preSuperExecutionId = this.normalizeId(dym.getLong("superExecutionId"));
        this.preActivityId = dym.getString("activityId");
        this.preActive = dym.getBoolean("active");
        this.preBillExecution = dym.getBoolean("billexecution");
        this.preScope = dym.getBoolean("scope");
        this.preCurrentActinstId = this.normalizeId(dym.getLong("currentActInstId"));
        this.preSuspensionState = dym.getString("suspensionState");
        this.preName = dym.getLocaleString("name");
        this.preBusinessKey = dym.getString("businessKey");
        this.preCurrentTaskId = this.normalizeId(dym.getLong("currentTaskId"));
        this.preEntityNumber = dym.getString("entityNumber");
        this.preCountEnabled = dym.getBoolean("countEnabled");
        this.preEventSubscriptionCount = dym.getInt("eventSubscriptionCount");
        this.preTaskCount = dym.getInt("taskCount");
        this.preJobCount = dym.getInt("jobCount");
        this.preTimerJobCount = dym.getInt("timerJobCount");
        this.preSuspendedJobCount = dym.getInt("suspendedJobCount");
        this.preDeadLetterJobCount = dym.getInt("deadLetterJobCount");
        this.preVariableCount = dym.getInt("variableCount");
        this.preIdentityLinkCount = dym.getInt("identityLinkCount");
        this.preEventScope = dym.getBoolean("eventScope");
        this.preMultiInstanceRoot = dym.getBoolean("multiInstanceRoot");
        this.preStartUserId = this.normalizeId(dym.getLong("startUserId"));
        this.preBillno = dym.getString("billno");
        this.preActivityName = dym.getLocaleString("activityName");
        this.preSubject = dym.getLocaleString("subject");
        this.preEntraBillName = dym.getLocaleString("entraBillName");
        this.preSchemeId = this.normalizeId(dym.getLong("schemeId"));
        this.preMainOrgId = this.normalizeId(dym.getLong("mainOrgId"));
        this.preOrgViewId = dym.getString("orgviewid");
        this.preTestingPlanId = this.normalizeId(dym.getLong("testingPlanId"));
        this.preCreateDate = dym.getDate("createDate");
        this.preBusinessId = dym.getString("businessid");
        this.preBillType = dym.getString("billType");
    }

    public void setTransientBill(DynamicObject transientBill) {
        this.transientBill = transientBill;
    }

    @Override
    public Long getId() {
        return this.preId;
    }

    @Override
    public void setId(Long id) {
        this.preId = id;
    }

    @Override
    public Long getProcessInstanceId() {
        return this.preProcessInstanceId;
    }

    @Override
    public void setProcessInstanceId(Long processInstanceId) {
        this.preProcessInstanceId = processInstanceId;
    }

    @Override
    public Long getRootProcessInstanceId() {
        return this.preRootProcessInstanceId;
    }

    @Override
    public void setRootProcessInstanceId(Long rootProcessInstanceId) {
        this.preRootProcessInstanceId = rootProcessInstanceId;
    }

    @Override
    public Long getProcessDefinitionId() {
        return this.preProcessDefinitionId;
    }

    @Override
    public void setProcessDefinitionId(Long processDefinitionId) {
        this.preProcessDefinitionId = processDefinitionId;
    }

    @Override
    public Long getParentId() {
        return this.preParentId;
    }

    @Override
    public void setParentId(Long parentId) {
        this.preParentId = parentId;
    }

    @Override
    public Long getSuperExecutionId() {
        return this.preSuperExecutionId;
    }

    @Override
    public void setSuperExecutionId(Long superExecutionId) {
        this.preSuperExecutionId = superExecutionId;
    }

    @Override
    public String getActivityId() {
        return this.preActivityId;
    }

    @Override
    public void setActivityId(String activityId) {
        this.preActivityId = activityId;
    }

    @Override
    public String getEventName() {
        return this.eventName;
    }

    @Override
    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    @Override
    public String getProcessInstanceBusinessKey() {
        return this.getProcessInstance().getBusinessKey();
    }

    @Override
    public String getCurrentActivityId() {
        return this.getActivityId();
    }

    @Override
    public FlowElement getCurrentFlowElement() {
        if (this.currentFlowElement == null) {
            Long processDefinitionId = null;
            if (this.getProcessInstance() != null) {
                processDefinitionId = this.getProcessInstance().getProcessDefinitionId();
            } else if (this.getProcessDefinitionId() != null) {
                processDefinitionId = this.getProcessDefinitionId();
            }
            if (processDefinitionId != null) {
                Process process = ProcessDefinitionUtil.getProcess(processDefinitionId, this.getProcessInstanceId());
                this.currentFlowElement = process.getFlowElement(this.getCurrentActivityId(), true);
            }
        }
        return this.currentFlowElement;
    }

    @Override
    public void setCurrentFlowElement(FlowElement currentFlowElement) {
        this.currentFlowElement = currentFlowElement;
        if (currentFlowElement != null) {
            this.setActivityId(currentFlowElement.getId());
        } else {
            this.setActivityId(null);
        }
    }

    @Override
    public ActivitiListener getCurrentActivitiListener() {
        return this.currentActivitiListener;
    }

    @Override
    public void setCurrentActivitiListener(ActivitiListener currentActivitiListener) {
        this.currentActivitiListener = currentActivitiListener;
    }

    @Override
    public boolean isActive() {
        return this.preActive;
    }

    @Override
    public void setActive(boolean isActive) {
        this.preActive = isActive;
    }

    @Override
    public void inactivate() {
        this.preActive = Boolean.FALSE;
    }

    @Override
    public boolean isEnded() {
        return this.ended;
    }

    @Override
    public void setEnded(boolean isEnded) {
        this.ended = isEnded;
    }

    @Override
    public boolean isBillExecution() {
        return this.preBillExecution;
    }

    @Override
    public void setBillExecution(boolean isConcurrent) {
        this.preBillExecution = isConcurrent;
    }

    @Override
    public boolean isProcessInstanceType() {
        return WfUtils.isEmpty(this.getParentId());
    }

    @Override
    public boolean isScope() {
        return this.preScope;
    }

    @Override
    public void setScope(boolean isScope) {
        this.preScope = isScope;
    }

    @Override
    public Long getCurrentActInstId() {
        return this.preCurrentActinstId;
    }

    @Override
    public void setCurrentActInstId(Long lastActInstId) {
        this.preCurrentActinstId = lastActInstId;
    }

    @Override
    public String getCurrentWFPlugin() {
        return this.wfPlugin;
    }

    @Override
    public void setCurrentWFPlugin(String implementation) {
        this.wfPlugin = implementation;
    }

    @Override
    public Map<String, Object> getCurrentWFPluginParams() {
        return this.wfPluginParams;
    }

    @Override
    public void setCurrentWFPluginParams(Map<String, Object> wfPluginParams) {
        this.wfPluginParams = wfPluginParams;
    }

    @Override
    public String getSuspensionState() {
        return this.preSuspensionState;
    }

    @Override
    public void setSuspensionState(String suspensionState) {
        this.preSuspensionState = suspensionState;
    }

    @Override
    public boolean isSuspended() {
        return this.preSuspensionState.equals(ManagementConstants.SUSPENDED.getStateCode());
    }

    @Override
    public ILocaleString getName() {
        return this.preName;
    }

    @Override
    public void setName(ILocaleString name) {
        this.preName = name;
    }

    @Override
    public ILocaleString getDescription() {
        return this.preDescription;
    }

    @Override
    public void setDescription(ILocaleString description) {
        this.preDescription = description;
    }

    @Override
    public String getProcessDefinitionName() {
        return this.processDefinitionName;
    }

    @Override
    public void setProcessDefinitionName(String processDefinitionName) {
        this.processDefinitionName = processDefinitionName;
    }

    @Override
    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    @Override
    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    @Override
    public Integer getProcessDefinitionVersion() {
        return this.processDefinitionVersion;
    }

    @Override
    public void setProcessDefinitionVersion(Integer processDefinitionVersion) {
        this.processDefinitionVersion = processDefinitionVersion;
    }

    @Override
    public Long getDeploymentId() {
        return this.deploymentId;
    }

    @Override
    public void setDeploymentId(Long deploymentId) {
        this.deploymentId = deploymentId;
    }

    @Override
    public Map<String, Object> getProcessVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (this.queryVariables != null) {
            for (VariableInstanceEntity variableInstance : this.queryVariables) {
                if (variableInstance.getId() == null || variableInstance.getTaskId() != null) continue;
                variables.put(variableInstance.getName(), variableInstance.getValue());
            }
        }
        return variables;
    }

    @Override
    public String getBusinessKey() {
        String businessKey = this.preBusinessKey;
        return businessKey;
    }

    @Override
    public void setBusinessKey(String businessKey) {
        this.preBusinessKey = businessKey;
    }

    public List<Long> getCurrentApprover() {
        try {
            Object approvaler = this.getVariable("currentApprover");
            if (approvaler instanceof List) {
                return (List)approvaler;
            }
            FlowElement node = this.getCurrentFlowElement();
            if (node != null && this.tempVariableMap.get(node.getId()) != null) {
                return this.tempVariableMap.get(node.getId()).getAssigneeId();
            }
            ArrayList<Long> approverIds = new ArrayList<Long>();
            TaskEntity task = this.getCurrentTask();
            if (task != null) {
                approverIds = new ArrayList(task.getParticipants());
            }
            return approverIds;
        }
        catch (Exception e) {
            this.logger.info(WfUtils.getExceptionStacktrace(e));
            return Collections.emptyList();
        }
    }

    public Long getCurrentTaskId() {
        return this.preCurrentTaskId;
    }

    @Override
    public void setCurrentTaskId(Long currentTaskId) {
        this.preCurrentTaskId = currentTaskId;
    }

    public Object getCurrentTaskResult(WFTaskResultEnum result) {
        try {
            Object o = this.getVariable(result.name());
            if (o != null) {
                return o;
            }
            FlowElement node = this.getCurrentFlowElement();
            if (node != null && this.tempVariableMap.get(node.getId()) != null) {
                NodeTempVariable v = this.tempVariableMap.get(node.getId());
                if (WFTaskResultEnum.auditNumber.equals((Object)result)) {
                    return v.getAuditNumber();
                }
                if (WFTaskResultEnum.auditType.equals((Object)result)) {
                    return v.getAuditType();
                }
                for (DecisionOption option : node.getDecisionOptions()) {
                    if (!option.getNumber().equals(v.getAuditNumber())) continue;
                    return option.getName();
                }
            }
            if (this.getCurrentTask() != null) {
                return this.getCurrentTask().getVariable(result.name());
            }
        }
        catch (Exception e) {
            this.logger.info(WfUtils.getExceptionStacktrace(e));
        }
        return null;
    }

    @Override
    public String getEntityNumber() {
        String entityNumber = this.preEntityNumber;
        if (WfUtils.isEmpty(entityNumber)) {
            entityNumber = this.getProcessInstance().getEntityNumber();
        }
        return entityNumber;
    }

    @Override
    public void setEntityNumber(String entityNumber) {
        this.preEntityNumber = entityNumber;
    }

    @Override
    public boolean isCountEnabled() {
        return this.preCountEnabled;
    }

    @Override
    public void setCountEnabled(boolean isCountEnabled) {
        this.preCountEnabled = isCountEnabled;
    }

    @Override
    public int getEventSubscriptionCount() {
        return this.preEventSubscriptionCount;
    }

    @Override
    public void setEventSubscriptionCount(int eventSubscriptionCount) {
        this.preEventSubscriptionCount = eventSubscriptionCount;
    }

    @Override
    public int getTaskCount() {
        return this.preTaskCount;
    }

    @Override
    public void setTaskCount(int taskCount) {
        this.preTaskCount = taskCount;
    }

    @Override
    public int getJobCount() {
        return this.preJobCount;
    }

    @Override
    public void setJobCount(int jobCount) {
        this.preJobCount = jobCount;
    }

    @Override
    public int getTimerJobCount() {
        return this.preTimerJobCount;
    }

    @Override
    public void setTimerJobCount(int timerJobCount) {
        this.preTimerJobCount = timerJobCount;
    }

    @Override
    public int getSuspendedJobCount() {
        return this.preSuspendedJobCount;
    }

    @Override
    public void setSuspendedJobCount(int suspendedJobCount) {
        this.preSuspendedJobCount = suspendedJobCount;
    }

    @Override
    public int getDeadLetterJobCount() {
        return this.preDeadLetterJobCount;
    }

    @Override
    public void setDeadLetterJobCount(int deadLetterJobCount) {
        this.preDeadLetterJobCount = deadLetterJobCount;
    }

    @Override
    public int getVariableCount() {
        return this.preVariableCount;
    }

    @Override
    public void setVariableCount(int variableCount) {
        this.preVariableCount = variableCount;
    }

    @Override
    public int getIdentityLinkCount() {
        return this.preIdentityLinkCount;
    }

    @Override
    public void setIdentityLinkCount(int identityLinkCount) {
        this.preIdentityLinkCount = identityLinkCount;
    }

    @Override
    public ExecutionEntity getProcessInstance() {
        this.ensureProcessInstanceInitialized();
        return this.processInstance;
    }

    protected void ensureProcessInstanceInitialized() {
        if (this.processInstance == null && WfUtils.isNotEmpty(this.getProcessInstanceId())) {
            this.processInstance = new PreComputatorExecutionEntityImpl((ExecutionEntityImpl)Context.getCommandContext().getExecutionEntityManager().findById(this.getProcessInstanceId()));
        }
    }

    @Override
    public void setProcessInstance(ExecutionEntity processInstance) {
        this.processInstance = (PreComputatorExecutionEntityImpl)processInstance;
        if (processInstance != null) {
            this.preProcessInstanceId = this.processInstance.getId();
        }
    }

    @Override
    public PreComputatorExecutionEntityImpl getParent() {
        this.ensureParentInitialized();
        return this.parent;
    }

    protected void ensureParentInitialized() {
        if (this.parent == null && WfUtils.isNotEmpty(this.getParentId())) {
            this.parent = new PreComputatorExecutionEntityImpl((ExecutionEntityImpl)Context.getCommandContext().getExecutionEntityManager().findById(this.getParentId()));
        }
    }

    @Override
    public void setParent(ExecutionEntity parent) {
        this.parent = (PreComputatorExecutionEntityImpl)parent;
        this.preParentId = parent != null ? parent.getId() : null;
    }

    @Override
    public ExecutionEntity getSuperExecution() {
        this.ensureSuperExecutionInitialized();
        return this.superExecution;
    }

    protected void ensureSuperExecutionInitialized() {
        if (this.superExecution == null && WfUtils.isNotEmpty(this.getSuperExecutionId())) {
            this.superExecution = new PreComputatorExecutionEntityImpl((ExecutionEntityImpl)Context.getCommandContext().getExecutionEntityManager().findById(this.getSuperExecutionId()));
        }
    }

    @Override
    public void setSuperExecution(ExecutionEntity superExecution) {
        this.superExecution = (PreComputatorExecutionEntityImpl)superExecution;
        if (superExecution != null) {
            superExecution.setSubProcessInstance(null);
        }
        this.preSuperExecutionId = superExecution != null ? ((ExecutionEntityImpl)superExecution).getId() : null;
    }

    @Override
    public ExecutionEntity getSubProcessInstance() {
        this.ensureSubProcessInstanceInitialized();
        return this.subProcessInstance;
    }

    protected void ensureSubProcessInstanceInitialized() {
        if (this.subProcessInstance == null) {
            this.subProcessInstance = new PreComputatorExecutionEntityImpl((ExecutionEntityImpl)Context.getCommandContext().getExecutionEntityManager().findSubProcessInstanceBySuperExecutionId(this.getId()));
        }
    }

    @Override
    public void setSubProcessInstance(ExecutionEntity subProcessInstance) {
        this.subProcessInstance = (PreComputatorExecutionEntityImpl)subProcessInstance;
    }

    @Override
    public ExecutionEntity getRootProcessInstance() {
        this.ensureRootProcessInstanceInitialized();
        return this.rootProcessInstance;
    }

    protected void ensureRootProcessInstanceInitialized() {
        if (this.rootProcessInstance == null && WfUtils.isNotEmpty(this.getRootProcessInstanceId())) {
            this.rootProcessInstance = new PreComputatorExecutionEntityImpl((ExecutionEntityImpl)Context.getCommandContext().getExecutionEntityManager().findById(this.getRootProcessInstanceId()));
        }
    }

    @Override
    public void setRootProcessInstance(ExecutionEntity rootProcessInstance) {
        this.rootProcessInstance = (PreComputatorExecutionEntityImpl)rootProcessInstance;
        this.preRootProcessInstanceId = rootProcessInstance != null ? rootProcessInstance.getId() : null;
    }

    @Override
    public List<? extends ExecutionEntity> getExecutions() {
        this.ensureExecutionsInitialized();
        return this.executions;
    }

    protected void ensureExecutionsInitialized() {
    }

    @Override
    public void addChildExecution(ExecutionEntity executionEntity) {
        this.ensureExecutionsInitialized();
        this.executions.add((PreComputatorExecutionEntityImpl)executionEntity);
    }

    @Override
    public List<TaskEntity> getTasks() {
        this.ensureTasksInitialized();
        return this.tasks;
    }

    protected void ensureTasksInitialized() {
        if (this.tasks == null) {
            this.tasks = Context.getCommandContext().getTaskEntityManager().findTasksByExecutionId(this.getId());
            if (this.tasks == null) {
                this.tasks = new ArrayList<TaskEntity>(0);
            }
        }
    }

    @Override
    public List<EventSubscriptionEntity> getEventSubscriptions() {
        this.ensureEventSubscriptionsInitialized();
        return this.eventSubscriptions;
    }

    protected void ensureEventSubscriptionsInitialized() {
        if (this.eventSubscriptions == null) {
            this.eventSubscriptions = Context.getCommandContext().getEventSubscriptionEntityManager().findEventSubscriptionsByExecution(this.getId());
            if (this.eventSubscriptions == null) {
                this.eventSubscriptions = new ArrayList<EventSubscriptionEntity>(0);
            }
        }
    }

    @Override
    public List<JobEntity> getJobs() {
        this.ensureJobsInitialized();
        return this.jobs;
    }

    protected void ensureJobsInitialized() {
        if (this.jobs.isEmpty()) {
            this.jobs = Context.getCommandContext().getJobEntityManager().findJobsByExecutionId(this.getId());
            if (this.jobs == null) {
                this.jobs = new ArrayList<JobEntity>(0);
            }
        }
    }

    @Override
    public List<TimerJobEntity> getTimerJobs() {
        this.ensureTimerJobsInitialized();
        return this.timerJobs;
    }

    protected void ensureTimerJobsInitialized() {
        if (this.timerJobs == null) {
            this.timerJobs = Context.getCommandContext().getTimerJobEntityManager().findJobsByExecutionId(this.getId());
            if (this.timerJobs == null) {
                this.timerJobs = new ArrayList<TimerJobEntity>(0);
            }
        }
    }

    @Override
    public List<IdentityLinkEntity> getIdentityLinks() {
        this.ensureIdentityLinksInitialized();
        return this.identityLinks;
    }

    protected void ensureIdentityLinksInitialized() {
        if (this.identityLinks == null) {
            this.identityLinks = Context.getCommandContext().getIdentityLinkEntityManager().findIdentityLinksByProcessInstanceId(this.getId());
            if (this.identityLinks == null) {
                this.identityLinks = new ArrayList<IdentityLinkEntity>(0);
            }
        }
    }

    @Override
    public String getDeleteReason() {
        return this.deleteReason;
    }

    @Override
    public void setDeleteReason(String deleteReason) {
        this.deleteReason = deleteReason;
    }

    @Override
    public boolean isEventScope() {
        return this.preEventScope;
    }

    @Override
    public void setEventScope(boolean isEventScope) {
        this.preEventScope = isEventScope;
    }

    @Override
    public boolean isMultiInstanceRoot() {
        return this.preMultiInstanceRoot;
    }

    @Override
    public void setMultiInstanceRoot(boolean isMultiInstanceRoot) {
        this.preMultiInstanceRoot = isMultiInstanceRoot;
    }

    @Override
    public Date getLockTime() {
        return this.preLockTime;
    }

    @Override
    public void setLockTime(Date lockTime) {
        this.preLockTime = lockTime;
    }

    @Override
    public void forceUpdate() {
        this.forcedUpdate = true;
    }

    @Override
    public Long getStartUserId() {
        return this.preStartUserId;
    }

    @Override
    public void setStartUserId(Long startUserId) {
        this.preStartUserId = startUserId;
    }

    @Override
    public String getBillNo() {
        return this.preBillno;
    }

    @Override
    public void setBillNo(String billNo) {
        this.preBillno = billNo;
    }

    @Override
    public TaskEntity getCurrentTask() {
        this.ensureCurrentTaskInitialized();
        return this.currentTask;
    }

    protected void ensureCurrentTaskInitialized() {
        if (this.currentTask == null && WfUtils.isNotEmpty(this.getCurrentTaskId())) {
            HistoricTaskInstanceEntity hiTask;
            try {
                this.currentTask = (TaskEntity)Context.getCommandContext().getTaskEntityManager().findById(this.getCurrentTaskId());
            }
            catch (Exception e) {
                this.logger.info(e.getMessage());
            }
            if (this.currentTask == null && (hiTask = (HistoricTaskInstanceEntity)Context.getCommandContext().getHistoricTaskInstanceEntityManager().findById(this.getCurrentTaskId())) != null) {
                this.currentTask = new TaskEntityImpl(hiTask);
                this.currentTask.setExecution(this);
                BpmnModel model = ProcessDefinitionUtil.getBpmnModel(this.getProcessDefinitionId(), this.getProcessInstanceId());
                FlowElement elem = model.getFlowElement(this.getActivityId());
                Map<String, Object> tmp = Context.getCommandContext().getHistoricVariableInstanceEntityManager().findVariablesByTaskId(this.getCurrentTaskId());
                HashMap<String, Object> variables = new HashMap(tmp.size());
                if (elem instanceof UserTask) {
                    variables = TaskBehaviorUtil.processVariables(((UserTask)elem).getVariables(), elem);
                }
                for (Map.Entry<String, Object> entry : tmp.entrySet()) {
                    variables.put(entry.getKey(), entry.getValue());
                }
                this.currentTask.setTransientVariablesLocal(variables);
            }
        }
    }

    @Override
    public void setCurrentTask(TaskEntity currentTask) {
        this.currentTask = currentTask;
        this.preCurrentTaskId = currentTask != null && WfUtils.isNotEmpty(currentTask.getId()) ? currentTask.getId() : null;
    }

    @Override
    public void setCurrentTaskOnly(TaskEntity currentTask) {
        this.currentTask = currentTask;
    }

    @Override
    public ILocaleString getActivityName() {
        return this.preActivityName;
    }

    @Override
    public void setActivityName(ILocaleString activityName) {
        this.preActivityName = activityName;
    }

    @Override
    public ILocaleString getSubject() {
        return this.preSubject;
    }

    @Override
    public void setSubject(ILocaleString subject) {
        this.preSubject = subject;
    }

    @Override
    public ILocaleString getEntraBillName() {
        return this.preEntraBillName;
    }

    @Override
    public void setEntraBillName(ILocaleString entraBillName) {
        this.preEntraBillName = entraBillName;
    }

    @Override
    public String getBillType() {
        return this.preBillType;
    }

    @Override
    public void setBillType(String billType) {
        this.preBillType = billType;
    }

    @Override
    public Long getSchemeId() {
        return this.preSchemeId;
    }

    @Override
    public void setSchemeId(Long schemeId) {
        this.preSchemeId = schemeId;
    }

    @Override
    public Long getMainOrgId() {
        return this.preMainOrgId;
    }

    @Override
    public void setMainOrgId(Long mainOrgId) {
        this.preMainOrgId = mainOrgId;
    }

    @Override
    public String getOrgViewId() {
        return this.preOrgViewId;
    }

    @Override
    public void setOrgViewId(String orgViewId) {
        this.preOrgViewId = orgViewId;
    }

    @Override
    public Long getTestingPlanId() {
        return this.preTestingPlanId;
    }

    @Override
    public void setTestingPlanId(Long testingPlanId) {
        this.preTestingPlanId = testingPlanId;
    }

    @Override
    public Long getModifierId() {
        return this.preModifierId;
    }

    @Override
    public void setModifierId(Long modifierId) {
        this.preModifierId = modifierId;
    }

    @Override
    public Long getCreatorId() {
        return this.preCreatorId;
    }

    @Override
    public void setCreatorId(Long creatorId) {
        this.preCreatorId = creatorId;
    }

    @Override
    public Date getCreateDate() {
        return this.preCreateDate;
    }

    @Override
    public void setCreateDate(Date date) {
        this.preCreateDate = date;
    }

    @Override
    protected Collection<VariableInstanceEntity> loadVariableInstances() {
        if (WfUtils.isNotEmpty(this.getId())) {
            List<VariableInstanceEntity> variables = Context.getCommandContext().getVariableInstanceEntityManager().findVariableInstancesByExecutionId(this.getId());
            ArrayList<VariableInstanceEntity> copyVariables = new ArrayList<VariableInstanceEntity>();
            if (variables != null) {
                for (VariableInstanceEntity v : variables) {
                    copyVariables.add(Context.getCommandContext().getVariableInstanceEntityManager().create(v.getName(), v.getType(), v.getValue()));
                }
            }
            return copyVariables;
        }
        return new ArrayList<VariableInstanceEntity>();
    }

    @Override
    protected VariableScopeImpl getParentVariableScope() {
        return this.getParent();
    }

    @Override
    protected void initializeVariableInstanceBackPointer(VariableInstanceEntity variableInstance) {
        if (WfUtils.isNotEmpty(this.getProcessInstanceId())) {
            variableInstance.setProcessInstanceId(this.getProcessInstanceId());
        } else {
            variableInstance.setProcessInstanceId(this.getId());
        }
        variableInstance.setExecutionId(this.getId());
    }

    @Override
    protected VariableInstanceEntity getSpecificVariable(String variableName) {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext == null) {
            throw new WFEngineException("lazy loading outside command context");
        }
        return commandContext.getVariableInstanceEntityManager().findVariableInstanceByExecutionAndName(this.getId(), variableName);
    }

    @Override
    protected List<VariableInstanceEntity> getSpecificVariables(Collection<String> variableNames) {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext == null) {
            throw new WFEngineException("lazy loading outside command context");
        }
        return commandContext.getVariableInstanceEntityManager().findVariableInstancesByExecutionAndNames(this.getId(), variableNames);
    }

    public Map<String, NodeTempVariable> getTempVariableMap() {
        return this.tempVariableMap;
    }

    public void setTempVariableMap(Map<String, NodeTempVariable> tempVariableMap) {
        this.tempVariableMap = tempVariableMap;
    }

    @Override
    public void setBusinessId(String businessId) {
        this.preBusinessId = businessId;
    }

    @Override
    public String getBusinessId() {
        return this.preBusinessId;
    }

    public DynamicObject getTransientBill() {
        return this.transientBill;
    }

    @Override
    public String getDynObjTypeName() {
        return null;
    }

    @Override
    protected void updateVariableInstance(VariableInstanceEntity variableInstance, Object value, ExecutionEntity sourceActivityExecution) {
        if (variableInstance != null) {
            VariableTypes variableTypes = Context.getProcessEngineConfiguration().getVariableTypes();
            VariableType newType = variableTypes.findVariableType(value);
            if (!variableInstance.getType().equals(newType)) {
                variableInstance.setValue(null);
                variableInstance.setType(newType);
                variableInstance.forceUpdate();
                variableInstance.setValue(value);
            } else {
                variableInstance.setValue(value);
            }
        }
    }

    @Override
    protected VariableInstanceEntity createVariableInstance(String variableName, Object value, ExecutionEntity sourceActivityExecution) {
        VariableTypes variableTypes = Context.getProcessEngineConfiguration().getVariableTypes();
        VariableType type = variableTypes.findVariableType(value);
        VariableInstanceEntity variableInstance = Context.getCommandContext().getVariableInstanceEntityManager().create(variableName, type, value);
        this.initializeVariableInstanceBackPointer(variableInstance);
        if (this.variableInstances != null) {
            this.variableInstances.put(variableName, variableInstance);
        } else {
            this.ensureVariableInstancesInitialized();
            this.variableInstances.put(variableName, variableInstance);
        }
        return variableInstance;
    }

    @Override
    protected void deleteVariableInstanceForExplicitUserCall(VariableInstanceEntity variableInstance, ExecutionEntity sourceActivityExecution) {
        variableInstance.setValue(null);
    }
}

