/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.runtime;

import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.PreComputorInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.PreComputorInstanceEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.PreComputorInstanceEntityManager;

public class PreComputorInstanceEntityManagerImpl
extends AbstractEntityManager<PreComputorInstanceEntity>
implements PreComputorInstanceEntityManager {
    public PreComputorInstanceEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public Class<? extends PreComputorInstanceEntity> getManagedEntityClass() {
        return PreComputorInstanceEntityImpl.class;
    }

    @Override
    public String getEntityName() {
        return "wf_precomputorinstance";
    }

    @Override
    public String getSelectFields() {
        return "id, processinstanceid, schemeid, strategy, validity, version, createdate, modifydate, businesskey, billno, activityid, processdefinitionid, executionid, activityname, entrynodeid, entrynodename, entryauditnumber, entryauditname, entrytaskid, precomputorresult.isnormal, precomputorresult.nodeid, precomputorresult.nodename, precomputorresult.assignee, precomputorresult.assigneename, precomputorresult.nodetype, precomputorresult.status, precomputorresult.auditnumber, precomputorresult.bizidentifykey, precomputorresult.nextnodeid,precomputorresult.errtype, precomputorresult.errmsg, precomputorresult.exceptionmsg";
    }

    @Override
    public void invalidInstanceByProcInstId(Long procInstId) {
        QFilter procinstFilter = new QFilter("processinstanceid", "=", (Object)procInstId);
        QFilter validityFilter = new QFilter("validity", "=", (Object)Boolean.TRUE);
        List dym = this.findByQueryFilters(new QFilter[]{procinstFilter, validityFilter});
        for (PreComputorInstanceEntity entity : dym) {
            entity.setValidity(Boolean.FALSE);
            this.update(entity);
        }
    }

    @Override
    public void invalidInstanceByProcInstId(Long procInstId, Long schemeId) {
        QFilter procinstFilter = new QFilter("processinstanceid", "=", (Object)procInstId);
        QFilter schemeFilter = new QFilter("schemeid", "=", (Object)schemeId);
        QFilter validityFilter = new QFilter("validity", "=", (Object)Boolean.TRUE);
        List dym = this.findByQueryFilters(new QFilter[]{procinstFilter, schemeFilter, validityFilter});
        for (PreComputorInstanceEntity entity : dym) {
            entity.setValidity(Boolean.FALSE);
            this.update(entity);
        }
    }

    @Override
    public int getMaxVersion(Long procInstId) {
        int version = 0;
        String sql = "SELECT fversion FROM t_wf_precomputorinstance WHERE FPROCINSTID = ? ORDER BY fversion DESC";
        Object[] params = new Object[]{procInstId};
        try (DataSet ds = DB.queryDataSet((String)"wf.getMaxVersion", (DBRoute)DBRoute.workflow, (String)sql, (Object[])params);){
            Iterator iter = ds.iterator();
            if (iter.hasNext()) {
                Row row = (Row)iter.next();
                version = Math.max(version, row.getInteger("fversion"));
            }
        }
        return ++version;
    }

    @Override
    public void deleteInstanceByProcInstId(Long procInstId) {
        this.deleteByFilters(new QFilter[]{new QFilter("processinstanceid", "=", (Object)procInstId)});
    }

    @Override
    public boolean existValidInstanceByProcInstId(Long procInstId) {
        return QueryServiceHelper.exists((String)"wf_precomputorinstance", (QFilter[])new QFilter[]{new QFilter("processinstanceid", "=", (Object)procInstId), new QFilter("validity", "=", (Object)Boolean.TRUE)});
    }
}

