/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.runtime;

import java.text.MessageFormat;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.EventSubscriptionEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.SignalEventSubscriptionEntity;

public class SignalEventSubscriptionEntityImpl
extends EventSubscriptionEntityImpl
implements SignalEventSubscriptionEntity {
    private static final long serialVersionUID = 1L;
    private static final String CONFIGURATION_TEMPLATE = "'{'\"scope\":\"{0}\"'}'";

    public SignalEventSubscriptionEntityImpl() {
        this.setEventType("signal");
    }

    public SignalEventSubscriptionEntityImpl(DynamicObject dynamicObject) {
        super(dynamicObject);
        this.setEventType("signal");
    }

    @Override
    public void setConfiguration(String configuration) {
        if (configuration != null && configuration.contains("{\"scope\":")) {
            super.setConfiguration(configuration);
        } else {
            super.setConfiguration(MessageFormat.format(CONFIGURATION_TEMPLATE, configuration));
        }
    }

    @Override
    public boolean isProcessInstanceScoped() {
        String scope = this.extractScopeFormConfiguration();
        return scope != null && "processInstance".equals(scope);
    }

    @Override
    public boolean isGlobalScoped() {
        String scope = this.extractScopeFormConfiguration();
        return scope == null || scope.equalsIgnoreCase(" ") || "global".equals(scope);
    }

    protected String extractScopeFormConfiguration() {
        if (WfUtils.isEmpty(this.getConfiguration())) {
            return null;
        }
        return this.getConfiguration().substring(10, this.getConfiguration().length() - 2);
    }
}

